package com.elitesland.tw.tw5.server.prd.humanresources.ability.dao;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdCompositeAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdAbilityLevelDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdCompositeAbilityDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力RepoProc
 */

@Component
public class PrdCompositeAbilityDao extends BaseRepoProc<PrdCompositeAbilityDO> {

    private static final QPrdCompositeAbilityDO qPrdCompositeAbilityDO = QPrdCompositeAbilityDO.prdCompositeAbilityDO;

    private static final QPrdAbilityLevelDO qPrdAbilityLevelDO = QPrdAbilityLevelDO.prdAbilityLevelDO;

    protected PrdCompositeAbilityDao() {

        super(qPrdCompositeAbilityDO);

    }


    public PagingVO<PrdCompositeAbilityVO> page(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        JPAQuery<PrdCompositeAbilityVO> query =
                select(PrdCompositeAbilityVO.class)
                        .where(bulidPredicate(prdCompositeAbilityQuery));
        prdCompositeAbilityQuery.setPaging(query);
        prdCompositeAbilityQuery.fillOrders(query, qPrdCompositeAbilityDO);
        return PagingVO.<PrdCompositeAbilityVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdCompositeAbilityDO)
                .set(qPrdCompositeAbilityDO.deleteFlag, 1)
                .where(qPrdCompositeAbilityDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdCompositeAbilityVO get(Long id) {

        PrdCompositeAbilityVO prdCompositeAbilityVO = select(PrdCompositeAbilityVO.class)
                .where(qPrdCompositeAbilityDO.id.eq(id))
                .fetchOne();

        return prdCompositeAbilityVO;

    }


    public List<PrdCompositeAbilityVO> getList(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        List<PrdCompositeAbilityVO> res =
                select(PrdCompositeAbilityVO.class)
                        .where(bulidPredicate(prdCompositeAbilityQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdCompositeAbilityDO.docNo,
                        qPrdCompositeAbilityDO.levelId,
                        qPrdCompositeAbilityDO.levelName,
                        qPrdCompositeAbilityDO.state,
                        qPrdCompositeAbilityDO.firstAuditFlag,
                        qPrdCompositeAbilityDO.firstAuditor,
                        qPrdCompositeAbilityDO.firstAuditorId,
                        qPrdCompositeAbilityDO.firstAuditorType,
                        qPrdCompositeAbilityDO.firstAuditorUpFlag,
                        qPrdCompositeAbilityDO.jobType1,
                        qPrdCompositeAbilityDO.jobType2,
                        qPrdCompositeAbilityDO.crossLevelFlag,
                        qPrdCompositeAbilityDO.dlRatio,
                        qPrdCompositeAbilityDO.obtainType,
                        qPrdCompositeAbilityDO.auditor,
                        qPrdCompositeAbilityDO.auditorId,
                        qPrdCompositeAbilityDO.auditorType,
                        qPrdCompositeAbilityDO.abilityUpFlag,
                        qPrdCompositeAbilityDO.abilityDesc,
                        qPrdCompositeAbilityDO.id,
                        qPrdCompositeAbilityDO.name,
                        qPrdCompositeAbilityDO.createTime,
                        qPrdCompositeAbilityDO.remark

                )).from(qPrdCompositeAbilityDO);

    }


    private Predicate bulidPredicate(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getDocNo()), qPrdCompositeAbilityDO.docNo, prdCompositeAbilityQuery.getDocNo())
                .andLike(StringUtils.isNotBlank(prdCompositeAbilityQuery.getName()), qPrdCompositeAbilityDO.name, prdCompositeAbilityQuery.getName())
                .andEq(null != prdCompositeAbilityQuery.getLevelId(), qPrdCompositeAbilityDO.levelId, prdCompositeAbilityQuery.getLevelId())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getLevelName()), qPrdCompositeAbilityDO.levelName, prdCompositeAbilityQuery.getLevelName())
                .andEq(null != prdCompositeAbilityQuery.getState(), qPrdCompositeAbilityDO.state, prdCompositeAbilityQuery.getState())
                .andEq(null != prdCompositeAbilityQuery.getFirstAuditFlag(), qPrdCompositeAbilityDO.firstAuditFlag, prdCompositeAbilityQuery.getFirstAuditFlag())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getFirstAuditor()), qPrdCompositeAbilityDO.firstAuditor, prdCompositeAbilityQuery.getFirstAuditor())
                .andEq(null != prdCompositeAbilityQuery.getFirstAuditorId(), qPrdCompositeAbilityDO.firstAuditorId, prdCompositeAbilityQuery.getFirstAuditorId())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getJobType1()), qPrdCompositeAbilityDO.jobType1, prdCompositeAbilityQuery.getJobType1())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getJobType2()), qPrdCompositeAbilityDO.jobType2, prdCompositeAbilityQuery.getJobType2())
                .andEq(null != prdCompositeAbilityQuery.getCrossLevelFlag(), qPrdCompositeAbilityDO.crossLevelFlag, prdCompositeAbilityQuery.getCrossLevelFlag())
                .andEq(null != prdCompositeAbilityQuery.getDlRatio(), qPrdCompositeAbilityDO.dlRatio, prdCompositeAbilityQuery.getDlRatio())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getObtainType()), qPrdCompositeAbilityDO.obtainType, prdCompositeAbilityQuery.getObtainType())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getAuditor()), qPrdCompositeAbilityDO.auditor, prdCompositeAbilityQuery.getAuditor())
                .andEq(null != prdCompositeAbilityQuery.getAuditorId(), qPrdCompositeAbilityDO.auditorId, prdCompositeAbilityQuery.getAuditorId())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getAuditorType()), qPrdCompositeAbilityDO.auditorType, prdCompositeAbilityQuery.getAuditorType())
                .andEq(null != prdCompositeAbilityQuery.getAbilityUpFlag(), qPrdCompositeAbilityDO.abilityUpFlag, prdCompositeAbilityQuery.getAbilityUpFlag())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityQuery.getAbilityDesc()), qPrdCompositeAbilityDO.abilityDesc, prdCompositeAbilityQuery.getAbilityDesc())
                .andIn(CollUtil.isNotEmpty(prdCompositeAbilityQuery.getIds()), qPrdCompositeAbilityDO.id, prdCompositeAbilityQuery.getIds())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 编号
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getDocNo())) {
            predicates.add(qPrdCompositeAbilityDO.docNo.eq(prdCompositeAbilityQuery.getDocNo()));
        }
        // 级别id
        if (null != prdCompositeAbilityQuery.getLevelId()) {
            predicates.add(qPrdCompositeAbilityDO.levelId.eq(prdCompositeAbilityQuery.getLevelId()));
        }
        // 级别名称
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getLevelName())) {
            predicates.add(qPrdCompositeAbilityDO.levelName.eq(prdCompositeAbilityQuery.getLevelName()));
        }
        // 状态
        if (null != prdCompositeAbilityQuery.getState()) {
            predicates.add(qPrdCompositeAbilityDO.state.eq(prdCompositeAbilityQuery.getState()));
        }
        // 首次审批标志
        if (null != prdCompositeAbilityQuery.getFirstAuditFlag()) {
            predicates.add(qPrdCompositeAbilityDO.firstAuditFlag.eq(prdCompositeAbilityQuery.getFirstAuditFlag()));
        }
        // 首次审批审核人
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getFirstAuditor())) {
            predicates.add(qPrdCompositeAbilityDO.firstAuditor.eq(prdCompositeAbilityQuery.getFirstAuditor()));
        }
        // 首次审批审核人id
        if (null != prdCompositeAbilityQuery.getFirstAuditorId()) {
            predicates.add(qPrdCompositeAbilityDO.firstAuditorId.eq(prdCompositeAbilityQuery.getFirstAuditorId()));
        }
        // 工种类型1
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getJobType1())) {
            predicates.add(qPrdCompositeAbilityDO.jobType1.eq(prdCompositeAbilityQuery.getJobType1()));
        }
        // 工种类型2
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getJobType2())) {
            predicates.add(qPrdCompositeAbilityDO.jobType2.eq(prdCompositeAbilityQuery.getJobType2()));
        }
        // 跨级别晋升标志
        if (null != prdCompositeAbilityQuery.getCrossLevelFlag()) {
            predicates.add(qPrdCompositeAbilityDO.crossLevelFlag.eq(prdCompositeAbilityQuery.getCrossLevelFlag()));
        }
        // 当量系数
        if (null != prdCompositeAbilityQuery.getDlRatio()) {
            predicates.add(qPrdCompositeAbilityDO.dlRatio.eq(prdCompositeAbilityQuery.getDlRatio()));
        }
        // 获得方式
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getObtainType())) {
            predicates.add(qPrdCompositeAbilityDO.obtainType.eq(prdCompositeAbilityQuery.getObtainType()));
        }
        // 能力获取审核人
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getAuditor())) {
            predicates.add(qPrdCompositeAbilityDO.auditor.eq(prdCompositeAbilityQuery.getAuditor()));
        }
        // 能力获取审核人id
        if (null != prdCompositeAbilityQuery.getAuditorId()) {
            predicates.add(qPrdCompositeAbilityDO.auditorId.eq(prdCompositeAbilityQuery.getAuditorId()));
        }
        // 能力获取审核人类型
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getAuditorType())) {
            predicates.add(qPrdCompositeAbilityDO.auditorType.eq(prdCompositeAbilityQuery.getAuditorType()));
        }
        // 能力以上标志
        if (null != prdCompositeAbilityQuery.getAbilityUpFlag()) {
            predicates.add(qPrdCompositeAbilityDO.abilityUpFlag.eq(prdCompositeAbilityQuery.getAbilityUpFlag()));
        }
        // 能力描述
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getAbilityDesc())) {
            predicates.add(qPrdCompositeAbilityDO.abilityDesc.eq(prdCompositeAbilityQuery.getAbilityDesc()));
        }
        // 名称
        if (StringUtils.isNotEmpty(prdCompositeAbilityQuery.getName())) {
            predicates.add(qPrdCompositeAbilityDO.name.eq(prdCompositeAbilityQuery.getName()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        long res = select(PrdCompositeAbilityVO.class)
                .where(bulidPredicate(prdCompositeAbilityQuery))
                .fetchCount();

        return res;


    }

    public Long updateState(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {
        long res = jpaQueryFactory.update(qPrdCompositeAbilityDO)
                .set(qPrdCompositeAbilityDO.state, prdCompositeAbilityPayload.getState())
                .where(qPrdCompositeAbilityDO.id.eq(prdCompositeAbilityPayload.getId()))
                .execute();
        return res;
    }

    public PagingVO<PrdCompositeAbilityVO> levelPage(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        JPAQuery<PrdCompositeAbilityVO> query = jpaQueryFactory.select(Projections.bean(PrdCompositeAbilityVO.class,
                        qPrdCompositeAbilityDO.docNo,
                        qPrdCompositeAbilityDO.levelId,
                        qPrdCompositeAbilityDO.levelName,
                        qPrdCompositeAbilityDO.state,
                        qPrdCompositeAbilityDO.firstAuditFlag,
                        qPrdCompositeAbilityDO.firstAuditor,
                        qPrdCompositeAbilityDO.firstAuditorId,
                        qPrdCompositeAbilityDO.firstAuditorType,
                        qPrdCompositeAbilityDO.firstAuditorUpFlag,
                        qPrdCompositeAbilityDO.jobType1,
                        qPrdCompositeAbilityDO.jobType2,
                        qPrdCompositeAbilityDO.crossLevelFlag,
                        qPrdCompositeAbilityDO.dlRatio,
                        qPrdCompositeAbilityDO.obtainType,
                        qPrdCompositeAbilityDO.auditor,
                        qPrdCompositeAbilityDO.auditorId,
                        qPrdCompositeAbilityDO.auditorType,
                        qPrdCompositeAbilityDO.abilityUpFlag,
                        qPrdCompositeAbilityDO.abilityDesc,
                        qPrdCompositeAbilityDO.id,
                        qPrdCompositeAbilityDO.createTime,
                        qPrdCompositeAbilityDO.remark,
                        qPrdAbilityLevelDO.abilityDesc,
                        qPrdAbilityLevelDO.dlRatio,
                        qPrdAbilityLevelDO.id.as("abilityLevelId"),
                        qPrdAbilityLevelDO.levelDtlName

                )).from(qPrdCompositeAbilityDO)
                .join(qPrdAbilityLevelDO).on(qPrdAbilityLevelDO.abilityId.eq(qPrdCompositeAbilityDO.id))
                .where(bulidPredicate(prdCompositeAbilityQuery))
                .where(qPrdAbilityLevelDO.deleteFlag.eq(0));

        prdCompositeAbilityQuery.setPaging(query);
        prdCompositeAbilityQuery.fillOrders(query, qPrdCompositeAbilityDO);
        return PagingVO.<PrdCompositeAbilityVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public List<PrdCompositeAbilityVO> levelList(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        return jpaQueryFactory.select(Projections.bean(PrdCompositeAbilityVO.class,
                        qPrdCompositeAbilityDO.docNo,
                        qPrdCompositeAbilityDO.levelId,
                        qPrdCompositeAbilityDO.levelName,
                        qPrdCompositeAbilityDO.state,
                        qPrdCompositeAbilityDO.firstAuditFlag,
                        qPrdCompositeAbilityDO.firstAuditor,
                        qPrdCompositeAbilityDO.firstAuditorId,
                        qPrdCompositeAbilityDO.firstAuditorType,
                        qPrdCompositeAbilityDO.firstAuditorUpFlag,
                        qPrdCompositeAbilityDO.jobType1,
                        qPrdCompositeAbilityDO.jobType2,
                        qPrdCompositeAbilityDO.crossLevelFlag,
                        qPrdCompositeAbilityDO.dlRatio,
                        qPrdCompositeAbilityDO.obtainType,
                        qPrdCompositeAbilityDO.auditor,
                        qPrdCompositeAbilityDO.auditorId,
                        qPrdCompositeAbilityDO.auditorType,
                        qPrdCompositeAbilityDO.abilityUpFlag,
                        qPrdCompositeAbilityDO.abilityDesc,
                        qPrdCompositeAbilityDO.id,
                        qPrdCompositeAbilityDO.createTime,
                        qPrdCompositeAbilityDO.remark,
                        qPrdAbilityLevelDO.abilityDesc,
                        qPrdAbilityLevelDO.dlRatio,
                        qPrdAbilityLevelDO.id.as("abilityLevelId"),
                        qPrdAbilityLevelDO.levelDtlName

                )).from(qPrdCompositeAbilityDO)
                .join(qPrdAbilityLevelDO).on(qPrdAbilityLevelDO.abilityId.eq(qPrdCompositeAbilityDO.id))
                .where(bulidPredicate(prdCompositeAbilityQuery))
                .where(qPrdAbilityLevelDO.deleteFlag.eq(0))
                .fetch();

    }

    public PrdCompositeAbilityVO findByAbilityLevelId(Long abilityLevelId) {

        return jpaQueryFactory.select(Projections.bean(PrdCompositeAbilityVO.class,
                        qPrdCompositeAbilityDO.docNo,
                        qPrdCompositeAbilityDO.levelId,
                        qPrdCompositeAbilityDO.levelName,
                        qPrdCompositeAbilityDO.state,
                        qPrdCompositeAbilityDO.firstAuditFlag,
                        qPrdCompositeAbilityDO.firstAuditor,
                        qPrdCompositeAbilityDO.firstAuditorId,
                        qPrdCompositeAbilityDO.firstAuditorType,
                        qPrdCompositeAbilityDO.firstAuditorUpFlag,
                        qPrdCompositeAbilityDO.jobType1,
                        qPrdCompositeAbilityDO.jobType2,
                        qPrdCompositeAbilityDO.crossLevelFlag,
                        qPrdCompositeAbilityDO.dlRatio,
                        qPrdCompositeAbilityDO.obtainType,
                        qPrdCompositeAbilityDO.auditor,
                        qPrdCompositeAbilityDO.auditorId,
                        qPrdCompositeAbilityDO.auditorType,
                        qPrdCompositeAbilityDO.abilityUpFlag,
                        qPrdCompositeAbilityDO.abilityDesc,
                        qPrdCompositeAbilityDO.id,
                        qPrdCompositeAbilityDO.createTime,
                        qPrdCompositeAbilityDO.remark,
                        qPrdAbilityLevelDO.abilityDesc,
                        qPrdAbilityLevelDO.dlRatio,
                        qPrdAbilityLevelDO.id.as("abilityLevelId"),
                        qPrdAbilityLevelDO.levelDtlName

                )).from(qPrdCompositeAbilityDO)
                .join(qPrdAbilityLevelDO).on(qPrdAbilityLevelDO.abilityId.eq(qPrdCompositeAbilityDO.id))
                .where(qPrdAbilityLevelDO.id.eq(abilityLevelId))
                .where(qPrdAbilityLevelDO.deleteFlag.eq(0))
                .fetchFirst();

    }

    public void updateByName(PrdCompositeAbilityVO prdCompositeAbilityVO) {

        jpaQueryFactory.update(qPrdCompositeAbilityDO)
                .set(qPrdCompositeAbilityDO.name, prdCompositeAbilityVO.getName())
                .where(qPrdCompositeAbilityDO.id.eq(prdCompositeAbilityVO.getId()))
                .execute();
    }

}

