package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdExamTempGradeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdExamTempGradeDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempGradePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempGradeVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板等级RepoProc
 */

@Component
public class PrdExamTempGradeDao extends BaseRepoProc<PrdExamTempGradeDO> {

    private static final QPrdExamTempGradeDO qPrdExamTempGradeDO = QPrdExamTempGradeDO.prdExamTempGradeDO;


    protected PrdExamTempGradeDao() {

        super(qPrdExamTempGradeDO);

    }


    public PagingVO<PrdExamTempGradeVO> page(PrdExamTempGradeQuery prdExamTempGradeQuery) {

        JPAQuery<PrdExamTempGradeVO> query =
                select(PrdExamTempGradeVO.class)
                        .where(bulidPredicate(prdExamTempGradeQuery));
        prdExamTempGradeQuery.setPaging(query);
        prdExamTempGradeQuery.fillOrders(query, qPrdExamTempGradeDO);
        return PagingVO.<PrdExamTempGradeVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdExamTempGradeDO)
                .set(qPrdExamTempGradeDO.deleteFlag, 1)
                .where(qPrdExamTempGradeDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdExamTempGradeVO get(Long id) {

        PrdExamTempGradeVO prdExamTempGradeVO = select(PrdExamTempGradeVO.class)
                .where(qPrdExamTempGradeDO.id.eq(id))
                .fetchOne();

        return prdExamTempGradeVO;

    }


    public List<PrdExamTempGradeVO> getList(PrdExamTempGradeQuery prdExamTempGradeQuery) {

        List<PrdExamTempGradeVO> res =
                select(PrdExamTempGradeVO.class)
                        .where(bulidPredicate(prdExamTempGradeQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdExamTempGradeDO.tempId,
                        qPrdExamTempGradeDO.name,
                        qPrdExamTempGradeDO.scoreRatioStart,
                        qPrdExamTempGradeDO.scoreRatioEnd,
                        qPrdExamTempGradeDO.id,
                        qPrdExamTempGradeDO.createTime,
                        qPrdExamTempGradeDO.remark

                )).from(qPrdExamTempGradeDO);

    }


    private Predicate bulidPredicate(PrdExamTempGradeQuery prdExamTempGradeQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdExamTempGradeQuery.getTempId(), qPrdExamTempGradeDO.tempId, prdExamTempGradeQuery.getTempId())
                .andEq(StringUtils.isNotBlank(prdExamTempGradeQuery.getName()), qPrdExamTempGradeDO.name, prdExamTempGradeQuery.getName())
                .andEq(null != prdExamTempGradeQuery.getScoreRatioStart(), qPrdExamTempGradeDO.scoreRatioStart, prdExamTempGradeQuery.getScoreRatioStart())
                .andEq(null != prdExamTempGradeQuery.getScoreRatioEnd(), qPrdExamTempGradeDO.scoreRatioEnd, prdExamTempGradeQuery.getScoreRatioEnd())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdExamTempGradeQuery prdExamTempGradeQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 模板id
        if (null != prdExamTempGradeQuery.getTempId()) {
            predicates.add(qPrdExamTempGradeDO.tempId.eq(prdExamTempGradeQuery.getTempId()));
        }
        // 等级名称
        if (StringUtils.isNotEmpty(prdExamTempGradeQuery.getName())) {
            predicates.add(qPrdExamTempGradeDO.name.eq(prdExamTempGradeQuery.getName()));
        }
        // 分数占比开始
        if (null != prdExamTempGradeQuery.getScoreRatioStart()) {
            predicates.add(qPrdExamTempGradeDO.scoreRatioStart.eq(prdExamTempGradeQuery.getScoreRatioStart()));
        }
        // 分数占比结束
        if (null != prdExamTempGradeQuery.getScoreRatioEnd()) {
            predicates.add(qPrdExamTempGradeDO.scoreRatioEnd.eq(prdExamTempGradeQuery.getScoreRatioEnd()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdExamTempGradeQuery prdExamTempGradeQuery) {

        long res = select(PrdExamTempGradeVO.class)
                .where(bulidPredicate(prdExamTempGradeQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdExamTempGradePayload prdExamTempGradePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdExamTempGradeDO);

        // 模板id
        if (null != prdExamTempGradePayload.getTempId()) {
            update.set(qPrdExamTempGradeDO.tempId, prdExamTempGradePayload.getTempId());
        }
        // 等级名称
        if (StringUtils.isNotEmpty(prdExamTempGradePayload.getName())) {
            update.set(qPrdExamTempGradeDO.name, prdExamTempGradePayload.getName());
        }
        // 分数占比开始
        if (null != prdExamTempGradePayload.getScoreRatioStart()) {
            update.set(qPrdExamTempGradeDO.scoreRatioStart, prdExamTempGradePayload.getScoreRatioStart());
        }
        // 分数占比结束
        if (null != prdExamTempGradePayload.getScoreRatioEnd()) {
            update.set(qPrdExamTempGradeDO.scoreRatioEnd, prdExamTempGradePayload.getScoreRatioEnd());
        }
        long res = update.where(qPrdExamTempGradeDO.id.eq(prdExamTempGradePayload.getId()))
                .execute();
        return res;

    }

    public Long delByTempId(Long id) {
        long res = jpaQueryFactory.update(qPrdExamTempGradeDO)
                .set(qPrdExamTempGradeDO.deleteFlag, 1)
                .where(qPrdExamTempGradeDO.tempId.eq(id))
                .execute();
        return res;
    }


}

