package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempPointService;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdExamTempPointConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdExamTempPointDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempPointQuery;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdExamTempPointRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdExamTempPointDao;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempPointVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板-绩效考核点Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdExamTempPointServiceImpl implements PrdExamTempPointService {


    private final PrdExamTempPointDao prdExamTempPointDao;

    private final PrdExamTempPointRepo prdExamTempPointRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdExamTempPointVO save(PrdExamTempPointPayload prdExamTempPointPayload) {

        checkData(prdExamTempPointPayload);
        PrdExamTempPointDO prdExamTempPointDO = new PrdExamTempPointDO();
        prdExamTempPointDO = PrdExamTempPointConvert.INSTANCE.p2d(prdExamTempPointPayload);
        PrdExamTempPointDO res = prdExamTempPointRepo.save(prdExamTempPointDO);
        return PrdExamTempPointConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdExamTempPointVO update(PrdExamTempPointPayload prdExamTempPointPayload) {

        Assert.notNull(prdExamTempPointPayload.getId(), "id is null");
        PrdExamTempPointVO res = save(prdExamTempPointPayload);
        return res;

    }


    @Override
    public PrdExamTempPointVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdExamTempPointVO res = prdExamTempPointDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdExamTempPointVO> page(PrdExamTempPointQuery prdExamTempPointQuery) {

        PagingVO<PrdExamTempPointVO> res = prdExamTempPointDao.page(prdExamTempPointQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdExamTempPointDao.del(ids);
        return res;

    }

    @Override
    public List<PrdExamTempPointVO> getList(PrdExamTempPointQuery prdExamTempPointQuery) {

        List<PrdExamTempPointVO> res = prdExamTempPointDao.getList(prdExamTempPointQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdExamTempPointPayload
     */
    private void checkData(PrdExamTempPointPayload prdExamTempPointPayload) {

        if (null == prdExamTempPointPayload.getWeightRatio()) {
            throw new BusinessException("权重不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdExamTempPointPayload prdExamTempPointPayload) {
        Assert.notNull(prdExamTempPointPayload.getId(), "id不能为空");
        Long res = prdExamTempPointDao.update(prdExamTempPointPayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delByTempId(Long id) {
        Long res = prdExamTempPointDao.delByTempId(id);
    }


}

