package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.OfferEntryApplyProcPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.OfferEntryApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.OfferEntryApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.OfferEntryApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QOfferEntryApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.OfferEntryApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class OfferEntryApplyDAO {

    private final OfferEntryApplyRepo offerEntryApplyRepo;

    private final QOfferEntryApplyDO qOfferEntryApplyDO = QOfferEntryApplyDO.offerEntryApplyDO;

    private final JPAQueryFactory jpaQueryFactory;

    private final QPrdOrgPersonDO qPrdOrgPersonDO = QPrdOrgPersonDO.prdOrgPersonDO;


    public OfferEntryApplyDO save(OfferEntryApplyDO offerEntryApplyDO) {
        return offerEntryApplyRepo.save(offerEntryApplyDO);
    }

    public OfferEntryApplyDO queryByProcId(String procId) {
        return offerEntryApplyRepo.findByProcInstId(procId);
    }

    public PagingVO<OfferEntryApplyVO> queryPaging(OfferEntryApplyQuery query) {
        JPAQuery<OfferEntryApplyVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<OfferEntryApplyVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<OfferEntryApplyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<OfferEntryApplyVO> getJpaQueryWhere(OfferEntryApplyQuery query) {
        JPAQuery<OfferEntryApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qOfferEntryApplyDO.deleteFlag.eq(0));

        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            jpaQuery.where(qOfferEntryApplyDO.procInstStatus.eq(query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getPersonName())) {
            jpaQuery.where(qOfferEntryApplyDO.personName.eq(query.getPersonName()));
        }
        if (!ObjectUtils.isEmpty(query.getDeliverOffer())) {
            jpaQuery.where(qOfferEntryApplyDO.deliverOffer.eq(query.getDeliverOffer()));
        }
        if (!ObjectUtils.isEmpty(query.getNoneOfferReason())) {
            jpaQuery.where(qOfferEntryApplyDO.noneOfferReason.like(SqlUtil.toSqlLikeString(query.getNoneOfferReason())));
        }
        if (!ObjectUtils.isEmpty(query.getJobs())) {
            jpaQuery.where(qOfferEntryApplyDO.jobs.like(SqlUtil.toSqlLikeString(query.getJobs())));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qOfferEntryApplyDO.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qOfferEntryApplyDO.extString5.eq(query.getExtString5()));
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            jpaQuery.where(qOfferEntryApplyDO.parentId.eq(query.getParentId()));
        }
        if (!ObjectUtils.isEmpty(query.getCooperationMode())) {
            jpaQuery.where(qOfferEntryApplyDO.cooperationMode.eq(query.getCooperationMode()));
        }
        if (!ObjectUtils.isEmpty(query.getInLieuFlag())) {
            jpaQuery.where(qOfferEntryApplyDO.inLieuFlag.eq(query.getInLieuFlag()));
        }
        if (!ObjectUtils.isEmpty(query.getBusiTrainFlag())) {
            jpaQuery.where(qOfferEntryApplyDO.busiTrainFlag.eq(query.getBusiTrainFlag()));
        }

        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qOfferEntryApplyDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qOfferEntryApplyDO, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<OfferEntryApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(OfferEntryApplyVO.class,
                        qOfferEntryApplyDO.id,
                        qOfferEntryApplyDO.createTime,
                        qOfferEntryApplyDO.procInstName,
                        qOfferEntryApplyDO.procInstId,
//                        qOfferEntryApplyDO.personName,
                        qOfferEntryApplyDO.deliverOffer,
                        qOfferEntryApplyDO.noneOfferReason,
                        qOfferEntryApplyDO.enrollDate,
                        qOfferEntryApplyDO.orgId,
                        qOfferEntryApplyDO.extString5,
                        qOfferEntryApplyDO.parentId,
                        qOfferEntryApplyDO.cooperationMode,
                        qOfferEntryApplyDO.jobs,
                        qOfferEntryApplyDO.createUserId,
                        qOfferEntryApplyDO.personId,
                        qOfferEntryApplyDO.procInstStatus,
                        qOfferEntryApplyDO.inLieuFlag,
                        qOfferEntryApplyDO.busiTrainFlag,
                        qOfferEntryApplyDO.extString6,
                        qOfferEntryApplyDO.bookId,
                        qOfferEntryApplyDO.entryType,
                        qOfferEntryApplyDO.internshipStartDate,
                        qOfferEntryApplyDO.platformEmail,
                        qPrdOrgPersonDO.personName
                )).from(qOfferEntryApplyDO)
                .leftJoin(qPrdOrgPersonDO).on(qOfferEntryApplyDO.personId.eq(qPrdOrgPersonDO.id));
    }

    public OfferEntryApplyVO queryByKey(Long applyId) {
        return getJpaQuerySelect().where(qOfferEntryApplyDO.id.eq(applyId)).fetchFirst();
    }

    public List<OfferEntryApplyDO> queryByPersonId(Long personId) {
        return offerEntryApplyRepo.findAllByPersonId(personId);
    }

    public void updateProcStatus(OfferEntryApplyProcPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qOfferEntryApplyDO)
                .where(qOfferEntryApplyDO.id.eq(payload.getId()));

        if (payload.getProcInstId() != null) {
            update.set(qOfferEntryApplyDO.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qOfferEntryApplyDO.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qOfferEntryApplyDO.approvedTime, payload.getApprovedTime());
        }

        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qOfferEntryApplyDO.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qOfferEntryApplyDO.procInstId);
            }
        }
        // 执行修改
        update.execute();
    }

}
