package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonRewardPunishDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonRewardPunishDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonRewardPunishRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PersonRewardPunishDAO {
    private final PersonRewardPunishRepo personRewardPunishRepo;
    private final JPAQueryFactory jpaQueryFactory;

    private final QPersonRewardPunishDO personRewardPunishDO = QPersonRewardPunishDO.personRewardPunishDO;

    public List<PersonRewardPunishDO> findAllByPersonId(Long personId) {
        return personRewardPunishRepo.findAllByPersonId(personId);
    }

    public void deleteAllByPersonId(Long personId) {
        jpaQueryFactory.update(personRewardPunishDO)
                .set(personRewardPunishDO.deleteFlag, 1)
                .where(personRewardPunishDO.personId.eq(personId))
                .execute();
    }

    public void saveAll(List<PersonRewardPunishDO> personRewardPunishDOS) {
        personRewardPunishRepo.saveAll(personRewardPunishDOS);
    }
    
}
