package com.elitesland.tw.tw5.server.prd.mpxj.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDate;

@Entity
@Table(name = "mpxj_mpp_task")
@org.hibernate.annotations.Table(appliesTo = "mpxj_mpp_task", comment = "project-mpp表")
@Data
@Getter
@Setter
public class MpxjMppTaskDO extends BaseModel {
    @Comment("项目id")
    @Column()
    private Long projectId;

    @Comment("wbsId")
    @Column()
    private Long wbsId;

    @Comment("上级id")
    @Column()
    private Long parentId;

    @Comment("行id")
    @Column()
    private Integer rowId;

    @Comment("行父级id")
    @Column()
    private Integer rowParentId;

    @Comment("层级")
    @Column()
    private Integer tasKLevel;//层级
    @Comment("wbs码")
    @Column()
    private String wbsCode;//wbs码
    @Comment("任务名称")
    @Column()
    private String taskName;//任务名称
    @Comment("任务进度")
    @Column()
    private String taskProgress;//任务进度
    @Comment("开始时间")
    @Column()
    private LocalDate planStartDate;//开始时间
    @Comment("结束时间")
    @Column()
    private LocalDate planFinishDate;//结束时间
    @Comment("基线2完成时间")
    @Column()
    private LocalDate baseline2FinishDate;//基线2完成时间
    @Comment("工期")
    @Column()
    private Double planDueDate;//工期
    @Comment("资源名称")
    @Column()
    private String sourceName;//资源名称
    @Comment("前置任务")
    @Column()
    private String taskPredecessors;//前置任务
    @Comment("总成型任务标记")
    @Column()
    private Boolean summaryFlag;//工期

}
