package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TUserVacationCancelPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TUserVacationCancelQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TUserVacationCancelVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTUserVacationCancelDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QUserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TUserVacationCancelDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TUserVacationCancelRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 假期取消申请
 *
 * @author carl
 * @date 2024-06-18
 */
@Repository
@RequiredArgsConstructor
public class TUserVacationCancelDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TUserVacationCancelRepo repo;
    private final QTUserVacationCancelDO qdo = QTUserVacationCancelDO.tUserVacationCancelDO;
    private static final QUserVacationApplyDO qdoApply = QUserVacationApplyDO.userVacationApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TUserVacationCancelVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TUserVacationCancelVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 用户id
                qdo.userId,
                // 直属领导id
                qdo.pUserId,
                // 部门id
                qdo.orgId,
                // 请假id
                qdo.applyId,
                // 公司id
                qdo.companyId,
                // 请假单号
                qdo.applyNo,
                // 操作类型
                qdo.operType,
                // 阶段活动名称
                qdo.cancelDesc,
                // 操作日期
                qdo.cancelDate,
                // 审批状态
                qdo.procInstStatus,
                // 流程id
                qdo.procInstId
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TUserVacationCancelVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(TUserVacationCancelVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 用户id
                qdo.userId,
                // 直属领导id
                qdo.pUserId,
                // 部门id
                qdo.orgId,
                // 请假id
                qdo.applyId,
                // 公司id
                qdo.companyId,
                // 请假单号
                qdo.applyNo,
                // 操作类型
                qdo.operType,

                // 阶段活动名称
                qdo.cancelDesc,
                // 操作日期
                qdo.cancelDate,
                // 审批状态
                qdo.procInstStatus,
                // 流程id
                qdo.procInstId,
                qdoApply.startDate,
                qdoApply.endDate,
                qdoApply.vacationDays
        )).from(qdo).leftJoin(qdoApply).on(qdo.applyId.eq(qdoApply.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TUserVacationCancelVO> getJpaQueryWhere(TUserVacationCancelQuery query) {
        JPAQuery<TUserVacationCancelVO> jpaQuery = getJpaQuerySelect0();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);

        jpaQuery.groupBy(qdo.id);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TUserVacationCancelQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TUserVacationCancelQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 用户id 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            list.add(qdo.userId.eq(query.getUserId()));
        }
        /** 直属领导id 精确 */
        if (!ObjectUtils.isEmpty(query.getPUserId())) {
            list.add(qdo.pUserId.eq(query.getPUserId()));
        }
        /** 部门id 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            list.add(qdo.orgId.eq(query.getOrgId()));
        }
        /** 请假id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyId())) {
            list.add(qdo.applyId.eq(query.getApplyId()));
        }
        /** 公司id 精确 */
        if (!ObjectUtils.isEmpty(query.getCompanyId())) {
            list.add(qdo.companyId.eq(query.getCompanyId()));
        }
        /** 请假单号 模糊 */
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            list.add(qdo.applyNo.like(SqlUtil.toSqlLikeString(query.getApplyNo())));
        }
        /** 操作类型 精确 */
        if (!ObjectUtils.isEmpty(query.getOperType())) {
            list.add(qdo.operType.eq(query.getOperType()));
        }
        /** 阶段活动名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getCancelDesc())) {
            list.add(qdo.cancelDesc.like(SqlUtil.toSqlLikeString(query.getCancelDesc())));
        }
        /** 操作日期 精确 */
        if (!ObjectUtils.isEmpty(query.getCancelDate())) {
            list.add(qdo.cancelDate.eq(query.getCancelDate()));
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 流程id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TUserVacationCancelVO queryByKey(Long id) {
        JPAQuery<TUserVacationCancelVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<TUserVacationCancelVO> queryByKeys(List<Long> ids) {
        JPAQuery<TUserVacationCancelVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TUserVacationCancelVO> queryListDynamic(TUserVacationCancelQuery query) {
        JPAQuery<TUserVacationCancelVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);

        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TUserVacationCancelVO> queryPaging(TUserVacationCancelQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TUserVacationCancelVO> jpaQuery = getJpaQueryWhere(query);
        List<TUserVacationCancelVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TUserVacationCancelVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TUserVacationCancelDO save(TUserVacationCancelDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TUserVacationCancelDO> saveAll(List<TUserVacationCancelDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TUserVacationCancelPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 用户id
        if (payload.getUserId() != null) {
            update.set(qdo.userId, payload.getUserId());
        }
        // 直属领导id
        if (payload.getPUserId() != null) {
            update.set(qdo.pUserId, payload.getPUserId());
        }
        // 部门id
        if (payload.getOrgId() != null) {
            update.set(qdo.orgId, payload.getOrgId());
        }
        // 请假id
        if (payload.getApplyId() != null) {
            update.set(qdo.applyId, payload.getApplyId());
        }
        // 公司id
        if (payload.getCompanyId() != null) {
            update.set(qdo.companyId, payload.getCompanyId());
        }
        // 请假单号
        if (payload.getApplyNo() != null) {
            update.set(qdo.applyNo, payload.getApplyNo());
        }
        // 操作类型
        if (payload.getOperType() != null) {
            update.set(qdo.operType, payload.getOperType());
        }
        // 阶段活动名称
        if (payload.getCancelDesc() != null) {
            update.set(qdo.cancelDesc, payload.getCancelDesc());
        }
        // 操作日期
        if (payload.getCancelDate() != null) {
            update.set(qdo.cancelDate, payload.getCancelDate());
        }
        // 审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 流程id
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 用户id
            if (nullFields.contains("userId")) {
                update.setNull(qdo.userId);
            }
            // 直属领导id
            if (nullFields.contains("pUserId")) {
                update.setNull(qdo.pUserId);
            }
            // 部门id
            if (nullFields.contains("orgId")) {
                update.setNull(qdo.orgId);
            }
            // 请假id
            if (nullFields.contains("applyId")) {
                update.setNull(qdo.applyId);
            }
            // 公司id
            if (nullFields.contains("companyId")) {
                update.setNull(qdo.companyId);
            }
            // 请假单号
            if (nullFields.contains("applyNo")) {
                update.setNull(qdo.applyNo);
            }
            // 操作类型
            if (nullFields.contains("operType")) {
                update.setNull(qdo.operType);
            }
            // 阶段活动名称
            if (nullFields.contains("cancelDesc")) {
                update.setNull(qdo.cancelDesc);
            }
            // 操作日期
            if (nullFields.contains("cancelDate")) {
                update.setNull(qdo.cancelDate);
            }
            // 审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 流程id
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

