package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 用印申请
 *
 * @author wangly
 * @date 2023-09-14
 */
@Entity
@Table(name = "t_busi_signet_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_busi_signet_apply", comment = "用印申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TBusiSignetApplyDO extends BaseModel implements Serializable  {
    /** BaseBU */
    @Comment("BaseBU")
    @Column()
    private Long basebuId;
    /** 所属公司 */
    @Comment("所属公司")
    @Column()
    private Long ouId;
    /** 联系电话 */
    @Comment("联系电话")
    @Column()
    private String phone;
    /** 邮箱 */
    @Comment("邮箱")
    @Column()
    private String email;
    /** 印章场景 */
    @Comment("印章场景")
    @Column()
    private String signetScene;
    /** 是否需要打印 */
    @Comment("是否需要打印 1是0否")
    @Column()
    private Boolean printFlag;
    /** 印章类型 */
    @Comment("印章类型")
    @Column()
    private String signetType;
    /** 相关印章 */
    @Comment("相关印章")
    @Column()
    private String relatedSignet;
    /** 印章所属公司 */
    @Comment("印章所属公司")
    @Column()
    private String signetBelongCompany;
    /** 印章用途 */
    @Comment("印章用途")
    @Column()
    private String signetPurpose;
    /** 申请印章 */
    @Comment("申请印章")
    @Column()
    private String signetApply;
    /** 是否外借 */
    @Comment("是否外借")
    @Column()
    private Boolean lendFlag;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCode;
    /** 印章归还说明 */
    @Comment("印章归还说明")
    @Column()
    private String signetReturnRemark;
    /** 申请人 */
    @Comment("申请人")
    @Column()
    private Long applyResId;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 预计归还时间 */
    @Comment("预计归还时间")
    @Column()
    private LocalDate predictReturnTime;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字段4 */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /** 扩展字段5 */
    @Comment("扩展字段5")
    @Column()
    private String ext5;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    public void copy(TBusiSignetApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
