package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 工时用-任务表
 *
 * @author duwh
 * @date 2022-12-10
 */
@Entity
@Table(name = "t_task", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_task", comment = "工时用-任务表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskDO extends BaseModel {
    /**
     * 4.0任务主键
     */
    @Comment("4.0任务主键")
    @Column(name = "task_id_v4")
    private Long taskIdV4;
    /**
     * 任务编号
     */
    @Comment("任务编号")
    @Column()
    private String taskNo;
    /**
     * 任务名称
     */
    @Comment("任务名称")
    @Column()
    private String taskName;
    /**
     * 任务状态
     */
    @Comment("任务状态")
    @Column()
    private String taskStatus;
    /**
     * 发包资源id
     */
    @Comment("发包资源id")
    @Column()
    private Long disterUserId;
    /**
     * 费用承担bu_id
     */
    @Comment("费用承担bu_id")
    @Column()
    private Long expenseBuId;
    /**
     * 接收资源bu_id
     */
    @Comment("接收资源bu_id")
    @Column()
    private Long receiverBuId;
    /**
     * 接收资源id
     */
    @Comment("接收资源id")
    @Column()
    private Long receiverUserId;
    /**
     * 事由类型 01 项目 02 售前 03 bu
     */
    @Comment("事由类型 01 项目 02 售前 03 bu")
    @Column()
    private String reasonType;
    /**
     * 事由id
     */
    @Comment("事由id")
    @Column()
    private Long reasonId;
    /**
     * 4.0事由id
     */
    @Comment("4.0事由id")
    @Column(name = "reason_id_v4")
    private Long reasonIdv4;
    /**
     * 计划开始日期
     */
    @Comment("计划开始日期")
    @Column()
    private LocalDate planStartDate;
    /**
     * 计划结束日期
     */
    @Comment("计划结束日期")
    @Column()
    private LocalDate planEndDate;
    /**
     * 验收方式
     */
    @Comment("验收方式")
    @Column()
    private String acceptMethod;
    /**
     * 计价方式
     */
    @Comment("计价方式")
    @Column()
    private String pricingMethod;
    /**
     * 派发人天数
     */
    @Comment("派发人天数")
    @Column()
    private BigDecimal days;
    /**
     * bu结算价
     */
    @Comment("bu结算价")
    @Column()
    private BigDecimal buSettlePrice;
    /**
     * 派发当量系数
     */
    @Comment("派发当量系数")
    @Column()
    private BigDecimal eqvaRatio;
    /**
     * 总当量数
     */
    @Comment("总当量数")
    @Column()
    private BigDecimal eqvaQty;
    /**
     * 当量结算单价
     */
    @Comment("当量结算单价")
    @Column()
    private BigDecimal settlePrice;
    /**
     * 已结算当量数
     */
    @Comment("已结算当量数")
    @Column()
    private BigDecimal settledEqva;
    /**
     * 已结算人天数
     */
    @Comment("已结算人天数")
    @Column()
    private BigDecimal settledDays;
    /**
     * 已结算金额
     */
    @Comment("已结算金额")
    @Column()
    private BigDecimal settledAmt;
    /**
     * 任务包类型
     */
    @Comment("任务包类型")
    @Column()
    private String taskPackageType;
    /**
     * 任务来源类型
     */
    @Comment("任务来源类型")
    @Column()
    private String taskSourceType;
    /**
     * 任务包关闭时间
     */
    @Comment("任务包关闭时间")
    @Column()
    private LocalDateTime closedTime;
    /**
     * 定时任务自动结算当量标记
     */
    @Comment("定时任务自动结算当量标记")
    @Column()
    private Integer autoSettleFlag;
    /**
     * 发包日期
     */
    @Comment("发包日期")
    @Column()
    private LocalDate distDate;
    /**
     * 追加当量;记录任务包当量变更流程累计追加的当量
     */
    @Comment("追加当量;记录任务包当量变更流程累计追加的当量")
    @Column()
    private BigDecimal addEqva;
    /**
     * 原始发包当量；用于记录第一次任务包派发流程审批通过时的任务包当量
     */
    @Comment("原始发包当量；用于记录第一次任务包派发流程审批通过时的任务包当量")
    @Column()
    private BigDecimal baseTaskEqva;
    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /**
     * 拓展4
     */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /**
     * 拓展5
     */
    @Comment("拓展5")
    @Column()
    private String ext5;

    //TODO 需要4.0同步到5.0的时候  根据reasonType 动态冗余
    /**
     * 事由名称冗余
     */
    @Comment("事由名称冗余")
    @Column()
    private String reasonName;

    /**
     * 已填工时当量
     */
    @Comment("已填工时当量")
    @Column()
    private BigDecimal usedEqva;

    /**
     * 工时填报剩余可用当量
     */
    @Comment("工时填报剩余可用当量")
    @Column()
    private BigDecimal effectiveEqva;


    public void copy(TaskDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
