package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.extra.spring.SpringUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleDetailPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.MonthlyTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetApproveQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetSubsidySettingQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetSubsidySettingService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeLeaderQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeSuperiorQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsTimesheetProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSettingService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalResQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalConfigService;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalResService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.SystemSettingEnum;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.budget.common.functionEnum.BudgetCostType;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.OrgEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RestStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.*;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.VacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.OvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.work.dao.OvertimeApplicationDAO;
import com.elitesland.tw.tw5.server.prd.work.repo.OvertimeApplicationRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.querydsl.core.QueryResults;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus.*;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsTimesheetServiceImpl implements PmsTimesheetService {

    private final TimesheetRepo timesheetRepo;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final PmsProjectService pmsProjectService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserDAO daoUser;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final TimesheetDAO timesheetDAO;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;
    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final OvertimeApplicationRepo overtimeApplicationRepo;
    private final OvertimeApplicationDAO overtimeApplicationDAO;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final TaskInfoService taskInfoService;
    private final VacationDAO vacationDAO;
    private final TaskCommonService taskCommonService;
    private final TaskPackageService taskPackageService;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final PmsResourcePlanRoleService pmsResourcePlanRoleService;
    private final CacheUtil cacheUtil;
    private final com.elitesland.tw.tw5.server.common.ExcelUtil twExcelUtil;
    private final UdcUtil udcUtil;

    private final UserVacationService userVacationService;
    @Autowired
    @Lazy
    private VacationService vacationService;
    private final TsApprovalResService tsApprovalResService;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;
    private final CalTaskSettleService calTaskSettleService;
    private BeanSearcher beanSearcher;
    private final CrmOpportunityService crmOpportunityService;
    private final BuProjectService buProjectService;
    private final PrdSystemSettingService prdSystemSettingService;
    private final TimesheetSubsidySettingService timesheetSubsidySettingService;
    private final BudgetCommonService budgetCommonService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_TIME_SHEET);
    }

    /**
     * 工时分页查询
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    @Override
    public PagingVO<TimesheetVO> paging(TimesheetQuery query) {
        PagingVO<TimesheetVO> timesheetVOPagingVO = timesheetDAO.queryPaging(query);
        List<Long> timesheetIds = new ArrayList<>();
        if (timesheetVOPagingVO.getTotal() > 0) {
            List<Long> userIds = timesheetVOPagingVO.getRecords().stream().map(TimesheetVO::getTsUserId).distinct().collect(Collectors.toList());
            List<PrdOrgEmployeeDO> prdOrgEmployeeDOS = prdOrgEmployeeDAO.queryListByUserIdList(userIds);
            Map<Long, PrdOrgEmployeeDO> maps = prdOrgEmployeeDOS.stream().collect(Collectors.toMap(PrdOrgEmployeeDO::getUserId, Function.identity()));
            timesheetVOPagingVO.getRecords().forEach(vo -> {
                timesheetIds.add(vo.getId());
                PrdOrgEmployeeDO prdOrgEmployeeDO = maps.get(vo.getTsUserId());
                if (prdOrgEmployeeDO != null) {
                    vo.setBaseCityId(prdOrgEmployeeDO.getExtString5());
                }
            });
            //获取审批记录
            getApprovalResLogs(timesheetVOPagingVO.getRecords());
        }
        return timesheetVOPagingVO;
    }

    /**
     * 获取审批记录
     *
     * @param timesheetVOS
     */
    void getApprovalResLogs(List<TimesheetVO> timesheetVOS) {
//        if(query.getAppFlag()!=null && query.getAppFlag()==1){
        // 审批记录查询
        List<Long> timesheetIds = timesheetVOS.stream().map(TimesheetVO::getId).collect(Collectors.toList());
        TsApprovalResQuery tsApprovalResQuery = new TsApprovalResQuery();
        tsApprovalResQuery.setTimesheetIds(timesheetIds);
        // 审批记录查询
        List<TsApprovalResVO> tsApprovalResVOS = tsApprovalResService.queryListDynamic(tsApprovalResQuery);
        tsApprovalResVOS = udcUtil.translateList(tsApprovalResVOS);
        // 分组和排序
        Map<Long, List<TsApprovalResVO>> groupedByTimesheetId = tsApprovalResVOS.stream()
                .collect(Collectors.groupingBy(TsApprovalResVO::getTimesheetId,
                        Collectors.collectingAndThen(Collectors.toList(), list -> {
                            list.sort(Comparator.comparingInt(TsApprovalResVO::getSortIndex));
                            return list;
                        })
                ));
        timesheetVOS.forEach(vo -> {
            List<TsApprovalResVO> tsApprovalResVOS1 = groupedByTimesheetId.get(vo.getId());
            if (!CollectionUtils.isEmpty(tsApprovalResVOS1)) {
                vo.setTsApprovalResVOS(tsApprovalResVOS1);
            }
            // 设置审批人的岗位
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(vo.getTsUserId());
            if (employee != null) {
                vo.setJobsName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), employee.getJobs()));
            }
        });

//        }
    }

    // 获取项目归属部门
    private void getProjectBuName(List<TimesheetVO> timesheetVOS) {
        if (!CollectionUtils.isEmpty(timesheetVOS)) {

            // 如果是无项目无任务 取当前填报人的所在bu
            List<TimesheetVO> noProjectVOS = timesheetVOS.stream().filter(vo -> PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(vo.getReasonType()) && BigDecimal.ZERO.compareTo(new BigDecimal(vo.getReasonId())) == 0).collect(Collectors.toList());
            if(!CollectionUtils.isEmpty(noProjectVOS)){
                noProjectVOS.stream().forEach(vo -> {
                    vo.setProjectBuName(cacheUtil.getOrgName(vo.getTsUserBuId()));
                });
            }
            //合同项目
            List<TimesheetVO> contractProjectVOS = timesheetVOS.stream().filter(vo -> PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(vo.getReasonType()) && BigDecimal.ZERO.compareTo(new BigDecimal(vo.getReasonId())) != 0).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(contractProjectVOS)) {
                List<Long> contractProjectIdS = contractProjectVOS.stream().map(TimesheetVO::getReasonId).collect(Collectors.toList());
                List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryByKeysSimple(contractProjectIdS);
                final Map<Long, List<PmsProjectVO>> contractProjectMap = pmsProjectVOS.stream().collect(Collectors.groupingBy(PmsProjectVO::getId));
                contractProjectVOS.stream().forEach(vo -> {
                    if (contractProjectMap.containsKey(vo.getReasonId())) {
                        PmsProjectVO pmsProjectVO = contractProjectMap.get(vo.getReasonId()).get(0);
                        vo.setProjectBuName(cacheUtil.getOrgName(pmsProjectVO.getDeliBuId()));
                    }
                });
            }
            // bu项目
            List<TimesheetVO> buProjectVOS = timesheetVOS.stream().filter(vo -> PmsReasonTypeEnum.PROJ_BU.getCode().equals(vo.getReasonType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(buProjectVOS)) {
                List<Long> buProjectIdS = buProjectVOS.stream().map(TimesheetVO::getReasonId).collect(Collectors.toList());
                BuProjectQuery buProjectQuery = new BuProjectQuery();
                buProjectQuery.setIds(buProjectIdS);
                List<BuProjectVO> buProjectVOS1 = buProjectService.queryListDynamicSimple(buProjectQuery);
                final Map<Long, List<BuProjectVO>> buProjectMap = buProjectVOS1.stream().collect(Collectors.groupingBy(BuProjectVO::getId));
                buProjectVOS.stream().forEach(vo -> {
                    if (buProjectMap.containsKey(vo.getReasonId())) {
                        BuProjectVO buProjectVO = buProjectMap.get(vo.getReasonId()).get(0);
                        vo.setProjectBuName(cacheUtil.getOrgName(buProjectVO.getDeliBuId()));
                    }
                });
            }
            // 商机项目
            List<TimesheetVO> oppoProjectVOS = timesheetVOS.stream().filter(vo -> PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(vo.getReasonType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(oppoProjectVOS)) {
                List<Long> oppoProjectIdS = oppoProjectVOS.stream().map(TimesheetVO::getReasonId).collect(Collectors.toList());
                CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
                crmOpportunityQuery.setProjectIds(oppoProjectIdS);
                List<CrmOpportunityListVO> crmOpportunityListVOS = crmOpportunityService.queryListDynamic(crmOpportunityQuery);

                final Map<Long, List<CrmOpportunityListVO>> oppoProjectMap = crmOpportunityListVOS.stream().collect(Collectors.groupingBy(CrmOpportunityListVO::getProjectId));
                oppoProjectVOS.stream().forEach(vo -> {
                    if (oppoProjectMap.containsKey(vo.getReasonId())) {
                        CrmOpportunityListVO crmOpportunityListVO = oppoProjectMap.get(vo.getReasonId()).get(0);
                        vo.setProjectBuName(cacheUtil.getOrgName(crmOpportunityListVO.getPreSaleOrgId()));
                    }
                });
            }
        }
    }

    @Override
    public PagingVO<TimesheetVO> pagingPermission(TimesheetQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(TimesheetVO.class, mapBuilder.build());
        long total = (long) totalNum;
        if (total == 0) {
            return PagingVO.empty();
        }
        List<TimesheetVO> timesheetVOS = beanSearcher.searchList(TimesheetVO.class, mapBuilder.build());
        //获取审批记录
        getApprovalResLogs(timesheetVOS);
        // 获取项目归属部门
        getProjectBuName(timesheetVOS);
        return PagingVO.<TimesheetVO>builder().records(timesheetVOS).total(total).build();
    }

    @Override
    public List<TimesheetVO> listPermission(TimesheetQuery query) {
        query.setCurrent(0);
        query.setSize(2500000);
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        List<TimesheetVO> timesheetVOS = beanSearcher.searchList(TimesheetVO.class, mapBuilder.build());
        //获取审批记录
        // getApprovalResLogs(timesheetVOS);
        timesheetVOS.stream().forEach(vo -> {
                    // 设置审批人的岗位
                    PrdOrgEmployeeVO employee = cacheUtil.getEmployee(vo.getTsUserId());
                    if (employee != null) {
                        vo.setJobsName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), employee.getJobs()));
                    }
                }
        );
        getProjectBuName(timesheetVOS);
        return timesheetVOS;
    }

    /**
     * 分页权限 条件封装
     *
     * @param query 查询
     * @return {@link MapBuilder}
     */
    private MapBuilder pageWhereBuilder(TimesheetQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty(query.getIdList())) {
            builder.field(TimesheetVO::getId, query.getIdList()).op(FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty(query.getActName())) {
            builder.field(TimesheetVO::getActName, query.getActName()).op(FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty(query.getTaskName())) {
            String actIden = cacheUtil.getSystemSelectionValueByName("prd:timesheet:actType", query.getTaskName());
            String likeStr = "%" + query.getTaskName() + "%";
            if (StringUtils.hasText(actIden) && !query.getTaskName().equals(actIden)) {
                // jpaQuery.where(qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())).or(qdo.tsActIden.eq(actIden)));
                builder.field(TimesheetVO::getTaskName, TimesheetVO::getTsActIden).sql("$1 like ? or $2 = ?", likeStr, actIden);
            } else {
                // jpaQuery.where(qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())));
                builder.field(TimesheetVO::getTaskName, query.getTaskName()).op(FieldOps.Contain);
            }
        }
        if (!ObjectUtils.isEmpty(query.getTaskPackageName())) {
            if (query.getTaskPackageName().equals("无任务")) {
                // jpaQuery.where(qdo.taskPackageName.like(SqlUtil.toSqlLikeString(query.getTaskPackageName())).or(qdo.projId.isNull().and(qdo.taskPackageId.isNull().or(qdo.taskPackageId.isNotNull().and(qdo.taskPackageId.eq(0L))))));
                String likeStr = "%" + query.getTaskPackageName() + "%";
                builder.field(TimesheetVO::getTaskPackageName, TimesheetVO::getProjId, TimesheetVO::getTaskPackageId).sql("" +
                        " $1 like ? or ( ($2 is null or $2=0) and  ( $3 is null or $3=0))", likeStr);
            } else {
                builder.field(TimesheetVO::getTaskPackageName, query.getTaskPackageName()).op(FieldOps.Contain);
            }
        }
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            builder.field(TimesheetVO::getProjId, query.getProjId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getTsUserId())) {
            builder.field(TimesheetVO::getTsUserId, query.getTsUserId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getTsUserBuId())) {
            builder.field(TimesheetVO::getTsUserBuId, query.getTsUserBuId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getTsStatus())) {
            builder.field(TimesheetVO::getTsStatus, query.getTsStatus()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            builder.field(TimesheetVO::getReasonId, query.getReasonId()).op(FieldOps.Equal);
        }
        // 转移到审批表中
        if (!ObjectUtils.isEmpty(query.getApprUserId())) {
            builder.field(TimesheetVO::getApprUserId, query.getApprUserId()).op(FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty(query.getTsUserIdList())) {
            builder.field(TimesheetVO::getTsUserId, query.getTsUserIdList()).op(FieldOps.InList);
        }

        if (!ObjectUtils.isEmpty(query.getWorkDateBetween())) {
            builder.field(TimesheetVO::getWorkDate, query.getWorkDateBetween().get(0), query.getWorkDateBetween().get(1)).op(FieldOps.Between);
            //jpaQuery.where(qdo.workDate.between(query.getWorkDateBetween().get(0), query.getWorkDateBetween().get(1)));
        }
        if (!ObjectUtils.isEmpty(query.getApprovalTime())) {
            builder.field(TimesheetVO::getApprovalTime, query.getApprovalTime().get(0), query.getApprovalTime().get(1)).op(FieldOps.Between);
        }

        if (!ObjectUtils.isEmpty(query.getWorkDate())) {
            //  jpaQuery.where(qdo.workDate.between(query.getWorkDate().get(0), query.getWorkDate().get(1)));
            builder.field(TimesheetVO::getWorkDate, query.getWorkDate().get(0), query.getWorkDate().get(1)).op(FieldOps.Between);

        }
        if (!ObjectUtils.isEmpty(query.getNonHolidayFlag()) && query.getNonHolidayFlag() == 1) {
            // jpaQuery.where((qdo.tsTaskIden.isNull().or(qdo.tsTaskIden.ne("VACATION"))).and(qdo.tsActIden.isNull().or(qdo.tsActIden.ne("LEGALHOLIDAY"))));
            builder.field(TimesheetVO::getTsTaskIden, TimesheetVO::getTsActIden)
                    .sql("($1 is null or $1  <> 'VACATION') and ( $2 is null or $2 <> 'LEGALHOLIDAY' ) ");

            // builder.sql("(ts_task_iden is null or ts_task_iden <> 'VACATION') and ( ts_act_iden is null or ts_act_iden <> 'LEGALHOLIDAY' )");
        }

        if (!ObjectUtils.isEmpty(query.getNoTaskFlag())) {
            if (query.getNoTaskFlag() == 0) {
                //查无任务
                builder.field(TimesheetVO::getTaskPackageId).sql("" +
                        "( $1 is null or $1=0)");
            }
            if (query.getNoTaskFlag() == 1) {
                //去除无任务
                builder.field(TimesheetVO::getTaskPackageId, 0).op(FieldOps.GreaterThan);
            }
        }

        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.desc("workDate"));
        query.setOrders(orderse);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

    @Override
    public void getPermissionParams(TimesheetQuery query) {
        if (query.getIsPermission()) {
            final Long loginUserId = GlobalUtil.getLoginUserId();
            // 判断 管理员
            final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (!isSystemAdmin) {
                // 判断当前登录人是否是系统管理员or 拥有角色【客户经营管理员	CUST_OPER_MANAGER】
                List<Long> userIdsByPlatRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
                // BU级权限（查看当前登录人是否是部门负责人）
                final List<PrdOrgOrganizationDO> organizationDOList = prdOrgOrganizationDAO.queryByManagerId(loginUserId);
                Set<Long> orgIdList = null;
                if (!CollectionUtils.isEmpty(organizationDOList)) {
                    orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
                }
                // 上下级权限
                //查出来userId的所有下级userId
                final List<PrdOrgEmployeeRefVO> empRef = daoUser.queryLowListByKey(null, loginUserId);
                final Set<Long> empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                // 有没有平台级权限
                if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                    Set<Long> queryUserIds = new HashSet<>();
                    //最基础的权限要查看自己
                    queryUserIds.add(loginUserId);
                    //有没有部门级别权限
                    if (orgIdList != null && !orgIdList.isEmpty()) {
                        // 部门成员
                        //查询部门下的成员
                        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                        Set<Long> collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                        queryUserIds.addAll(collect);
                    }
                    if (empRefUserIdList != null && !empRefUserIdList.isEmpty()) {
                        // 查询下级
                        queryUserIds.addAll(empRefUserIdList);
                    }
                    query.setTsUserIdList(queryUserIds);
                }
            }
        }
    }

    /**
     * 工时审批分页查询
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    @Override
    public PagingVO<TimesheetVO> pagingSingle(TimesheetQuery query) {
        if (!ObjectUtils.isEmpty(query.getTsUserIdName())) {
            PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
            employeeQuery.setPersonName(query.getTsUserIdName());
            PagingVO<PrdOrgEmployeeVO> paging = prdOrgEmployeeService.paging(employeeQuery);
            if (!ObjectUtils.isEmpty(paging.getRecords())) {
                Set<Long> userIdList = paging.getRecords().stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toSet());
                query.setTsUserIdList(userIdList);
            }
        }
        Page<TimesheetDO> page = timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetConvert.INSTANCE::toVo));
    }


    @Override
    public PagingVO pagingGroup(TimesheetQuery query) {
        query.setOrders(null);
        if (!ObjectUtils.isEmpty(query.getTsUserIdName())) {
            PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
            employeeQuery.setPersonName(query.getTsUserIdName());
            PagingVO<PrdOrgEmployeeVO> paging = prdOrgEmployeeService.paging(employeeQuery);
            if (!ObjectUtils.isEmpty(paging.getRecords())) {
                Set<Long> userIdList = paging.getRecords().stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toSet());
                query.setTsUserIdList(userIdList);
            }
        } else {
            query.setTsUserIdList(new HashSet<>());
        }
        final Page<Object[]> page = timesheetRepo.pagingGroup(query.getTsUserId(), query.getApprUserId(), query.getTsStatus(), query.getTsUserBuId(), query.getTimesheetIdV4IsNull(), query.getPageRequest(), query.getBlurryQuery(), query.getTsUserIdList());
        final List<Object[]> content = page.getContent();
        final List<TimesheetVO> all = getAll(content);
        // 理论支出当量
        setTheoryGetEqva(all);
        return PagingVO.<TimesheetVO>builder().records(all).total(page.getTotalElements()).build();
    }


    /**
     * 理论支出当量
     *
     * @param list 列表
     */
    public void setTheoryGetEqva(List<TimesheetVO> list) {
        if (list != null && list.size() > 0) {
            for (TimesheetVO timeView : list) {
                String[] groupIdsArr = timeView.getGroupIds().split(",");
                BigDecimal bd = new BigDecimal("0");
                for (int i = 0; i < groupIdsArr.length; i++) {
                    final TimesheetVO data = queryByKey(Long.valueOf(groupIdsArr[i]));
                    if (data.getTaskPackageId() != null && data.getTaskPackageId() > 0) {
                        final TaskPackageVO task = taskPackageService.queryByKey(data.getTaskPackageId(), false);
                        if (task != null && "04".equals(task.getAcceptMethod())) {
                            bd = bd.add(data.getWorkHour().divide(new BigDecimal("8"), 1, RoundingMode.UP).multiply(task.getEqvaRatio()));
                        }
                    }
                }
                timeView.setTheoryGetEqva(bd);
            }
        }
    }

    public List<TimesheetVO> getAll(List<Object[]> objects) {
        List<TimesheetVO> list = new ArrayList<>();
        for (Object[] obj : objects) {
            TimesheetVO timesheetVO = new TimesheetVO();
            timesheetVO.setGroupIds(String.valueOf(obj[0]));
            timesheetVO.setWorkHour(BigDecimal.valueOf(Double.parseDouble(String.valueOf(obj[1]))));
            timesheetVO.setProjId(obj[2] != null ? Long.valueOf(String.valueOf(obj[2])) : null);
            timesheetVO.setProjNo(String.valueOf(obj[3]));
            timesheetVO.setProjName(String.valueOf(obj[4]));
            timesheetVO.setTsStatus(String.valueOf(obj[5]));
            timesheetVO.setApprUserId(obj[6] != null ? Long.valueOf(String.valueOf(obj[6])) : null);
            timesheetVO.setWeekStartDate(obj[7] != null ? LocalDate.parse(String.valueOf(obj[7])) : null);
            timesheetVO.setTaskId(obj[8] != null ? Long.valueOf(String.valueOf(obj[8])) : null);
            timesheetVO.setTaskNo(String.valueOf(obj[9]));
            timesheetVO.setTaskName(String.valueOf(obj[10]));
            timesheetVO.setTsUserId(obj[11] != null ? Long.valueOf(String.valueOf(obj[11])) : null);
            timesheetVO.setTsUserBuId(obj[12] != null ? Long.valueOf(String.valueOf(obj[12])) : null);
            timesheetVO.setTsUserBuName(obj[13] != null ? String.valueOf(obj[13]) : "");
            list.add(timesheetVO);
        }
        return list;
    }

    @Override
    public List<TimesheetVO> listGroup(TimesheetQuery query) {
        QTimesheetDO qTimesheetDO = QTimesheetDO.timesheetDO;
        final JPAQuery<TimesheetDO> jpaQuery = jpaQueryFactory.select(qTimesheetDO)
                .from(qTimesheetDO)
                .where(qTimesheetDO.deleteFlag.eq(0));
        if (null != query.getTsUserId()) {
            jpaQuery.where(qTimesheetDO.tsUserId.eq(query.getTsUserId()));
        }
        if (null != query.getApprUserId()) {
            jpaQuery.where(qTimesheetDO.apprUserId.eq(query.getApprUserId()));
        }
        if (StringUtils.hasText(query.getTsStatus())) {
            jpaQuery.where(qTimesheetDO.tsStatus.eq(query.getTsStatus()));
        }
        final QueryResults<TimesheetDO> queryResults = jpaQuery.groupBy(qTimesheetDO.projId, qTimesheetDO.yearWeek, qTimesheetDO.tsUserId)
                .orderBy(qTimesheetDO.yearWeek.desc(), qTimesheetDO.tsUserId.desc())
                .fetchResults();
        final List<TimesheetVO> timesheetVOList = TimesheetConvert.INSTANCE.toVoList(queryResults.getResults());
        return timesheetVOList;
    }

    /**
     * 工时查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link TimesheetVO}>
     */
    @Override
    public List<TimesheetVO> queryList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.toVoList(timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public Map<LocalDate, Object> getTimesheetOverview(TimesheetQuery query) {
        Map<LocalDate, Object> result = new HashMap<>();
        final Long loginUserId = GlobalUtil.getLoginUserId();
//        final Long loginUserId = 579785889740361181L;
        if (loginUserId == null) {
            throw TwException.error("", "用户查询失败！");
        }
        query.setTsUserId(loginUserId);
        List<TimesheetVO> timesheetVOS = queryList(query);
        //按日期进行分组
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        List<LocalDate> workDate = query.getWorkDate();
        LocalDate startDate = workDate.get(0);
        LocalDate endDate = workDate.get(1);
        for (LocalDate localDate = startDate; localDate.isBefore(endDate.plusDays(1)); localDate = localDate.plusDays(1)) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            if (timesheetVOS1 == null || timesheetVOS1.isEmpty()) {
                result.put(localDate, "");
            } else {
                String status = "";
                int rejectedNum = 0;
                int createNum = 0;
                int approvingNum = 0;
                int approvedNum = 0;
                int settledNum = 0;
                for (TimesheetVO timesheetVO : timesheetVOS1) {
                    String tsStatus = timesheetVO.getTsStatus();
                    switch (TimesheetStatus.valueOf(tsStatus)) {
                        case CREATE:
                            createNum++;
                            break;
                        case REJECTED:
                            rejectedNum++;
                            break;
                        case APPROVING:
                            approvingNum++;
                            break;
                        case APPROVED:
                            approvedNum++;
                            break;
                        case SETTLED:
                            settledNum++;
                    }
                }
                if (rejectedNum > 0) {
                    status = REJECTED.getCode();
                } else if (createNum > 0) {
                    status = CREATE.getCode();
                } else if (approvingNum > 0) {
                    status = APPROVING.getCode();
                } else if (approvedNum > 0) {
                    status = APPROVED.getCode();
                } else if (settledNum > 0) {
                    status = SETTLED.getCode();
                }
                BigDecimal reduce = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                    // 总工时
                    reduce = timesheetVOS1.stream().map(e -> e.getWorkHour()).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                Map<String, Object> result1 = new HashMap<>();
                result1.put("status", status);
                result1.put("hour", reduce);
                result.put(localDate, result1);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public Boolean getTimesheetRemind(TimesheetQuery query) {

        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode(), RoleEnum.PLATFORM_RES.getCode()));
        if (rolePermission) {
            return false;
        } else {
            Map<LocalDate, Object> timesheetOverview = getTimesheetOverview(query);
            for (LocalDate localDate : timesheetOverview.keySet()) {
                if (timesheetOverview.get(localDate).equals("")) {
                    return true;
                } else {
                    Map<String, Object> result1 = (Map<String, Object>) timesheetOverview.get(localDate);
                    String status = (String) result1.get("status");
                    if (!status.equals("APPROVING") && !status.equals("APPROVED")) {
                        return true;
                    }
                }
            }
            return false;
        }

    }


    @Override
    public Map<LocalDate, Object> getAccReimTimesheetOverview(TimesheetQuery query) {
        Map<LocalDate, Object> result = new HashMap<>();
//        final Long loginUserId = 579785889740361181L;
        if (query.getTsUserId() == null) {
            throw TwException.error("", "用户参数必传！");
        }
        List<TimesheetVO> timesheetVOS = queryList(query);
        //按日期进行分组
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        List<LocalDate> workDate = query.getWorkDateBetween();
        LocalDate startDate = workDate.get(0);
        LocalDate endDate = workDate.get(1);
        // 查询节假日信息
        List<LocalDate> vacationDay = vacationService.findVacationDay(startDate, endDate);
        for (LocalDate localDate = startDate; localDate.isBefore(endDate.plusDays(1)); localDate = localDate.plusDays(1)) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            // 有工时就判断状态 没有工时看是不是周末 如果不是周末直接给空 是周末 就给节假日标志
            Map<String, Object> result1 = new HashMap<>();
            if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                String status = "";
                int rejectedNum = 0;
                int createNum = 0;
                int approvingNum = 0;
                int approvedNum = 0;
                int settledNum = 0;
                for (TimesheetVO timesheetVO : timesheetVOS1) {
                    String tsStatus = timesheetVO.getTsStatus();
                    switch (TimesheetStatus.valueOf(tsStatus)) {
                        case CREATE:
                            createNum++;
                            break;
                        case REJECTED:
                            rejectedNum++;
                            break;
                        case APPROVING:
                            approvingNum++;
                            break;
                        case APPROVED:
                            approvedNum++;
                            break;
                        case SETTLED:
                            settledNum++;
                    }

                    if (rejectedNum > 0) {
                        status = REJECTED.getCode();
                    } else if (createNum > 0) {
                        status = CREATE.getCode();
                    } else if (approvingNum > 0) {
                        status = APPROVING.getCode();
                    } else if (approvedNum > 0) {
                        status = APPROVED.getCode();
                    } else if (settledNum > 0) {
                        status = SETTLED.getCode();
                    }
                    BigDecimal reduce = BigDecimal.ZERO;
                    if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                        // 总工时
                        reduce = timesheetVOS1.stream().map(e -> e.getWorkHour()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    result1.put("hour", reduce);
                    result1.put("status", status);
                    // 节假日标志
                    result1.put("vacDayFlag", false);
                    result.put(localDate, result1);
                }
            } else if (!CollectionUtils.isEmpty(vacationDay) && vacationDay.contains(localDate)) {
                // 节假日标志
                result1.put("vacDayFlag", true);
                result.put(localDate, result1);
            } else {
                result.put(localDate, result1);
            }
        }
        return result;
    }

    @Override
    public void updateApprovingUser(List<Long> keys, Long apprUserId) {
        if (null == apprUserId || CollectionUtils.isEmpty(keys)) {
            log.warn("请求参数为空，工时列表变更审批人错误");
            return;
        }
        // 审批记录查询
        TsApprovalResQuery tsApprovalResQuery = new TsApprovalResQuery();
        tsApprovalResQuery.setTimesheetIds(keys);
        tsApprovalResQuery.setApprovalStatus(APPROVING.getCode());
        List<TsApprovalResVO> tsApprovalResVOS = tsApprovalResService.queryListDynamic(tsApprovalResQuery);
        for (TsApprovalResVO tsApprovalResVO : tsApprovalResVOS) {
            TsApprovalResPayload approvalResPayload = new TsApprovalResPayload();
            approvalResPayload.setId(tsApprovalResVO.getId());
            approvalResPayload.setApprovalResId(apprUserId);
            tsApprovalResService.updateByKeyDynamic(approvalResPayload);
        }
        timesheetRepo.updateApprovingUser(keys, apprUserId);
    }

    /**
     * 生成法定假日工时
     *
     * @param param
     */
    @Override
    public void generateVacationPublicTimesheet(String param) {

    }


    @Override
    public List<TimesheetSyncDataVO> querySyncDataList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.doListToSyncVo(timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public long count(TimesheetQuery query) {
        return timesheetRepo.count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    @Override
    public TimesheetVO queryByKey(Long key) {
        TimesheetDO entity = timesheetRepo.findById(key).orElseGet(TimesheetDO::new);
        Assert.notNull(entity.getId(), "工时不存在");
        TimesheetVO vo = TimesheetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    /**
     * 插入
     * <p>
     * 待补4.0逻辑 ：// 新建工时时,将对应的活动修改为进行中的状态(未开始和延迟状态的才修改)
     *
     * @param payload 有效载荷
     * @return {@link TimesheetVO}
     */
    @Override
//    @Transactional(rollbackFor = Exception.class)
    public TimesheetVO insert(TimesheetPayload payload) {
        if (payload.getProjId() != null && payload.getProjId() != 0) {
            payload.setTsTaskIden(null);
            payload.setTsActIden(null);
        }
        // 参数校验
        // 提交验证
        check(payload);
        //  根据日期查询已审批、审批中、已结算状态的工作小时，验证是否大于8
        // 校验任务包当量
        initData(payload);
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        // 将4.0工时标志设置为空，防止5.0修改假期工时后提交，导致不会同步到4.0
//        entityDo.setTimesheetIdV4(null);
        // 更新周报读取状态
        // LocalDate workDate = payload.getWorkDate();
        // int yearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate));
        biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(), 0);
        TimesheetDO save = timesheetRepo.save(entityDo);
        payload.setId(save.getId());
        return TimesheetConvert.INSTANCE.toVo(save);
    }

    /**
     * 法定假日 自动生成工时
     *
     * @param payloadList 有效载荷列表
     */
    @Override
    public void saveAllForAutoCreate(List<TimesheetPayload> payloadList) {
        if (!CollectionUtils.isEmpty(payloadList)) {
            List<TimesheetDO> doList = TimesheetConvert.INSTANCE.toDoList(payloadList);
            timesheetRepo.saveAll(doList);

            for (TimesheetDO newTimesheetDO : doList) {
                newTimesheetDO.setTimesheetId(newTimesheetDO.getId());
            }
            //同步插入计划
            List<TimesheetPlanDO> timesheetPlanDOS = TimesheetConvert.INSTANCE.toTimesheetPlanDo(doList);
            timesheetPlanDOS = timesheetPlanDOS.stream().map(e -> {
                e.setTsTaskIden("NOTASK");
                e.setTsActIden("VACATION");
                LocalDate workDate = e.getWorkDate();
                if (null != workDate) {
                    e.setWorkType(workDate.toString() + " 09:00:00," + workDate.toString() + " 18:00:00");
                }
                e.setId(null);
                return e;
            }).collect(Collectors.toList());
            timesheetPlanRepo.saveAll(timesheetPlanDOS);
            for (TimesheetPlanDO timesheetPlanDO : timesheetPlanDOS) {
                Long timesheetId = timesheetPlanDO.getTimesheetId();
                for (TimesheetDO newTimesheetDO : doList) {
                    if (newTimesheetDO.getId().equals(timesheetId)) {
                        timesheetRepo.updatePlan(newTimesheetDO.getId(), timesheetPlanDO.getId());
                    }
                }
            }
        }
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(TimesheetPayload payload) {
        if (payload.isSubmitted()) {
            if (payload.getId() != null && payload.getId() > 0) {
                final TimesheetVO timesheetVO = queryByKey(payload.getId());
                // 提交单据状态校验 只能提交新建或已退回的单据
                if (!TimesheetStatus.CREATE.getCode().equals(timesheetVO.getTsStatus()) &&
                        !TimesheetStatus.REJECTED.getCode().equals(timesheetVO.getTsStatus())) {
                    throw TwException.error("", "只能提交新建或已退回的单据");
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            // 项目id、 必填   --任务id、活动id
            // 工作日期、工时、工作说明
            // 字段必填验证

            // 无项目 无任务的情况下 任务包id不会传
            // if (null == payload.getTaskPackageId()) {
            //     throw TwException.error("", "请选择任务包");
            // }
            if (null == payload.getWorkDate()) {
                throw TwException.error("", "请选择工作日期");
            }
            if (!StringUtils.hasText(payload.getWorkDesc())) {
                throw TwException.error("", "请输入工作日志");
            }
            if (null == payload.getWorkHour()) {
                throw TwException.error("", "请填写工时");
            }
            if (null != payload.getTaskPackageId()) {
                TaskPackageVO taskPackageVO = taskPackageService.queryByKey(payload.getTaskPackageId(), false);
                if (null == taskPackageVO) {
                    throw TwException.error("", "任务包不存在");
                }
            }
            if (null != payload.getTaskId()) {
                final TaskInfoVO taskVO = taskInfoService.queryByKey(payload.getTaskId(), true);
                if (null == taskVO) {
                    throw TwException.error("", "任务不存在");
                }
                List<String> statuss = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode());
                if (!statuss.contains(taskVO.getTaskStatus()) && !taskVO.getId().equals(0L)) {
                    throw TwException.error("", taskVO.getTaskName() + "-任务不可用");
                    // throw TwException.error("", "请选择【激活】状态的任务");
                }
            }

        }
    }

    /**
     * 批量插入
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link TimesheetVO}>
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<TimesheetVO> batchInsert(TimesheetListPayload payload) {
        List<TimesheetVO> timesheetVOList = new ArrayList<>();
        boolean submitted = payload.isSubmitted();
        final List<TimesheetPayload> timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty(timesheetList)) {
            // 待更新工时剩余当量的 任务数据集合
            // Map<Long, BigDecimal> taskUpdateEffectiveEqvaMap = new HashMap<>();
            // 待更新 工时已填写使用当量的 任务数据集合
            List<TimesheetPayload> pmsTimeSheetPayloadListForTask = null;

            // 因前端不好传值问题，这里特殊处理下
            timesheetList.forEach(timesheetPayload -> {
                // 拦截不规范的工时，禁止提交
                // if (timesheetPayload.getProjId() == null || timesheetPayload.getWorkHour() == null) {
                //     throw TwException.error("", "日期" + timesheetPayload.getWorkDate() + "的工时信息不完整，不能提交！");
                // }
                if (timesheetPayload.getWorkHour() == null) {
                    throw TwException.error("", "日期" + timesheetPayload.getWorkDate() + "的工时信息不完整，不能提交！");
                }
                final Long taskId = timesheetPayload.getTaskId();
                if (taskId != null && (taskId.equals(0L) || taskId.equals(1L))) {
                    timesheetPayload.setTaskId(null);
                }
                final Long taskPackageId = timesheetPayload.getTaskPackageId();
                if (taskPackageId != null && (taskPackageId.equals(0L) || taskPackageId.equals(1L))) {
                    timesheetPayload.setTaskPackageId(null);
                }
            });
            // 校验工时是否超过8小时1
            if (payload.isCheckFlag() && !workHourValidate(payload)) {
                throw TwException.error("", "当天工时已超过8小时");
            }
            // 校验节假日0工时，只能有1条；
            if (!workHourHolidayValidate(payload)) {
                throw TwException.error("", "节假日只能填一条0工时记录");
            }

            // dib注释
            // List<TimesheetPayload> shiftingList = new ArrayList<>();
            // for (TimesheetPayload timesheetPayload : timesheetList) {
            //     if (StringUtils.hasText(timesheetPayload.getTsActIden()) && "SHIFTING".equals(timesheetPayload.getTsActIden())) {
            //         // 获取所有调休的数据
            //         shiftingList.add(timesheetPayload);
            //     }
            // }
            // if (!CollectionUtils.isEmpty(shiftingList)) {
            //     // 剔除调所有调休数据
            //     timesheetList.removeAll(shiftingList);
            //     // 处理所有的调休数据
            //     doShiftingTimesheetList(shiftingList, submitted);
            // }

            if (submitted) {
                // 如果是提交工时的话，要保证校验正确，需要先保存再提交
                timesheetList.forEach(timesheetPayload -> {
                    timesheetPayload.setSubmitted(false);
                    TimesheetVO insert = insert(timesheetPayload);
                    timesheetPayload.setId(insert.getId());
                });
                // 6851 【工作日志】增加校验 不允许填写今天之后的工时，可以进行保存
                checkWorkDate(payload);

                // 运维类项目 当量校验 ,补发任务包，关联工时
                // dib注释
                // validateDevOpsEqva(payload, timesheetList);

                //(非运维类工时) 工时提交时校验工时占用任务包的当量是否充足
                // dib注释
                // String msg = validateEqvaPms(payload);
                // if (StringUtils.hasText(msg)) {
                //     throw TwException.error("", msg);
                // }
                // dib校验当量和费用
                boolean checkEqvaAmtFlag = false;
                checkEqvaAmtFlag = getCheckEqvaAmtFlag(checkEqvaAmtFlag);
                if (checkEqvaAmtFlag) {
                    validateEqvaAndAmt(payload);
                }
                // dib注释
                pmsTimeSheetPayloadListForTask = timesheetList.stream()
                        .filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0)
                        .collect(Collectors.toList());
            }
            timesheetList.forEach(timesheetPayload -> {
                        if (payload.isSubmitted()) {
                            timesheetPayload.setSubmitted(true);
                        }
                        timesheetVOList.add(insert(timesheetPayload));
                    }
            );
            // dib注释
            // 修改任务包当量信息
            if (!CollectionUtils.isEmpty(pmsTimeSheetPayloadListForTask)) {
                pmsTimeSheetPayloadListForTask.forEach(TimesheetPayload -> {
                    updatePmsTaskInfoByTimesheetPayload(TimesheetPayload);
                });
            }
        }

        // 需要删除的数据
        final List<Long> deleteIdList = payload.getDeleteIdList();
        if (!CollectionUtils.isEmpty(deleteIdList)) {
            deleteSoft(deleteIdList);
        }
        return timesheetVOList;
    }

    public List<LocalDate> findVacationDayIn(List<LocalDate> localDateList) {
        List<LocalDate> res = vacationDAO.findVacationDayIn(localDateList);
        return res;
    }

    /**
     * https://zentao.elitescloud.com/index.php?m=story&f=view&storyID=7486&version=0&param=&storyType=story
     * <p>
     * 4. 关于提交工时的人天数与当量数判断
     * 4.1 若工时的事由类型 == '项目' && 项目的 ext1 != 'DEV_OPS'，提交工时数据时需要判断项目资源规划的人天数
     * 资源在此项目上提交 (工时状态=审批中+审批通过）的工时之和/8 + 本次提交的工时/8 =< 资源在此项目上的规划人天数 ?
     * 是，可以提交工时
     * 否，暂定拦截，提示“项目资源规划人天数不足，无法提交”
     * 前端处理，页面字段“活动”的下拉列表中，隐藏“当量余额”
     * <p>
     * <p>
     * <p>
     * 4.3 若工时的事由类型 != '项目'
     * 根据当量余额和工时当量的比较，判断能够提交工时
     * 工时当量 <= 当量余额
     * 其中当量余额 = 任务当量- 状态为审批中、已通过的工时当量之和
     * 是可以提交
     * 否拦截，提示语如下
     * "任务包当量不足！本次填报的任务包【" + taskName + "】总的工时当量【" + tsSubmitEqva + "】大于任务包剩余可用于工时填报的当量【" + tsEffecttiveEqva + "】，请填报其他任务包或向发包人申请给任务包追加当量";
     *
     * @param payload
     * @return
     */
    private String validateEqvaPms(TimesheetListPayload payload) {
        // 过滤非运维工时 、状态
        final List<TimesheetPayload> timesheetPayloadList = payload.getTimesheetList().stream()
                .filter(timesheetPayload -> tsStatusCheck(timesheetPayload)
                                && (
                                ObjectUtils.isEmpty(timesheetPayload.getType())
                                        || !timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode())
                        )
                ).collect(Collectors.toList());

        // PROJ_CONTRACT 合同项目类工时 任务包当量校验 240307 去掉资源规划校验
//        String projectTaskEqvaResult = validateProjectTaskEqva(timesheetPayloadList);
//        if (StringUtils.hasText(projectTaskEqvaResult)) {
//            return projectTaskEqvaResult;
//        }

        // bu、商机 任务包当量校验
        String buAndOppoProjectTaskEqvaResult = validateBuAndOppoProjectTaskEqva(timesheetPayloadList);
        if (StringUtils.hasText(buAndOppoProjectTaskEqvaResult)) {
            return buAndOppoProjectTaskEqvaResult;
        }

        return null;
    }

    /**
     * 验证合同项目任务eqva
     * <p>
     * * 4. 关于提交工时的人天数与当量数判断
     * * 4.1 若工时的事由类型 == '项目' && 项目的 ext1 != 'DEV_OPS'，提交工时数据时需要判断项目资源规划的人天数
     * * 资源在此项目上提交 (工时状态=审批中+审批通过+已结算）的工时之和/8 + 本次提交的工时/8 =< 资源在此项目上的规划人天数 ?
     * * 是，可以提交工时
     * * 否，暂定拦截，提示“项目资源规划人天数不足，无法提交”
     * * 前端处理，页面字段“活动”的下拉列表中，隐藏“当量余额”
     *
     * @param timesheetPayloadList 时间表有效负载列表
     * @return {@link String}
     */
    private String validateProjectTaskEqva(List<TimesheetPayload> timesheetPayloadList) {
        // 过滤掉没有填选任务包的工时  只拉取合同项目任务包的工时
        List<TimesheetPayload> tsListTmp = timesheetPayloadList.stream()
                .filter(ts ->
                        ts.getTaskId() != null
                                && ts.getTaskId() > 0 &&
                                ts.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())
                ).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }

        //要提交工时关联的任务包id
        List<Long> reasonIdList = tsListTmp.stream().map(t -> t.getReasonId()).collect(Collectors.toList());
        // //给工时id给一个初始值
        // tsListTmp.stream().forEach(ts -> {
        //     if (ts.getId() == null) {
        //         ts.setId(Math.round(Math.random() * 100000000) * -1);
        //     }
        // });
        // // 计算每条工时的当量  工时主键集合
        // List<Long> tsIds = tsListTmp.stream().map(ts -> ts.getId()).collect(Collectors.toList());
        // // 计算工时占用人天
        // TimesheetQuery timesheetQuery = new TimesheetQuery();
        // timesheetQuery.setIdList(tsIds);
        // 查询工时列表信息 人、日期、工时、baseBu
        //根据id查询工时List
        // final List<TimesheetVO> tsViews = queryList(timesheetQuery);
        TimesheetQuery timesheetQuery2 = new TimesheetQuery();
        // Long loginUserId = GlobalUtil.getLoginUserId();
        // 提交某项目的工时，只和项目的资源规划的“总人天数”进行比较，而不需要 工时提交人 和 资源规划中的资源 进行匹配，即：
        // ****项目上提交**** (工时状态=审批中+审批通过+已结算）的工时之和/8 + 本次提交的工时/8 =< 项目的规划人天数
        // timesheetQuery2.setTsUserId(loginUserId);
        timesheetQuery2.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
        timesheetQuery2.setReasonIdList(reasonIdList);
        //根据id查询工时List
        final List<TimesheetVO> tsViewsAll = queryList(timesheetQuery2);
        List<TimesheetVO> twVoList = new ArrayList<>();
        twVoList.addAll(tsViewsAll);
        // 把前端传过来的工时 放到一个集合里
        for (TimesheetPayload timesheetPayload : tsListTmp) {
            long count = tsViewsAll.stream().filter(ts -> ts.getId().equals(timesheetPayload.getId())).count();
            if (count < 1) {
                TimesheetVO timesheetVO = TimesheetConvert.INSTANCE.payloadToVo(timesheetPayload);
                twVoList.add(timesheetVO);
            }
        }
        Map<Long, BigDecimal> dayUsedMap = twVoList.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getProjContractTimeSheet()), HashMap::putAll);
        Map<Long, BigDecimal> dayUsedMapTemp = dayUsedMap;
        // 按项目汇总，每个任务包下工时占用的总当量
        Map<Long, List<TimesheetVO>> reasonTsMap = twVoList.stream().collect(Collectors.groupingBy(TimesheetVO::getReasonId));
        Set<Long> reasonIdSet = reasonTsMap.keySet();

        for (Long resonId : reasonIdSet) {
            BigDecimal tsSubmitDay = reasonTsMap.get(resonId).stream()
                    // 当前项目下所有工时上报的总人天
                    .map(ts -> dayUsedMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : dayUsedMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();

            // PmsResourcePlanRoleVO pmsResourcePlanRoleVO = pmsResourcePlanRoleService.getByObjectId(resonId, loginUserId, PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            // if (null == pmsResourcePlanRoleVO) {
            //     log.error("项目资源规划人天数不足，无法提交,没有找到资源规划数据；objId:{};loginUserId:{};", resonId, loginUserId);
            //     return "项目资源规划人天数不足，无法提交";
            // }
//            BigDecimal totalDay = pmsResourcePlanRoleService.getByObjectId(resonId, PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
//            //计算项目下资源规划填报工时的人天
//            // BigDecimal totalDay = pmsResourcePlanRoleVO.getTotalDays();
//            log.info("当前项目下所有工时上报的总人天:" + tsSubmitDay);
//            log.info("资源规划下的规划人天:" + totalDay);
//            if (tsSubmitDay != null && totalDay != null && tsSubmitDay.doubleValue() > totalDay.doubleValue()) {
//                String reasonName = twVoList.stream().filter(t -> t.getReasonId().equals(resonId)).map(t -> t.getReasonName()).findAny().get();
//                log.error("项目资源规划人天数不足，无法提交！本次填报的项目【" + reasonName + "】总的工时人天【" + tsSubmitDay + "】大于资源规划【" + totalDay + "】，请填报其他项目或向项目经理申请资源规划");
//                // 项目资源规划人天数(m)小于已提交的工时天数(hours/8)，不可提交！
//                return "项目资源规划人天数(" + totalDay + ")小于已提交的工时天数(" + tsSubmitDay + ")，不可提交！";
//            }

        }
        return null;
    }

    /**
     * 验证当量和费用 dib
     *
     * @param payload 有效载荷
     * @return {@link String}
     */
    private String validateEqvaAndAmt(TimesheetListPayload payload) {

        // 过滤非运维工时 、状态
        final List<TimesheetPayload> timesheetPayloadList = payload.getTimesheetList().stream()
                .filter(timesheetPayload -> tsStatusCheck(timesheetPayload)
                                && (
                                ObjectUtils.isEmpty(timesheetPayload.getType())
                                        || !timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode())
                        )
                ).collect(Collectors.toList());
        // 过滤掉没有填选事由的工时
        List<TimesheetPayload> tsListTmp = timesheetPayloadList.stream()
                .filter(ts ->
                                ts.getReasonId() != null
                                        && ts.getReasonId() != 0
                                        && StringUtils.hasText(ts.getReasonType())
                                        && ts.getStageId() != null
                        // &&
                        // (ts.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())
                        //     || ts.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode()))
                ).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }
        //给工时id给一个初始值
        tsListTmp.stream().forEach(ts -> {
            if (ts.getId() == null) {
                ts.setId(Math.round(Math.random() * 100000000) * -1);
            }
        });
        // 计算每条工时的当量  工时主键集合
        List<Long> tsIds = tsListTmp.stream().map(ts -> ts.getId()).collect(Collectors.toList());
        // 计算工时占用任务包的当量
        Map<Long, BigDecimal> tsEqvaMap = calTsUsedEqvasByTsIdsDib(tsIds);// 仅计算工时id大于0的值

        // 计算补贴金额  计算补助
        Map<Long, BigDecimal> tsSubSidyAmtMap = calTsUsedSubSidyAmtByTsIdsDib(tsIds, payload);// 仅计算工时id大于0的值

        //计算工时id小于0的工时占用的当量
        List<TimesheetPayload> tsTemp = tsListTmp.stream().filter(ts -> ts.getId() < 0).collect(Collectors.toList());
        if (tsTemp != null || tsTemp.size() > 0) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<>();
            }
            for (TimesheetPayload ts : tsTemp) {
                // 根据工时日期、填报工时的人员 计算占用当量
                BigDecimal eqva = calTsUsedEqvasByTsDetail(ts.getWorkDate(), ts.getTsUserId(), ts.getWorkHour());
                tsEqvaMap.put(ts.getId(), eqva);

                // 计算 补助金额
                calSubSidyAmt(ts);
                tsSubSidyAmtMap.put(ts.getId(), ts.getSubsidyAmt());
            }
        }
        Map<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;
        Map<Long, BigDecimal> tsSubSidyAmtMapTemp = tsSubSidyAmtMap;

        // 按事由汇总，每个事由包下工时占用的总当量
        // Map<Long, List<TimesheetPayload>> reasonIdTsMap = tsListTmp.stream().collect(Collectors.groupingBy(TimesheetPayload::getReasonId));
        Map<GroupingKey, List<TimesheetPayload>> reasonIdTsMap = tsListTmp.stream()
                .collect(Collectors.groupingBy(
                        tp -> new GroupingKey(tp.getReasonId(), tp.getReasonType(), tp.getStageId()),
                        Collectors.toList()
                ));
        Set<GroupingKey> reasonIdSet = reasonIdTsMap.keySet();
        for (GroupingKey groupingKey : reasonIdSet) {
            Long reasonId = groupingKey.getReasonId();
            String reasonType = groupingKey.getReasonType();
            Long stageId = groupingKey.getStageId();
            BigDecimal tsSubmitEqva = reasonIdTsMap.get(groupingKey).stream()
                    // 当前事由下所有工时上报的总当量
                    .map(ts -> tsEqvaMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : tsEqvaMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
            // 验证当量是否超出预算
            budgetCommonService.checkBudgetEqva(reasonId, reasonType, stageId, tsSubmitEqva);
        }


        // 校验费用
        PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("ACC:SUBJECT:REF1");
        Long budgetItemId = 0L;
        if (systemSelection != null && StringUtils.hasText(systemSelection.getExtString1())) {
            budgetItemId = Long.valueOf(systemSelection.getExtString1());
        }

        Set<GroupingKey> reasonIdSetAmt = reasonIdTsMap.keySet();
        for (GroupingKey groupingKey : reasonIdSetAmt) {
            Long reasonId = groupingKey.getReasonId();
            String reasonType = groupingKey.getReasonType();
            BigDecimal tsSubmitAmt = reasonIdTsMap.get(groupingKey).stream()
                    // 当前事由下所有工时上报的总当量
                    .map(ts -> tsSubSidyAmtMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : tsSubSidyAmtMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
            // 验证预算
            budgetCommonService.checkBudgetAmt(reasonId, reasonType, budgetItemId, tsSubmitAmt, BudgetCostType.time_sheet.getCode());
        }
        return null;
    }

    // 自定义一个类来作为分组的key
    @Data
    class GroupingKey {
        private final Long reasonId;
        private final String reasonType;
        private final Long stageId;
    }

    /**
     * 验证bu和oppo项目任务eqva
     * <p>
     * * 4.3 若工时的事由类型 != '项目'
     * * 根据当量余额和工时当量的比较，判断能够提交工时
     * * 工时当量 <= 当量余额
     * * 其中当量余额 = 任务当量- 状态为审批中、已通过的工时当量之和
     * 其中当量余额 = 任务当量数 - 当量系数 *（状态为审批中&已通过的工时数）/ 8
     * * 是可以提交
     * * 否拦截，提示语如下
     * * "任务包当量不足！本次填报的任务包【" + taskName + "】总的工时当量【" + tsSubmitEqva + "】大于任务包剩余可用于工时填报的当量【" + tsEffecttiveEqva + "】，请填报其他任务包或向发包人申请给任务包追加当量";
     * *
     *
     * @param timesheetPayloadList 时间表有效负载列表
     * @return {@link String}
     */
    private String validateBuAndOppoProjectTaskEqva(List<TimesheetPayload> timesheetPayloadList) {
        // 过滤掉没有填选任务包的工时  只拉取bu、商机任务包的工时
        List<TimesheetPayload> tsListTmp = timesheetPayloadList.stream()
                .filter(ts ->
                        ts.getTaskId() != null
                                && ts.getTaskId() > 0 &&
                                (ts.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())
                                        || ts.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode()))
                ).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }
        //要提交工时关联的任务包id
        List<Long> taskIdList = tsListTmp.stream().map(t -> t.getTaskId()).collect(Collectors.toList());
        //计算任务包当量 原始发包当量、追加当量、被工时用掉的当量、剩余还可以用来填报的当量
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setIdList(taskIdList);
        List<TaskInfoVO> taskVOList = taskInfoService.queryListCommon(taskInfoQuery);
        // 任务包已经被工时用掉的当量
        Map<Long, BigDecimal> tsEffectiveEqva = taskVOList.stream()
                .collect(Collectors.toMap(TaskInfoVO::getId, TaskInfoVO::getEffectiveEqva));// 计算任务包剩余可用于填报工时的当量
        //给工时id给一个初始值
        tsListTmp.stream().forEach(ts -> {
            if (ts.getId() == null) {
                ts.setId(Math.round(Math.random() * 100000000) * -1);
            }
        });
        // 计算每条工时的当量  工时主键集合
        List<Long> tsIds = tsListTmp.stream().map(ts -> ts.getId()).collect(Collectors.toList());
        // 计算工时占用任务包的当量
        Map<Long, BigDecimal> tsEqvaMap = calTsUsedEqvasByTsIds(tsIds);// 仅计算工时id大于0的值
        //计算工时id小于0的工时占用的当量
        List<TimesheetPayload> tsTemp = tsListTmp.stream().filter(ts -> ts.getId() < 0).collect(Collectors.toList());
        if (tsTemp != null || tsTemp.size() > 0) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<>();
            }
            for (TimesheetPayload ts : tsTemp) {
                // 根据工时日期、填报工时的人员、选择的任务包 计算占用当量
                BigDecimal eqva = calTsUsedEqvasByTsDetail(ts.getWorkDate(), ts.getTsUserId(), ts.getTaskId(), ts.getWorkHour());
                tsEqvaMap.put(ts.getId(), eqva);
            }
        }
        Map<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;

        // 按任务包汇总，每个任务包下工时占用的总当量
        Map<Long, List<TimesheetPayload>> taskTsMap = tsListTmp.stream().collect(Collectors.groupingBy(TimesheetPayload::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            BigDecimal tsSubmitEqva = taskTsMap.get(taskId).stream()
                    // 当前任务包下所有工时上报的总当量
                    .map(ts -> tsEqvaMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : tsEqvaMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
            //计算任务包剩余可用于填报工时的当量
            BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
            log.info("当前任务包下所有工时上报的总当量:" + tsSubmitEqva);
            log.info("计算任务包剩余可用于填报工时的当量:" + tsEffecttiveEqva);
            if (tsSubmitEqva != null && tsEffecttiveEqva != null && tsSubmitEqva.doubleValue() > tsEffecttiveEqva.doubleValue()) {
                String taskName = taskVOList.stream().filter(t -> t.getId().equals(taskId)).map(t -> t.getTaskName()).findAny().get();
                return "任务包当量不足！本次填报的任务包【" + taskName + "】总的工时当量【" + tsSubmitEqva + "】大于任务包剩余可用于工时填报的当量【" + tsEffecttiveEqva + "】，请填报其他任务包或向发包人申请给任务包追加当量";
            }

        }
        return null;
    }

    /**
     * 更新pms任务信息 （提交）
     *
     * @param timesheetPayload 时间表有效载荷
     */
    private void updatePmsTaskInfoByTimesheetPayload(TimesheetPayload timesheetPayload) {
        Long taskId = timesheetPayload.getTaskId();
        Long tsUserId = timesheetPayload.getTsUserId();
        BigDecimal workHour = timesheetPayload.getWorkHour();
        taskCommonService.updateTimeSheet(timesheetPayload, taskId, tsUserId, workHour, "1");
    }

    /**
     * 更新pms任务信息 （审批通过 APPROVED、提交撤回 CREATE、审批拒绝 REJECTED、【已审批通过工时，被撤回情况（管理员特殊操作，不能直接改数据库了 ）】APPROVED_TO_CREATE ）
     *
     * @param entity   实体
     * @param approved 已批准
     */
    private void updatePmsTaskInfoByTimesheetEntity(TimesheetDO entity, TimesheetStatus approved) {
        Long taskId = entity.getTaskId();
        Long tsUserId = entity.getTsUserId();
        BigDecimal workHour = entity.getWorkHour();
        if (null == entity.getTaskId()) {
            // 无项目无任务的情况下 taskId为空
            return;
        }
        TimesheetPayload timesheetPayload = new TimesheetPayload();
        timesheetPayload.setId(entity.getId());
        timesheetPayload.setWorkDate(entity.getWorkDate());
        timesheetPayload.setWorkDesc(entity.getWorkDesc());
        // 审批通过 APPROVED
        if (APPROVED.getCode().equals(approved.getCode())) {
            taskCommonService.updateTimeSheet(timesheetPayload, taskId, tsUserId, workHour, "2");
            // 提交撤回 CREATE、审批拒绝 REJECTED
        } else if (REJECTED.getCode().equals(approved.getCode()) || CREATE.getCode().equals(approved.getCode())) {
            BigDecimal negativeNumberWorkHour = workHour.negate();
            taskCommonService.updateTimeSheet(timesheetPayload, taskId, tsUserId, negativeNumberWorkHour, "1");
            // 【已审批通过工时，被撤回情况（管理员特殊操作，不能直接改数据库了 ）】APPROVED_TO_CREATE
        } else if (APPROVED_TO_CREATE.getCode().equals(approved.getCode())) {
            BigDecimal negativeNumberWorkHour = workHour.negate();
            taskCommonService.updateTimeSheet(timesheetPayload, taskId, tsUserId, negativeNumberWorkHour, "2");
        }
    }

    /**
     * 运维类项目当量校验
     * 项目剩余当量 = 已拨付 - 工时占用当量
     * <p>
     * https://zentao.elitescloud.com/index.php?m=story&f=view&storyID=7486&version=0&param=&storyType=story
     * * 4.2 若工时的事由类型 == '项目' && 项目的 ext1 == 'DEV_OPS'
     * * 提交工时，即 2.2 中所描述的，不作改动
     *
     * @param payload       有效载荷
     * @param timesheetList
     * @return {@link String}
     */
    private List<TimesheetVO> validateDevOpsEqva(TimesheetListPayload payload, List<TimesheetPayload> timesheetList) {
        // 查询请求的运维项目，且是非自动发包的工时(没有关联任务包)
        final List<TimesheetPayload> timesheetPayloadList = payload.getTimesheetList().stream()
                .filter(timesheetPayload ->
                        // 根据工时状态过滤
                        tsStatusCheck(timesheetPayload)
                                // 过滤无项目
                                && timesheetPayload.getProjId() > 0
                                // 取出 运维类项目工时
                                && timesheetPayload.getTaskId() == null
                                && StringUtils.hasText(timesheetPayload.getType())
                                && timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode())
                ).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(timesheetPayloadList)) {
            return null;
        }

        // 帮我吧工时提交校验及初始化任务包，任务，成员数据
        List<TimesheetVO> timesheetVOS = taskCommonService.bw8TimeSheetSubmit(timesheetPayloadList);

        if (!CollectionUtils.isEmpty(timesheetVOS)) {
            timesheetList.forEach(timesheetPayload -> {
                Long id = timesheetPayload.getId();
                // Long taskPackageId = timesheetPayload.getTaskPackageId();

                if (StringUtils.hasText(timesheetPayload.getType())
                        && timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode())
                ) {
                    timesheetVOS.stream().filter(timesheetVO -> timesheetVO.getId().equals(id)).forEach(timesheetVO -> {
                        if (timesheetVO.getTaskPackageId() == null || timesheetVO.getTaskId() == null) {
                            log.error("帮我吧工时生成任务异常");
                            throw TwException.error("500", "帮我吧工时生成任务异常");
                        }
                        timesheetPayload.setTaskPackageId(timesheetVO.getTaskPackageId());
                        // timesheetPayload.setTaskPackageName(timesheetVO.getTaskPackageName());
                        timesheetPayload.setTaskId(timesheetVO.getTaskId());
                        // timesheetPayload.setTaskName(timesheetVO.getTaskName());

                    });
                }
            });
        }
        return timesheetVOS;
    }

    private void doShiftingTimesheetList(List<TimesheetPayload> timesheetPayloadList, boolean submitted) {
        // 校验
        for (TimesheetPayload timesheetPayload : timesheetPayloadList) {
            OvertimeApplicationDO overtimeApplicationDO = overtimeApplicationRepo.findById(Long.valueOf(timesheetPayload.getExt2())).get();
            if (!RestStatusEnum.CREATE.getCode().equals(overtimeApplicationDO.getRestStatus())) {
                throw TwException.error("500", "工作计划时间已使用，请重新选择!");
            }
            if (timesheetPayload.getWorkHour().compareTo(overtimeApplicationDO.getOvertimeWorkHour()) > 0) {
                throw TwException.error("500", "调休时间大于工作计划时间,请重新填写!");
            }
        }

        if (submitted) {
            // 修改调休状态
            for (TimesheetPayload timesheetPayload : timesheetPayloadList) {
                OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                overtimeApplicationDO.setRestStatus(RestStatusEnum.REST_APPROVING.getCode());
                overtimeApplicationDO.setRestDate(timesheetPayload.getWorkDate());
                overtimeApplicationDO.setId(Long.valueOf(timesheetPayload.getExt2()));

                overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
            }
        }

        for (TimesheetPayload timesheetPayload : timesheetPayloadList) {
            initData(timesheetPayload);
            TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(timesheetPayload);
            entityDo.setExt2(timesheetPayload.getExt2());
            entityDo.setTsUserId(GlobalUtil.getLoginUserId());
            timesheetRepo.save(entityDo);
        }
    }

    /**
     * 不允许填写今天之后的工时
     *
     * @param payload 有效载荷
     */
    private void checkWorkDate(TimesheetListPayload payload) {
        LocalDate now = LocalDate.now();
        final List<TimesheetPayload> timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty(timesheetList)) {
            final long count = timesheetList.stream().filter(timesheetPayload -> timesheetPayload.getWorkDate().isAfter(now)).count();
            if (count > 0) {
                throw TwException.error("", "不允许提前提交工时");
            }
        }
    }


    /**
     * 工时状态检查
     *
     * @param timesheetPayload 时间表有效载荷
     * @return boolean
     */
    private boolean tsStatusCheck(TimesheetPayload timesheetPayload) {
        timesheetPayload.setTsUserId(GlobalUtil.getLoginUserId());
        final boolean flag = timesheetPayload.getTsStatus() != null &&
                (timesheetPayload.getTsStatus().equals(CREATE.getCode()) || timesheetPayload.getTsStatus().equals(REJECTED.getCode()));
        return flag;
    }

    /**
     * 根据工时日期、填报工时的人员、选择的任务包 计算占用当量
     *
     * @param workDate 工时填报日期
     * @param tsUserId 填报人userId
     * @param taskId   任务包id
     * @param workHour 工时小时数
     * @return
     */
    private BigDecimal calTsUsedEqvasByTsDetail(LocalDate workDate, Long tsUserId, Long taskId, BigDecimal workHour) {
        if (workDate == null || taskId == null) {
            return null;
        }
        if (workDate == null) {
            return null;
        }
        if (tsUserId == null) {
            tsUserId = GlobalUtil.getLoginUserId();
        }
        TaskInfoVO taskInfoVO = taskInfoService.queryByKey(taskId, true);
        if (taskInfoVO == null) {
            throw TwException.error("", "任务包不存在");
            // return null;
        }
        // 第一种方案
        //计算当量系数
        // BigDecimal eqvaRatio = employeeEqvaRatioService.getEqvaRatio(tsUserId, workDate);

        // 第二种方案是根据任务包id查询任务包当量系数
        BigDecimal eqvaRatio = taskInfoVO.getEqvaRatio();
        if (eqvaRatio == null) {
            // 兼容迁移的老数据
            eqvaRatio = employeeEqvaRatioService.getEqvaRatio(tsUserId, workDate);
        }
        if (eqvaRatio == null) {
            throw TwException.error("", "当量系数不可为空");
            // return null;
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);//向下取整数
    }


    /**
     * 根据工时日期、填报工时的人员、选择的任务包 计算占用当量
     *
     * @param workDate 工时填报日期
     * @param tsUserId 填报人userId
     * @param workHour 工时小时数
     * @return
     */
    private BigDecimal calTsUsedEqvasByTsDetail(LocalDate workDate, Long tsUserId, BigDecimal workHour) {
        if (workDate == null) {
            return null;
        }
        if (workDate == null) {
            return null;
        }
        if (tsUserId == null) {
            tsUserId = GlobalUtil.getLoginUserId();
        }
        BigDecimal eqvaRatio = null;
        if (eqvaRatio == null) {
            // 兼容迁移的老数据
            eqvaRatio = employeeEqvaRatioService.getEqvaRatio(tsUserId, workDate);
        }
        if (eqvaRatio == null) {
            throw TwException.error("", "当量系数不可为空");
            // return null;
        }
        if (workHour == null) {
            throw TwException.error("", "工时不可为空");
            // workHour = BigDecimal.valueOf(8);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);//向下取整数
    }


    /**
     * 根据工时日期、填报工时的人员、选择的项目 计算占用当量
     *
     * @param workDate  工时填报日期
     * @param eqvaRatio 当量系数
     * @param projId    任务包id
     * @param workHour  工时小时数
     * @return
     */
    private BigDecimal calProjTsUsedEqvasByTsDetail(LocalDate workDate, BigDecimal eqvaRatio, Long projId, BigDecimal workHour) {
        if (workDate == null || projId == null) {
            return null;
        }

        //计算当量系数
        if (eqvaRatio == null) {
            return null;
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8), 2, RoundingMode.DOWN);//向下取整数
    }

    /**
     * 计算多个任务包的已填工时当量
     *
     * @param taskIdList 任务v4主键集合
     * @return 任务包id，已填工时当量 map
     */
    private Map<Long, BigDecimal> calTsUsedEqvasByIds(List<Long> taskIdList) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTaskIdList(taskIdList);
        List<String> tsStatusList = new ArrayList<>();
        tsStatusList.add(APPROVED.getCode());
        tsStatusList.add(APPROVING.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        // 查询工时列表信息 人、日期、工时、baseBu
        // 根据任务包查询工时
        List<TimesheetVO> tsViews = queryList(timesheetQuery);

        if (tsViews == null || tsViews.size() == 0) {// 任务包没有关联任何工时
            return null;
        }

        //计算每条工时占用的当量
        Map<Long, BigDecimal> tsEqvaMap = calTsUsedEqvasByTsIds(tsViews.stream()
                .map(ts -> ts.getId()).collect(Collectors.toList()));
        tsViews = tsViews.stream().map(ts -> {
            ts.setEqvaTimeSheet(tsEqvaMap.get(ts.getId()));
            return ts;
        }).collect(Collectors.toList());

        //按任务包对工时进行分组，并求当量和
        Map<Long, BigDecimal> returnMap = new HashMap<>();
        Map<Long, List<TimesheetVO>> taskTsMap = tsViews.stream().collect(Collectors.groupingBy(TimesheetVO::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            returnMap.put(taskId, taskTsMap.get(taskId).stream().
                    map(ts -> ts.getEqvaTimeSheet() == null ? BigDecimal.ZERO : ts.getEqvaTimeSheet())
                    .reduce(BigDecimal::add).get());
        }
        return returnMap;
    }

    /**
     * 计算工时占用任务包的当量
     *
     * @param timeSheetIds 工时id
     * @return 工时id 工时占用当量
     */
    private Map<Long, BigDecimal> calTsUsedEqvasByTsIds(List<Long> timeSheetIds) {
        log.warn("debug:::目标操作的工时列表" + timeSheetIds);
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setIdList(timeSheetIds);
        // 查询工时列表信息 人、日期、工时、baseBu
        //根据id查询工时List
        final List<TimesheetVO> tsViews = queryList(timesheetQuery);

        for (TimesheetVO v : tsViews) {
            // 查询任务包的信息
            // pms改造配合 注释老逻辑
            // final TaskVO taskVO = taskService.queryByTaskIdV4(v.getTaskId());
            // if ("04".equals(taskVO.getAcceptMethod()) && taskVO.getEqvaRatio() != null) {// 人天任务包使用任务包的派发当量系数，跳过计算当量系数，节约系统资源
            //     continue;
            // }
            // 计算工时的当量系数
            // 非人天任务包，不能用任务包的派发当量系数当做计算当量的系数
            v.setEqvaRatio(null);
            // 老方案 第一种方案
            // final BigDecimal eqvaRatio = employeeEqvaRatioService.getEqvaRatio(v.getTsUserId(), v.getWorkDate());
            // v.setEqvaRatio(eqvaRatio);


            // pms改造配合 新方案 第二种方案
            TaskInfoVO taskInfoVO = taskInfoService.queryByKey(v.getTaskId(), true);
            Assert.notNull(taskInfoVO, "任务包不存在");
            BigDecimal eqvaRatio = taskInfoVO.getEqvaRatio();
            if (null == eqvaRatio) {
                // 兼容迁移的老数据
                eqvaRatio = employeeEqvaRatioService.getEqvaRatio(v.getTsUserId(), v.getWorkDate());
                if (null == eqvaRatio) {
                    throw TwException.error("", "当量系数不可为空");
                }
            }
            v.setEqvaRatio(eqvaRatio);
        }
        // 计算工时占用的当量
        // 工时当量系数计算完成后，直接调用v.getEqvaTimeSheet()方法即可
//        return tsViews.stream().collect(Collectors.toMap(TimesheetVO::getId, TimesheetVO::getEqvaTimeSheet));
        // 解决value为空问题
        return tsViews.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getEqvaTimeSheet()), HashMap::putAll);


    }

    /**
     * 计算工时占用任务包的当量
     *
     * @param timeSheetIds 工时表id
     * @return {@link Map}<{@link Long}, {@link BigDecimal}>
     */
    private Map<Long, BigDecimal> calTsUsedEqvasByTsIdsDib(List<Long> timeSheetIds) {
        log.warn("debug:::目标操作的工时列表" + timeSheetIds);
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setIdList(timeSheetIds);
        // 查询工时列表信息 人、日期、工时、baseBu
        //根据id查询工时List
        final List<TimesheetVO> tsViews = queryList(timesheetQuery);

        for (TimesheetVO v : tsViews) {
            v.setEqvaRatio(null);
            BigDecimal eqvaRatio = null;
            if (null == eqvaRatio) {
                // 兼容迁移的老数据
                eqvaRatio = employeeEqvaRatioService.getEqvaRatio(v.getTsUserId(), v.getWorkDate());
                if (null == eqvaRatio) {
                    throw TwException.error("", "当量系数不可为空");
                }
            }
            v.setEqvaRatio(eqvaRatio);
        }
        // 计算工时占用的当量
        // 工时当量系数计算完成后，直接调用v.getEqvaTimeSheet()方法即可
//        return tsViews.stream().collect(Collectors.toMap(TimesheetVO::getId, TimesheetVO::getEqvaTimeSheet));
        // 解决value为空问题
        return tsViews.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getEqvaTimeSheet()), HashMap::putAll);
    }

    /**
     * 计算工时占用补助金额
     *
     * @param timeSheetIds 时间表id
     * @param payload
     * @return {@link Map}<{@link Long}, {@link BigDecimal}>
     */
    private Map<Long, BigDecimal> calTsUsedSubSidyAmtByTsIdsDib(List<Long> timeSheetIds, TimesheetListPayload payload) {
        log.warn("debug:::目标操作的工时列表" + timeSheetIds);
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setIdList(timeSheetIds);
        //根据id查询工时List
        final List<TimesheetVO> tsViews = queryList(timesheetQuery);
        for (TimesheetVO tsView : tsViews) {
            TimesheetPayload timesheetPayload = TimesheetConvert.INSTANCE.toPayload(tsView);
            calSubSidyAmt(timesheetPayload);
            tsView.setSubsidyAmt(timesheetPayload.getSubsidyAmt());
            payload.getTimesheetList().stream()
                    .filter(ts -> ts.getId().equals(tsView.getId()))
                    .forEach(ts ->
                            {
                                ts.setSubsidyAmt(tsView.getSubsidyAmt());
                                ts.setSubsidyAmtCalFlag(false);
                            }
                    );
        }
        return tsViews.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getSubsidyAmt()), HashMap::putAll);
    }

    /**
     * 校验工作时间
     *
     * @param payload 有效载荷
     * @return boolean
     */
    private boolean workHourValidate(TimesheetListPayload payload) {
        //  过滤已审批、审批中状态的数据 用于校验工作小时
        Map<LocalDate, Double> resultMap =
                payload.getTimesheetList().stream()
                        .filter(timesheetPayload -> timesheetPayload.getTsStatus() != null &&
                                (timesheetPayload.getTsStatus().equals(CREATE.getCode()) || timesheetPayload.getTsStatus().equals(REJECTED.getCode()))
                        ).collect(
                                Collectors.groupingBy(TimesheetPayload::getWorkDate,
                                        Collectors.summingDouble(TimesheetPayload::getDoubleWorkHour)
                                )
                        );
        List<Boolean> isValid = new ArrayList<>();

        resultMap.forEach((date, workHour) -> {
            // 根据日期查询已审批、审批中、已结算状态的工作小时，验证是否大于8
            TimesheetQuery query = new TimesheetQuery();
            query.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
            query.setTsUserId(GlobalUtil.getLoginUserId());
            query.setWorkDateQuery(date);
            final List<TimesheetVO> timesheetVOList = queryList(query);
            // 已提交的工作小时
            Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
            if (workHour + wh > 8d) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    /**
     * 校验工作时间
     *
     * @param payload 有效载荷
     * @return boolean
     */
    private boolean workHourHolidayValidate(TimesheetListPayload payload) {
        List<TimesheetVO> tempList = new ArrayList();
        //  过滤已审批、审批中状态的数据 用于校验工作小时
        List<TimesheetPayload> timesheetList = payload.getTimesheetList().stream()
                .filter(timesheetPayload -> timesheetPayload.getTsStatus() != null &&
                        (timesheetPayload.getTsStatus().equals(CREATE.getCode()) || timesheetPayload.getTsStatus().equals(REJECTED.getCode()))
                ).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(timesheetList)) {
            List<TimesheetVO> timesheetVOS = TimesheetConvert.INSTANCE.payloadToVoList(timesheetList);
            tempList.addAll(timesheetVOS);
        }

        List<LocalDate> workDateList = timesheetList.stream()
                .map(timesheetPayload -> timesheetPayload.getWorkDate()).collect(Collectors.toList());
        // 获取当月的节假日工时
        List<LocalDate> vacationDayList = findVacationDayIn(workDateList);

        // 根据日期查询已审批、审批中、已结算状态的工作小时，验证是否大于8
        TimesheetQuery query = new TimesheetQuery();
        query.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
        query.setTsUserId(GlobalUtil.getLoginUserId());
        query.setWorkDateIn(workDateList);
        final List<TimesheetVO> timesheetVOList = queryList(query);
        if (!CollectionUtils.isEmpty(timesheetVOList)) {
            tempList.addAll(timesheetVOList);
        }

        Map<LocalDate, List<TimesheetVO>> localDateListMap = tempList.stream().filter(timesheetPayload -> {
            LocalDate workDate = timesheetPayload.getWorkDate();
            BigDecimal workHour = timesheetPayload.getWorkHour();
            long count = vacationDayList.stream().filter(vacationDay -> vacationDay.isEqual(workDate)).count();
            return count > 0 && workHour.compareTo(BigDecimal.ZERO) == 0;
        }).collect(Collectors.groupingBy(TimesheetVO::getWorkDate));

        List<Boolean> isValid = new ArrayList<>();
        localDateListMap.forEach((date, timesheetPayloadList) -> {
            if (timesheetPayloadList.stream().count() > 1) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    /**
     * 初始化数据
     *
     * @param payload 有效载荷
     */
    private void initData(TimesheetPayload payload) {
        // 新增情况
        //if (null == payload.getId()) {
        payload.setWorkDayOffStatus("UNGEN");
        payload.setWorkFlag("NO");
        payload.setSettleStatus("NONE");
        payload.setAutoSaveFlag(0);
        if (payload.getTsUserId() == null) {
            // 设置填写人为当前登录人
            payload.setTsUserId(GlobalUtil.getLoginUserId());
        }
        //  获取当前用户的组织信息
        final List<PrdOrgDataRefVO> prdOrgDataRefVOS = daoUser.queryOrgListByKey(payload.getTsUserId());
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS)) {
            final List<PrdOrgDataRefVO> list = prdOrgDataRefVOS.stream()
                    .filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                final Long orgId = list.get(0).getOrgId();
                final String orgName = list.get(0).getOrgName();
                payload.setTsUserBuId(orgId);
                payload.setTsUserBuName(orgName);
            }
        }
        if (null != payload.getProjId()) {
            final PmsProjectVO projectVO = pmsProjectService.queryByKeySimple(payload.getProjId());
            if (!StringUtils.hasText(payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText(payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        // 任务包冗余
        if (payload.getTaskPackageId() != null) {
            final TaskPackageVO taskPackageVO = taskPackageService.queryByKey(payload.getTaskPackageId(), false);
            if (!StringUtils.hasText(payload.getTaskPackageNo())) {
                payload.setTaskPackageNo(null != taskPackageVO ? taskPackageVO.getTaskPackageNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskPackageName())) {
                payload.setTaskPackageName(null != taskPackageVO ? taskPackageVO.getTaskPackageName() : "");
            }
            if (ObjectUtils.isEmpty(payload.getReasonId())) {
                payload.setReasonId(null != taskPackageVO ? taskPackageVO.getReasonId() : null);
            }
            if (!StringUtils.hasText(payload.getReasonType())) {
                payload.setReasonType(null != taskPackageVO ? taskPackageVO.getReasonType() : "");
            }
            if (!StringUtils.hasText(payload.getReasonName())) {
                payload.setReasonName(null != taskPackageVO ? taskPackageVO.getReasonName() : "");
            }
        }

        // 活动阶段（冗余）
        if (payload.getStageId() != null) {
            final PmsProjectActivityVO resActivityVO = pmsProjectActivityService.queryByKey(payload.getStageId());
            if (!StringUtils.hasText(payload.getStageNo())) {
                payload.setStageNo(null != resActivityVO ? resActivityVO.getActNo() : "");
            }
            if (!StringUtils.hasText(payload.getStageName())) {
                payload.setStageName(null != resActivityVO ? resActivityVO.getActName() : "");
            }
        }
        // 任务 冗余翻译
        if (null != payload.getTaskId()) {
            final TaskInfoVO taskVO = taskInfoService.queryByKey(payload.getTaskId(), true);
            if (!StringUtils.hasText(payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getValidEqva() : null);
            }
        }
        // 活动 冗余翻译
        // if (null != payload.getActId()) {
        //     final PmsProjectActivityVO resActivityVO = pmsProjectActivityService.queryByKey(payload.getActId());
        //     if (!StringUtils.hasText(payload.getActNo())) {
        //         payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
        //     }
        //     if (!StringUtils.hasText(payload.getActName())) {
        //         payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
        //     }
        // }
        // 经营计划冗余翻译
        if (null != payload.getOperPlanId()) {
            final CrmOperationPlanDetailVO planDetailVO = crmOperationPlanDetailService.queryByKey(payload.getOperPlanId());
            if (!StringUtils.hasText(payload.getOperPlanName())) {
                payload.setOperPlanName(null != planDetailVO ? planDetailVO.getPlanName() : "");
            }
        }
        payload.setApprResult(null);
        if (payload.isSubmitted()) {
            // 设置为审批中状态
            payload.setTsStatus(APPROVING.getCode());
            // ！！！！审批资源Id
//            payload.setApprUserId(findApprUserId(payload));
            handleApprovalUser(payload);
            // 提交时间
            if (payload.getId() != null && payload.getId() > 0) {
                TimesheetDO entity = timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull(entity.getId(), "工时不存在");
                payload.setSubmitTime(entity.getSubmitTime());
                if (entity.getSubmitTime() == null) {
                    payload.setSubmitTime(LocalDateTime.now());
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            payload.setLastSubmitTime(LocalDateTime.now());
        } else {
            if (payload.getId() != null && payload.getId() > 0) {
                // 非新建时，设置为原单据状态
                TimesheetDO entity = timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull(entity.getId(), "工时不存在");
                payload.setSubmitTime(entity.getSubmitTime());
                payload.setLastSubmitTime(entity.getLastSubmitTime());
                payload.setTsStatus(entity.getTsStatus());
            } else {
                // 设置为创建状态
                payload.setTsStatus(TimesheetStatus.CREATE.getCode());
            }
        }
        if (payload.getWorkDate() != null) {
            // 设置当前年周
            payload.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate())));
            // entity.setWeekStartDate(entity.getWorkDate().with(TemporalAdjusters.previousOrSame( DayOfWeek.MONDAY)));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }

        // 计算补助金额
        calSubSidyAmtPro(payload);
    }

    private void calSubSidyAmtPro(TimesheetPayload payload) {
        if (payload.getSubsidyAmtCalFlag() != null && payload.getSubsidyAmtCalFlag()) {
            calSubSidyAmt(payload);
        }
    }

    /**
     * 计算补助金额
     *
     * @param payload
     */
    private void calSubSidyAmt(TimesheetPayload payload) {
        //如果是无项目无任务的直接return 无项目无任务的不计算补贴
        if(payload.getReasonId()==0L){
            return;
        }
        // 计算补助金额 = [补贴标准 金额] * (填报工时+[工时计算调整]) / 8

        // [补贴标准 金额]  = 资源主档中查询
        // 资源主档 prd_org_employee.ext_string11	出差补助/天
        // 资源主档 prd_org_employee.ext_string12	项目现场补助/天

        // 通过工时补助配置 查询工时计算调整
        // 判定为：节假日，员工当天的工时，是否已经有了 8小时的 ‘节假日’工时。
        // 其余场景，均为 工作日。特别注意，请假流程自动生成工时的场合，也是工作日。
        // 根据日期查询已审批、审批中、已结算状态的工作小时，验证是否大于8
        TimesheetQuery query = new TimesheetQuery();
        query.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
        query.setTsUserId(payload.getTsUserId());
        query.setWorkDateQuery(payload.getWorkDate());
        query.setTsTaskIden("VACATION");
        query.setTsActIden("LEGALHOLIDAY");
        final List<TimesheetVO> timesheetVOList = queryList(query);
        // 已填写的工作小时
        Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
        String workDateType = SubsidyWorkDateTypeEnum.WORK.getCode();
        if (wh == 8d) {
            workDateType = SubsidyWorkDateTypeEnum.HOLIDAY.getCode();
        }

        String holidaySubsidyType = SubsidyHolidaySubsidyTypeTypeEnum.N.getCode();
        String projectSubsidyRole = null;
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            // 假期的时候，才参考
            if (workDateType.equals(SubsidyWorkDateTypeEnum.HOLIDAY.getCode())) {
                holidaySubsidyType = SubsidyHolidaySubsidyTypeTypeEnum.Y.getCode();
                projectSubsidyRole = SubsidyHolidaySubsidyTypeTypeEnum.N.getCode();
                final PmsProjectVO projectVO = pmsProjectService.queryByKeySimple(payload.getReasonId());
                Assert.notNull(projectVO, "项目不存在");
                // 周末现场有补助？
                Integer depreciationMonths = projectVO.getDepreciationMonths();
                if (null != depreciationMonths && depreciationMonths == 1) {
                    projectSubsidyRole = SubsidyHolidaySubsidyTypeTypeEnum.Y.getCode();
                }
            }
        }
        TimesheetSubsidySettingQuery subsidySettingQuery = new TimesheetSubsidySettingQuery();
        subsidySettingQuery.setReasonType(payload.getReasonType());
        subsidySettingQuery.setWorkDateType(workDateType);
        subsidySettingQuery.setHolidaySubsidyType(holidaySubsidyType);
        subsidySettingQuery.setProjectSubsidyRole(projectSubsidyRole);
        subsidySettingQuery.setSubsidySelectTypeCode(payload.getExt4());
        List<TimesheetSubsidySettingVO> list = timesheetSubsidySettingService.queryListDynamic(subsidySettingQuery);
        if (list.size() < 1 && payload.getReasonId() != 0) {
            log.error("未匹配到工时补贴配置，请检查t_timesheet_subsidy_setting数据");
            throw TwException.error("", "工时配置错误，请联系管理员");
        }
        if (list.size() != 1 && payload.getReasonId() != 0) {
            log.error("匹配到多条工时补贴配置，请检查t_timesheet_subsidy_setting数据");
            throw TwException.error("", "工时配置错误，请联系管理员");
        }
        TimesheetSubsidySettingVO timesheetSubsidySettingVO = list.get(0);
        BigDecimal workHourCal = timesheetSubsidySettingVO.getWorkHourCal();
        String subsidyStdType = timesheetSubsidySettingVO.getSubsidyStdType();
        BigDecimal subSidyAmt = BigDecimal.ZERO;
        if (StringUtils.hasText(subsidyStdType) && !subsidyStdType.equals(SubsidyStdTypeEnum.NO.getCode())) {
            PrdOrgEmployeeDO prdOrgEmployeeDO = prdOrgEmployeeDAO.queryByUserId(payload.getTsUserId());
            Assert.notNull(prdOrgEmployeeDO, "资源不存在");
            // 出差补贴
            if (subsidyStdType.equals(SubsidyStdTypeEnum.TRAVEL.getCode())) {
                // 出差补助/天
                subSidyAmt = getSubsidy(payload.getTsUserId(), prdOrgEmployeeDO.getExtString11());
            } else if (subsidyStdType.equals(SubsidyStdTypeEnum.ON_SITE.getCode())) {
                // 项目现场补助/天
                subSidyAmt = getSubsidy(payload.getTsUserId(), prdOrgEmployeeDO.getExtString12());
            }
        }
        // 计算补助金额 = [补贴标准 金额] * (填报工时+[工时计算调整]) / 8
        BigDecimal sumWorkHour = payload.getWorkHour().add(workHourCal);
        // 最终补助金额
        BigDecimal resultSubSidyAmt = sumWorkHour.divide(new BigDecimal(8)).multiply(subSidyAmt).setScale(2, RoundingMode.HALF_UP);
        payload.setSubsidyAmt(resultSubSidyAmt);
    }

    private BigDecimal getSubsidy(Long userId, String subsidyStr) {
        BigDecimal result = BigDecimal.ZERO;
        if (StringUtils.hasText(subsidyStr)) {
            try {
                result = new BigDecimal(subsidyStr);
            } catch (Exception e) {
                log.error("资源{}维护的补助标准格式错误；错误数据 {}", userId, subsidyStr);
            }
        }
        return result;
    }

    /**
     * 根据 事由类型、是否工作日、周末现场是否考虑补助、项目补助规则 查询补助类型（出差类型）下拉选择
     *
     * @param workDate
     * @param reasonType
     * @param reasonId
     * @param tsUserId
     */
    @Override
    public List<TimesheetSubsidySelectTypeVO> listWorkTypeExt4(LocalDate workDate, String reasonType, Long reasonId, Long tsUserId) {
        List<TimesheetSubsidySettingVO> list = getTimesheetSubsidySettingCommon(workDate, reasonType, reasonId, tsUserId);
        List<TimesheetSubsidySelectTypeVO> selectList = list.stream()
                .map(vo -> {
                    TimesheetSubsidySelectTypeVO selectTypeVO = new TimesheetSubsidySelectTypeVO(vo.getSubsidySelectTypeName(), vo.getSubsidySelectTypeCode(), vo.getSubsidySelectDefaultFlag());
                    return selectTypeVO;
                }).collect(Collectors.toList());
        return selectList;

    }

    /**
     * 根据 事由类型、是否工作日、周末现场是否考虑补助、项目补助规则 查询可填写工时 下拉选择
     *
     * @param workDate
     * @param reasonType
     * @param reasonId
     * @param tsUserId
     */
    @Override
    public List<TimesheetSubsidySelectTypeVO> listWorkHourSelect(LocalDate workDate, String reasonType, Long reasonId, Long tsUserId) {
        List<TimesheetSubsidySettingVO> list = getTimesheetSubsidySettingCommon(workDate, reasonType, reasonId, tsUserId);
        List<String> selectList = list.stream()
                .map(TimesheetSubsidySettingVO::getWorkHourSelect).collect(Collectors.toList());
        Set<String> set = new HashSet<>();
        for (String temp : selectList) {
            String[] split = temp.split(",");
            for (String s : split) {
                set.add(s);
            }
        }
        List<TimesheetSubsidySelectTypeVO> collect = set.stream().sorted()
                .map(vo -> {
                    TimesheetSubsidySelectTypeVO selectTypeVO = new TimesheetSubsidySelectTypeVO(vo, vo);
                    return selectTypeVO;
                }).collect(Collectors.toList());
        return collect;
    }

    private List<TimesheetSubsidySettingVO> getTimesheetSubsidySettingCommon(LocalDate workDate, String reasonType, Long reasonId, Long tsUserId) {
        if (workDate == null) {
            throw TwException.error("", "workDate不能为空");
        }
        if (!StringUtils.hasText(reasonType)) {
            throw TwException.error("", "reasonType不能为空");
        }
        if (null == tsUserId) {
            tsUserId = GlobalUtil.getLoginUserId();
        }
        TimesheetQuery query = new TimesheetQuery();
        query.setTsUserId(tsUserId);
        query.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
        query.setWorkDateQuery(workDate);
        query.setTsTaskIden("VACATION");
        query.setTsActIden("LEGALHOLIDAY");
        final List<TimesheetVO> timesheetVOList = queryList(query);
        // 已填写的工作小时
        Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
        String workDateType = SubsidyWorkDateTypeEnum.WORK.getCode();
        if (wh == 8d) {
            workDateType = SubsidyWorkDateTypeEnum.HOLIDAY.getCode();
        }

        String holidaySubsidyType = SubsidyHolidaySubsidyTypeTypeEnum.N.getCode();
        String projectSubsidyRole = null;
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            if (reasonId == null) {
                throw TwException.error("", "reasonId不能为空");
            }
            if (reasonId == 0) {
                return Collections.EMPTY_LIST;
            }
            // 假期的时候，才参考
            if (workDateType.equals(SubsidyWorkDateTypeEnum.HOLIDAY.getCode())) {
                holidaySubsidyType = SubsidyHolidaySubsidyTypeTypeEnum.Y.getCode();
                projectSubsidyRole = SubsidyHolidaySubsidyTypeTypeEnum.N.getCode();
                final PmsProjectVO projectVO = pmsProjectService.queryByKeySimple(reasonId);
                Assert.notNull(projectVO, "项目不存在");
                // 周末现场有补助？
                Integer depreciationMonths = projectVO.getDepreciationMonths();
                if (null != depreciationMonths && depreciationMonths == 1) {
                    projectSubsidyRole = SubsidyHolidaySubsidyTypeTypeEnum.Y.getCode();
                }
            }
        }

        TimesheetSubsidySettingQuery subsidySettingQuery = new TimesheetSubsidySettingQuery();
        subsidySettingQuery.setReasonType(reasonType);
        subsidySettingQuery.setWorkDateType(workDateType);
        subsidySettingQuery.setHolidaySubsidyType(holidaySubsidyType);
        subsidySettingQuery.setProjectSubsidyRole(projectSubsidyRole);

        List<TimesheetSubsidySettingVO> list = timesheetSubsidySettingService.queryListDynamic(subsidySettingQuery);
        return list;
    }

    /**
     * 获取工时审批人
     *
     * @param payload
     * @return
     */
    private void handleApprovalUser(TimesheetPayload payload) {
        // TsNotaskApprovalConfigService tsNotaskApprovalConfigService = SpringUtil.getBean(TsNotaskApprovalConfigService.class);
        TsApprovalConfigService tsApprovalConfigService = SpringUtil.getBean(TsApprovalConfigService.class);
        LocalDate workDate = payload.getWorkDate();
        int year = workDate.getYear();
        List<TsApprovalResPayload> tsApprovalResPayloads = tsApprovalConfigService.queryApprovalResDib(payload.getReasonId(), payload.getReasonType(), payload.getTsUserId(), year);
        // //1.任务不为空选任务派发资源审批
        // if (payload.getTaskId() != null) {
        //     TaskInfoVO taskInfoVO = taskInfoService.queryByKey(payload.getTaskId(), false);
        //     if (null != taskInfoVO) {
        //         tsApprovalResPayloads = tsApprovalConfigService.queryApprovalRes(taskInfoVO.getTaskPackageId(), year);
        //     }
        // } else {
        //     // 无项目无任务
        //     String tsTaskIden = payload.getTsTaskIden();
        //     if (tsTaskIden != null && tsTaskIden.equals("NOTASK")) {
        //         // 读取配置
        //         Map<String, Object> result = tsNotaskApprovalConfigService.noTaskApprovalConfigRule(payload.getWorkHour(), workDate, payload.getTsActIden());
        //         Integer ut = (Integer) result.get("ut");
        //         // 将ut值保存再工时里面
        //         payload.setUt(ut);
        //         tsApprovalResPayloads = (List<TsApprovalResPayload>) result.get("tsApprovalResPayloads");
        //     }
        // }
        for (TsApprovalResPayload tsApprovalResPayload : tsApprovalResPayloads) {
            tsApprovalResPayload.setTimesheetId(payload.getId());
            // 保存工时审批列表
            tsApprovalResService.insert(tsApprovalResPayload);
            if (tsApprovalResPayload.getApprovalStatus().equals("APPROVING")) {
                payload.setApprUserId(tsApprovalResPayload.getApprovalResId());
            }
        }
    }

    /**
     * 获取工时审批人
     *
     * @param payload
     * @return
     */
    private Long findApprUserId(TimesheetPayload payload) {
        Long apprUserId = null;
        /**
         * 1.任务不为空选任务派发资源审批
         * 2.任务为空，项目非空选择项目经理审批
         * 3.都是空，由资源bu负责人审批
         * 4.如果审批资源和提交人相同
         *   4.1 如果提交人是事业部leader，提交人自己审
         *   4.2 不是事业部leader，取提交人bu负责人
         */
        //1.任务不为空选任务派发资源审批
        if (payload.getTaskId() != null) {
            TaskInfoVO taskInfoVO = taskInfoService.queryByKey(payload.getTaskId(), false);
            if (null != taskInfoVO) {
                // 发包人审批工时
                Long disterResId = taskInfoVO.getDisterResId();
                if (disterResId != null && disterResId >= 0) {
                    apprUserId = disterResId;
                }
            }
        } else {
            //2.任务为空，项目非空选择项目经理审批
            if (payload.getProjId() != null) {
                PmsProjectQuery twProjectQuery = new PmsProjectQuery();
                twProjectQuery.setId(payload.getProjId());
                final List<PmsProjectVO> projects = pmsProjectService.queryListDynamic(twProjectQuery);
                if (projects != null && projects.size() > 0) {
                    Long pmId = projects.get(0).getPmResId();
                    if (pmId != null && pmId > 0) {
                        apprUserId = pmId;
                    }
                }
            }
        }
        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(payload.getTsUserId());
        if (null == userDefaultOrg) {
            throw TwException.error("", "匹配不到审批人，请联系管理员");
        }
        //3.都是空，由资源bu负责人审批
        if (apprUserId == null) {
            apprUserId = userDefaultOrg.getManageId();
        }
        //4.如果审批资源和提交人相同
        if (apprUserId.longValue() == payload.getTsUserId().longValue()) {
            if (StringUtils.hasText(userDefaultOrg.getBuLevel()) && userDefaultOrg.getBuLevel().equals(OrgEnum.BuLevel.BU_LEVEL1.getCode())) {
                if (userDefaultOrg.getManageId().longValue() != apprUserId.longValue()) {
                    //4.2 不是事业部leader，取提交人bu负责人
                    apprUserId = userDefaultOrg.getManageId();
                }
            } else {
                //4.2 不是事业部leader，取提交人bu负责人
                apprUserId = userDefaultOrg.getManageId();
            }
        }
        return apprUserId;
    }

    /**
     * 工时的审批资源ID取值 (无详设) 业务描述者:曹继旺、张勇强、薛老师
     * <p>
     * desc:
     * 1、选择了任务包，并且任务包的发包人存在，则任务包的发包人为审批人
     * 1、1 选择了任务包，如果是基于授权方法的任务包，则根据授权配置中指定的审批角色判断（PM:项目经理 PL:授权接收人）
     * 2、如果没选择任务包或者任务包的发包人为空，则项目经理作为审批人
     * 3、项目、任务包都没有选或项目经理、任务包的发包人都是空，则资源上级为审批人
     *
     * @param payload 工时
     * @return
     */
    private Long findApprUserId0(TimesheetPayload payload) {

        //选择了任务包，并且任务包的发包人存在，则任务包的发包人为审批人
        if (payload.getTaskId() != null) {
            // 选择了任务包，如果是基于授权方法的任务包，则根据授权配置中指定的审批角色判断（PM:项目经理 PL:授权接收人）
            // final Long apprResIdByAuthInfo = taskService.getApprResIdByAuthInfo(payload.getTaskId());
            // if (null != apprResIdByAuthInfo) {
            //     return apprResIdByAuthInfo;
            // }

            // 根据4.0任务id查询
            TaskInfoVO taskInfoVO = taskInfoService.queryByKey(payload.getTaskId(), false);
            if (null != taskInfoVO) {
                // 发包人审批工时
                Long disterResId = taskInfoVO.getDisterResId();
                if (disterResId != null && disterResId >= 0) {
                    return disterResId;
                }
//                // 验收人审批工时
//                Long acceptorId = taskInfoVO.getDisterResId();
//                if (acceptorId != null && acceptorId >= 0) {
//                    return acceptorId;
//                }
            }
        }
        //如果没选择任务包或者任务包的发包人为空，则项目经理作为审批人
        if (payload.getProjId() != null) {
            PmsProjectQuery twProjectQuery = new PmsProjectQuery();
            twProjectQuery.setId(payload.getProjId());
            final List<PmsProjectVO> projects = pmsProjectService.queryListDynamic(twProjectQuery);
            if (projects != null && projects.size() > 0) {
                Long pmId = projects.get(0).getPmResId();
                if (pmId != null && pmId > 0) {
                    return pmId;
                }
            }
        }

        /*if (entity.getTaskId() != null) {//选了任务包，审批人为任务包的发包者
            return taskMapper.findTask(entity.getTaskId()).getDisterResId();
        }*/
        //项目、任务包都没有选或项目经理、任务包的发包人都是空，则资源上级为审批人
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(payload.getTsUserId());
        if (null == prdOrgEmployeeRefVO) {
            log.error("【匹配不到审批人】：工时填报用户主键：{} ; 工时数据：{}", payload.getTsUserId(), payload);
            throw TwException.error("", "匹配不到审批人，请联系管理员");
            //  查找自己的上级、管理员没有上级的情况就是自己
            //return payload.getTsUserId();
        }
        // 用户的部门
        Long tsUserBuId = payload.getTsUserBuId();
        PrdOrgOrganizationDO prdOrgOrganizationDO = prdOrgOrganizationDAO.queryById(tsUserBuId);
        String organizationType = prdOrgOrganizationDO.getOrganizationType();
        if (organizationType != null) {
            Long apprUserId = null;
            switch (organizationType) {
                case "BD":
                case "BY":
                    // 查询当前登录人是不是部门负责人
                    // BU级权限（查看当前登录人是否是部门负责人）
                    final List<PrdOrgOrganizationDO> organizationDOList = prdOrgOrganizationDAO.queryByManagerId(payload.getTsUserId());
                    Set<Long> orgIdList = null;
                    if (!CollectionUtils.isEmpty(organizationDOList)) {
                        orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
                        if (orgIdList.contains(tsUserBuId)) {
                            //上级审批
                            Long parentId = prdOrgEmployeeRefVO.getParentId();
                            return parentId;
                        } else {
                            // 部门负责人审批
                            Long manageId = prdOrgEmployeeRefVO.getManageId();
                            return manageId;
                        }
                    }
                    // 部门负责人审批
                    apprUserId = prdOrgEmployeeRefVO.getManageId();
                    break;
                case "BM":
                case "BS":
                    //查找资源的父id
                    apprUserId = prdOrgEmployeeRefVO.getParentId();
                    break;
            }
            return apprUserId;
        } else {
            //查找资源的父id
            Long parentId = prdOrgEmployeeRefVO.getParentId();
            return parentId;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetVO update(TimesheetPayload payload) {
        if (payload.getProjId() != null) {
            final PmsProjectVO projectVO = pmsProjectService.queryByKeySimple(payload.getProjId());
            if (!StringUtils.hasText(payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText(payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (payload.getTaskPackageId() != null) {
            final TaskPackageVO taskPackageVO = taskPackageService.queryByKey(payload.getTaskPackageId(), false);
            if (!StringUtils.hasText(payload.getTaskPackageNo())) {
                payload.setTaskPackageNo(null != taskPackageVO ? taskPackageVO.getTaskPackageNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskPackageName())) {
                payload.setTaskPackageName(null != taskPackageVO ? taskPackageVO.getTaskPackageName() : "");
            }
            if (ObjectUtils.isEmpty(payload.getReasonId())) {
                payload.setReasonId(null != taskPackageVO ? taskPackageVO.getReasonId() : null);
            }
            if (!StringUtils.hasText(payload.getReasonType())) {
                payload.setReasonType(null != taskPackageVO ? taskPackageVO.getReasonType() : "");
            }
            if (!StringUtils.hasText(payload.getReasonName())) {
                payload.setReasonName(null != taskPackageVO ? taskPackageVO.getReasonName() : "");
            }
        }
        if (payload.getTaskId() != null) {
            final TaskInfoVO taskVO = taskInfoService.queryByKey(payload.getTaskId(), true);
            if (!StringUtils.hasText(payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getValidEqva() : null);
            }
        }
        TimesheetDO entity = timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
        Assert.notNull(entity.getId(), "工时不存在");
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetConvert.INSTANCE.toVo(timesheetRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    // 判断状态是否为创建
                    if (!TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus()) &&
                            !TimesheetStatus.REJECTED.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只能删除状态为创建或者退回的工时");
                    }
                    // 对于调休的工时删除修改加班的状态
                    String overtimeApplicationId = entity.getExt2();
                    if (StringUtils.hasText(overtimeApplicationId) && "SHIFTING".equals(entity.getTsActIden())) {

                        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                        overtimeApplicationDO.setRestStatus(RestStatusEnum.CREATE.getCode());
                        overtimeApplicationDO.setRestDate(entity.getWorkDate());
                        overtimeApplicationDO.setId(Long.valueOf(overtimeApplicationId));
                        overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
                    }
                }
            });
            timesheetDAO.deleteSoft(keys);
        }
    }

    /**
     * 审批通过
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void toApproved(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    if (!APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中的单据才允许审批通过");
                    }
                    // 审批记录查询
                    TsApprovalResQuery tsApprovalResQuery = new TsApprovalResQuery();
                    tsApprovalResQuery.setTimesheetId(id);
                    tsApprovalResQuery.setApprovalStatus(APPROVING.getCode());
                    // 审批记录查询
                    List<TsApprovalResVO> tsApprovalResVOS = tsApprovalResService.queryListDynamic(tsApprovalResQuery);
                    if (!CollectionUtils.isEmpty(tsApprovalResVOS)) {
                        TsApprovalResVO tsApprovalResVO = tsApprovalResVOS.get(0);//只能有一条审批中的工时
                        if (!GlobalUtil.getLoginUserId().equals(tsApprovalResVO.getApprovalResId())) {
                            throw TwException.error("", "审批人错误");
                        }
                        Integer lastFlag = tsApprovalResVO.getLastFlag();
                        // 更新审批数据
                        TsApprovalResPayload approvalResPayload = new TsApprovalResPayload();
                        approvalResPayload.setId(tsApprovalResVO.getId());
                        if (tsApprovalResVO.getFristApprovalTime() == null) {
                            approvalResPayload.setFristApprovalTime(LocalDateTime.now());
                        }
                        approvalResPayload.setApprovalTime(LocalDateTime.now());
                        if (lastFlag == 1) {
                            approvalResPayload.setApprovalStatus(APPROVED.getCode());
                            // entity.setApprUserId(null);
                            entity.setTsStatus("APPROVED");
                            // 审批完成
                            entity.setTsStatus(APPROVED.getCode());
                            entity.setApprResult("审批通过");
                            entity.setApprovalTime(LocalDateTime.now());
                            timesheetRepo.save(entity);
                            // 修改任务包当量信息
                            updatePmsTaskInfoByTimesheetEntity(entity, APPROVED);
                        } else {
                            approvalResPayload.setApprovalStatus(APPROVED.getCode());
                            // 更新下一个节点
                            Integer sortIndex = tsApprovalResVO.getSortIndex() + 1;
                            tsApprovalResQuery = new TsApprovalResQuery();
                            tsApprovalResQuery.setTimesheetId(id);
                            tsApprovalResQuery.setSortIndex(sortIndex);
                            tsApprovalResVOS = tsApprovalResService.queryListDynamic(tsApprovalResQuery);
                            if (!CollectionUtils.isEmpty(tsApprovalResVOS)) {
                                TsApprovalResVO nextTsApprovalResVO = tsApprovalResVOS.get(0);
                                TsApprovalResPayload nextApprovalResPayload = new TsApprovalResPayload();
                                nextApprovalResPayload.setId(nextTsApprovalResVO.getId());
                                nextApprovalResPayload.setApprovalStatus(APPROVING.getCode());
                                tsApprovalResService.updateByKeyDynamic(nextApprovalResPayload);
                                //更新审批人
                                entity.setApprUserId(nextTsApprovalResVO.getApprovalResId());
                                timesheetRepo.save(entity);
//                                timesheetDAO.updateAppruserId(id,nextTsApprovalResVO.getApprovalResId());
                            } else {
                                throw TwException.error("", "获取下一个审批节点失败，请联系管理员！");
                            }
                        }
                        tsApprovalResService.updateByKeyDynamic(approvalResPayload);

                    } else {
                        // 走老审批
                        entity.setTsStatus(APPROVED.getCode());
                        entity.setApprResult("审批通过");
                        entity.setApprovalTime(LocalDateTime.now());
                        timesheetRepo.save(entity);
                        // 修改任务包当量信息
                        updatePmsTaskInfoByTimesheetEntity(entity, APPROVED);
                    }

                    // 调休修改状态
                    String overtimeApplicationId = entity.getExt2();
                    if (StringUtils.hasText(overtimeApplicationId) && "SHIFTING".equals(entity.getTsActIden())) {
                        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                        overtimeApplicationDO.setRestStatus(RestStatusEnum.RESTED.getCode());
                        overtimeApplicationDO.setRestDate(entity.getWorkDate());
                        overtimeApplicationDO.setId(Long.valueOf(overtimeApplicationId));
                        overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
                    }
                    // 修改任务包当量信息
//                    updatePmsTaskInfoByTimesheetEntity(entity, APPROVED);
                }
            });
        }
    }


    /**
     * 高级审批
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void toAdvanced(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    if (!APPROVING.getCode().equals(entity.getTsStatus()) && !CREATE.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中或新建的单据才允许审批通过");
                    }
                    entity.setTsStatus(APPROVED.getCode());
                    entity.setApprResult("审批通过");
                    timesheetRepo.save(entity);

                    // 更新pms任务信息
                    updatePmsTaskInfoByTimesheetEntity(entity, APPROVED);

                }
            });
        }
    }

    /**
     * 审批拒绝
     *
     * @param keys       键
     * @param apprResult 从结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void rejected(List<Long> keys, String apprResult) {
        if (!keys.isEmpty()) {
            // List<Long> taskIdList = new ArrayList<>();
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    if (!APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中的单据才允许审批拒绝");
                    }
//                    if (!GlobalUtil.getLoginUserId().equals(entity.getApprUserId())) {
//                        throw TwException.error("", "审批人错误");
//                    }
                    // 删除所有的审批节点
                    tsApprovalResService.deleteSoftByTimesheetId(id);
                    entity.setApprUserId(null);
                    entity.setTsStatus(REJECTED.getCode());
                    entity.setApprResult(apprResult);
                    timesheetRepo.save(entity);

                    // 更新任务包工时当量信息
                    // final Long taskId = entity.getTaskId();
                    // if (null != taskId && taskId > 0) {
                    //     taskIdList.add(taskId);
                    // }

                    // 调休修改状态
                    String overtimeApplicationId = entity.getExt2();
                    if (StringUtils.hasText(overtimeApplicationId) && "SHIFTING".equals(entity.getTsActIden())) {
                        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                        overtimeApplicationDO.setRestStatus(RestStatusEnum.REJECTED.getCode());
                        overtimeApplicationDO.setRestDate(entity.getWorkDate());
                        overtimeApplicationDO.setId(Long.valueOf(overtimeApplicationId));
                        overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
                    }

                    // 更新pms任务信息
                    updatePmsTaskInfoByTimesheetEntity(entity, REJECTED);
                }
            });

        }
    }

    /**
     * 撤回
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void revoked(List<Long> keys) {
        if (!keys.isEmpty()) {
            // List<Long> taskIdList = new ArrayList<>();
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {

                    TimesheetDO entity = optional.get();
                    if (!APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中的单据才允许撤回");
                    }
                    if (entity.getReturnFlag() != null && !entity.getReturnFlag()) {
                        throw TwException.error("", "该工时不允许撤回");
                    }
                    // 删除所有的审批节点
                    tsApprovalResService.deleteSoftByTimesheetId(id);
                    entity.setTsStatus(CREATE.getCode());
                    entity.setApprUserId(null);
                    entity.setApprResult("审批撤回");
                    timesheetRepo.save(entity);

                    // 更新任务包工时当量信息
                    // final Long taskId = entity.getTaskId();
                    // if (null != taskId && taskId > 0) {
                    //     taskIdList.add(taskId);
                    // }

                    // 更新pms任务信息
                    updatePmsTaskInfoByTimesheetEntity(entity, CREATE);
                }
            });

        }
    }

    /**
     * 更新任务包工时当量信息
     *
     * @param taskIdList 任务id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateTaskTimesheetEqva(List<Long> taskIdList) {

    }

    public void updateTaskTimesheetEqva(List<Long> taskIdList, TimesheetStatus timesheetStatus) {
        if (!CollectionUtils.isEmpty(taskIdList)) {
            // //计算任务包当量 原始发包当量、追加当量、被工时用掉的当量、剩余还可以用来填报的当量
            // TaskQuery query = new TaskQuery();
            // query.setTaskIdV4List(taskIdList);
            //
            // final List<TaskVO> taskList = taskService.queryList(query);
            // Map<Long, BigDecimal> tsUsedEqvaMap = calTsUsedEqvasByIds(taskIdList);//任务包已经被工时用掉的当量
            // Map<Long, BigDecimal> tsEffectiveEqva = taskList.stream().map(t -> {
            //     if (tsUsedEqvaMap != null) {
            //         t.setTsUsedEqva(tsUsedEqvaMap.get(t.getTaskIdV4()));
            //     }
            //     return t;
            // }).collect(Collectors.toMap(TaskVO::getTaskIdV4, TaskVO::getTsEffectiveEqva));// 计算任务包剩余可用于填报工时的当量
            // 去重
            Set<Long> taskIdsSet = new HashSet<>();
            taskIdsSet.addAll(taskIdList);
            for (Long taskId : taskIdsSet) {
                //计算任务包剩余可用于填报工时的当量
                // BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
                // if (null != tsEffecttiveEqva) {
                //     taskRepo.updateTaskEffectiveEqva(taskId, tsEffecttiveEqva);
                // }
                // //计算任务包已填工时当量
                // BigDecimal usedEqva = BigDecimal.ZERO;
                // if (null != tsUsedEqvaMap) {
                //     usedEqva = tsUsedEqvaMap.get(taskId) != null ? tsUsedEqvaMap.get(taskId) : BigDecimal.ZERO;
                // }
                // taskInfoService.updateTaskFromWorkHours(taskId,null,timesheetStatus.getCode());
                // taskRepo.updateUsedEqva(taskId, usedEqva);
            }
        }
    }

    @Override
    public Map<Long, Long> getTimesheetAndPlanIds() {
        Map<Long, Long> orgMap = new HashMap<>();
        List<Map<String, Object>> timeSheetAndPlanIds = timesheetRepo.getTimesheetAndPlanIds();
        for (Map<String, Object> timesheetAndPlanId : timeSheetAndPlanIds) {
            Long timesheetId = (Long) timesheetAndPlanId.get("timesheetId");
            Long workPlanId = (Long) timesheetAndPlanId.get("workPlanId");
            if (timesheetId != null && workPlanId != null) {
                orgMap.put(timesheetId, workPlanId);
            }
        }
        return orgMap;
    }

    @Override
    public Map<Long, Long> getV4AndV5TimesheetIds() {
        Map<Long, Long> timesheetMap = new HashMap<>();
        List<Map<String, Object>> v4AndV5TimesheetIds = timesheetRepo.getV4AndV5TimesheetIds();
        for (Map<String, Object> v4AndV5TimesheetId : v4AndV5TimesheetIds) {
            Long timesheetId = (Long) v4AndV5TimesheetId.get("timesheetId");
            Long timesheetIdV4 = (Long) v4AndV5TimesheetId.get("timesheetIdV4");
            if (timesheetId != null && timesheetIdV4 != null) {
                timesheetMap.put(timesheetIdV4, timesheetId);
            }
        }
        return timesheetMap;
    }

    /**
     * 工时填写企业微信自动提醒(BU/研发BU全员)
     */
    @Override
    public String timesheetAlertAll() {
        List<PrdOrgEmployeeDO> onJobUsers = prdOrgEmployeeDAO.getOnJobUser();

        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate yesterday = LocalDate.now().minusDays(1);
        LocalDate workDay = firstDayMonth;
        long difference = LocalDate.now().toEpochDay() - firstDayMonth.toEpochDay();
        List<LocalDate> dateList = new ArrayList<>();
        List<String> sendLogList = new ArrayList<>();
        List<String> unSendLogList = new ArrayList<>();
        if (difference >= 0) {
            while (workDay.isBefore(LocalDate.now())) {
                dateList.add(workDay);
                workDay = workDay.plusDays(1);
            }
            for (PrdOrgEmployeeDO user : onJobUsers) {
                List<LocalDate> writeDateList;
                LocalDate enrollDate = user.getEnrollDate();
                HashSet<LocalDate> unWritedSet;
                HashSet<LocalDate> writedSet;
                if (!ObjectUtils.isEmpty(enrollDate)) {
                    if (enrollDate.isBefore(firstDayMonth)) {
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, yesterday);
                        unWritedSet = new HashSet<>(dateList);
                    } else if (enrollDate.isAfter(yesterday)) {
                        writeDateList = new ArrayList<>(0);
                        unWritedSet = new HashSet<>(0);
                    } else {
                        List<LocalDate> enDateList = new ArrayList<>();
                        while (enrollDate.isBefore(yesterday.plusDays(1))) {
                            enDateList.add(enrollDate);
                            enrollDate = enrollDate.plusDays(1);
                        }
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, yesterday);
                        unWritedSet = new HashSet<>(enDateList);
                    }
                } else {
                    writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, yesterday);
                    unWritedSet = new HashSet<>(dateList);
                }
                writedSet = new HashSet<>(writeDateList);
                unWritedSet.removeAll(writedSet);
                if (unWritedSet.size() > 0) {
                    List<LocalDate> unWriteDateList = unWritedSet.stream().toList();
                    String content = "您" + unWriteDateList + "工时未填写,请及时填写";
                    String employeeName = user.getEmployeeName();
                    boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(user.getWecomId(), content);
                    if (sendFlag) {
                        sendLogList.add(employeeName);
                    } else {
                        unSendLogList.add(employeeName);
                    }
                }
            }
        }
        return "成功:" + sendLogList + "失败:" + unSendLogList;
    }

    @Override
    public String timesheetAlertSuperior() {
        List<PrdOrgEmployeeDO> onJobUsers = prdOrgEmployeeDAO.getOnJobUser();

        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastThreeDay = LocalDate.now().minusDays(3);
        LocalDate workDay = firstDayMonth;
        List<PrdOrgEmployeeSuperiorQuery> userSuperiorList = prdOrgEmployeeDAO.getUserSuperior();
        Map<Long, Long> userSuperiorMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getEmployeeId, PrdOrgEmployeeSuperiorQuery::getSuperiorId));
        Map<Long, String> superiorNameMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getSuperiorId, PrdOrgEmployeeSuperiorQuery::getSuperiorName, (val1, val2) -> val2));
        Map<Long, String> superiorWxMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getSuperiorId, PrdOrgEmployeeSuperiorQuery::getSuperiorWxId, (val1, val2) -> val2));
        Map<Long, String> superiorMap = new HashMap<>();
        List<String> sendLogList = new ArrayList<>();
        List<String> unSendLogList = new ArrayList<>();
        List<LocalDate> dateList = new ArrayList<>();
        long difference = lastThreeDay.toEpochDay() - firstDayMonth.toEpochDay();
        if (difference >= 0) {
            while (workDay.isBefore(lastThreeDay.plusDays(1))) {
                dateList.add(workDay);
                workDay = workDay.plusDays(1);
            }
            for (PrdOrgEmployeeDO user : onJobUsers) {
                if (userSuperiorMap.containsKey(user.getUserId())) {
                    List<LocalDate> writeDateList;
                    LocalDate enrollDate = user.getEnrollDate();
                    HashSet<LocalDate> unWritedSet;
                    HashSet<LocalDate> writedSet;
                    if (!ObjectUtils.isEmpty(enrollDate)) {
                        if (enrollDate.isBefore(firstDayMonth)) {
                            writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                            unWritedSet = new HashSet<>(dateList);
                        } else if (enrollDate.isAfter(lastThreeDay)) {
                            writeDateList = new ArrayList<>(0);
                            unWritedSet = new HashSet<>(0);
                        } else {
                            List<LocalDate> enDateList = new ArrayList<>();
                            while (enrollDate.isBefore(lastThreeDay.plusDays(1))) {
                                enDateList.add(enrollDate);
                                enrollDate = enrollDate.plusDays(1);
                            }
                            writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                            unWritedSet = new HashSet<>(enDateList);
                        }
                    } else {
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                        unWritedSet = new HashSet<>(dateList);
                    }
                    writedSet = new HashSet<>(writeDateList);
                    unWritedSet.removeAll(writedSet);
                    if (unWritedSet.size() > 0) {
                        String userContent = user.getEmployeeName();
                        Long superiorId = userSuperiorMap.get(user.getUserId());
                        if (superiorMap.containsKey(superiorId)) {
                            String content = superiorMap.get(superiorId);
                            content = content + ',' + userContent;
                            superiorMap.put(superiorId, content);
                        } else {
                            superiorMap.put(superiorId, userContent);
                        }
                    }
                }
            }
            for (Long superiorId : superiorMap.keySet()) {
                String content = "您的下级【" + superiorMap.get(superiorId) + "】 工时已长时间延误未填写，请帮忙跟催以免影响工时结算。";
                boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(superiorWxMap.get(superiorId), content);
                String log = superiorNameMap.get(superiorId) + ":【" + superiorMap.get(superiorId) + "】" +
                        "\n";
                if (sendFlag) {
                    sendLogList.add(log);
                } else {
                    unSendLogList.add(log);
                }
            }
        }
        return "成功:" + sendLogList + "失败:" + unSendLogList;
    }

    @Override
    public String timesheetAlertBuLeader() {
        List<PrdOrgEmployeeDO> onJobUsers = prdOrgEmployeeDAO.getOnJobUser();

        LocalDate lastMonday = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).minusDays(7);
        LocalDate lastFriday = lastMonday.plusDays(4);
        LocalDate workDay = lastMonday;
        List<PrdOrgEmployeeLeaderQuery> userBuLeaderList = prdOrgEmployeeDAO.getUserBuLeader();
        Map<Long, Long> userBuLeaderMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getEmployeeId, PrdOrgEmployeeLeaderQuery::getOrgLeaderId));
        Map<Long, String> userBuLeaderNameMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getOrgLeaderId, PrdOrgEmployeeLeaderQuery::getOrgLeaderName, (val1, val2) -> val2));
        Map<Long, String> buLeaderWxMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getOrgLeaderId, PrdOrgEmployeeLeaderQuery::getOrgLeaderWxId, (val1, val2) -> val2));
        Map<Long, String> buLeaderMap = new HashMap<>();
        List<LocalDate> dateList = new ArrayList<>();
        List<String> sendLogList = new ArrayList<>();
        List<String> unSendLogList = new ArrayList<>();
        while (workDay.isBefore(lastFriday.plusDays(1))) {
            dateList.add(workDay);
            workDay = workDay.plusDays(1);
        }
        for (PrdOrgEmployeeDO user : onJobUsers) {
            if (userBuLeaderMap.containsKey(user.getUserId())) {
                List<LocalDate> writeDateList;
                LocalDate enrollDate = user.getEnrollDate();
                HashSet<LocalDate> unWritedSet;
                HashSet<LocalDate> writedSet;
                if (!ObjectUtils.isEmpty(enrollDate)) {
                    if (enrollDate.isBefore(lastMonday)) {
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                        unWritedSet = new HashSet<>(dateList);
                    } else if (enrollDate.isAfter(lastFriday)) {
                        writeDateList = new ArrayList<>(0);
                        unWritedSet = new HashSet<>(0);
                    } else {
                        List<LocalDate> enDateList = new ArrayList<>();
                        while (enrollDate.isBefore(lastFriday.plusDays(1))) {
                            enDateList.add(enrollDate);
                            enrollDate = enrollDate.plusDays(1);
                        }
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                        unWritedSet = new HashSet<>(enDateList);
                    }
                } else {
                    writeDateList = timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                    unWritedSet = new HashSet<>(dateList);
                }
                writedSet = new HashSet<>(writeDateList);
                unWritedSet.removeAll(writedSet);
                if (unWritedSet.size() > 0) {
                    String userContent = user.getEmployeeName();
                    Long buLeaderId = userBuLeaderMap.get(user.getUserId());
                    if (buLeaderMap.containsKey(buLeaderId)) {
                        String content = buLeaderMap.get(buLeaderId);
                        content = content + ',' + userContent;
                        buLeaderMap.put(buLeaderId, content);
                    } else {
                        buLeaderMap.put(buLeaderId, userContent);
                    }
                }
            }
        }
        for (Long buLeaderId : buLeaderMap.keySet()) {
            String content = "您的部门成员【" + buLeaderMap.get(buLeaderId) + "】上周有工时未填写，请帮忙跟催以免影响工时结算。";
            boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(buLeaderWxMap.get(buLeaderId), content);
            String log = userBuLeaderNameMap.get(buLeaderId) + ":【" + buLeaderMap.get(buLeaderId) + "】" +
                    "\n";
            if (sendFlag) {
                sendLogList.add(log);
            } else {
                unSendLogList.add(log);
            }
        }
        return "成功:" + sendLogList + "失败:" + unSendLogList;
    }


    /**
     * 修复一到六月的工时，临时方法
     */
    @Override
    @Deprecated
    public void repairTimesheet() {
        // List<Map<String, Object>> timesheetList = timesheetRepo.queryTimeSheetToRepair();
        // for (Map<String, Object> timesheet : timesheetList) {
        //     BigInteger id = (BigInteger) timesheet.get("id");
        //     BigInteger projId = (BigInteger) timesheet.get("projId");
        //     BigInteger tsUserId = (BigInteger) timesheet.get("tsUserId");
        //     Map<String, Object> timesheetToCopy = timesheetRepo.queryTimeSheetToCopy(projId, tsUserId);
        //     if (!ObjectUtils.isEmpty(timesheetToCopy)) {
        //         //更新当前的工时
        //         timesheetRepo.updateTimesheetByCopy((BigInteger) timesheetToCopy.get("taskId"), (String) timesheetToCopy.get("taskNo"), (String) timesheetToCopy.get("taskName"), (BigInteger) timesheetToCopy.get("actId"), (String) timesheetToCopy.get("actNo"), (String) timesheetToCopy.get("actName"), id);
        //     }
        // }
    }

    @Override
    public String timesheetApprovingAlert() {
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate today = LocalDate.now();
        List<String> sendLogList = new ArrayList<>();
        List<String> unSendLogList = new ArrayList<>();
        Map<Long, String> apprMap = new HashMap<>();
        List<TimesheetApproveQuery> timesheetApproverList = timesheetDAO.approvingDate(firstDayMonth, today);
        Map<Long, String> apprWxMap = timesheetApproverList.stream().collect(Collectors.toMap(TimesheetApproveQuery::getApprUserId, TimesheetApproveQuery::getApprWxId, (val1, val2) -> val2));
        Map<Long, String> apprNameMap = timesheetApproverList.stream().collect(Collectors.toMap(TimesheetApproveQuery::getApprUserId, TimesheetApproveQuery::getApprName, (val1, val2) -> val2));
        for (TimesheetApproveQuery timesheetApproveQuery : timesheetApproverList) {
            String userContent = timesheetApproveQuery.getEmployeeName();
            Long apprUserId = timesheetApproveQuery.getApprUserId();
            if (apprMap.containsKey(apprUserId)) {
                String content = apprMap.get(apprUserId);
                content = content + ',' + userContent;
                apprMap.put(apprUserId, content);
            } else {
                apprMap.put(apprUserId, userContent);
            }
        }
        for (Long apprUserId : apprMap.keySet()) {
            String content = "您有【" + apprMap.get(apprUserId) + "】 提交的工时未审批，请及时审批";
            boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(apprWxMap.get(apprUserId), content);
            String log = apprNameMap.get(apprUserId) + ":【" + apprMap.get(apprUserId) + "】" + "\n";
            if (sendFlag) {
                sendLogList.add(log);
            } else {
                unSendLogList.add(log);
            }
        }
        return "成功:" + sendLogList + "失败:" + unSendLogList;
    }

    @Override
    public void approvedRevoked(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
//                    if (!APPROVING.getCode().equals(entity.getTsStatus())) {
                    if (APPROVED.getCode().equals(entity.getTsStatus())) {
                        // Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.TIME_SHEET_MANAGER.getCode()));
                        // if (!rolePermission) {
                        //     //审批通过但不是工时管理员
                        //     throw TwException.error("", "无操作工时高级撤回的权限！");
                        // }
                        // dib
                        // 工时已经审批的增加“取消审批”功能，
                        // 并且填写人、审批人、管理员都可以操作（需要使用配置形式开启确认是否能操作），
                        // 需要增加可取消撤回的截止日期配置，截止到该日期之前的工时不能取消撤回
                        boolean flag = false;

                        // 是否开启工时已经审批的增加“取消审批”功能
                        flag = getRevokedFlag(flag);
                        if (!flag) {
                            throw TwException.error("", "无操作工时高级撤回的权限！");
                        }
                        // int interval = 60;
                        // interval = getInterval(interval);
                        // LocalDate now = LocalDate.now();
                        LocalDate workDate = entity.getWorkDate();
                        // // 时间间隔
                        // if (ChronoUnit.DAYS.between(workDate, now) > interval) {
                        //     throw TwException.error("", "该工时已经超过" + interval + "天，不能撤回");
                        // }
                        LocalDate rejectedEndDate = getRejectedEndDate();
                        if (null != rejectedEndDate) {
                            log.info("TIMESHEET_APPROVED_REJECTED_END_DATE >>> rejectedEndDate:{}", rejectedEndDate);
                            if (DateUtil.differenceDays(workDate, rejectedEndDate) >= 0) {
                                throw TwException.error("", "该工时已经超过" + rejectedEndDate + "，不能撤回");
                            }
                        }
                    } else {
                        //即不等审批中也不等审批通过
                        throw TwException.error("", "只有审批通过的单据才允许撤回");
                    }
//                    }

                    // 更新pms任务信息
                    updatePmsTaskInfoByTimesheetEntity(entity, APPROVED_TO_CREATE);

                    entity.setTsStatus(CREATE.getCode());
                    entity.setApprUserId(null);
                    entity.setApprResult("审批撤回");
                    timesheetRepo.save(entity);
                }
            });

        }
    }

    /**
     * 是否开启工时校验预算当量、费用
     *
     * @param flag 旗帜
     * @return boolean
     */
    private boolean getCheckEqvaAmtFlag(boolean flag) {
        PrdSystemSettingVO systemSettingByKey = prdSystemSettingService.getSystemSettingByKey(SystemSettingEnum.TIMESHEET_SUBMIT_CHECK_EQVA_AMT_FLAG.getCode());
        if (systemSettingByKey != null) {
            String settingValue = systemSettingByKey.getSettingValue();
            if (StringUtils.hasText(settingValue)) {
                if (settingValue.equals("1")) {
                    flag = true;
                } else if (settingValue.equals("0")) {
                    flag = false;
                } else {
                    flag = false;
                }
            }
        }
        return flag;
    }

    /**
     * 获取允许工时撤回标记
     *
     * @param flag 旗帜
     * @return boolean
     */
    private boolean getRevokedFlag(boolean flag) {
        PrdSystemSettingVO systemSettingByKey = prdSystemSettingService.getSystemSettingByKey(SystemSettingEnum.TIMESHEET_APPROVED_REJECTED_FLAG.getCode());
        if (systemSettingByKey != null) {
            String settingValue = systemSettingByKey.getSettingValue();
            if (StringUtils.hasText(settingValue)) {
                if (settingValue.equals("1")) {
                    flag = true;
                } else if (settingValue.equals("2")) {
                    flag = false;
                }
            }
        }
        return flag;
    }

    /**
     * 获取间隔时间
     *
     * @param interval 间隔
     * @return int
     */
    private int getInterval(int interval) {
        PrdSystemSettingVO systemSettingByKeyInterval = prdSystemSettingService.getSystemSettingByKey(SystemSettingEnum.TIMESHEET_APPROVED_REJECTED_INTERVAL.getCode());
        if (systemSettingByKeyInterval != null) {
            String settingValue = systemSettingByKeyInterval.getSettingValue();
            if (StringUtils.hasText(settingValue)) {
                try {
                    interval = Integer.parseInt(settingValue);
                } catch (NumberFormatException ignored) {
                    log.error("系统设置项-【TIMESHEET_APPROVED_REJECTED_INTERVAL】配置有误，请检查");
                }
            }
        }
        return interval;
    }

    /**
     * 获取间隔时间
     *
     * @return int
     */
    private LocalDate getRejectedEndDate() {
        LocalDate endDate = null;
        PrdSystemSettingVO systemSettingByKeyInterval = prdSystemSettingService.getSystemSettingByKey(SystemSettingEnum.TIMESHEET_APPROVED_REJECTED_END_DATE.getCode());
        if (systemSettingByKeyInterval != null) {
            String settingValue = systemSettingByKeyInterval.getSettingValue();
            if (StringUtils.hasText(settingValue)) {
                try {
                    endDate = DateUtil.strToLocalDate(settingValue);
                } catch (NumberFormatException ignored) {
                    log.error("系统设置项-【TIMESHEET_APPROVED_REJECTED_END_DATE】配置有误，请检查");
                }
            }
        }
        return endDate;
    }


    /**
     * 生成请假工时
     */
    @Override
    public void generateVacationPrivateTimesheet(UserVacationApplyPayload applyPayload) {

//        UserVacationApplyVO applyVO = vacationApplyService.queryApplyByKey(String.valueOf(applyId));
        List<UserVacationApplyDetailPayload> applyDetailPayloadList = applyPayload.getApplyDetailPayloadList();
        List<UserVacationApplyDetailPayload> extapplyDetailPayloadList = applyPayload.getExtapplyDetailPayloadList();
        if (!CollectionUtils.isEmpty(extapplyDetailPayloadList)) {
            applyDetailPayloadList.addAll(extapplyDetailPayloadList);
        }
        for (UserVacationApplyDetailPayload detail : applyDetailPayloadList) {
            BigDecimal workHour = new BigDecimal(8).multiply(detail.getVDays()).setScale(2, RoundingMode.HALF_UP);
//            hadleTimesheetInsert(applyPayload, detail.getId(), detail.getVDate(), workHour, null, detail.getVInterval());
            hadleTimesheetInsert(applyPayload, detail, workHour);
        }
    }

    @Override
    @Transactional
    public void deleteVacationPrivateTimesheet(List<Long> applyDetailIds) {
        timesheetDAO.deleteByVacationApplyId(applyDetailIds);
    }

    @Override
    @Transactional
    public void updateVacationPrivateTimesheet(UserVacationApplyPayload applyPayload, Integer opertType) {
        List<Long> applyDetailIds = applyPayload.getApplyDetailPayloadList().stream().map(e -> e.getId()).collect(Collectors.toList());

        // List<TimesheetVO> collect = timesheetVOS.stream().filter(vo -> vo.getTaskId() != null).collect(Collectors.toList());
        if (opertType == 0) {
            timesheetDAO.deleteByVacationApplyId(applyDetailIds);
        }
        if (opertType == 1) {
            if (VacationTypeEnum.REWARD.getCode().equals(applyPayload.getVacationType())) {
                //查询奖励假对应的工时
                List<TimesheetVO> timesheetVOS = timesheetDAO.queryListByVactionIds(applyDetailIds);
                //处理奖励假工时
                handleVacationTask(applyPayload);
                List<TimesheetPayload> timesheetPayloads = new ArrayList<>();

                List<TaskInfoVO> taskInfoVOS = new ArrayList<>();

                applyPayload.getApplyDetailPayloadList().forEach(detailPayload -> {
                    TaskInfoVO taskInfoVO = applyPayload.getTaskInfoVOS().stream().filter(vo -> vo.getId().equals(detailPayload.getTaskId())).findFirst().get();
                    if (!taskInfoVOS.contains(taskInfoVO)) {
                        taskInfoVOS.add(taskInfoVO);
                    }
                    if (detailPayload.getId() != null) {
                        TimesheetVO timesheetVO = timesheetVOS.stream().filter(vo -> vo.getVacationApplyDetailId().equals(detailPayload.getId())).findFirst().get();
                        BigDecimal multiply = detailPayload.getVDays().multiply(BigDecimal.valueOf(8));
                        if (multiply.compareTo(timesheetVO.getWorkHour()) < 0) {
                            //说明是拆分的请假详情
                            timesheetVO.setWorkHour(multiply);
                            //copy一份新的工时
                            TimesheetVO timesheetVO0 = new TimesheetVO();
                            timesheetVO0.copy(timesheetVO);
                            timesheetVO0.setId(null);
                            timesheetVOS.add(timesheetVO0);
                        }
                        TimesheetPayload payload = TimesheetConvert.INSTANCE.toPayload(timesheetVO);
                        timesheetPayloads.add(payload);
                        //处理奖励假工时任务
                        handleVacationTaskTimesheet(taskInfoVO, payload);
                    }
                });
                Optional<UserVacationApplyDetailPayload> first = applyPayload.getApplyDetailPayloadList().stream().filter(detail -> detail.getId() == null).findFirst();
                if (first.isPresent()) {
                    //说明是拆分的请假详情
                    UserVacationApplyDetailPayload detailPayload = first.get();
                    TaskInfoVO taskInfoVO = applyPayload.getTaskInfoVOS().stream().filter(vo -> vo.getId().equals(detailPayload.getTaskId())).findFirst().get();
                    if (!taskInfoVOS.contains(taskInfoVO)) {
                        taskInfoVOS.add(taskInfoVO);
                    }
                    TimesheetVO timesheetVO = timesheetVOS.stream().filter(vo -> vo.getId() == null).findFirst().get();
                    BigDecimal multiply = detailPayload.getVDays().multiply(BigDecimal.valueOf(8));
                    timesheetVO.setWorkHour(multiply);
                    TimesheetPayload payload = TimesheetConvert.INSTANCE.toPayload(timesheetVO);
                    timesheetPayloads.add(payload);

                    //处理奖励假工时任务
                    handleVacationTaskTimesheet(taskInfoVO, payload);
                }

//                timesheetVOS.forEach(vo -> {
//                    TimesheetPayload payload = TimesheetConvert.INSTANCE.toPayload(vo);
//                    timesheetPayloads.add(payload);
//                    UserVacationApplyDetailPayload detail = applyPayload.getApplyDetailPayloadList().stream().filter(detailPayload -> vo.getVacationApplyDetailId().equals(detailPayload.getId())).findFirst().get();
//
//
//                    //处理奖励假工时任务
//                    handleVacationTaskTimesheet(applyPayload, detail, payload);
//                    //有效任务
//                    TaskInfoVO taskInfoVO1 = applyPayload.getTaskInfoVOS().stream().filter(taskInfoVO -> taskInfoVO.getId().equals(payload.getTaskId())).findFirst().get();
//                    if (!taskInfoVOS.contains(taskInfoVO1)) {
//                        taskInfoVOS.add(taskInfoVO1);
//                    }
//                });
                log.info("handleTaskSettle1:" + taskInfoVOS.size());
                //处理任务数据及结算数据
                handleTaskSettle(taskInfoVOS);
                //重新保存工时
                timesheetRepo.saveAll(TimesheetConvert.INSTANCE.toDoList(timesheetPayloads));
            } else {
                timesheetDAO.updateStatusByVacationApplyId(applyDetailIds);
            }


        }
    }

    /**
     * 处理任务数据及结算数据
     *
     * @param taskInfoVOS
     */
    void handleTaskSettle(List<TaskInfoVO> taskInfoVOS) {
        Map<Long, List<TaskInfoVO>> maps = taskInfoVOS.stream().collect(Collectors.groupingBy(TaskInfoVO::getTaskPackageId));
        TaskPackageVO taskPackageVO = taskPackageService.queryByKey(taskInfoVOS.get(0).getTaskPackageId(), null);
        List<TaskPackageVO> taskPackageVOS = Arrays.asList(taskPackageVO);
        //结算
        List<CalTaskSettleDetailPayload> detailPayloads = calTaskSettleService.taskAutoSettle(maps, taskPackageVOS, true);
        Map<Long, Long> taskSettleIdMap = new HashMap<>();
        detailPayloads.forEach(detailPayload -> {
            taskSettleIdMap.put(detailPayload.getTaskId(), detailPayload.getSettleId());
        });
        log.info("handleTaskSettle2:" + detailPayloads.size());
        taskInfoVOS.forEach(taskInfoVO -> {
            log.info("handleTaskSettle3:" + taskInfoVO.toString());
            TaskInfoPayload payload = new TaskInfoPayload();
            payload.setId(taskInfoVO.getId());
            payload.setUsedEqva(taskInfoVO.getUsedEqva());
            payload.setApprovedEqva(taskInfoVO.getApprovedEqva());
            payload.setSettledEqva(taskInfoVO.getApprovedEqva());
            if (taskInfoVO.getTotalEqva().compareTo(taskInfoVO.getApprovedEqva()) == 0) {
                payload.setTaskStatus(TaskStatusEnum.CLOSED.getCode());
            }
            taskInfoService.updateByKeyDynamic(payload);
        });
        //保存工时和任务的结算关系
        calTaskSettleService.saveTaskTaskSettleTimesheet(taskSettleIdMap);
    }

    /**
     * 处理奖励假工时
     *
     * @param timesheetEntity
     */
    void handleVacationTaskTimesheet(TaskInfoVO taskInfoVO, TimesheetPayload timesheetEntity) {
        timesheetEntity.setType("PROJ");
        if (taskInfoVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            timesheetEntity.setProjId(taskInfoVO.getReasonId());
            timesheetEntity.setProjName(taskInfoVO.getReasonName());
        } else {
            timesheetEntity.setProjId(0L);
            timesheetEntity.setProjName("无项目");
        }
        timesheetEntity.setTaskId(taskInfoVO.getId());
        timesheetEntity.setTaskNo(taskInfoVO.getTaskNo());
        timesheetEntity.setTaskName(taskInfoVO.getTaskName());
        timesheetEntity.setTaskPackageId(taskInfoVO.getTaskPackageId());
        timesheetEntity.setTaskPackageName(taskInfoVO.getTaskPackageName());
        timesheetEntity.setReasonId(taskInfoVO.getReasonId());
        timesheetEntity.setReasonName(taskInfoVO.getReasonName());
        timesheetEntity.setReasonType(taskInfoVO.getReasonType());
        timesheetEntity.setTsStatus("APPROVED");

        //重新赋值任务审批通过和使用当量
        BigDecimal divide = timesheetEntity.getWorkHour().divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);
        BigDecimal upEqva = divide.multiply(taskInfoVO.getEqvaRatio());
        BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
        BigDecimal newUsedEqva = usedEqva.add(upEqva);

        taskInfoVO.setUsedEqva(newUsedEqva);
        BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
        BigDecimal newApprovedEqva = approvedEqva.add(upEqva);
        if (newUsedEqva.compareTo(newApprovedEqva) < 0) {
            taskInfoVO.setUsedEqva(newApprovedEqva);
        }
        taskInfoVO.setApprovedEqva(newApprovedEqva);
        log.info("handleTaskSettle0:" + newUsedEqva + "/:" + newApprovedEqva);
    }

    /**
     * 处理奖励假任务问题
     *
     * @param payload
     */
    void handleVacationTask(UserVacationApplyPayload payload) {
        UserVacationVO userVacationVO = userVacationService.queryById(payload.getVacationId());
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setReasonType(userVacationVO.getReasonType());
        taskInfoQuery.setReasonId(userVacationVO.getReasonId());
        taskInfoQuery.setTaskResId(userVacationVO.getUserId());
        taskInfoQuery.setSourceType(TaskSourceTypeEnum.REWARD.getCode());
        taskInfoQuery.setTaskStatus(TaskStatusEnum.PENDING.getCode());
        List<TaskInfoVO> taskInfoVOS0 = taskInfoService.queryListCommon(taskInfoQuery);
        if (ObjectUtils.isEmpty(taskInfoVOS0)) {
            throw TwException.error("", "奖励假对应任务不存在");
        }
        taskInfoVOS0 = taskInfoVOS0.stream().filter(vo -> vo.getEffectiveEqva().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        BigDecimal eqvaRatio = taskInfoVOS0.get(0).getEqvaRatio();
        if (eqvaRatio == null) {
            BigDecimal eqvaRatio0 = prdOrgEmployeeEqvaRatioService.getEqvaRatio(userVacationVO.getUserId(), LocalDate.now());
            eqvaRatio = eqvaRatio0;
            taskInfoVOS0.forEach(infoVO -> infoVO.setEqvaRatio(eqvaRatio0));
        }

        //把任务放在请假申请中
        payload.setTaskInfoVOS(taskInfoVOS0);
        List<TaskInfoVO> taskInfoVOS = payload.getTaskInfoVOS();
        List<UserVacationApplyDetailPayload> applyDetailPayloadList = payload.getApplyDetailPayloadList();
        /**
         *
         * 1.如果是整天请假 取任务剩余当量>请假当量就行
         * 2.如果是半天
         *   2.1 任务剩余当量>请假当量
         *   2.2 优先选择剩余当量是当量系数基数倍的，否则再随便选
         *
         */
        final BigDecimal fianlEqvaRatio = eqvaRatio;
        applyDetailPayloadList.forEach(detail -> {
//            处理奖励假申请明细关联任务
            handleApplyDetail(detail, taskInfoVOS, fianlEqvaRatio);
        });
        Optional<UserVacationApplyDetailPayload> first = applyDetailPayloadList.stream().filter(detail -> detail.getTaskId() == null).findFirst();
        if (first.isPresent()) {
            //重新分解奖励假详情
            UserVacationApplyDetailPayload etailPayload = first.get();
            etailPayload.setVDays(etailPayload.getVDays().divide(BigDecimal.valueOf(2), 4, RoundingMode.DOWN));
            //重新分解奖励假详情
            handleApplyDetail(etailPayload, taskInfoVOS, fianlEqvaRatio);
            if (etailPayload.getTaskId() == null) {
                throw TwException.error("", "奖励假对应任务当量不足，请联系管理员");
            }
            UserVacationApplyDetailPayload etailPayload0 = new UserVacationApplyDetailPayload();
            etailPayload0.setId(null);
            etailPayload0.setApplyId(etailPayload.getApplyId());
            etailPayload0.setVMonth(etailPayload.getVMonth());
            etailPayload0.setVDate(etailPayload.getVDate());
            etailPayload0.setVDays(etailPayload.getVDays());
            //重新分解奖励假详情
            handleApplyDetail(etailPayload0, taskInfoVOS, fianlEqvaRatio);
            if (etailPayload.getTaskId() == null) {
                throw TwException.error("", "奖励假对应任务当量不足，请联系管理员");
            }
            applyDetailPayloadList.add(etailPayload0);
            payload.setApplyDetailPayloadList(applyDetailPayloadList);
        }


    }

    /**
     * 处理奖励假申请明细关联任务
     *
     * @param detail
     * @param taskInfoVOS
     * @param fianlEqvaRatio
     */
    void handleApplyDetail(UserVacationApplyDetailPayload detail, List<TaskInfoVO> taskInfoVOS, BigDecimal fianlEqvaRatio) {
        //请假明细当量
        TaskInfoVO taskInfoVO = null;
        BigDecimal applyEqva = detail.getVDays().multiply(fianlEqvaRatio);
        if (detail.getVDays().compareTo(BigDecimal.ONE) == 0) {
            //1.如果是整天请假 取任务剩余当量>请假当量就行
            Optional<TaskInfoVO> first = taskInfoVOS.stream().filter(infoVO -> infoVO.getEffectiveEqva().compareTo(applyEqva) >= 0).findFirst();
            if (first.isPresent()) {
                taskInfoVO = first.get();
            }
            //   taskInfoVO = taskInfoVOS.stream().filter(infoVO -> infoVO.getEffectiveEqva().compareTo(applyEqva) >= 0).findFirst().get();

        } else {
            //2.剩余当量足够，并且+申请假期是当量系数的整数倍
            Optional<TaskInfoVO> first = taskInfoVOS.stream().filter(infoVO ->
                    (infoVO.getEffectiveEqva().add(applyEqva)).compareTo(fianlEqvaRatio) >= 0 && ((infoVO.getEffectiveEqva().add(applyEqva)).divide(fianlEqvaRatio)).stripTrailingZeros().scale() <= 0
            ).findFirst();
            if (first.isPresent()) {
                taskInfoVO = first.get();
            } else {
                Optional<TaskInfoVO> first1 = taskInfoVOS.stream().filter(infoVO -> infoVO.getEffectiveEqva().compareTo(applyEqva) >= 0).findFirst();
                if (first1.isPresent()) {
                    taskInfoVO = first1.get();
                } else {
                    throw TwException.error("", "奖励假对应任务当量不足，请联系管理员");
                }
            }
        }
        detail.setTaskId(null);
        if (taskInfoVO != null) {
            //重新赋值剩余当量
            taskInfoVO.setEffectiveEqva(taskInfoVO.getEffectiveEqva().subtract(applyEqva));
            detail.setTaskId(taskInfoVO.getId());
        }
    }

    /**
     * 请假自动插入工时
     *
     * @param applyPayload 假期对象
     * @param workHour     工时小时数
     */
    @Transactional(rollbackFor = Exception.class)
    public void hadleTimesheetInsert(UserVacationApplyPayload applyPayload, UserVacationApplyDetailPayload detail, BigDecimal workHour) {
        TimesheetPayload timesheetEntity = new TimesheetPayload();
        timesheetEntity.setTsUserId(applyPayload.getUserId());
        //timesheetEntity.setTsStatus("APPROVED");
        timesheetEntity.setTsStatus(APPROVING.getCode());
        timesheetEntity.setWorkDate(detail.getVDate());
        timesheetEntity.setApprUserId(1381L);
        timesheetEntity.setSubmitTime(applyPayload.getCreateTime());
        timesheetEntity.setLastSubmitTime(applyPayload.getCreateTime());
        timesheetEntity.setApprovalTime(LocalDateTime.now());
        //BigDecimal workHour1 = new BigDecimal(8);
        //  获取当前用户的组织信息
        final List<PrdOrgDataRefVO> prdOrgDataRefVOS = daoUser.queryOrgListByKey(applyPayload.getUserId());
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS)) {
            final List<PrdOrgDataRefVO> refList = prdOrgDataRefVOS.stream()
                    .filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(refList)) {
                final Long orgId = refList.get(0).getOrgId();
                final String orgName = refList.get(0).getOrgName();
                timesheetEntity.setTsUserBuId(orgId);
                timesheetEntity.setTsUserBuName(orgName);
            }
        }
        timesheetEntity.setWorkHour(workHour);
        timesheetEntity.setWorkDesc("请假流程自动填写");
        int weekBaseYear = timesheetEntity.getWorkDate().get(WeekFields.ISO.weekBasedYear());//2018-12-31 返回2019
        int weeks = timesheetEntity.getWorkDate().get(WeekFields.ISO.weekOfWeekBasedYear());
        String week = weeks < 10 ? "0" + weeks : weeks + "";
        String yearWeek = weekBaseYear + week;
        timesheetEntity.setWeekStartDate(timesheetEntity.getWorkDate().with(DayOfWeek.MONDAY));
        timesheetEntity.setYearWeek(Integer.parseInt(yearWeek));
        timesheetEntity.setAutoSaveFlag(1);
        //timesheetEntity.setRemark("请假自动生成工时");
        timesheetEntity.setProjId(0L);//设置项目为无项目1
        timesheetEntity.setProjName("无项目");
        timesheetEntity.setReasonId(0L);
        timesheetEntity.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
        timesheetEntity.setReasonName("无项目");
//        timesheetEntity.setApprUserId(0L);//设置审批人
        timesheetEntity.setApprResult("审批通过");

        // 默认活动为假期类型
        timesheetEntity.setTsActIden(applyPayload.getVacationType());
        // 病假	SICK
        if (VacationTypeEnum.SICK.getCode().equals(applyPayload.getVacationType())) {
            // 病假	SICKLEAVE
            timesheetEntity.setTsActIden("SICKLEAVE");
        }
        if (VacationTypeEnum.IN_LIEU.getCode().equals(applyPayload.getVacationType())) {
            // 调休	SHIFTING
            timesheetEntity.setTsActIden("SHIFTING");
        }
        if (VacationTypeEnum.REWARD.getCode().equals(applyPayload.getVacationType())) {
            //奖励假 REWARDLEAVE
            timesheetEntity.setTsActIden("REWARDLEAVE");
//            //处理奖励假工时任务
//            handleVacationTaskTimesheet(applyPayload, detail, timesheetEntity);
        }
        timesheetEntity.setTsTaskIden("VACATION");
        timesheetEntity.setSettleStatus("NONE");
        timesheetEntity.setProcId(applyPayload.getProcInstId());
        timesheetEntity.setVacationApplyDetailId(detail.getId());
        timesheetEntity.setReturnFlag(false);
//        timesheetEntity.setVInterval(vInterval);
        timesheetRepo.save(TimesheetConvert.INSTANCE.toDo(timesheetEntity));

        //注释原因：这个list传参固定值是null，不知道业务逻辑
        // 针对存在已填写记录的工时处理
        // 先备份已填写的数据 到一个临时表  5  2  1
        // 修改已填写的数据 工时数据  已填写工时8-请假工时4= 修改后的工时4（4怎么分配）
//        if (!CollectionUtils.isEmpty(list)) {
//            AtomicReference<BigDecimal> tempWorkHour = new AtomicReference<>(workHour);
//            List<TimesheetPayload> updateList = new ArrayList<>();
//            list.forEach(twTimesheetListView -> {
//                TimesheetPayload entityTemp = new TimesheetPayload();
//                TimesheetPayload updateEntity = new TimesheetPayload();
//                BeanUtils.copyProperties(twTimesheetListView, entityTemp);
//                BeanUtils.copyProperties(twTimesheetListView, updateEntity);
//                // 请假工时 减完以后 就跳过
//                if (tempWorkHour.get().compareTo(BigDecimal.ZERO) > 0) {
//                    // 左(已填工时数)>=右（请教工时数）
//                    if (updateEntity.getWorkHour().compareTo(tempWorkHour.get()) > -1) {
//                        // 5-4 = 1
//                        final BigDecimal subtract = updateEntity.getWorkHour().subtract(tempWorkHour.get());
//                        // 结果大于等于0的话
//                        updateEntity.setWorkHour(subtract);
//                    } else {
//                        updateEntity.setWorkHour(BigDecimal.ZERO);
//                    }
//                }
//                updateEntity.setAutoSaveFlag(1);
//                updateEntity.setProcId(applyPayload.getProcInstId());
//                updateEntity.setAutoUpdateFlag(1);
//                updateList.add(updateEntity);
//            });
//            //修改已填写的数据 工时数据  已填写工时8-请假工时4= 修改后的工时4（2怎么分配）
//            if (!CollectionUtils.isEmpty(updateList)) {
//                updateList.forEach(twTimesheetEntity -> {
//                    update(twTimesheetEntity);
//                });
//            }
//        }
    }


    @Override
    public PagingVO monthlyPaging(MonthlyTimesheetQuery query) {
        List<Object[]> objects = timesheetRepo.queryMonthlyTimesheetVO(query);
        // 计算分页偏移量
        int offset = (query.getSize() - 1) * query.getCurrent();
        // 手动分页
        List<Object[]> pageObjects = objects.stream()
                .skip(offset) // 跳过前offset个元素
                .limit(query.getSize()).toList();
        List<MonthlyTimesheetVO> monthlyTimesheetVOS = this.monthlyTimesheetMap(pageObjects);
        return PagingVO.<MonthlyTimesheetVO>builder().records(monthlyTimesheetVOS).total(objects.size()).build();
    }

    @Override
    public void monthlySyncToJDE(MonthlyTimesheetQuery query) {
        List<Object[]> objects = timesheetRepo.queryMonthlyTimesheetVO(query);
        String jdeFileName = "";
        if (!ObjectUtils.isEmpty(query.getWorkDateStart()) && !ObjectUtils.isEmpty(query.getWorkDateEnd())) {
            jdeFileName = query.getWorkDateStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
        }
        // TW文件格式
        List<MonthlyTimesheetVO> monthlyTimesheetVOS = this.monthlyTimesheetMap(objects);
        // JDE文件格式
        List<JDEMonthlyTimesheetVO> jdeMonthlyTimesheetVOS = monthlyTimesheetMapToJDE(monthlyTimesheetVOS);
        try {
            // 将jde文件上传到某个服务器
            JDEMonthlyTimesheetExport(jdeMonthlyTimesheetVOS, jdeFileName);
        } catch (Exception e) {
            e.printStackTrace();
            throw TwException.error("", "生成月度员工工时统计表失败，请联系管理员");
        }
    }

    @Override
    public void monthlyExport(MonthlyTimesheetQuery query, HttpServletResponse response) {
        List<Object[]> objects = timesheetRepo.queryMonthlyTimesheetVO(query);
        // 文件名称
        StringBuilder fileName = new StringBuilder("月度员工工时统计表（财务）");
        if (!ObjectUtils.isEmpty(query.getWorkDateStart()) && !ObjectUtils.isEmpty(query.getWorkDateEnd())) {
            fileName.append("-").append(query.getWorkDateStart()).append("-").append(query.getWorkDateEnd());
        }
        // TW文件格式
        List<MonthlyTimesheetVO> monthlyTimesheetVOS = this.monthlyTimesheetMap(objects);
        try {
            // 将TW文件导出
            monthlyTimesheetImport(monthlyTimesheetVOS, response, fileName.toString());
        } catch (Exception e) {
            e.printStackTrace();
            throw TwException.error("", "导出月度员工工时统计表失败，请联系管理员");
        }
    }

    @Override
    public List<TimesheetVO> queryDaoList(TimesheetQuery query) {
        return timesheetDAO.queryList(query);
    }

    @Override
    public List<PmsTimesheetProjectVO> listProject(Long userId, Boolean selectAll) {
        List<PmsTimesheetProjectVO> resultList = new ArrayList<>();
        // 交付项目
        List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryListByProjectMember(userId, selectAll);
        List<PmsTimesheetProjectVO> projectList = pmsProjectVOS.stream().map(pmsProjectVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(pmsProjectVO.getId());
            pmsTimesheetProjectVO.setReasonName(pmsProjectVO.getProjName());
            pmsTimesheetProjectVO.setReasonNo(pmsProjectVO.getProjNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(projectList);

        // 商机项目
        List<CrmOpportunityVO> oppoProject = crmOpportunityService.findByMemberIdIdEq(userId);
        List<PmsTimesheetProjectVO> oppoProjectList = oppoProject.stream().map(opportunityVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(opportunityVO.getProjectId());
            pmsTimesheetProjectVO.setReasonName(opportunityVO.getProjectName());
            pmsTimesheetProjectVO.setReasonNo(opportunityVO.getProjectNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_OPPO.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(oppoProjectList);

        // BU项目
        BuProjectQuery buProjectQuery = new BuProjectQuery();
        List<BuProjectVO> buProjectVOS = buProjectService.listByMember(buProjectQuery);
        List<PmsTimesheetProjectVO> buProjectList = buProjectVOS.stream().map(buProjectVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(buProjectVO.getId());
            pmsTimesheetProjectVO.setReasonName(buProjectVO.getProjName());
            pmsTimesheetProjectVO.setReasonNo(buProjectVO.getProjNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_BU.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(buProjectList);

        return resultList;
    }

    @Override
    public List<PmsTimesheetProjectVO> listAllProject() {
        List<PmsTimesheetProjectVO> resultList = new ArrayList<>();
        // 交付项目
        List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryListByReasonIdList(null);
        List<PmsTimesheetProjectVO> projectList = pmsProjectVOS.stream().map(pmsProjectVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(pmsProjectVO.getId());
            pmsTimesheetProjectVO.setReasonName(pmsProjectVO.getProjName());
            pmsTimesheetProjectVO.setReasonNo(pmsProjectVO.getProjNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(projectList);

        // 商机项目
        CrmOpportunityQuery opportunityQuery = new CrmOpportunityQuery();
        List<CrmOpportunityListVO> oppoProject = crmOpportunityService.querySimpleList(opportunityQuery);
        List<PmsTimesheetProjectVO> oppoProjectList = oppoProject.stream().map(opportunityVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(opportunityVO.getProjectId());
            pmsTimesheetProjectVO.setReasonName(opportunityVO.getProjectName());
            pmsTimesheetProjectVO.setReasonNo(opportunityVO.getProjectNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_OPPO.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(oppoProjectList);

        // BU项目
        BuProjectQuery buProjectQuery = new BuProjectQuery();
        List<BuProjectVO> buProjectVOS = buProjectService.queryListDynamicSimple(buProjectQuery);
        List<PmsTimesheetProjectVO> buProjectList = buProjectVOS.stream().map(buProjectVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(buProjectVO.getId());
            pmsTimesheetProjectVO.setReasonName(buProjectVO.getProjName());
            pmsTimesheetProjectVO.setReasonNo(buProjectVO.getProjNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_BU.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(buProjectList);

        return resultList;
    }

    /**
     * 月度员工工时数据映射
     */
    private List<MonthlyTimesheetVO> monthlyTimesheetMap(List<Object[]> objectResultList) {
        List<MonthlyTimesheetVO> monthlyTimesheetVOList = new ArrayList<>();
        objectResultList.forEach(object -> {
            MonthlyTimesheetVO monthlyTimesheetVO = new MonthlyTimesheetVO();
            Optional.ofNullable(object[0]).ifPresent(s -> monthlyTimesheetVO.setPrjAscriptionOuNO(s.toString()));
            Optional.ofNullable(object[1]).ifPresent(s -> monthlyTimesheetVO.setResAscriptionOuNO(s.toString()));
            Optional.ofNullable(object[2]).ifPresent(s -> monthlyTimesheetVO.setYear(s.toString()));
            Optional.ofNullable(object[3]).ifPresent(s -> monthlyTimesheetVO.setMonthly(s.toString()));
            Optional.ofNullable(object[4]).ifPresent(s -> monthlyTimesheetVO.setResNo(s.toString()));
            Optional.ofNullable(object[5]).ifPresent(s -> monthlyTimesheetVO.setResBu(s.toString()));
            Optional.ofNullable(object[6]).ifPresent(s -> monthlyTimesheetVO.setEmployeeName(s.toString()));
            Optional.ofNullable(object[7]).ifPresent(s -> monthlyTimesheetVO.setRefContractNo(s.toString()));
            Optional.ofNullable(object[8]).ifPresent(s -> monthlyTimesheetVO.setPrjName(s.toString()));
            Optional.ofNullable(object[9]).ifPresent(s -> monthlyTimesheetVO.setDeliverBu(s.toString()));
            Optional.ofNullable(object[10]).ifPresent(s -> monthlyTimesheetVO.setContractNo(s.toString()));
            Optional.ofNullable(object[11]).ifPresent(s -> monthlyTimesheetVO.setDays((BigDecimal) s));
            Optional.ofNullable(object[12]).ifPresent(s -> monthlyTimesheetVO.setEqvaRatio((BigDecimal) s));
            Optional.ofNullable(object[13]).ifPresent(s -> monthlyTimesheetVO.setSettleEqva((BigDecimal) s));
            Optional.ofNullable(object[14]).ifPresent(s -> monthlyTimesheetVO.setProductNo(s.toString()));
            Optional.ofNullable(object[15]).ifPresent(s -> monthlyTimesheetVO.setPjType(s.toString()));
            Optional.ofNullable(object[16]).ifPresent(s -> monthlyTimesheetVO.setPjType1(s.toString()));
            monthlyTimesheetVOList.add(monthlyTimesheetVO);
        });
        return monthlyTimesheetVOList;
    }

    /**
     * 将月度员工工时数据映射成JDE文件格式
     *
     * @param monthlyTimesheetVOS 月度员工工时数据
     * @return result
     */
    private List<JDEMonthlyTimesheetVO> monthlyTimesheetMapToJDE(List<MonthlyTimesheetVO> monthlyTimesheetVOS) {
        return monthlyTimesheetVOS.stream()
                .map(monthlyVO -> {
                    JDEMonthlyTimesheetVO baseVO = new JDEMonthlyTimesheetVO();
                    BeanUtils.copyProperties(monthlyVO, baseVO);
                    return baseVO;
                }).toList();
    }

    /**
     * 导出月度员工工时统计EXCEL
     *
     * @param monthlyTimesheetVOS 数据
     * @param response            响应
     * @param fileName            文件名
     * @throws Exception
     */
    private void monthlyTimesheetImport(List<MonthlyTimesheetVO> monthlyTimesheetVOS, HttpServletResponse response, String fileName) throws Exception {
        if (!CollectionUtils.isEmpty(monthlyTimesheetVOS)) {
            ClassPathResource classPathResource = new ClassPathResource("template/monthlyTimesheet.xlsx");
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            // 月度工时统计Sheet页
            monthlyTimesheetSheet(monthlyTimesheetVOS, workbook);
            // 汇总页
            monthlyTimesheetSummarySheet(monthlyTimesheetVOS, workbook);
            // 执行所有公式
            workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
            com.elitesland.tw.tw5.server.common.ExcelUtil.writeResponse(response, fileName, workbook);
        }
    }

    /**
     * 上传
     *
     * @param jdeMonthlyTimesheetVOS 数据
     * @param fileName               文件名称
     */
    private void JDEMonthlyTimesheetExport(List<JDEMonthlyTimesheetVO> jdeMonthlyTimesheetVOS, String fileName) {
//        ExcelWriterSheetBuilder sheet = EasyExcel.write("/upload/" + fileName + ".csv", JDEMonthlyTimesheetVO.class)
//                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
//                .sheet("月度员工工时统计");
//        // 列
//        ExcelUtil.excelHelper(sheet, JDEMonthlyTimesheetVO.class, null);
//        //写入
//        sheet.doWrite(jdeMonthlyTimesheetVOS);
        String filePath = "/upload/" + fileName + ".csv";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath))) {
            // 写入 CSV 文件的表头
            writer.write("年度,期间,项目成本中心,REP项目编号,员工编号,实际工作期间的天数,当量系数,结算当量,工时类型");
            writer.newLine();
            // 写入对象列表中的每个对象
            for (JDEMonthlyTimesheetVO jdeMonthlyTimesheetVO : jdeMonthlyTimesheetVOS) {
                // 逐个写入属性值
                writePropertyValue(writer, jdeMonthlyTimesheetVO.getYear());
                writePropertyValue(writer, jdeMonthlyTimesheetVO.getMonthly());
                writePropertyValue(writer, jdeMonthlyTimesheetVO.getRefContractNo());
                writePropertyValue(writer, jdeMonthlyTimesheetVO.getContractNo());
                writePropertyValue(writer, jdeMonthlyTimesheetVO.getResNo());
                writePropertyValue(writer, jdeMonthlyTimesheetVO.getDays());
                writePropertyValue(writer, jdeMonthlyTimesheetVO.getEqvaRatio());
                writePropertyValue(writer, jdeMonthlyTimesheetVO.getSettleEqva());
                writer.write(jdeMonthlyTimesheetVO.getPjType1() != null ? jdeMonthlyTimesheetVO.getPjType1() : "");
                writer.newLine(); // 写入换行符
            }
        } catch (IOException ignored) {
            throw TwException.error("", "生成月度员工工时统计表失败，请联系管理员");
        }
    }

    // 写入属性值的通用方法
    private static void writePropertyValue(BufferedWriter writer, Object value) throws IOException {
        value = value == null ? "" : value;
        writer.write(value.toString());
        writer.write(",");
    }

    /**
     * 月度员工公式统计sheet页
     *
     * @param monthlyTimesheetVOS 数据
     * @param workbook            excel
     */
    private void monthlyTimesheetSheet(List<MonthlyTimesheetVO> monthlyTimesheetVOS, Workbook workbook) {
        XSSFSheet monthlyTimesheetSheet = (XSSFSheet) workbook.getSheet("月度员工工时统计");
        // 奇数行格式
        CellStyle oddCellStyle = this.commonCreateCellStyle(workbook);
        oddCellStyle.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.getIndex());
        // 偶数行格式
        CellStyle evenCellStyle = this.commonCreateCellStyle(workbook);
        evenCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        if (monthlyTimesheetSheet != null) {
            int nextRow = 1;
            for (MonthlyTimesheetVO monthlyTimesheetVO : monthlyTimesheetVOS) {
                Row row = monthlyTimesheetSheet.createRow(nextRow);
                // 设置行高
                row.setHeightInPoints((float) 22.65);
                CellStyle cellStyle = nextRow % 2 == 0 ? evenCellStyle : oddCellStyle;
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 0, nextRow);       // 序号
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 1, monthlyTimesheetVO.getPrjAscriptionOuNO());  // 项目归属公司号
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 2, monthlyTimesheetVO.getResAscriptionOuNO());  // 资源归属公司号
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 3, monthlyTimesheetVO.getYear());     // 年度
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 4, monthlyTimesheetVO.getMonthly());  // 月度
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 5, monthlyTimesheetVO.getResNo());    // 员工编号
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 6, monthlyTimesheetVO.getEmployeeName()); // 姓名
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 7, monthlyTimesheetVO.getDays());     // 天数
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 8, monthlyTimesheetVO.getResBu());    // 资源BU
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 9, monthlyTimesheetVO.getRefContractNo());        // 参考合同号
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 10, monthlyTimesheetVO.getPrjName());    // 项目名称
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 11, monthlyTimesheetVO.getDeliverBu());  // 交付BU
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 12, monthlyTimesheetVO.getPjType1());    // 项目属性
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 13, monthlyTimesheetVO.getContractNo()); // 合同号
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 14, monthlyTimesheetVO.getEqvaRatio());  // 当量系数
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 15, monthlyTimesheetVO.getSettleEqva()); // 结算当量
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 16, monthlyTimesheetVO.getProductNo());  // 产品编号
                twExcelUtil.setCellValueAndStyle(row, cellStyle, 17, monthlyTimesheetVO.getPjType());  // 类型
                nextRow++;
            }
            // 设置最后一行合计
            Row sumRow = monthlyTimesheetSheet.createRow(nextRow);
            twExcelUtil.setCellValue(sumRow, 0, "合计：");
            Cell sumCell7 = sumRow.createCell(7);   // 总天数
            sumCell7.setCellFormula("SUM(H2:H" + nextRow + ")"); // 设置单元格公式
            Cell sumCell15 = sumRow.createCell(15);   // 总当量
            sumCell15.setCellFormula("SUM(P2:P" + nextRow + ")");
        }
    }

    /**
     * 汇总页
     *
     * @param monthlyTimesheetVOS 数据
     * @param workbook            excel
     */
    private void monthlyTimesheetSummarySheet(List<MonthlyTimesheetVO> monthlyTimesheetVOS, Workbook workbook) {
        XSSFSheet monthlyTimesheetSummarySheet = (XSSFSheet) workbook.getSheet("汇总");
        AtomicInteger nextRow = new AtomicInteger(1);
        // 奇数行格式
        CellStyle oddCellStyle = this.commonCreateCellStyle(workbook);
        oddCellStyle.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.getIndex());
        // 偶数行格式
        CellStyle evenCellStyle = this.commonCreateCellStyle(workbook);
        evenCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        Map<String, List<MonthlyTimesheetVO>> monthlyTimesheetMap = monthlyTimesheetVOS.stream()
                .filter(Objects::nonNull)
                .collect(Collectors.groupingBy(
                        monthlyTimesheet -> monthlyTimesheet.getResNo() + monthlyTimesheet.getEmployeeName()
                ));
        monthlyTimesheetMap.forEach((resNoAndEmployeeName, timesheetVOS) -> {
            Row row = monthlyTimesheetSummarySheet.createRow(nextRow.get());
            // 设置行高
            row.setHeightInPoints((float) 22.65);
            CellStyle cellStyle = nextRow.get() % 2 == 0 ? evenCellStyle : oddCellStyle;
            BigDecimal days = BigDecimal.ZERO;  // 天数
            BigDecimal settleEqva = BigDecimal.ZERO;
            for (MonthlyTimesheetVO monthlyTimesheetVO : timesheetVOS) {
                days = days.add(monthlyTimesheetVO.getDays() == null ? BigDecimal.ZERO : monthlyTimesheetVO.getDays());
                settleEqva = settleEqva.add(monthlyTimesheetVO.getSettleEqva() == null ? BigDecimal.ZERO : monthlyTimesheetVO.getSettleEqva());
            }
            MonthlyTimesheetVO monthlyTimesheetVO = timesheetVOS.get(0);
            twExcelUtil.setCellValueAndStyle(row, cellStyle, 0, nextRow);    // 序号
            twExcelUtil.setCellValueAndStyle(row, cellStyle, 1, monthlyTimesheetVO.getResNo());      // 员工编号
            twExcelUtil.setCellValueAndStyle(row, cellStyle, 2, monthlyTimesheetVO.getEmployeeName());  // 姓名
            twExcelUtil.setCellValueAndStyle(row, cellStyle, 3, days);  // 天数
            twExcelUtil.setCellValueAndStyle(row, cellStyle, 4, monthlyTimesheetVO.getResBu());  // 资源BU
            twExcelUtil.setCellValueAndStyle(row, cellStyle, 5, monthlyTimesheetVO.getEqvaRatio());  // 当量系数
            twExcelUtil.setCellValueAndStyle(row, cellStyle, 6, settleEqva);  // 结算当量
            nextRow.getAndIncrement();
        });
        // 设置最后一行合计
        Row sumRow = monthlyTimesheetSummarySheet.createRow(nextRow.get());
        twExcelUtil.setCellValue(sumRow, 0, "合计：");
        Cell sumCell3 = sumRow.createCell(3);   // 总天数
        sumCell3.setCellFormula("SUM(D2:D" + nextRow + ")"); // 设置单元格公式
        Cell sumCell6 = sumRow.createCell(6);   // 总当量
        sumCell6.setCellFormula("SUM(G2:g" + nextRow + ")");
    }

    /**
     * 设置公共样式
     */
    private CellStyle commonCreateCellStyle(Workbook workbook) {
        // 设置样式
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short) 9);
        font.setFontName("SimSun");
        style.setFont(font);//增加字体样式
        style.setAlignment(HorizontalAlignment.CENTER);//增加水平居中样式
        style.setVerticalAlignment(VerticalAlignment.CENTER);//增加垂直居中样式
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND); //必须设置 否则背景色不生效
        style.setWrapText(true); // 启用自动换行
        // 顶边栏
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        // 右边栏
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        // 底边栏
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        // 左边栏
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        return style;
    }

}
