package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeEqvaRatioDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeEqvaRatioDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author zoey
 * @Description:当量系数管理
 * @date 2023/6/2 - 13:31
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgEmployeeEqvaRatioServiceImpl implements PrdOrgEmployeeEqvaRatioService {

    private final PrdOrgEmployeeEqvaRatioDAO eqvaRatioDAO;
    private final PrdOrgEmployeeDAO employeeDAO;

    @Override
    public BigDecimal getEqvaRatio(Long userId, LocalDate date) {
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
        if ((date == null || date.isAfter(LocalDate.now())) && !ObjectUtils.isEmpty(prdOrgEmployeeRefVO)) {
            return prdOrgEmployeeRefVO.getEqvaRatio();
        }
        BigDecimal eqvaRatioDefaultZero = getEqvaRatioDefaultZero(userId, date);
        if (eqvaRatioDefaultZero.compareTo(BigDecimal.ZERO) < 1) {
            throw TwException.error("", "用户" + prdOrgEmployeeRefVO.getEmployeeName() + "日期" + date + "当量系数查询失败");
        } else if (eqvaRatioDefaultZero.equals(BigDecimal.valueOf(100))) {
            if (ObjectUtils.isEmpty(prdOrgEmployeeRefVO)) {
                throw TwException.error("", "用户" + userId.toString() + "日期" + date + "当量系数查询失败");
            }
            return prdOrgEmployeeRefVO.getEqvaRatio();
        }
        return eqvaRatioDefaultZero;
    }

    @Override
    public BigDecimal getEqvaRatioDefaultZero(Long userId, LocalDate date) {

        List<PrdOrgEmployeeEqvaRatioVO> eqvaRatioList = eqvaRatioDAO.getEqvaRatioList(userId, null);
        List<PrdOrgEmployeeEqvaRatioVO> tempList = new ArrayList<>();
        // 用逻辑来处理时间
        for (PrdOrgEmployeeEqvaRatioVO prdOrgEmployeeEqvaRatioVO : eqvaRatioList) {
            if (prdOrgEmployeeEqvaRatioVO.getStartDate().isAfter(date)) {
                continue;
            } else {
                if (prdOrgEmployeeEqvaRatioVO.getEndDate() != null) {
                    if (prdOrgEmployeeEqvaRatioVO.getEndDate().isBefore(date)) {
                        continue;
                    } else {
                        tempList.add(prdOrgEmployeeEqvaRatioVO);
                    }
                } else {
                    tempList.add(prdOrgEmployeeEqvaRatioVO);
                }
            }
        }
        //对符合要求的当量系数再次筛选
        Collections.sort(tempList);
        if (!tempList.isEmpty()) {
            return tempList.get(0).getEqvaRatio();
        } else {
            // throw TwException.error("", "用户" + prdOrgEmployeeRefVO.getEmployeeName() + "日期" + date + "当量系数查询失败");
            return BigDecimal.valueOf(100);//代表没取到
        }
    }

    @Override
    public List<PrdOrgEmployeeEqvaRatioVO> getEqvaRatioListByDate(PrdOrgEmployeeEqvaRatioQuery query) {
        return eqvaRatioDAO.getEqvaRatioListByDate(query);
    }

//    @Override
//    @Transactional
//    public void batchUpsert(PrdOrgEmployeeGradePayload payload) {
//        for (Long userId : payload.getUserIds()) {
//            //修改员工数据
//            PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
//            employeePayload.setUserId(userId);
//            employeePayload.setExtString1(payload.getProfessionalGrade());
//            employeePayload.setExtString2(payload.getManageGrade());
//            employeePayload.setExtString3(payload.getProfessionalType());
//            employeePayload.setExtString4(payload.getJobType());
//            BigDecimal eqvaRatio = BigDecimal.valueOf(Objects.requireNonNull(TwJobGradeEnum.getTwJobGradeEnum(payload.getProfessionalGrade())).getEqva());
//            employeePayload.setEqvaRatio(eqvaRatio);
//            employeeDAO.updateByUserId(employeePayload);
////            //修改之前当量记录结束时间
//            eqvaRatioDAO.updateEqvaDate(userId, LocalDate.now().minusDays(1));
//            //保存当量系数变更记录
//            PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO = new PrdOrgEmployeeEqvaRatioDO();
//            employeeEqvaRatioDO.setUserId(userId);
//            employeeEqvaRatioDO.setEqvaRatio(eqvaRatio);
//            employeeEqvaRatioDO.setStartDate(LocalDate.now());
//            eqvaRatioDAO.saveGrade(employeeEqvaRatioDO);
//        }
//    }

    @Override
    public void upsertEqvaRatio(PrdOrgEmployeeEqvaRatioPayload payload) {
//            //修改之前当量记录结束时间
        eqvaRatioDAO.updateEqvaDate(payload.getUserId(), payload.getStartDate().minusDays(1));
        //保存当量系数变更记录
        PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO = new PrdOrgEmployeeEqvaRatioDO();
        employeeEqvaRatioDO.setUserId(payload.getUserId());
        employeeEqvaRatioDO.setEqvaRatio(payload.getEqvaRatio());
        employeeEqvaRatioDO.setStartDate(payload.getStartDate());
        employeeEqvaRatioDO.setEndDate(payload.getEndDate());
        eqvaRatioDAO.saveGrade(employeeEqvaRatioDO);
    }

}
