package com.elitesland.tw.tw5.server.prd.partner.identity.controller;

import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务伙伴-供应商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴-供应商信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessSupplierInfo")
@Slf4j
public class BusinessSupplierInfoController {

    private final BusinessSupplierInfoService businessSupplierInfoService;

    /**
     * 业务伙伴-供应商信息-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务伙伴-供应商信息-新增")
    public TwOutputUtil insert(@RequestBody BusinessSupplierInfoPayload payload){
        return TwOutputUtil.ok(businessSupplierInfoService.insert(payload));
    }

    /**
     * 业务伙伴-供应商信息-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务伙伴-供应商信息-更新")
    public TwOutputUtil update(@RequestBody BusinessSupplierInfoPayload payload){
        return TwOutputUtil.ok(businessSupplierInfoService.update(payload));
    }

//    /**
//     * 业务伙伴-供应商信息-主键查询 暂且没用 需要可放开
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("业务伙伴-供应商信息-主键查询")
//    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(businessSupplierInfoService.queryByKey(key));
//    }

//    /**
//     * 业务伙伴-供应商信息-分页 暂且没用 需要可放开
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("业务伙伴-供应商信息-分页")
//    public TwOutputUtil paging(BusinessSupplierInfoQuery query) {
//        return TwOutputUtil.ok(businessSupplierInfoService.queryPaging(query));
//    }

    /**
     * 业务伙伴-供应商信息-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴-供应商信息-查询列表")
    public TwOutputUtil<List<BusinessSupplierInfoVO>> queryList(BusinessSupplierInfoQuery query) {
        return TwOutputUtil.ok(businessSupplierInfoService.queryListDynamic(query));
    }

    /**
     * 业务伙伴-供应商信息-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴-供应商信息-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessSupplierInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
    /**
     * 业务伙伴-供应商信息-供应商状态修改
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/activeSupplier")
    @ApiOperation("业务伙伴-供应商信息-供应商状态修改")
    public TwOutputUtil activeSupplier(Long partnerId,String partnerName,String supplierStatus){
        businessSupplierInfoService.updateSupplierStatus(partnerId,partnerName,supplierStatus);
        return TwOutputUtil.ok();
    }

    /**
     * 业务伙伴-供应商信息-供应商状态修改
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/activeSupplier/check")
    @ApiOperation("业务伙伴-供应商信息-供应商激活检验 true通过 false不通过")
    public TwOutputUtil activeSupplierCheck(Long bookId){
        Boolean res = businessSupplierInfoService.activeSupplierCheck(bookId);
        return TwOutputUtil.ok(res);
    }


    @GetMapping("/activeSupplier/checkWithChange")
    @ApiOperation("业务伙伴-供应商信息-供应商激活检验 true通过 false不通过")
    public TwOutputUtil activeSupplierCheckWithChange(Long bookId){
        Boolean res = businessSupplierInfoService.activeSupplierCheckWithChange(bookId);
        return TwOutputUtil.ok(res);
    }

}
