package com.elitesland.tw.tw5.server.prd.personplan.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsCommunicatePlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsCommunicatePlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsCommunicatePlanVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.PmsCommunicatePlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 项目沟通计划
 *
 * @author wangxl
 * @date 2024/4/1
 */
@RestController
@RequestMapping("pms/pmsCommunicatePlan")
@RequiredArgsConstructor
@Slf4j
@Api(value = "项目沟通计划", tags = {"项目沟通计划"})
public class PmsCommunicatePlanController {

    private final PmsCommunicatePlanService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsCommunicatePlanVO>> page(PmsCommunicatePlanQuery query) {
        return service.queryPage(query);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsCommunicatePlanVO>> list(PmsCommunicatePlanQuery query) {
        return service.queryList(query);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsCommunicatePlanVO> queryByKey(Long id) {
        return service.queryByKey(id);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
//    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsCommunicatePlanVO> insert(@RequestBody PmsCommunicatePlanPayload payload) {
        // 关键日志打印
        log.debug("【PmsCommunicatePlanController.insert】入参：" + payload.toString());
        return service.insert(payload);
    }

//    @ApiOperation("修改")
//    @PostMapping("/update")
//    public TwOutputUtil<PmsCommunicatePlanVO> update(@RequestBody PmsCommunicatePlanPayload payload) {
//        // 关键日志打印
//        log.debug("【PmsCommunicatePlanController.update】入参：" + payload.toString());
//        return service.update(payload);
//    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsCommunicatePlanVO> updateDynamic(@RequestBody PmsCommunicatePlanPayload payload) {
        // 关键日志打印
        log.debug("【PmsCommunicatePlanController.updateDynamic】入参：" + payload.toString());
        return service.updateDynamic(payload);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsCommunicatePlanController.deleteSoft】入参：" + ids);
        return service.deleteSoft(ids);
    }
}