package com.elitesland.tw.tw5.server.prd.personplan.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRolePayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目角色
 *
 * @author xxb
 * @date 2023-07-07
 */
@Api(tags = "项目角色")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectRole")
@Slf4j
public class PmsProjectRoleController {

    private final PmsProjectRoleService pmsProjectRoleService;

    /**
     * 项目角色-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目角色-新增")
    public TwOutputUtil<PmsProjectRoleVO> insert(@RequestBody PmsProjectRolePayload payload){
        return TwOutputUtil.ok(pmsProjectRoleService.insert(payload));
    }

    /**
     * 项目角色-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("项目角色-更新")
    public TwOutputUtil<PmsProjectRoleVO> update(@RequestBody PmsProjectRolePayload payload){
        return TwOutputUtil.ok(pmsProjectRoleService.update(payload));
    }

    /**
     * 项目角色-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("项目角色-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsProjectRolePayload payload){
        return TwOutputUtil.ok(pmsProjectRoleService.updateByKeyDynamic(payload));
    }

    /**
     * 项目角色-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("项目角色-主键查询")
    public TwOutputUtil<PmsProjectRoleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectRoleService.queryByKey(key));
    }

    /**
     * 项目角色-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("项目角色-分页")
    public TwOutputUtil<PagingVO<PmsProjectRoleVO>>  paging(PmsProjectRoleQuery query) {
        return TwOutputUtil.ok(pmsProjectRoleService.queryPaging(query));
    }

    /**
     * 项目角色-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("项目角色-查询列表")
    public TwOutputUtil<List<PmsProjectRoleVO>> queryList(PmsProjectRoleQuery query) {
        return TwOutputUtil.ok(pmsProjectRoleService.queryListDynamic(query));
    }

    /**
     * 项目角色-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目角色-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectRoleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
