package com.elitesland.tw.tw5.server.prd.personplan.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ExternalRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ExternalRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ExternalRelatedPartiesVO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.ExternalRelatedPartiesDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QExternalRelatedPartiesDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 外部相关方RepoProc
 */
@Component
public class ExternalRelatedPartiesDao extends BaseRepoProc<ExternalRelatedPartiesDO> {

   private static final QExternalRelatedPartiesDO qExternalRelatedPartiesDO = QExternalRelatedPartiesDO.externalRelatedPartiesDO;


   protected ExternalRelatedPartiesDao() {

       super(qExternalRelatedPartiesDO);

   }


   public PagingVO<ExternalRelatedPartiesVO> page(ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       JPAQuery<ExternalRelatedPartiesVO> query =
           select(ExternalRelatedPartiesVO.class)
               .where(bulidPredicate(externalRelatedPartiesQuery));
       externalRelatedPartiesQuery.setPaging(query);
       externalRelatedPartiesQuery.fillOrders(query, qExternalRelatedPartiesDO);
       return PagingVO.<ExternalRelatedPartiesVO>builder()
               .total(query.fetchCount())
               .records(query.fetch())
               .build();

   }


   public Long del(List<Long> ids) {

       Long res = jpaQueryFactory.update(qExternalRelatedPartiesDO)
               .set(qExternalRelatedPartiesDO.deleteFlag, 1)
               .where(qExternalRelatedPartiesDO.id.in(ids))
               .execute();

       return res;

   }


   public ExternalRelatedPartiesVO get(Long id) {

       ExternalRelatedPartiesVO externalRelatedPartiesVO = select(ExternalRelatedPartiesVO.class)
               .where(qExternalRelatedPartiesDO.id.eq(id))
               .fetchOne();

       return externalRelatedPartiesVO;

   }


   public List<ExternalRelatedPartiesVO> getList(ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       List<ExternalRelatedPartiesVO> res =
           select(ExternalRelatedPartiesVO.class)
               .where(bulidPredicate(externalRelatedPartiesQuery))
               .fetch();

       return res;

   }


   private <T> JPAQuery<T> select(Class<T> cls) {

       return
               jpaQueryFactory.select(Projections.bean(cls,
                   qExternalRelatedPartiesDO.name,
                   qExternalRelatedPartiesDO.type,
                   qExternalRelatedPartiesDO.phone,
                   qExternalRelatedPartiesDO.email,
                   qExternalRelatedPartiesDO.ouCode,
                   qExternalRelatedPartiesDO.ouName,
                   qExternalRelatedPartiesDO.buId,
                   qExternalRelatedPartiesDO.buCode,
                   qExternalRelatedPartiesDO.buName,
                   qExternalRelatedPartiesDO.id,
                   qExternalRelatedPartiesDO.createTime,
                   qExternalRelatedPartiesDO.remark

               )).from(qExternalRelatedPartiesDO);

   }


   private Predicate bulidPredicate(ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       Predicate predicate = PredicateBuilder.builder()
           .andEq(StringUtils.isNotBlank(externalRelatedPartiesQuery.getName()), qExternalRelatedPartiesDO.name, externalRelatedPartiesQuery.getName())
           .andEq(StringUtils.isNotBlank(externalRelatedPartiesQuery.getType()), qExternalRelatedPartiesDO.type, externalRelatedPartiesQuery.getType())
           .andEq(StringUtils.isNotBlank(externalRelatedPartiesQuery.getPhone()), qExternalRelatedPartiesDO.phone, externalRelatedPartiesQuery.getPhone())
           .andEq(StringUtils.isNotBlank(externalRelatedPartiesQuery.getEmail()), qExternalRelatedPartiesDO.email, externalRelatedPartiesQuery.getEmail())
           .andEq(StringUtils.isNotBlank(externalRelatedPartiesQuery.getOuCode()), qExternalRelatedPartiesDO.ouCode, externalRelatedPartiesQuery.getOuCode())
            .andEq(StringUtils.isNotBlank(externalRelatedPartiesQuery.getOuName()), qExternalRelatedPartiesDO.ouName, externalRelatedPartiesQuery.getOuName())
           .andEq(null != externalRelatedPartiesQuery.getBuId(), qExternalRelatedPartiesDO.buId, externalRelatedPartiesQuery.getBuId())
           .andEq(StringUtils.isNotBlank(externalRelatedPartiesQuery.getBuCode()), qExternalRelatedPartiesDO.buCode, externalRelatedPartiesQuery.getBuCode())
           .andEq(StringUtils.isNotBlank(externalRelatedPartiesQuery.getBuName()), qExternalRelatedPartiesDO.buName, externalRelatedPartiesQuery.getBuName())
           .build();

       return predicate;

   }


   private Predicate bulidPredicates(ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       List<Predicate> predicates = new ArrayList<>();
       // 相关方名称
       if (StringUtils.isNotEmpty(externalRelatedPartiesQuery.getName())) {
           predicates.add(qExternalRelatedPartiesDO.name.eq(externalRelatedPartiesQuery.getName()));
       }
       // 相关方类型
       if (StringUtils.isNotEmpty(externalRelatedPartiesQuery.getType())) {
           predicates.add(qExternalRelatedPartiesDO.type.eq(externalRelatedPartiesQuery.getType()));
       }
       // 联系方式
       if (StringUtils.isNotEmpty(externalRelatedPartiesQuery.getPhone())) {
           predicates.add(qExternalRelatedPartiesDO.phone.eq(externalRelatedPartiesQuery.getPhone()));
       }
       // 电子邮箱
       if (StringUtils.isNotEmpty(externalRelatedPartiesQuery.getEmail())) {
           predicates.add(qExternalRelatedPartiesDO.email.eq(externalRelatedPartiesQuery.getEmail()));
       }
       // 公司编码
       if (StringUtils.isNotEmpty(externalRelatedPartiesQuery.getOuCode())) {
           predicates.add(qExternalRelatedPartiesDO.ouCode.eq(externalRelatedPartiesQuery.getOuCode()));
       }
       // 公司名称
       if (StringUtils.isNotEmpty(externalRelatedPartiesQuery.getOuName())) {
           predicates.add(qExternalRelatedPartiesDO.ouName.eq(externalRelatedPartiesQuery.getOuName()));
       }
       // 部门id
       if (null != externalRelatedPartiesQuery.getBuId()) {
           predicates.add(qExternalRelatedPartiesDO.buId.eq(externalRelatedPartiesQuery.getBuId()));
       }
       // 部门编码
       if (StringUtils.isNotEmpty(externalRelatedPartiesQuery.getBuCode())) {
           predicates.add(qExternalRelatedPartiesDO.buCode.eq(externalRelatedPartiesQuery.getBuCode()));
       }
       // 部门名称
       if (StringUtils.isNotEmpty(externalRelatedPartiesQuery.getBuName())) {
           predicates.add(qExternalRelatedPartiesDO.buName.eq(externalRelatedPartiesQuery.getBuName()));
       }

       Predicate predicate = ExpressionUtils.allOf(predicates);

       return predicate;
   }


   public Long count(ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       long res = select(ExternalRelatedPartiesVO.class)
               .where(bulidPredicates(externalRelatedPartiesQuery))
               .fetchCount();

       return res;


   }

   public Long update(ExternalRelatedPartiesPayload externalRelatedPartiesPayload) {
       JPAUpdateClause update = jpaQueryFactory.update(qExternalRelatedPartiesDO);

       // 相关方名称
       if (StringUtils.isNotEmpty(externalRelatedPartiesPayload.getName())) {
           update.set(qExternalRelatedPartiesDO.name,externalRelatedPartiesPayload.getName());
       }
       // 相关方类型
       if (StringUtils.isNotEmpty(externalRelatedPartiesPayload.getType())) {
           update.set(qExternalRelatedPartiesDO.type,externalRelatedPartiesPayload.getType());
       }
       // 联系方式
       if (StringUtils.isNotEmpty(externalRelatedPartiesPayload.getPhone())) {
           update.set(qExternalRelatedPartiesDO.phone,externalRelatedPartiesPayload.getPhone());
       }
       // 电子邮箱
       if (StringUtils.isNotEmpty(externalRelatedPartiesPayload.getEmail())) {
           update.set(qExternalRelatedPartiesDO.email,externalRelatedPartiesPayload.getEmail());
       }
       // 公司编码
       if (StringUtils.isNotEmpty(externalRelatedPartiesPayload.getOuCode())) {
           update.set(qExternalRelatedPartiesDO.ouCode,externalRelatedPartiesPayload.getOuCode());
       }
       // 公司名称
       if (StringUtils.isNotEmpty(externalRelatedPartiesPayload.getOuName())) {
           update.set(qExternalRelatedPartiesDO.ouName,externalRelatedPartiesPayload.getOuName());
       }
       // 部门id
       if (null != externalRelatedPartiesPayload.getBuId()) {
           update.set(qExternalRelatedPartiesDO.buId,externalRelatedPartiesPayload.getBuId());
       }
       // 部门编码
       if (StringUtils.isNotEmpty(externalRelatedPartiesPayload.getBuCode())) {
           update.set(qExternalRelatedPartiesDO.buCode,externalRelatedPartiesPayload.getBuCode());
       }
       // 部门名称
       if (StringUtils.isNotEmpty(externalRelatedPartiesPayload.getBuName())) {
           update.set(qExternalRelatedPartiesDO.buName,externalRelatedPartiesPayload.getBuName());
       }
       long res = update.where(qExternalRelatedPartiesDO.id.eq(externalRelatedPartiesPayload.getId()))
               .execute();
       return res;

   }

}

