package com.elitesland.tw.tw5.server.prd.personplan.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;


/**
 * 项目沟通计划DO
 *
 * @author wangxl
 * @date 2024-1-18
 */
@Entity
@Table(name = "pms_communicate_plan")
@org.hibernate.annotations.Table(appliesTo = "pms_communicate_plan", comment = "项目沟通计划")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PmsCommunicatePlanDO extends BaseModel {

    /**
     * 沟通议程
     */
    @Comment("沟通议程")
    @Column
    private String title;

    /**
     * 关联计划
     */
    @Comment("关联计划")
    @Column
    private Long wbsId;

    /**
     * 关联计划
     */
    @Comment("关联计划")
    @Column
    private String wbsName;

    /**
     * 计划沟通时间
     */
    @Comment("计划沟通时间")
    @Column
    private LocalDateTime communicateTime;

    /**
     * 参与人
     */
    @Comment("参与人")
    @Column
    private String processingUser;

    /**
     * 状态
     */
    @Comment("状态")
    @Column
    private Integer status;

    /**
     * 处理时间
     */
    @Comment("处理时间")
    @Column
    private LocalDateTime processingTime;

    /**
     * 提醒提前时间(min)
     */
    @Comment("提醒提前时间(min)")
    @Column
    private String beforeRemindTime;

    /**
     * 提醒提前时间名称(min)
     */
    @Comment("提醒提前时间名称(min)")
    @Column
    private String beforeRemindTimeName;


    /**
     * 提醒方式
     */
    @Comment("提醒方式")
    @Column
    private String remindMode;

    /**
     * 沟通内容
     */
    @Comment("沟通内容")
    @Column
    private String content;


    /**
     * 项目id
     */
    @Comment("项目id")
    @Column
    private Long proId;
}