package com.elitesland.tw.tw5.server.prd.personplan.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * 相关方变化历史记录DO
 * @author wangxl
 * @date 2024-1-18
 */
@Entity
@Table(name = "pms_related_history")
@org.hibernate.annotations.Table(appliesTo = "pms_related_history", comment = "相关方变化历史记录")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PmsRelatedHistoryDO extends BaseModel {

    @Comment("相关方id")
    @Column
    private Long relateId;

    @Comment("利益相关程度")
    @Column
    private Integer ext1;

    @Comment("权利程度")
    @Column
    private Integer ext2;

    @Comment("情感倾向")
    @Column
    private Integer ext3;

    @Comment("参与度")
    @Column
    private BigDecimal ext4;


    @Comment("来源类型")
    @Column
    private Integer sourceType;

}