package com.elitesland.tw.tw5.server.prd.personplan.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 项目相关方
 */
@Entity
@Table(name = "pro_related_parties")
@org.hibernate.annotations.Table(appliesTo = "pro_related_parties", comment = "项目相关方")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ProRelatedPartiesDO extends BaseModel {


    /**
     * 项目id
     */
    @Column(name = "pro_id", columnDefinition = "bigint(20) comment '项目id'")
    private Long proId;

    /**
     * 用户id
     */
    @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户id'")
    private Long userId;

    /**
     * 外部相关方id
     */
    @Column(name = "external_id", columnDefinition = "bigint(20) comment '外部相关方id'")
    private Long externalId;

    /**
     * 相关方名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '相关方名称'")
    private String name;

    /**
     * 相关方类型
     */
    @Column(name = "related_type", columnDefinition = "varchar(50) comment '相关方类型'")
    private String relatedType;

    /**
     * 项目角色
     */
    @Column(name = "pro_role", columnDefinition = "varchar(255) comment '项目角色'")
    private String proRole;

    /**
     * 联系电话
     */
    @Column(name = "phone", columnDefinition = "varchar(50) comment '联系电话'")
    private String phone;

    /**
     * 邮箱
     */
    @Column(name = "email", columnDefinition = "varchar(50) comment '邮箱'")
    private String email;

    /**
     * 公司id
     */
    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司id'")
    private Long ouId;

    /**
     * 公司编码
     */
    @Column(name = "ou_code", columnDefinition = "varchar(50) comment '公司编码'")
    private String ouCode;

    /**
     * 公司名称
     */
    @Column(name = "ou_name", columnDefinition = "varchar(255) comment '公司名称'")
    private String ouName;

    /**
     * 利益相关程度
     */
    @Column(name = "ext1", columnDefinition = "int(11) comment '利益相关程度'")
    private Integer ext1;

    /**
     * 权利程度
     */
    @Column(name = "ext2", columnDefinition = "int(11) comment '权利程度'")
    private Integer ext2;

    /**
     * 情感倾向
     */
    @Column(name = "ext3", columnDefinition = "int(11) comment '情感倾向'")
    private Integer ext3;

    /**
     * 参与度
     */
    @Column(name = "ext4", columnDefinition = "decimal(20,2) comment '参与度'")
    private BigDecimal ext4;




    /**
     * 类型0内部相关方 1外部相关方
     */
    @Column(name = "type", columnDefinition = "int(11) comment '类型0内部相关方 1外部相关方'")
    private Integer type;


    /**
     * 所属部门
     */
    @Column(name = "bu_name", columnDefinition = "varchar(50) comment '所属部门'")
    private String buName;


    /**
     * 参与度
     */
    @Column(name = "eqva_ratio", columnDefinition = "decimal(20,2) comment '当量'")
    private BigDecimal eqvaRatio;
}

