package com.elitesland.tw.tw5.server.prd.personplan.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ExternalRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ExternalRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ExternalRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ExternalRelatedPartiesVO;
import com.elitesland.tw.tw5.server.prd.personplan.convert.ExternalRelatedPartiesConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.ExternalRelatedPartiesDao;
import com.elitesland.tw.tw5.server.prd.personplan.entity.ExternalRelatedPartiesDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.ExternalRelatedPartiesRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 外部相关方Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ExternalRelatedPartiesServiceImpl implements ExternalRelatedPartiesService {


   private final ExternalRelatedPartiesDao externalRelatedPartiesDao;

   private final ExternalRelatedPartiesRepo externalRelatedPartiesRepo;


   @Override
   @Transactional(rollbackFor = Exception.class)
   public ExternalRelatedPartiesVO save(ExternalRelatedPartiesPayload externalRelatedPartiesPayload) {

       checkData(externalRelatedPartiesPayload);
       // 员工编号-员工名称-所属组织

       ExternalRelatedPartiesDO externalRelatedPartiesDO = new ExternalRelatedPartiesDO();
       externalRelatedPartiesDO = ExternalRelatedPartiesConvert.INSTANCE.p2d(externalRelatedPartiesPayload);
       ExternalRelatedPartiesDO res = externalRelatedPartiesRepo.save(externalRelatedPartiesDO);
       return ExternalRelatedPartiesConvert.INSTANCE.d2v(res);

   }


   @Override
   @Transactional(rollbackFor = Exception.class)
   public ExternalRelatedPartiesVO updateAll(ExternalRelatedPartiesPayload externalRelatedPartiesPayload) {

       Assert.notNull(externalRelatedPartiesPayload.getId(), "id is null");
       ExternalRelatedPartiesVO res = save(externalRelatedPartiesPayload);
       return res;

   }


   @Override
   public ExternalRelatedPartiesVO get(Long id) {

       if (null == id) {
           return null;
       }
       ExternalRelatedPartiesVO res = externalRelatedPartiesDao.get(id);
       return res;

   }


   @Override
   public PagingVO<ExternalRelatedPartiesVO> page(ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       PagingVO<ExternalRelatedPartiesVO> res = externalRelatedPartiesDao.page(externalRelatedPartiesQuery);
       return res;

   }


   @Override
   @Transactional(rollbackFor = Exception.class)
   public Long del(List<Long> ids) {

       if (CollectionUtil.isEmpty(ids)) {
           return 0L;
       }
       Long res = externalRelatedPartiesDao.del(ids);
       return res;

   }

   @Override
   public List<ExternalRelatedPartiesVO> getList(ExternalRelatedPartiesQuery externalRelatedPartiesQuery) {

       List<ExternalRelatedPartiesVO> res = externalRelatedPartiesDao.getList(externalRelatedPartiesQuery);
       return res;

   }


   /**
    * 数据校验
    * @param externalRelatedPartiesPayload
    */
   private void checkData(ExternalRelatedPartiesPayload externalRelatedPartiesPayload) {

       Assert.notNull(externalRelatedPartiesPayload.getType(), "相关方类型不能为空");
       Assert.notNull(externalRelatedPartiesPayload.getName(), "相关方名称不能为空");

   }

   @Override
   @Transactional(rollbackFor = Exception.class)
   public Long update(ExternalRelatedPartiesPayload externalRelatedPartiesPayload) {
       Assert.notNull(externalRelatedPartiesPayload.getId(), "id不能为空");
       Long res = externalRelatedPartiesDao.update(externalRelatedPartiesPayload);
       return res;
   }


}

