package com.elitesland.tw.tw5.server.prd.personplan.service;


import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsCommunicatePlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ProRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsCommunicatePlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsCommunicatePlanVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsCommunicatePlanDao;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.PmsCommunicatePlanService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 项目沟通计划service impl
 *
 * @author wangxl
 * @date 2024/4/1
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsCommunicatePlanServiceImpl implements PmsCommunicatePlanService {

    private final PmsCommunicatePlanDao dao;

    private final ProRelatedPartiesService proRelatedPartiesService;

    private final PrdFsmFileRefService prdFsmFileRefService;

    private final PrdMessageConfigService prdMessageConfigService;

//    private final PmsFocusDocService pmsFocusDocService;
//
//    private final PmsProjectWbsDAO pmsProjectWbsDAO;


    @Override
    public TwOutputUtil<PagingVO<PmsCommunicatePlanVO>> queryPage(PmsCommunicatePlanQuery query) {
        PagingVO<PmsCommunicatePlanVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsCommunicatePlanVO>> queryList(PmsCommunicatePlanQuery query) {
        List<PmsCommunicatePlanVO> listVO = dao.queryList(query);
        translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsCommunicatePlanQuery query) {
        return TwOutputUtil.ok(dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsCommunicatePlanVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsCommunicatePlanVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
//        // 文件附件
//        PmsFocusDocQuery pmsFocusDocQuery = new PmsFocusDocQuery();
//        pmsFocusDocQuery.setReasonId(id);
//        TwOutputUtil<List<PmsFocusDocVO>> listTwOutputUtil = pmsFocusDocService.queryList(pmsFocusDocQuery);
//        vo.setPmsFocusDocVOList(listTwOutputUtil.getData());

        // 查询相关方情感倾向
        if (StrUtil.isNotBlank(vo.getProcessingUser())) {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            List<Long> idList = Arrays.stream(vo.getProcessingUser().split(",")).map(Long::valueOf).collect(Collectors.toList());
            proRelatedPartiesQuery.setIdList(idList);
            proRelatedPartiesQuery.setType(1);
            List<ProRelatedPartiesVO> proRelatedPartiesVOList = proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            vo.setProRelatedPartiesVOList(proRelatedPartiesVOList);
        }
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsCommunicatePlanVO> insert(PmsCommunicatePlanPayload payload) {
        // 检查数据局
        checkData(payload);
        if (null == payload.getStatus()) {
            payload.setStatus(1);
        }
        // 保存数据
        PmsCommunicatePlanVO save = dao.save(payload);
        // 开启工作流
        // startWorkFlow(ado);
//        // 插入附件
//        if (CollUtil.isNotEmpty(payload.getFileCodes())) {
//            for (String fileCode : payload.getFileCodes()) {
//                PrdFsmFileRefPayload prdFsmFileRefPayload = new PrdFsmFileRefPayload();
//                prdFsmFileRefPayload.setObjId(save.getId());
//                prdFsmFileRefPayload.setObjType("PMS_COMMUNICATE_PLAN");
//                prdFsmFileRefPayload.setFileCode(fileCode);
//                prdFsmFileRefService.insert(prdFsmFileRefPayload);
//            }
//
//        }
        // 修改相关方
//        ProRelatedPartiesPayload proRelatedPartiesPayload = new ProRelatedPartiesPayload();
//        if (null != payload.getRelateId()) {
//            proRelatedPartiesPayload.setId(payload.getRelateId());
//            proRelatedPartiesPayload.setExt3(payload.getExt3());
//            Long res = proRelatedPartiesService.update(proRelatedPartiesPayload, 1);
//        }
        // 发送消息通知:  5,15,30

        if (null != payload.getCommunicateTime() && StrUtil.isNotBlank(payload.getBeforeRemindTime())) {
            if (payload.getCommunicateTime().isAfter(LocalDateTime.now())) {
                for (String beforeRemindTime : payload.getBeforeRemindTime().split(",")) {
                    // 发送消息提醒
                    PrdMessageConfigPayload prdMessageConfigPayload = new PrdMessageConfigPayload();
                    prdMessageConfigPayload.setMessageTitle("项目沟通计划提醒");
                    prdMessageConfigPayload.setContentType("systemMessage");
                    // 通知方式 enterprise_wechat  instation email
                    prdMessageConfigPayload.setNoticeWay(payload.getRemindMode());
                    prdMessageConfigPayload.setReleaseSource("埃林哲平台管理");
                    prdMessageConfigPayload.setNoticeScope("appoint_people");
                    // 发送人
                    String processingUser = payload.getProcessingUser();
                    prdMessageConfigPayload.setNoticeSource(processingUser);
                    // 发布具体时间
                    long pushTime = Long.parseLong(beforeRemindTime);
                    LocalDateTime localDateTime = payload.getCommunicateTime().minusMinutes(pushTime);
                    prdMessageConfigPayload.setTriggerTime(localDateTime);
                    prdMessageConfigPayload.setMessageType(2);
//                    PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsDAO.queryByKey(payload.getWbsId());
//                    payload.setWbsName(pmsProjectWbsVO.getWbsName());
                    prdMessageConfigPayload.setContentBigType("companyMessage");
                    String msgContent = "沟通议程" + payload.getTitle() + "即将开始\n" +
                            "   计划沟通时间：" + payload.getCommunicateTime().toString() +
//                        "   参与人：" + payload.getProcessingUser() +
                            "   关联计划：" + payload.getWbsName();
                    prdMessageConfigPayload.setMessageContent(msgContent);
                    prdMessageConfigService.insert(prdMessageConfigPayload);

                }

            }
        }
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsCommunicatePlanVO> update(PmsCommunicatePlanPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsCommunicatePlanVO save = dao.save(payload);

        // 修改相关方
        ProRelatedPartiesPayload proRelatedPartiesPayload = new ProRelatedPartiesPayload();
//        if (null != payload.getRelateId()) {
//            proRelatedPartiesPayload.setId(payload.getRelateId());
//            proRelatedPartiesPayload.setExt3(payload.getExt3());
//            Long res = proRelatedPartiesService.update(proRelatedPartiesPayload, 1);
//        }
        // 插入附件
//        if (CollUtil.isNotEmpty(payload.getFileCodes())) {
//            for (String fileCode : payload.getFileCodes()) {
//                PrdFsmFileRefPayload prdFsmFileRefPayload = new PrdFsmFileRefPayload();
//                prdFsmFileRefPayload.setObjId(save.getId());
//                prdFsmFileRefPayload.setObjType("PMS_COMMUNICATE_PLAN");
//                prdFsmFileRefPayload.setFileCode(fileCode);
//                prdFsmFileRefService.insert(prdFsmFileRefPayload);
//            }
//
//        }
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsCommunicatePlanVO> updateDynamic(PmsCommunicatePlanPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        if (payload.getStatus() != 1) {
            payload.setProcessingTime(LocalDateTime.now());
        }
        // 批量修改相关方情感倾向
        if (CollUtil.isNotEmpty(payload.getProRelatedPartiesPayloadList())) {
            payload.getProRelatedPartiesPayloadList().forEach(x -> {
                x.setId(x.getId());
                x.setExt3(x.getExt3());
                Long res = proRelatedPartiesService.update(x, 1);
            });
        }
        // 保存数据
        dao.updateByKeyDynamic(payload);
        // 项目文档上传
//        if (CollUtil.isNotEmpty(payload.getPmsFocusDocPayloadList())) {
//            payload.getPmsFocusDocPayloadList().forEach(x -> {
//                x.setReasonId(payload.getId());
//                x.setReasonType("COMMUNICATE_PLAN");
//            });
//            pmsFocusDocService.insertByCacheKey(payload.getPmsFocusDocPayloadList());
//        }
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return TwOutputUtil.ok(dao.deleteSoft(ids));
    }


    /**
     * 发起工作流
     *
     * @param payload payload
     * @return result
     */
    private TwOutputUtil<Long> startWorkFlow(PmsCommunicatePlanPayload payload) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
//        Assert.notNull(payload.getUserId(), "userId不能为空");
        // 变更资源审批
//        varMaps.put("Activity_111kevq", payload.getUserId());
        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));
//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        // 回写单据的工作流信息
//        payload.setProcInstId(procInstId);
//        payload.setProcInstStatus("");
        Long update = dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsCommunicatePlanPayload payload) {
        if (payload.getCommunicateTime() != null) {
//            for (String beforeRemindTime : payload.getBeforeRemindTime().split(",")) {
//                LocalDateTime localDateTime = payload.getCommunicateTime().minusMinutes(Long.parseLong(beforeRemindTime));
//                if (localDateTime.isBefore(LocalDateTime.now())) {
//                    throw new BusinessException("计划沟通时间不能小于当前时间");
//                }
//            }
        }

    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsCommunicatePlanVO> vos) {
        vos.forEach(vo -> {
            // 翻译vo对象
//            if (null != vo.getWbsId()) {
//                PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsDAO.queryByKey(vo.getWbsId());
//                vo.setWbsName(pmsProjectWbsVO.getWbsName());
//                vo.setWbsType(pmsProjectWbsVO.getWbsType());
//            }
            // 参与人
            if (StringUtils.hasText(vo.getProcessingUser())) {
                List<Long> processList = Arrays.stream(vo.getProcessingUser().split(",")).map(Long::valueOf).collect(Collectors.toList());
                ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
                proRelatedPartiesQuery.setIdList(processList);
                List<ProRelatedPartiesVO> proRelatedPartiesVOList = proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
                List<String> relateName = proRelatedPartiesVOList.stream().map(x -> x.getName()).collect(Collectors.toList());
                vo.setProcessingUserDesc(StrUtil.join(",", relateName));
            }

        });
    }

}
