package com.elitesland.tw.tw5.server.prd.personplan.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRoleAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleAssignmentService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleAssignmentVO;
import com.elitesland.tw.tw5.server.common.TwException;

import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsProjectRoleAssignmentDAO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PmsProjectRoleAssignmentDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PmsProjectRoleAssignmentRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 项目角色分配
 *
 * @author xxb
 * @date 2023-07-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectRoleAssignmentServiceImpl extends BaseServiceImpl implements PmsProjectRoleAssignmentService {

    private final PmsProjectRoleAssignmentRepo pmsProjectRoleAssignmentRepo;
    private final PmsProjectRoleAssignmentDAO pmsProjectRoleAssignmentDAO;

    @Override
    public PagingVO<PmsProjectRoleAssignmentVO> queryPaging(PmsProjectRoleAssignmentQuery query) {
        return pmsProjectRoleAssignmentDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectRoleAssignmentVO> queryListDynamic(PmsProjectRoleAssignmentQuery query) {
        return pmsProjectRoleAssignmentDAO.queryListDynamic(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insert(PmsProjectRoleAssignmentPayload payload) {
        if (ObjectUtils.isEmpty(payload.getProjectId())) {
            throw TwException.error("", "项目ID不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getUserId())) {
            throw TwException.error("", "用户资源不能为空，请核验！");
        }
        List<Long> projectRoleIds = payload.getProjectRoleIds();
        if (ObjectUtils.isEmpty(projectRoleIds)) {
            pmsProjectRoleAssignmentDAO.deleteByProjectAndUser(payload.getProjectId(), payload.getUserId());
        } else {
            // 角色Id 去重
            Set<Long> difference = new HashSet<>(projectRoleIds);

            // 查看数据库里 是有已经有数据
            List<PmsProjectRoleAssignmentVO> fromDB = pmsProjectRoleAssignmentDAO.queryByProjectAndUser(payload.getProjectId(), payload.getUserId());
            //获取要删除的数据
            List<Long> delIds = fromDB.stream().filter(vo -> !projectRoleIds.contains(vo.getProjectRoleId())).map(vo -> vo.getId()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(delIds)) {
                pmsProjectRoleAssignmentDAO.deleteSoft(delIds);
            }
            // 获取要新增的数据
            List<Long> projectRoleIdsFromDB = fromDB.stream().map(vo -> vo.getProjectRoleId()).collect(Collectors.toList());
            difference.removeAll(projectRoleIdsFromDB);
            List<PmsProjectRoleAssignmentDO> list = new ArrayList<>();
            for (Long projectRoleId : difference) {
                PmsProjectRoleAssignmentDO entityDo = new PmsProjectRoleAssignmentDO();
                entityDo.setProjectRoleId(projectRoleId);
                entityDo.setProjectId(payload.getProjectId());
                entityDo.setUserId(payload.getUserId());
                list.add(entityDo);
            }
            if (!ObjectUtils.isEmpty(list)) {
                pmsProjectRoleAssignmentRepo.saveAll(list);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insert(Long projectId, Long userId, List<Long> projectRoleIds) {
        if (ObjectUtils.isEmpty(projectId)) {
            throw TwException.error("", "项目ID不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(userId)) {
            throw TwException.error("", "用户资源不能为空，请核验！");
        }
        // 角色Id 去重
        Set<Long> difference = new HashSet<>(projectRoleIds);

        // 查看数据库里 是有已经有数据
        List<PmsProjectRoleAssignmentVO> fromDB = pmsProjectRoleAssignmentDAO.queryByProjectAndUser(projectId, userId);
        // 获取要新增的数据
        List<Long> projectRoleIdsFromDB = fromDB.stream().map(vo -> vo.getProjectRoleId()).collect(Collectors.toList());
        difference.removeAll(projectRoleIdsFromDB);

        List<PmsProjectRoleAssignmentDO> list = new ArrayList<>();
        for (Long projectRoleId : difference) {
            PmsProjectRoleAssignmentDO entityDo = new PmsProjectRoleAssignmentDO();
            entityDo.setProjectRoleId(projectRoleId);
            entityDo.setProjectId(projectId);
            entityDo.setUserId(userId);
            list.add(entityDo);
        }
        if (!ObjectUtils.isEmpty(list)) {
            pmsProjectRoleAssignmentRepo.saveAll(list);
        }
    }


}
