package com.elitesland.tw.tw5.server.prd.personplan.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsRelatedHistoryPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ProRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ResourceCostStrategyQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.*;

import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;

import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.personplan.convert.ProRelatedPartiesConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.ProRelatedPartiesDao;
import com.elitesland.tw.tw5.server.prd.personplan.entity.ProRelatedPartiesDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.ProRelatedPartiesRepo;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.PmsRelatedHistoryService;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.ResourceCostStrategyService;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 项目相关方Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ProRelatedPartiesServiceImpl implements ProRelatedPartiesService {


    private final ProRelatedPartiesDao proRelatedPartiesDao;

    private final ProRelatedPartiesRepo proRelatedPartiesRepo;

    private final PmsProjectRoleService pmsProjectRoleService;

    // private final StateFlowService service;

    private final PmsRelatedHistoryService pmsRelatedHistoryService;

    private final CacheUtil cacheUtil;

    private final PmsProjectDAO pmsProjectDAO;

    private final ResourceCostStrategyService resourceCostStrategyService;

    private final PersonPlanDtlService personPlanDtlService;
//    @Lazy
//    @Autowired
//    private TaskProService taskProService;

//    @Lazy
//    @Autowired
//    private TaskInfoService taskInfoService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProRelatedPartiesVO save(ProRelatedPartiesPayload proRelatedPartiesPayload) {

        checkData(proRelatedPartiesPayload);
        // 相关方重复校验
        if (proRelatedPartiesPayload.getType().equals(0)) {

            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setProId(proRelatedPartiesPayload.getProId());
            proRelatedPartiesQuery.setUserId(proRelatedPartiesPayload.getUserId());
            Long count = proRelatedPartiesDao.count(proRelatedPartiesQuery);
            if (count > 0) {
                throw new BusinessException("已存在相同的相关方");
            }

        } else if (proRelatedPartiesPayload.getType().equals(1)) {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setProId(proRelatedPartiesPayload.getProId());
            proRelatedPartiesQuery.setExternalId(proRelatedPartiesPayload.getExternalId());
            Long count = proRelatedPartiesDao.count(proRelatedPartiesQuery);
            if (count > 0) {
                throw new BusinessException("已存在相同的相关方");
            }
        }

        ProRelatedPartiesDO proRelatedPartiesDO = new ProRelatedPartiesDO();
        proRelatedPartiesDO = ProRelatedPartiesConvert.INSTANCE.p2d(proRelatedPartiesPayload);
        ProRelatedPartiesDO res = proRelatedPartiesRepo.save(proRelatedPartiesDO);
        // 相关方历史记录
        PmsRelatedHistoryPayload payload = new PmsRelatedHistoryPayload();
        payload.setRelateId(res.getId());
        payload.setExt1(res.getExt1());
        payload.setExt2(res.getExt2());
        payload.setExt3(res.getExt3());
        payload.setExt4(res.getExt4());
        payload.setSourceType(2);
        pmsRelatedHistoryService.insert(payload);
        return ProRelatedPartiesConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProRelatedPartiesVO updateAll(ProRelatedPartiesPayload proRelatedPartiesPayload) {

        Assert.notNull(proRelatedPartiesPayload.getId(), "id is null");
        ProRelatedPartiesVO res = save(proRelatedPartiesPayload);
        return res;

    }


    @Override
    public ProRelatedPartiesVO get(Long id) {

        if (null == id) {
            return null;
        }
        ProRelatedPartiesVO res = proRelatedPartiesDao.get(id);
        if (null != res) {
            translate(Collections.singletonList(res));
        }
        return res;

    }

    @Override
    public ProRelatedPartiesVO getSimple(Long id) {
        if (null == id) {
            return null;
        }
        ProRelatedPartiesVO res = proRelatedPartiesDao.get(id);
        return res;
    }


    @Override
    public PagingVO<ProRelatedPartiesVO> page(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        PagingVO<ProRelatedPartiesVO> res = proRelatedPartiesDao.page(proRelatedPartiesQuery);
        if (!CollectionUtils.isEmpty(res.getRecords())) {
            translate(res.getRecords());

        }
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Boolean exist = false;
        // 校验相关方是否在任务中存在
//        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
//        // 负责人
//        taskProQuery.setDirectorRelatedPartiesIdList(ids);
//        // 任务状态 进行中
//        taskInfoQuery.setTaskStatus("PROCESS");
//        ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
//        proRelatedPartiesQuery.setIdList(ids);
//        List<ProRelatedPartiesVO> list = proRelatedPartiesDao.getList(proRelatedPartiesQuery);
//        List<Long> collect = list.stream().map(x -> x.getProId()).collect(Collectors.toList());
//        // 项目id
//        taskProQuery.setReasonIdList(collect);
//        List<TaskProVO> taskProVOS = taskInfoService.queryListDynamic(taskProQuery);
//        if (CollUtil.isNotEmpty(taskProVOS)) {
//            exist = true;
//        }
        // 如果存在则弹窗提示异常
        if (exist) {
            throw new BusinessException("存在进行中的任务,请移交处理后再进行删除");
        }
        // 若存在，移交任务的负责人(批量移交负责人)
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = proRelatedPartiesDao.del(ids);
        return res;

    }

    // 校验是否移除
    @Override
    public CheckoutProRelatedRemoveVO checkoutRemoveRelated(List<Long> ids) {
        CheckoutProRelatedRemoveVO checkoutProRelatedRemoveVO = new CheckoutProRelatedRemoveVO();
        //true 需要移除 false 不需要移除 先默认给个false
        checkoutProRelatedRemoveVO.setRemoveflag(false);
        // 先查询所有的相关方数据
        List<ProRelatedPartiesDO> proRelatedPartiesDOS = proRelatedPartiesDao.get(ids);
        if (!CollectionUtils.isEmpty(proRelatedPartiesDOS)) {
            // 获取相关方的员工id
            List<Long> userIdList = proRelatedPartiesDOS.stream().map(p -> p.getUserId()).collect(Collectors.toList());
            //获取项目id
            Long proId = proRelatedPartiesDOS.get(0).getProId();
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setProId(proId);
            List<ProRelatedPartiesVO> proRelatedPartiesVOList = getList(proRelatedPartiesQuery);
            /**
             * 根据项目id查询任务
             * 1.任务负责人等于相关方的userId
             * 2.任务状态是进行中
             * 3.reasonType是项目
             * **/
//            TaskProQuery taskProQuery = new TaskProQuery();
//            taskProQuery.setReasonId(proId);
////            taskProQuery.setTaskStatus("2");
//
//            // 查询进行中的状态
//            StateFlowQuery stateFlowQuery = new StateFlowQuery();
//            stateFlowQuery.setState(2);
//            List<StateFlowVO> stateFlowVOS = service.getList(stateFlowQuery);
//            List<Long> flowIds = stateFlowVOS.stream().map(x -> x.getId()).collect(Collectors.toList());
//            if (CollUtil.isNotEmpty(flowIds)) {
//                taskProQuery.setStateFlowIdList(flowIds);
//            }
//            taskProQuery.setDirectorRelatedPartiesIdList(ids);
//            taskProQuery.setReasonType(TaskReasonTypeEnum.PROJ_CONTRACT.getCode());
//            TaskProService taskProService = SpringUtil.getBean(TaskProService.class);
//            List<TaskProVO> taskProVOS = taskProService.queryListDynamic(taskProQuery);
//            if (!CollectionUtils.isEmpty(taskProVOS)) {
//                List<Long> taskProIdList = taskProVOS.stream().map(p -> p.getId()).collect(Collectors.toList());
//                checkoutProRelatedRemoveVO.setRemoveflag(true);
//                checkoutProRelatedRemoveVO.setTaskProVOList(taskProVOS);
//                // 将选中的相关方从所有的相关方中排除出去
//                List<ProRelatedPartiesVO> newProRelatedPartiesVOList = proRelatedPartiesVOList.stream().filter(p -> !ids.contains(p.getId())).collect(Collectors.toList());
//                checkoutProRelatedRemoveVO.setProRelatedPartiesVOList(newProRelatedPartiesVOList);
//            }
        }
        return checkoutProRelatedRemoveVO;
    }


    @Override
    public List<ProRelatedPartiesVO> getList(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        List<ProRelatedPartiesVO> res = proRelatedPartiesDao.getList(proRelatedPartiesQuery);
        if (!CollectionUtils.isEmpty(res)) {
            translate(res);
        }
        return res;

    }

    @Override
    public List<ProRelatedPartiesVO> getListSimple(ProRelatedPartiesQuery proRelatedPartiesQuery) {
        List<ProRelatedPartiesVO> res = proRelatedPartiesDao.getList(proRelatedPartiesQuery);
        return res;
    }

    @Override
    public ProRelatedPartiesVO getListSimpleByProjectIdAndUserId(Long reasonId, Long loginUserId) {
        // 根据项目id、当前登录人、获取其相对方的主键
        ProRelatedPartiesQuery relatedPartiesQuery = new ProRelatedPartiesQuery();
        relatedPartiesQuery.setProId(reasonId);
        relatedPartiesQuery.setUserId(loginUserId);
        List<ProRelatedPartiesVO> listSimple = getListSimple(relatedPartiesQuery);
        if (!CollectionUtils.isEmpty(listSimple)) {
            return listSimple.get(0);
        }
        return null;
    }


    /**
     * 数据校验
     *
     * @param proRelatedPartiesPayload
     */
    private void checkData(ProRelatedPartiesPayload proRelatedPartiesPayload) {

        Assert.notNull(proRelatedPartiesPayload.getType(), "类型不能为空");
        Assert.notNull(proRelatedPartiesPayload.getRelatedType(), "相关方类型不能为空");
        Assert.notNull(proRelatedPartiesPayload.getProId(), "项目id不能为空");

        if (proRelatedPartiesPayload.getType().equals(0)) {
            Assert.notNull(proRelatedPartiesPayload.getUserId(), "用户id不能为空");
        } else if (proRelatedPartiesPayload.getType().equals(1)) {
            Assert.notNull(proRelatedPartiesPayload.getExternalId(), "外部相关方id不能为空");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(ProRelatedPartiesPayload proRelatedPartiesPayload, Integer sourceType) {
        Assert.notNull(proRelatedPartiesPayload.getId(), "id不能为空");

        Long res = proRelatedPartiesDao.update(proRelatedPartiesPayload);
        ProRelatedPartiesVO proRelatedPartiesVO = this.get(proRelatedPartiesPayload.getId());
        if (null == proRelatedPartiesVO) {
            return 0L;
        }
        // 相关方历史记录
        PmsRelatedHistoryPayload payload = new PmsRelatedHistoryPayload();
        payload.setRelateId(proRelatedPartiesVO.getId());
        payload.setExt1(proRelatedPartiesVO.getExt1());
        payload.setExt2(proRelatedPartiesVO.getExt2());
        payload.setExt3(proRelatedPartiesVO.getExt3());
        payload.setExt4(proRelatedPartiesVO.getExt4());
        // 如果没有传入sourceType，默认为手工修改
        if (null == sourceType) {
            sourceType = 3;
        }
        payload.setSourceType(sourceType);
        // 历史记录新增
        pmsRelatedHistoryService.insert(payload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<ProRelatedPartiesVO> iportForm(ProRelatedPartiesQuery proRelatedPartiesQuery) {

        List<ProRelatedPartiesVO> res = proRelatedPartiesDao.getList(proRelatedPartiesQuery);

        if (!CollectionUtils.isEmpty(res)) {
            List<Long> proRoleList = new ArrayList<>();


            List <Long> userIdList = res.stream().map(p -> p.getUserId()).collect(Collectors.toList());
            // 查询资源所有的资源规划
            List<PersonPlanDtlAndProjectVO> list = new ArrayList<>();
            if (!CollectionUtil.isEmpty(userIdList)) {
                ProRelatedPartiesQuery tempQuery = new ProRelatedPartiesQuery();
                tempQuery.setUserIdList(userIdList);
                List<ProRelatedPartiesVO> tempPartiesList = proRelatedPartiesDao.getList(tempQuery);
                Map<Long, Long> map = tempPartiesList.stream().collect(Collectors.toMap(ProRelatedPartiesVO::getId, ProRelatedPartiesVO::getUserId));
                List<Long> idList = tempPartiesList.stream().map(p -> p.getId()).collect(Collectors.toList());
                PersonPlanDtlQuery personPlanDtlQuery = new PersonPlanDtlQuery();
                personPlanDtlQuery.setRelatePartiesIdList(idList);
                List<PersonPlanDtlAndProjectVO> personPlanDtlAndProjectVOS = personPlanDtlService.queryByRelatePartiesId(personPlanDtlQuery);
                LocalDate startDate = proRelatedPartiesQuery.getStartDate();
                LocalDate endDate = proRelatedPartiesQuery.getEndDate();
                if (!CollectionUtil.isEmpty(personPlanDtlAndProjectVOS)) {
                    personPlanDtlAndProjectVOS.stream().forEach(p -> {
                        if(p.getProId().equals(proRelatedPartiesQuery.getProId())){
                            return;
                        }
                        boolean overlapping = isOverlapping(p.getStartDate(), p.getEndDate(), startDate, endDate);
                        if (overlapping) {
                            p.setUserId(map.get(p.getRelatePartiesId()));
                            list.add(p);
                        }
                    });
                }
            }

            Map<Long, List<PersonPlanDtlAndProjectVO>> listMap = list.stream().collect(Collectors.groupingBy(o -> o.getUserId()));

            PmsProjectRoleQuery pmsProjectRoleQuery = new PmsProjectRoleQuery();
            pmsProjectRoleQuery.setIds(proRoleList);
            // 获取项目角色列表
            List<PmsProjectRoleVO> pmsProjectRoleVOS = pmsProjectRoleService.queryListDynamic(pmsProjectRoleQuery);
            Map<Long, PmsProjectRoleVO> pmsProjectRoleVOMap = new HashMap<>();
            pmsProjectRoleVOS.stream().forEach(p -> {
                pmsProjectRoleVOMap.put(p.getId(), p);
            });
//            res.stream().forEach(p -> {
//                if (StringUtils.hasText(p.getProRole())) {
//                    String proRoleName = Arrays.stream(p.getProRole().split(",")).map(s -> pmsProjectRoleVOMap.get(Long.valueOf(s))).collect(Collectors.joining(","));
//                    p.setProRoleName(proRoleName);
//                }
//            });
            // 查询pms当量使用配置
            TwOutputUtil<List<ResourceCostStrategyVO>> listTwOutputUtil = resourceCostStrategyService.queryList(new ResourceCostStrategyQuery());
            List<ResourceCostStrategyVO> resourceCostStrategyVOList = listTwOutputUtil.getData();
            ResourceCostStrategyVO resourceCostStrategyVO = new ResourceCostStrategyVO();
            resourceCostStrategyVO.setType(1);
            if (CollUtil.isNotEmpty(resourceCostStrategyVOList)) {
                resourceCostStrategyVO = resourceCostStrategyVOList.get(0);
            }

            for (ProRelatedPartiesVO re : res) {
                if (StringUtils.hasText(re.getProRole())) {
                    List<String> collect = Arrays.stream(re.getProRole().split(",")).collect(Collectors.toList());
                    ArrayList<PmsProjectRoleVO> pmsProjectRoleVOS1 = new ArrayList<>();
                    for (String string : collect) {
                        PmsProjectRoleVO pmsProjectRoleVO = pmsProjectRoleVOMap.get(Long.valueOf(string));
                        pmsProjectRoleVOS1.add(pmsProjectRoleVO);
                    }
                    re.setProjectRoleVOList(pmsProjectRoleVOS1);
                }
                // 各资源的当量配置
                if (resourceCostStrategyVO.getType() == 1) {
                    re.setReferenceEqvaRatio(BigDecimal.ONE);
                }

                // 资源的相关项目的资源规划天数
                if (!CollectionUtil.isEmpty(listMap)) {
                    if (listMap.containsKey(re.getUserId())) {
                        List<PersonPlanDtlAndProjectVO> personPlanDtlAndProjectVOS1 = listMap.get(re.getUserId());
                        re.setPersonPlanDtlAndProjectVOList(personPlanDtlAndProjectVOS1);
                    }
                }
            }
        }
        return res;
    }

    private boolean isOverlapping(LocalDate date1, LocalDate date2, LocalDate startDate, LocalDate endDate) {
        // 确保 date1 <= date2 并且 startDate <= endDate
        if (date1.isAfter(date2) || startDate.isAfter(endDate)) {
            return false;
        }
        // 检查是否有重叠
        return !(date1.isAfter(endDate) || date2.isBefore(startDate));
    }


    @Override
    public Long count(ProRelatedPartiesQuery proRelatedPartiesQuery) {
        Long count = proRelatedPartiesDao.count(proRelatedPartiesQuery);
        return count;
    }


    /**
     * 翻译某些字段
     *
     * @param proRelatedPartiesVOList 一个包含项目相关方信息的列表，需要对其中的用户名称和角色名称进行翻译。
     */
    public void translate(List<ProRelatedPartiesVO> proRelatedPartiesVOList) {
        // 初始化用于存储角色ID的列表和角色名称的映射
        List<Long> proRoleList = new ArrayList<>();
        Map<Long, String> pmsProjectRoleVOMap = new HashMap<>();

        // 遍历列表，翻译用户名称
        proRelatedPartiesVOList.stream().forEach(p -> {
            if (null != p.getUserId()) {
                String userName = cacheUtil.getUserName(p.getUserId());
                p.setUserName(userName);
            }

            // 提取并存储角色ID
            if (StringUtils.hasText(p.getProRole())) {
                Arrays.stream(p.getProRole().split(",")).map(s -> proRoleList.add(Long.valueOf(s)));
            }
        });

        // 查询角色信息
        PmsProjectRoleQuery pmsProjectRoleQuery = new PmsProjectRoleQuery();
        pmsProjectRoleQuery.setIds(proRoleList);
        List<PmsProjectRoleVO> pmsProjectRoleVOS = pmsProjectRoleService.queryListDynamic(pmsProjectRoleQuery);

        // 建立角色ID与角色名称的映射
        pmsProjectRoleVOS.stream().forEach(p -> {
            pmsProjectRoleVOMap.put(p.getId(), p.getRoleName());
        });

        // 翻译角色名称
        proRelatedPartiesVOList.stream().forEach(p -> {
            if (StringUtils.hasText(p.getProRole())) {
                String proRoleName = Arrays.stream(p.getProRole().split(",")).map(s -> pmsProjectRoleVOMap.get(Long.valueOf(s))).collect(Collectors.joining(","));
                p.setProRoleName(proRoleName);
            }
        });
    }


    @Override
    public PagingVO<ProRelatedPartiesVO> relatePaging(ProRelatedPartiesQuery query) {

        Assert.notNull(query.getRelateId(), "相关方id不能为空");

        ProRelatedPartiesVO proRelatedPartiesVO = proRelatedPartiesDao.get(query.getRelateId());

//        proRelatedPartiesQuery.setProId(proRelatedPartiesVO.getProId());
        if (0 == proRelatedPartiesVO.getType()) {
            // 内部
            query.setUserId(proRelatedPartiesVO.getUserId());
        } else if (1 == proRelatedPartiesVO.getType()) {
            // 外部
            query.setExternalId(proRelatedPartiesVO.getExternalId());
        }

        PagingVO<ProRelatedPartiesVO> page = proRelatedPartiesDao.page(query);

        List<Long> proIds = page.getRecords().stream().map(x -> x.getProId()).collect(Collectors.toList());
        PmsProjectQuery pmsProjectQuery = new PmsProjectQuery();
        pmsProjectQuery.setIdList(proIds);
        List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryListDynamic(pmsProjectQuery);
        Map<Long, PmsProjectVO> pmsProjectVOMap = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getId, Function.identity(), (t1, t2) -> t1));

        page.getRecords().forEach(x -> {
            PmsProjectVO pmsProjectVO = pmsProjectVOMap.get(x.getProId());
            // 新增项目信息
            if (null != pmsProjectVO) {
                x.setProName(pmsProjectVO.getProjName());
                x.setProExt1(pmsProjectVO.getExt1());
                x.setPlanStartDate(x.getCreateTime());
                x.setPlanEndDate(pmsProjectVO.getPlanEndDate());

                x.setProExt1Desc(cacheUtil.transferSystemSelection("PMS:PROJECT:OTHER", x.getProExt1()));
            }

        });
        translate(page.getRecords());
        return page;
    }


    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(PmsProjectVO vo) {
//        vo.setContractFilesDatas(fileUtil.getFileDatas(vo.getContractFiles()));
//        vo.setSowFilesDatas(fileUtil.getFileDatas(vo.getSowFiles()));
//        vo.setBudgetFilesDatas(fileUtil.getFileDatas(vo.getBudgetFiles()));

//        vo.setCustIndustryName(cacheUtil.transferSystemSelection("crm:leads_customer_industry", vo.getCustIndustry()));
//        vo.setProjectTypeName(cacheUtil.transferSystemSelection("PMS:PROJECT:TYPE", vo.getProjectType()));
//        vo.setTimesheetPeriodName(cacheUtil.transferSystemSelection("PMS:PROJECT:TIMESHEET", vo.getTimesheetPeriod()));
//        vo.setProjectImportanceName(cacheUtil.transferSystemSelection("PMS:PROJECT:IMPORTANCE", vo.getProjectImportance()));
//        vo.setProjectDifficultyName(cacheUtil.transferSystemSelection("PMS:PROJECT;DIFFICULTY", vo.getProjectDifficulty()));
//        vo.setProjectStatusName(cacheUtil.transferSystemSelection("PMS:PROJECT:STATUS", vo.getProjectStatus()));
//        vo.setManagerUserName(cacheUtil.getUserName(vo.getManagerUserId()));
//        vo.setPmoManagerUserName(cacheUtil.getUserName(vo.getPmoManagerUserId()));
//        vo.setSaleManagerUserName(cacheUtil.getUserName(vo.getSaleManagerUserId()));
//        vo.setPayManagerUserName(cacheUtil.getUserName(vo.getPayManagerUserId()));
//        vo.setFinanceUserName(cacheUtil.getUserName(vo.getFinanceUserId()));
//        vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));

    }
}

