package com.elitesland.tw.tw5.server.prd.personplan.service.inter;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsCommunicatePlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsCommunicatePlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsCommunicatePlanVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;


import java.util.List;


/**
 * 项目沟通计划service
 * @author wangxl
 * @date 2024/4/1
 */
public interface PmsCommunicatePlanService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<PmsCommunicatePlanVO>> queryPage(PmsCommunicatePlanQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<PmsCommunicatePlanVO>> queryList(PmsCommunicatePlanQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(PmsCommunicatePlanQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<PmsCommunicatePlanVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsCommunicatePlanVO> insert(PmsCommunicatePlanPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsCommunicatePlanVO> update(PmsCommunicatePlanPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsCommunicatePlanVO> updateDynamic(PmsCommunicatePlanPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

}