package com.elitesland.tw.tw5.server.prd.pms.budget.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;
import com.elitesland.tw.tw5.server.common.Consts;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;


/**
 * 项目/预算/预算主表
 *
 * @author duwh
 * @date 2024/3/7
 */
@RestController
@RequestMapping(Consts.URI_PREFIX + "/wbsBudget")
@RequiredArgsConstructor
@Slf4j
@Api(value = "预算主表", tags = {"预算主表"})
public class PmsWbsBudgetController {

    private final PmsWbsBudgetService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsWbsBudgetVO>> page(PmsWbsBudgetQuery query) {
        PagingVO<PmsWbsBudgetVO> pagingVO = service.queryPage(query);
        return TwOutputUtil.ok(pagingVO);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsWbsBudgetVO>> list(PmsWbsBudgetQuery query) {
        List<PmsWbsBudgetVO> voList = service.queryList(query);
        return TwOutputUtil.ok(voList);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsWbsBudgetVO> queryByKey(Long id) {
        PmsWbsBudgetVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("根据项目 id获取预算详情")
    @GetMapping("/getByProIdAndVersionId")
    public TwOutputUtil<PmsWbsBudgetVO> getByProIdAndVersionId(Long proId, Long versionId) {
        PmsWbsBudgetVO vo = service.getByProIdAndVersionId(proId, versionId);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsWbsBudgetVO> insert(@RequestBody PmsWbsBudgetPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetController.insert】入参：" + payload.toString());
        PmsWbsBudgetVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsWbsBudgetVO> update(@RequestBody PmsWbsBudgetPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetController.update】入参：" + payload.toString());
        PmsWbsBudgetVO vo = service.update(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("应用人员规划-根据资源规划总额变更预算")
    @PostMapping("/updateByResPlan")
    public TwOutputUtil<BigDecimal> updateByResPlan(Long proId, Long budgetId) {
        BigDecimal vo = service.updateByResPlan(proId, budgetId);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsWbsBudgetVO> updateDynamic(@RequestBody PmsWbsBudgetPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetController.updateDynamic】入参：" + payload.toString());
        PmsWbsBudgetVO vo = service.updateDynamic(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsWbsBudgetController.deleteSoft】入参：" + ids);
        Long res = service.deleteSoft(ids);
        return TwOutputUtil.ok(res);
    }
}
