package com.elitesland.tw.tw5.server.prd.pms.budget.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetDetailsPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetDetailsQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetDetailsVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.budget.convert.PmsWbsBudgetDetailsConvert;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.repo.PmsWbsBudgetDetailsRepo;
import com.elitesland.tw.tw5.server.prd.pms.budget.model.entity.PmsWbsBudgetDetailsDO;
import com.elitesland.tw.tw5.server.prd.pms.budget.model.entity.QPmsWbsBudgetDetailsDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * 预算明细表dao
 * @author duwh
 * @date 2024/3/7
*/
@RequiredArgsConstructor
@Component
public class PmsWbsBudgetDetailsDao  {

    private static final QPmsWbsBudgetDetailsDO qdo = QPmsWbsBudgetDetailsDO.pmsWbsBudgetDetailsDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsWbsBudgetDetailsRepo repo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsWbsBudgetDetailsVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsWbsBudgetDetailsVO.class,
                qdo.id,
                qdo.tenantId,
                qdo.belongOrgId,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.tenantOrgId,
                qdo.remark,
                qdo.deleteFlag,
                qdo.budgetId,
                qdo.wbsId,
                qdo.wbsName,
                qdo.wbsCode,
                qdo.wbsStatus,
                qdo.versionId,
                qdo.versionNo,
                qdo.proId,
                qdo.effRelateId,
                qdo.resCost,
                qdo.allocatedResAmt,
                qdo.remainingResAmt,
                qdo.occupiedResAmt,
                qdo.settledResAmt,
                qdo.changeResAmt,
                qdo.changedAllocatedResAmt,
                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsWbsBudgetDetailsQuery query) {
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getBudgetId())) {
            jpaQuery.where(qdo.budgetId.eq(query.getBudgetId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsId())) {
            jpaQuery.where(qdo.wbsId.eq(query.getWbsId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsName())) {
            jpaQuery.where(qdo.wbsName.eq(query.getWbsName()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsCode())) {
            jpaQuery.where(qdo.wbsCode.eq(query.getWbsCode()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsSearch())) {
            jpaQuery.where(qdo.wbsName.like(com.elitesland.tw.tw5.server.common.util.SqlUtil.toSqlLikeString(query.getWbsSearch()))
                .or(qdo.wbsCode.like(com.elitesland.tw.tw5.server.common.util.SqlUtil.toSqlLikeString(query.getWbsSearch()))));
        }
        if (!ObjectUtils.isEmpty(query.getWbsStatus())) {
            jpaQuery.where(qdo.wbsStatus.eq(query.getWbsStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionId())) {
            jpaQuery.where(qdo.versionId.eq(query.getVersionId()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            jpaQuery.where(qdo.versionNo.eq(query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty(query.getProId())) {
            jpaQuery.where(qdo.proId.eq(query.getProId()));
        }
        if (!ObjectUtils.isEmpty(query.getEffRelateId())) {
            jpaQuery.where(qdo.effRelateId.eq(query.getEffRelateId()));
        }
        if (!ObjectUtils.isEmpty(query.getResCost())) {
            jpaQuery.where(qdo.resCost.eq(query.getResCost()));
        }
        if (!ObjectUtils.isEmpty(query.getAllocatedResAmt())) {
            jpaQuery.where(qdo.allocatedResAmt.eq(query.getAllocatedResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getRemainingResAmt())) {
            jpaQuery.where(qdo.remainingResAmt.eq(query.getRemainingResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getOccupiedResAmt())) {
            jpaQuery.where(qdo.occupiedResAmt.eq(query.getOccupiedResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getSettledResAmt())) {
            jpaQuery.where(qdo.settledResAmt.eq(query.getSettledResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getChangeResAmt())) {
            jpaQuery.where(qdo.changeResAmt.eq(query.getChangeResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getChangedAllocatedResAmt())) {
            jpaQuery.where(qdo.changedAllocatedResAmt.eq(query.getChangedAllocatedResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            jpaQuery.where(qdo.extString1.eq(query.getExtString1()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            jpaQuery.where(qdo.extString2.eq(query.getExtString2()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            jpaQuery.where(qdo.extString3.eq(query.getExtString3()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            jpaQuery.where(qdo.extString4.eq(query.getExtString4()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qdo.extString5.eq(query.getExtString5()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsWbsBudgetDetailsVO> queryPage(PmsWbsBudgetDetailsQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if(count == 0){
            return PagingVO.<PmsWbsBudgetDetailsVO>builder()
                    .total(count)
                    .records(Collections.emptyList())
                    .build();
        }
        JPAQuery<PmsWbsBudgetDetailsVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        SqlUtil.handlePage(jpaQuerySelect, query);
        jpaQuerySelect.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest() .getPageSize());
        return PagingVO.<PmsWbsBudgetDetailsVO>builder()
                .total(count)
                .records(jpaQuerySelect.fetch())
                .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsWbsBudgetDetailsVO> queryList(PmsWbsBudgetDetailsQuery query) {
        JPAQuery<PmsWbsBudgetDetailsVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsWbsBudgetDetailsQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count==null?0:count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsWbsBudgetDetailsVO queryByKey(Long id) {
        JPAQuery<PmsWbsBudgetDetailsVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsWbsBudgetDetailsVO save(PmsWbsBudgetDetailsPayload payload) {
        PmsWbsBudgetDetailsDO ado = PmsWbsBudgetDetailsConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsWbsBudgetDetailsConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsWbsBudgetDetailsDO> saveAll(List<PmsWbsBudgetDetailsDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsWbsBudgetDetailsPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getBudgetId() != null) {
            update.set(qdo.budgetId, payload.getBudgetId());
        }
        if (payload.getWbsId() != null) {
            update.set(qdo.wbsId, payload.getWbsId());
        }
        if (payload.getWbsName() != null) {
            update.set(qdo.wbsName, payload.getWbsName());
        }
        if (payload.getWbsCode() != null) {
            update.set(qdo.wbsCode, payload.getWbsCode());
        }
        if (payload.getWbsStatus() != null) {
            update.set(qdo.wbsStatus, payload.getWbsStatus());
        }
        if (payload.getVersionId() != null) {
            update.set(qdo.versionId, payload.getVersionId());
        }
        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        if (payload.getProId() != null) {
            update.set(qdo.proId, payload.getProId());
        }
        if (payload.getEffRelateId() != null) {
            update.set(qdo.effRelateId, payload.getEffRelateId());
        }
        if (payload.getResCost() != null) {
            update.set(qdo.resCost, payload.getResCost());
        }
        if (payload.getAllocatedResAmt() != null) {
            update.set(qdo.allocatedResAmt, payload.getAllocatedResAmt());
        }
        if (payload.getRemainingResAmt() != null) {
            update.set(qdo.remainingResAmt, payload.getRemainingResAmt());
        }
        if (payload.getOccupiedResAmt() != null) {
            update.set(qdo.occupiedResAmt, payload.getOccupiedResAmt());
        }
        if (payload.getSettledResAmt() != null) {
            update.set(qdo.settledResAmt, payload.getSettledResAmt());
        }
        if (payload.getChangeResAmt() != null) {
            update.set(qdo.changeResAmt, payload.getChangeResAmt());
        }
        if (payload.getChangedAllocatedResAmt() != null) {
            update.set(qdo.changedAllocatedResAmt, payload.getChangedAllocatedResAmt());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        // 处理要设置成空的字段(nullField处理)
        SqlUtil.handleNullFieldsUpdate(payload,qdo,update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

}
