package com.elitesland.tw.tw5.server.prd.pms.budget.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetDetailsPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetReleasePayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetDetailsQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetReleaseQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetDetailsService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetReleaseService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetVersionService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetDetailsVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetReleaseVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVersionVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsResourceQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActListService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsResourceService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsVersionService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsListVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsVersionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.budget.constants.BudgetVersionStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.budget.convert.PmsWbsBudgetDetailsConvert;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.PmsWbsBudgetDetailsDao;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;


/**
 * 预算明细表service impl
 *
 * @author duwh
 * @date 2024/3/7
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsWbsBudgetDetailsServiceImpl implements PmsWbsBudgetDetailsService {

    private final PmsWbsBudgetDetailsDao dao;
    private final PmsWbsBudgetVersionService pmsWbsBudgetVersionService;
    @Resource
    @Lazy
    private PmsWbsBudgetService pmsWbsBudgetService;
    private final PmsWbsVersionService pmsWbsVersionService;
    // private final PmsProjectWbsService pmsProjectWbsService;
    private final PmsProjectActListService pmsProjectActListService;
    private final PmsProjectWbsResourceService pmsProjectWbsResourceService;
    private final PmsProjectRoleService pmsProjectRoleService;
    private final PmsWbsBudgetReleaseService pmsWbsBudgetReleaseService;

    @Override
    public PagingVO<PmsWbsBudgetDetailsVO> queryPage(PmsWbsBudgetDetailsQuery query) {
        PagingVO<PmsWbsBudgetDetailsVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return pageVO;
    }

    @Override
    public List<PmsWbsBudgetDetailsVO> queryList(PmsWbsBudgetDetailsQuery query) {
        List<PmsWbsBudgetDetailsVO> listVO = dao.queryList(query);
        translate(listVO);
        return listVO;
    }

    @Override
    public long queryCount(PmsWbsBudgetDetailsQuery query) {
        return dao.queryCount(query);
    }

    @Override
    public PmsWbsBudgetDetailsVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsBudgetDetailsVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
        return vo;
    }

    @Override
    @Transactional
    public PmsWbsBudgetDetailsVO insert(PmsWbsBudgetDetailsPayload payload) {
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsBudgetDetailsVO save = dao.save(payload);
        // todo 开启工作流
        // startWorkFlow(ado);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsBudgetDetailsVO update(PmsWbsBudgetDetailsPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsBudgetDetailsVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsBudgetDetailsVO updateDynamic(PmsWbsBudgetDetailsPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return dao.deleteSoft(ids);
    }

    @Override
    @Transactional
    public PmsWbsBudgetVO init(PmsWbsBudgetDetailsPayload payload) {
        Long proId = payload.getProId();
        Assert.notNull(proId, "proId不能为空");

        // 查询V0版本数据
        Long budgetV0Count = countByProjectIdAndVersion(proId, 0);
        if (budgetV0Count < 1) {
            // 创建 V0版本数据
            PmsWbsBudgetVO oneBudget = createOneBudget(proId);
            return oneBudget;
        } else {
            // 查询预算版本
            PmsWbsBudgetVersionVO version = pmsWbsBudgetVersionService.getVersion(proId, BudgetVersionStatusEnum.CREATE.getCode());
            if (version == null) {
                PmsWbsBudgetVersionVO versionActive = pmsWbsBudgetVersionService.getVersion(proId, BudgetVersionStatusEnum.ACTIVE.getCode());
                PmsWbsBudgetVersionPayload versionPayload = new PmsWbsBudgetVersionPayload();
                versionPayload.setProId(proId);
                versionPayload.setVersionNo(versionActive.getVersionNo() + 1);
                versionPayload.setStepNum(3);
                versionPayload.setObjectStatus(BudgetVersionStatusEnum.CREATE.getCode());
                // 下一个版本
                version = pmsWbsBudgetVersionService.insert(versionPayload);
            }
            // 创建预算新版本
            // 拷贝 V0版本数据 创建 V1版本    // 拷贝预算主表、明细表数据
            PmsWbsBudgetVO budgetVO = copyOneAndCreateNext(proId, version);
            return budgetVO;
        }
    }

    /**
     * 复制一个并创建下一个
     * <p>
     * 查询 wbs最新版本信息
     * <p>
     * // 对比预算明细中老活动数据与新版（临时版未激活最新）活动数据状态差异
     * <p>
     * // （激活-变取消）有差异的数据 插入预算释放表
     *
     * @param proId            亲id
     * @param wbsBudgetVersion 下个预算版本
     * @return {@link PmsWbsBudgetVO}
     */
    private PmsWbsBudgetVO copyOneAndCreateNext(Long proId, PmsWbsBudgetVersionVO wbsBudgetVersion) {
        Assert.notNull(wbsBudgetVersion, "budgetVersionVO不能为空");
        Long budgetVersionVOId = wbsBudgetVersion.getId();
        PmsWbsBudgetQuery pmsWbsBudgetQueryOld = new PmsWbsBudgetQuery();
        pmsWbsBudgetQueryOld.setProId(proId);
        pmsWbsBudgetQueryOld.setVersionId(budgetVersionVOId);
        List<PmsWbsBudgetVO> budgetVoListOld = pmsWbsBudgetService.queryList(pmsWbsBudgetQueryOld);
        // 如果当前版本已存在，则只更新预算明细
        if (!CollectionUtils.isEmpty(budgetVoListOld)) {
            PmsWbsBudgetVO budgetVO = budgetVoListOld.get(0);

            PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
            Long budgetVOId = budgetVO.getId();
            detailsQuery.setBudgetId(budgetVOId);
            // detailsQuery.setVersionNo(0);
            List<PmsWbsBudgetDetailsVO> pmsWbsBudgetDetailsVOS = queryList(detailsQuery);
            List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList = PmsWbsBudgetDetailsConvert.INSTANCE.vtpList(pmsWbsBudgetDetailsVOS);
            // 查询新版活动数据 比对是否有新增
            // 查询最新版 wbs数据
            PmsWbsVersionVO wbsVersion = pmsWbsVersionService.getVersion(proId);
            PmsProjectWbsQuery pmsProjectWbsQuery = new PmsProjectWbsQuery();
            final Long versionId = wbsVersion.getId();
            pmsProjectWbsQuery.setVersionId(versionId);
            pmsProjectWbsQuery.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
            List<PmsProjectWbsListVO> wbsList = pmsProjectActListService.queryList(pmsProjectWbsQuery);

            // 处理新增的活动
            if (!CollectionUtils.isEmpty(wbsList)) {
                List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadListTemp = budgetDetailsPayloadList;
                List<PmsWbsBudgetDetailsPayload> newDetailPayloadList = new ArrayList<>();
                for (PmsProjectWbsListVO wbs : wbsList) {
                    Long wbsId = wbs.getId();

                    // 新活动的话
                    newWbsDataProcess(proId, wbsBudgetVersion, wbs, budgetDetailsPayloadListTemp, budgetDetailsPayloadList, wbsId, versionId, budgetVOId, newDetailPayloadList);
                    // 以上新增活动数据已处理完


                    // 处理修改的数据
                    PmsWbsBudgetDetailsPayload budgetDetailsPayload = budgetDetailsPayloadListTemp.stream()
                        // wbs.getEffRelateId() 为空代表新增的活动数据
                        .filter(details -> wbs.getEffRelateId() != null && details.getWbsId().equals(wbs.getId())).findFirst().orElse(null);
                    if (null != budgetDetailsPayload) {
                        budgetDetailsPayloadList.stream().filter(details -> details.getWbsId().equals(budgetDetailsPayload.getWbsId())).forEach(details -> {
                            details.setWbsName(wbs.getWbsName());
                            details.setWbsCode(wbs.getWbsCode());
                            details.setWbsStatus(wbs.getWbsStatus());
                            details.setWbsId(wbsId);
                            // 重新计算成本
                            PmsWbsBudgetDetailsPayload budgetDetail = getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, budgetVOId, wbsBudgetVersion);
                            details.setResCost(budgetDetail.getResCost());
                        });
                    }

                }
                if (!CollectionUtils.isEmpty(newDetailPayloadList)) {
                    budgetDetailsPayloadList.addAll(newDetailPayloadList);
                }
            }

            List<PmsWbsBudgetDetailsVO> detailsVOS = insertAll(budgetDetailsPayloadList);
            budgetVO.setDetails(detailsVOS);

            //TODO 查询释放表是否有数据 有数据 更新数据
            PmsWbsBudgetReleaseQuery budgetReleaseQuery = new PmsWbsBudgetReleaseQuery();
            budgetReleaseQuery.setProId(budgetVO.getProId());
            budgetReleaseQuery.setVersionId(budgetVersionVOId);
            List<PmsWbsBudgetReleaseVO> budgetReleaseVOS = pmsWbsBudgetReleaseService.queryList(budgetReleaseQuery);


            // 比对 新版 wbs 与 预算数据差异 主要是 wbs状态
            // 处理取消的活动
            List<PmsProjectWbsListVO> wbsCancelList = wbsList.stream().filter(
                wbs -> wbs.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode())
                    && !(wbs.getReleaseFlag() != null && wbs.getReleaseFlag().equals(true))
            ).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(wbsCancelList) && !CollectionUtils.isEmpty(detailsVOS)) {
                List<PmsWbsBudgetReleasePayload> releaseList = new ArrayList<>();
                // 查询预算明细数据
                for (PmsProjectWbsListVO wbs : wbsCancelList) {
                    // 如果预算释放表中budgetReleaseVOS存在过wbs.id，则跳过
                    if (!CollectionUtils.isEmpty(budgetReleaseVOS) && budgetReleaseVOS.stream().anyMatch(budgetReleaseVO -> budgetReleaseVO.getWbsId().equals(wbs.getId()))) {
                        continue;
                    }

                    List<PmsWbsBudgetDetailsVO> detailRelaseList = detailsVOS.stream().filter(details -> details.getWbsId().equals(wbs.getId())).collect(Collectors.toList());
                    List<PmsWbsBudgetReleasePayload> releasePayloadList = detailRelaseList.stream().map(details -> {
                        PmsWbsBudgetReleasePayload releasePayload = new PmsWbsBudgetReleasePayload();
                        releasePayload.setWbsId(wbs.getId());
                        releasePayload.setProId(proId);
                        releasePayload.setAllocatedResAmtBefore(details.getAllocatedResAmt());
                        releasePayload.setAllocatedResAmtBefore(details.getAllocatedResAmt());
                        // settledResAmtBefore
                        releasePayload.setSettledResAmtBefore(details.getSettledResAmt());
                        releasePayload.setOccupiedResAmtBefore(details.getOccupiedResAmt());
                        releasePayload.setRemainingResAmtBefore(details.getRemainingResAmt());
                        // releasePayload.setChangeResAmt(BigDecimal.ZERO);
                        // releasePayload.setAllocatedResAmtAfter(BigDecimal.ZERO);
                        // releasePayload.setOccupiedResAmtAfter(BigDecimal.ZERO);
                        // releasePayload.setRemainingResAmtAfter(BigDecimal.ZERO);
                        // releasePayload.setSettledResAmtAfter(BigDecimal.ZERO);
                        releasePayload.setVersionId(budgetVersionVOId);
                        return releasePayload;
                    }).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(releasePayloadList)) {
                        releaseList.addAll(releasePayloadList);
                    }
                }
                List<PmsWbsBudgetReleaseVO> releaseVOS = pmsWbsBudgetReleaseService.insertAll(releaseList);
                log.debug("预算释放表：budgetDetailsVO:{}", releaseVOS);
                budgetVO.setReleases(releaseVOS);
            }
            PmsWbsBudgetReleaseQuery releaseQuery = new PmsWbsBudgetReleaseQuery();
            releaseQuery.setProId(proId);
            releaseQuery.setVersionId(budgetVersionVOId);
            long releaseCount = pmsWbsBudgetReleaseService.queryCount(releaseQuery);
            budgetVO.setReleasesCount(releaseCount);
            return budgetVO;
        } else {

            // 以 V0为基准，复制一份数据

            PmsWbsBudgetQuery pmsWbsBudgetQuery = new PmsWbsBudgetQuery();
            pmsWbsBudgetQuery.setProId(proId);
            pmsWbsBudgetQuery.setVersionNo(0);
            List<PmsWbsBudgetVO> budgetVoList = pmsWbsBudgetService.queryList(pmsWbsBudgetQuery);
            // budgetVoList转为 map

            if (CollectionUtils.isEmpty(budgetVoList)) {
                throw  TwException.error("","V0版本数据不存在");
            }
            if (budgetVoList.size() > 1) {
                throw  TwException.error("","V0版本数据异常");
            }
            final Long budgetVersionId = wbsBudgetVersion.getId();
            final Integer budgetVersionNo = wbsBudgetVersion.getVersionNo();

            // List<PmsWbsBudgetPayload> newBudgetList = new ArrayList<>();
            // 复制主表
            // for (PmsWbsBudgetVO budgetVO : budgetVoList) {
            //     PmsWbsBudgetPayload budgetPayload = new PmsWbsBudgetPayload();
            //     BeanUtils.copyProperties(budgetVO, budgetPayload);
            //     budgetPayload.setId(null);
            //     budgetPayload.setVRelateId(budgetVO.getId());
            //     budgetPayload.setVersionId(wbsBudgetVersion.getId());
            //     budgetPayload.setVersionNo(wbsBudgetVersion.getVersionNo());
            //     newBudgetList.add(budgetPayload);
            // }
            // 复制V0主表,生成新版本数据
            List<PmsWbsBudgetPayload> newBudgetList = budgetVoList.stream().map(budget -> {
                PmsWbsBudgetPayload budgetPayload = new PmsWbsBudgetPayload();
                BeanUtils.copyProperties(budget, budgetPayload);
                budgetPayload.setId(null);
                budgetPayload.setEffRelateId(budget.getId());
                budgetPayload.setVersionId(budgetVersionId);
                budgetPayload.setVersionNo(budgetVersionNo);
                return budgetPayload;
            }).collect(Collectors.toList());

            List<PmsWbsBudgetVO> wbsBudgetVOS = pmsWbsBudgetService.insertAll(newBudgetList);
            PmsWbsBudgetVO budgetVO = wbsBudgetVOS.get(0);
            Long newBudgetId = budgetVO.getId();
            // 复制明细表
            // for (PmsWbsBudgetVO wbsBudgetVO : wbsBudgetVOS) {
            // 原预算主表 id
            Long effRelateId = budgetVO.getEffRelateId();
            PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
            detailsQuery.setBudgetId(effRelateId);
            // detailsQuery.setVersionNo(0);
            List<PmsWbsBudgetDetailsVO> pmsWbsBudgetDetailsVOS = queryList(detailsQuery);
            List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList = pmsWbsBudgetDetailsVOS.stream().map(detailsVO -> {
                PmsWbsBudgetDetailsPayload detailsPayload = new PmsWbsBudgetDetailsPayload();
                BeanUtils.copyProperties(detailsVO, detailsPayload);
                detailsPayload.setId(null);
                detailsPayload.setBudgetId(newBudgetId);
                detailsPayload.setEffRelateId(detailsVO.getId());
                detailsPayload.setVersionId(budgetVersionId);
                detailsPayload.setVersionNo(budgetVersionNo);
                // WBS Id 为 V0版本主键
                return detailsPayload;
            }).collect(Collectors.toList());

            // 查询新版活动数据 比对是否有新增
            // 查询最新版 wbs数据
            PmsWbsVersionVO wbsVersion = pmsWbsVersionService.getVersion(proId);
            PmsProjectWbsQuery pmsProjectWbsQuery = new PmsProjectWbsQuery();
            final Long versionId = wbsVersion.getId();
            pmsProjectWbsQuery.setVersionId(versionId);
            pmsProjectWbsQuery.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
            List<PmsProjectWbsListVO> wbsList = pmsProjectActListService.queryList(pmsProjectWbsQuery);

            // 处理新增的活动
            if (!CollectionUtils.isEmpty(wbsList)) {
                List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadListTemp = budgetDetailsPayloadList;
                List<PmsWbsBudgetDetailsPayload> newDetailPayloadList = new ArrayList<>();
                for (PmsProjectWbsListVO wbs : wbsList) {
                    Long wbsId = wbs.getId();
                    // 新活动的话
                    newWbsDataProcess(proId, wbsBudgetVersion, wbs, budgetDetailsPayloadListTemp, budgetDetailsPayloadList, wbsId, versionId, newBudgetId, newDetailPayloadList);
                    // 以上新增活动数据已处理完

                    // 处理修改的数据
                    PmsWbsBudgetDetailsPayload budgetDetailsPayload = budgetDetailsPayloadListTemp.stream()
                        // wbs.getEffRelateId() 为空代表新增的活动数据
                        .filter(details -> wbs.getEffRelateId() != null && details.getWbsId().equals(wbs.getEffRelateId())).findFirst().orElse(null);
                    if (null != budgetDetailsPayload) {
                        budgetDetailsPayloadList.stream().filter(details -> details.getWbsId().equals(budgetDetailsPayload.getWbsId())).forEach(details -> {
                            details.setWbsName(wbs.getWbsName());
                            details.setWbsCode(wbs.getWbsCode());
                            details.setWbsStatus(wbs.getWbsStatus());
                            details.setWbsId(wbsId);
                            // 重新计算成本
                            PmsWbsBudgetDetailsPayload budgetDetail = getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, newBudgetId, wbsBudgetVersion);
                            details.setResCost(budgetDetail.getResCost());
                        });
                    }

                    // // TODO duwh 比对wbs版本之间数据是否正确
                    // PmsWbsBudgetDetailsPayload budgetDetailsPayload = budgetDetailsPayloadListTemp.stream()
                    //     // wbs.getEffRelateId() 为空代表新增的活动数据
                    //     .filter(details -> wbs.getEffRelateId() != null && details.getWbsId().equals(wbs.getEffRelateId())).findFirst().orElse(null);
                    // Long wbsId = wbs.getId();
                    // if (budgetDetailsPayload == null) {
                    //     // TODO duwh id是否取对应该版本的活动id
                    //     // Long wbsId = wbs.getEffRelateId() != null ? wbs.getEffRelateId() : wbs.getId();
                    //     // 计算资源成本
                    //     PmsWbsBudgetDetailsPayload budgetDetail = getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, newBudgetId, wbsBudgetVersion);
                    //     newDetailPayloadList.add(budgetDetail);
                    // } else {
                    //     budgetDetailsPayloadList.stream().filter(details -> details.getWbsId().equals(budgetDetailsPayload.getWbsId())).forEach(details -> {
                    //         details.setWbsName(wbs.getWbsName());
                    //         details.setWbsCode(wbs.getWbsCode());
                    //         details.setWbsStatus(wbs.getWbsStatus());
                    //         details.setWbsId(wbsId);
                    //
                    //         // 重新计算成本
                    //         PmsWbsBudgetDetailsPayload budgetDetail = getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, newBudgetId, wbsBudgetVersion);
                    //         details.setResCost(budgetDetail.getResCost());
                    //     });
                    // }
                }
                if (!CollectionUtils.isEmpty(newDetailPayloadList)) {
                    budgetDetailsPayloadList.addAll(newDetailPayloadList);
                }
            }

            List<PmsWbsBudgetDetailsVO> detailsVOS = insertAll(budgetDetailsPayloadList);
            budgetVO.setDetails(detailsVOS);
            // }

            //TODO 查询释放表是否有数据 有数据 更新数据
            PmsWbsBudgetReleaseQuery budgetReleaseQuery = new PmsWbsBudgetReleaseQuery();
            budgetReleaseQuery.setProId(budgetVO.getProId());
            budgetReleaseQuery.setVersionId(budgetVersionVOId);
            List<PmsWbsBudgetReleaseVO> budgetReleaseVOS = pmsWbsBudgetReleaseService.queryList(budgetReleaseQuery);

            // 比对 新版 wbs 与 预算数据差异 主要是 wbs状态
            // 处理取消的活动
            List<PmsProjectWbsListVO> wbsCancelList = wbsList.stream().filter(
                wbs -> wbs.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode())
                    && !(wbs.getReleaseFlag() != null && wbs.getReleaseFlag().equals(true))
            ).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(wbsCancelList) && !CollectionUtils.isEmpty(detailsVOS)) {

                List<PmsWbsBudgetReleasePayload> releaseList = new ArrayList<>();
                // 查询预算明细数据
                for (PmsProjectWbsListVO wbs : wbsCancelList) {
                    // 如果预算释放表中budgetReleaseVOS存在过wbs.id，则跳过
                    if (!CollectionUtils.isEmpty(budgetReleaseVOS) && budgetReleaseVOS.stream().anyMatch(budgetReleaseVO -> budgetReleaseVO.getWbsId().equals(wbs.getId()))) {
                        continue;
                    }
                    List<PmsWbsBudgetDetailsVO> detailRelaseList = detailsVOS.stream().filter(details -> details.getWbsId().equals(wbs.getId())).collect(Collectors.toList());
                    List<PmsWbsBudgetReleasePayload> releasePayloadList = detailRelaseList.stream().map(details -> {
                        PmsWbsBudgetReleasePayload releasePayload = new PmsWbsBudgetReleasePayload();
                        releasePayload.setWbsId(wbs.getId());
                        releasePayload.setProId(proId);
                        releasePayload.setAllocatedResAmtBefore(details.getAllocatedResAmt());
                        // settledResAmtBefore
                        releasePayload.setSettledResAmtBefore(details.getSettledResAmt());
                        releasePayload.setOccupiedResAmtBefore(details.getOccupiedResAmt());
                        releasePayload.setRemainingResAmtBefore(details.getRemainingResAmt());
                        // releasePayload.setChangeResAmt(BigDecimal.ZERO);
                        // releasePayload.setAllocatedResAmtAfter(BigDecimal.ZERO);
                        // releasePayload.setOccupiedResAmtAfter(BigDecimal.ZERO);
                        // releasePayload.setRemainingResAmtAfter(BigDecimal.ZERO);
                        // releasePayload.setSettledResAmtAfter(BigDecimal.ZERO);
                        releasePayload.setVersionId(budgetVersionId);
                        return releasePayload;
                    }).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(releasePayloadList)) {
                        releaseList.addAll(releasePayloadList);
                    }
                }
                List<PmsWbsBudgetReleaseVO> releaseVOS = pmsWbsBudgetReleaseService.insertAll(releaseList);
                log.debug("预算释放表：budgetDetailsVO:{}", releaseVOS);
                budgetVO.setReleases(releaseVOS);
            }
            PmsWbsBudgetReleaseQuery releaseQuery = new PmsWbsBudgetReleaseQuery();
            releaseQuery.setProId(proId);
            releaseQuery.setVersionId(budgetVersionVOId);
            long releaseCount = pmsWbsBudgetReleaseService.queryCount(releaseQuery);
            budgetVO.setReleasesCount(releaseCount);
            return budgetVO;
        }
    }

    private void newWbsDataProcess(Long proId, PmsWbsBudgetVersionVO budgetVersionVO, PmsProjectWbsListVO wbs, List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadListTemp, List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList, Long wbsId, Long versionId, Long budgetVOId, List<PmsWbsBudgetDetailsPayload> newDetailPayloadList) {
        if (wbs.getEffRelateId() == null) {
            // 判断是否已存在
            List<PmsWbsBudgetDetailsPayload> list = budgetDetailsPayloadListTemp.stream().filter(details -> details.getWbsId().equals(wbs.getId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                if (list.size() > 1) {
                    throw TwException.error("", "数据异常");
                }
                // 已存在
                PmsWbsBudgetDetailsPayload pmsWbsBudgetDetailsPayload = list.get(0);
                // 更新
                budgetDetailsPayloadList.stream().filter(details -> details.getWbsId().equals(pmsWbsBudgetDetailsPayload.getWbsId())).forEach(details -> {
                    details.setWbsName(wbs.getWbsName());
                    details.setWbsCode(wbs.getWbsCode());
                    details.setWbsStatus(wbs.getWbsStatus());
                    details.setWbsId(wbsId);
                    // 重新计算成本
                    PmsWbsBudgetDetailsPayload budgetDetail = getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, budgetVOId, budgetVersionVO);
                    details.setResCost(budgetDetail.getResCost());
                });
            } else {
                // 新增一次
                PmsWbsBudgetDetailsPayload budgetDetail = getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, budgetVOId, budgetVersionVO);
                newDetailPayloadList.add(budgetDetail);
            }
        }
    }

    @Override
    @Transactional
    public List<PmsWbsBudgetDetailsVO> insertAll(List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList) {
        List<PmsWbsBudgetDetailsVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(budgetDetailsPayloadList)) {
            budgetDetailsPayloadList.forEach(budgetDetailsPayload -> {
                PmsWbsBudgetDetailsVO budgetDetailsVO = dao.save(budgetDetailsPayload);

                // 如果是临时保存预算数据 且
                // if (budgetDetailsVO.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode())) {
                //
                // }
                list.add(budgetDetailsVO);
            });
        }
        return list;
    }

    @Override
    @Transactional
    public List<PmsWbsBudgetDetailsVO> submit(List<PmsWbsBudgetDetailsPayload> list) {
        if (!CollectionUtils.isEmpty(list)) {
            PmsWbsBudgetDetailsPayload budgetDetailsPayload = list.get(0);
            Long versionId = budgetDetailsPayload.getVersionId();
            Long proId = budgetDetailsPayload.getProId();
            PmsWbsBudgetVersionVO pmsWbsBudgetVersionVO = pmsWbsBudgetVersionService.queryByKey(versionId);
            if (pmsWbsBudgetVersionVO.getObjectStatus().equals(BudgetVersionStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "当前版本已激活，不能提交");
            }
            Long budgetId = budgetDetailsPayload.getBudgetId();

            // 查询预算总费用
            PmsWbsBudgetVO budgetVO = pmsWbsBudgetService.queryByKey(budgetId);
            BigDecimal totalResAmt = budgetVO.getTotalResAmt() == null ? BigDecimal.ZERO : budgetVO.getTotalResAmt();
            BigDecimal totalFeeAmt = budgetVO.getTotalFeeAmt();
            totalFeeAmt = totalFeeAmt == null ? BigDecimal.ZERO : totalFeeAmt;

            // BigDecimal totalRemainingResAmt = budgetVO.getTotalRemainingResAmt();
            // if (null == totalRemainingResAmt) {
            //
            //     BigDecimal totalResAmt = budgetVO.getTotalResAmt() == null ? BigDecimal.ZERO : budgetVO.getTotalResAmt();
            //     BigDecimal totalOccupiedResAmt = budgetVO.getTotalOccupiedResAmt() == null ? BigDecimal.ZERO : budgetVO.getTotalOccupiedResAmt();
            //     BigDecimal totalSettledResAmtDb = budgetVO.getTotalSettledResAmt() == null ? BigDecimal.ZERO : budgetVO.getTotalSettledResAmt();
            //     // 剩余资源预算（含待分配）= 资源总预算 - 已占用 - 已结算
            //     totalRemainingResAmt = totalResAmt.subtract(totalOccupiedResAmt).subtract(totalSettledResAmtDb);
            // }
            //1. 验证“资源总预算”、“费用总预算”、“分配预算”是否均>=0; 否时拦截“{字段名}需>=0”
            // totalRemainingResAmt 小于 0 抛异常
            if (totalResAmt.compareTo(BigDecimal.ZERO) < 0) {
                throw TwException.error("", "资源总预算需>=0");
            }
            // BigDecimal totalRemainingFeeAmt = budgetVO.getTotalRemainingFeeAmt();
            // if (null == totalRemainingFeeAmt) {
            //     BigDecimal totalFeeAmt = budgetVO.getTotalFeeAmt() == null ? BigDecimal.ZERO : budgetVO.getTotalFeeAmt();
            //     BigDecimal totalOccupiedFeeAmt = budgetVO.getTotalOccupiedFeeAmt() == null ? BigDecimal.ZERO : budgetVO.getTotalOccupiedFeeAmt();
            //     BigDecimal getTotalSettledFeeAmtDb = budgetVO.getTotalSettledFeeAmt() == null ? BigDecimal.ZERO : budgetVO.getTotalSettledFeeAmt();
            //     // 剩余资源预算（含待分配）= 资源总预算 - 已占用 - 已结算
            //     totalRemainingFeeAmt = totalFeeAmt.subtract(totalOccupiedFeeAmt).subtract(getTotalSettledFeeAmtDb);
            // }
            // totalFeeAmt 需要小于 0
            if (totalFeeAmt.compareTo(BigDecimal.ZERO) < 0) {
                throw TwException.error("", "费用总预算需>=0");
            }
            // 获取明细中的分配预算之和
            BigDecimal allocatedBudgetSum = list.stream().map(pmsWbsBudgetDetailsPayload -> {
                BigDecimal allocateResAmt = pmsWbsBudgetDetailsPayload.getAllocatedResAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetDetailsPayload.getAllocatedResAmt();
                BigDecimal changeResAmt = pmsWbsBudgetDetailsPayload.getChangeResAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetDetailsPayload.getChangeResAmt();
                return allocateResAmt.add(changeResAmt);
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 2. 验证“分配预算”列的数据的和是否 =< 资源总预算 ；否时拦截“各活动的分配预算之需 =< 资源总预算
            // allocatedBudgetSum 大于totalResAmt 报错
            if (allocatedBudgetSum.compareTo(totalResAmt) > 0) {
                throw TwException.error("", "分配预算合计值 =< 资源总预算");
            }
            // 2. 本次计划变更被取消的活动，是否都释放了预算，否时拦截“需要释放所有被取消活动的预算”
            PmsWbsBudgetReleaseQuery budgetReleaseQuery = new PmsWbsBudgetReleaseQuery();
            budgetReleaseQuery.setProId(budgetVO.getProId());
            budgetReleaseQuery.setVersionId(versionId);
            List<PmsWbsBudgetReleaseVO> budgetReleaseVOS = pmsWbsBudgetReleaseService.queryList(budgetReleaseQuery);
            if (!CollectionUtils.isEmpty(budgetReleaseVOS)) {
                // 校验是否都释放了预算
                budgetReleaseVOS.forEach(budgetReleaseVO -> {
                    BigDecimal confirmSettledRes = budgetReleaseVO.getConfirmSettledRes() == null ? BigDecimal.ZERO : budgetReleaseVO.getConfirmSettledRes();
                    BigDecimal occupiedResAmtBefore = budgetReleaseVO.getOccupiedResAmtBefore() == null ? BigDecimal.ZERO : budgetReleaseVO.getOccupiedResAmtBefore();
                    if (confirmSettledRes.compareTo(occupiedResAmtBefore) != 0) {
                        log.error("需要释放所有被取消活动的预算;getWbsId:{};getWbsName:{};getWbsCode:{}", budgetReleaseVO.getWbsId(), budgetReleaseVO.getWbsName(), budgetReleaseVO.getWbsCode());
                        log.error("需要释放所有被取消活动的预算;confirmSettledRes:{};occupiedResAmtBefore:{};", confirmSettledRes, occupiedResAmtBefore);
                        throw TwException.error("", "需要释放所有被取消活动的预算");
                    }
                });
            }
            // 校验通过后 更新预算版本状态为激活
            // 更新预算版本状态为激活
            PmsWbsBudgetVersionPayload versionPayload = new PmsWbsBudgetVersionPayload();
            versionPayload.setId(versionId);
            versionPayload.setObjectStatus(BudgetVersionStatusEnum.ACTIVE.getCode());
            pmsWbsBudgetVersionService.updateDynamic(versionPayload);

            // 取预算释放中的数据，更新wbs的释放状态为已释放
            PmsWbsBudgetReleaseQuery releaseQuery = new PmsWbsBudgetReleaseQuery();
            releaseQuery.setProId(proId);
            releaseQuery.setVersionId(versionId);
            List<PmsWbsBudgetReleaseVO> pmsWbsBudgetReleaseVOS = pmsWbsBudgetReleaseService.queryList(releaseQuery);
            if (!CollectionUtils.isEmpty(pmsWbsBudgetReleaseVOS)) {
                List<Long> updateWbsIdList = pmsWbsBudgetReleaseVOS.stream().map(PmsWbsBudgetReleaseVO::getWbsId).collect(Collectors.toList());
                // 更新当前版本
                pmsProjectActListService.updateReleaseFlag(updateWbsIdList);

                // 更新 V0的状态
                PmsProjectWbsQuery wbsQuery = new PmsProjectWbsQuery();
                wbsQuery.setIdList(updateWbsIdList);
                List<PmsProjectWbsListVO> pmsProjectWbsListVOS = pmsProjectActListService.queryList(wbsQuery);
                List<Long> updateWbsIdListVersionZero = pmsProjectWbsListVOS.stream().map(PmsProjectWbsListVO::getEffRelateId).collect(Collectors.toList());
                pmsProjectActListService.updateReleaseFlag(updateWbsIdListVersionZero);
                //因为 wbs提交后，即刻生成新版本，所以已取消的活动（预算释放标记）没有更新到新版本中
                // 更新 下个版本的状态
                pmsProjectActListService.updateReleaseFlagByEffRelateId(updateWbsIdListVersionZero);
            }
            // 更新本版本的预算总表信息
            // 更新主表预算信息
            calculateMainTableInformation(budgetId);

            // TODO duwh 校验 1
            // 变更后分配预算合计值 =< 当前资源总预算，否时拦截“活动的分配预算之需 =< 资源总预算”

            // 校验2 本次计划变更被取消的活动，是否都释放了预算，否时拦截“需要释放所有被取消活动的预算”

            // 查询 V0版本预算主表信息
            // 查询 V0  还是查询上个版本？  effRelateId永远是V0版本的id
            Long effRelateIdV0Id = budgetVO.getEffRelateId();
            if (effRelateIdV0Id != null) {
                PmsWbsBudgetVO budgetZeroVersion = pmsWbsBudgetService.queryByKey(effRelateIdV0Id);

                // 覆盖 V0预算主表
                log.debug("V0版本预算主表：budgetZeroVersion:{}", budgetZeroVersion);
                PmsWbsBudgetPayload budgetPayload = new PmsWbsBudgetPayload();
                BeanUtils.copyProperties(budgetVO, budgetPayload);
                budgetPayload.setId(effRelateIdV0Id);
                budgetPayload.setVersionId(budgetZeroVersion.getVersionId());
                budgetPayload.setVersionNo(budgetZeroVersion.getVersionNo());
                pmsWbsBudgetService.updateDynamic(budgetPayload);


                // 查询上个最新版本的 wbs ； 转换 wbsId为 effRelateId
                // 处理预算明细中的活动主键 wbsId为 V0版本的 id
                PmsProjectWbsQuery wbsQuery = new PmsProjectWbsQuery();
                List<Long> idList = list.stream().map(PmsWbsBudgetDetailsPayload::getWbsId).collect(Collectors.toList());
                wbsQuery.setIdList(idList);
                List<PmsProjectWbsListVO> pmsProjectWbsListVOS = pmsProjectActListService.queryList(wbsQuery);
                // 把 list 中 wbsId与pmsProjectWbsListVOS id对应的数据 effRelateId更新到 list的 wbsId中
                list.forEach(payload -> {
                    PmsProjectWbsListVO pmsProjectWbsListVO = pmsProjectWbsListVOS.stream().filter(wbsListVO -> wbsListVO.getId().equals(payload.getWbsId()))
                        .findFirst().orElse(null);
                    if (pmsProjectWbsListVO != null) {
                        payload.setWbsId(pmsProjectWbsListVO.getEffRelateId());
                    }
                });
                // 持久化数据
                List<PmsWbsBudgetDetailsVO> detailsVOS = insertAll(list);

                // 查询 V0版本预算明细表信息
                PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
                detailsQuery.setBudgetId(budgetZeroVersion.getEffRelateId());
                List<PmsWbsBudgetDetailsVO> detailsZeroList = queryList(detailsQuery);
                // 比对 detailsZeroList有 detailsVOS没有的数据
                // detailsZeroList.forEach(detailZero -> {
                //     boolean flag = detailsVOS.stream().anyMatch(detail -> detail.getWbsId().equals(detailZero.getWbsId()));
                //     if (!flag) {
                //         // 不存在，删除
                //         deleteSoft(Arrays.asList(detailZero.getId()));
                //     }
                // });
                // 覆盖 V0版本中的预算明细
                // detailsVOS 根据 effRelateId 匹配 detailsZeroList 更新 V0版本 budgetId和其他信息
                detailsVOS.forEach(detail -> {
                    PmsWbsBudgetDetailsVO detailZero = detailsZeroList.stream().filter(detailZeroTemp -> detailZeroTemp.getId().equals(detail.getEffRelateId())).findFirst().orElse(null);
                    // 匹配上修改
                    if (detailZero != null) {
                        PmsWbsBudgetDetailsPayload detailsPayload = new PmsWbsBudgetDetailsPayload();
                        BeanUtils.copyProperties(detail, detailsPayload);
                        detailsPayload.setId(detailZero.getId());
                        detailsPayload.setVersionId(budgetZeroVersion.getVersionId());
                        detailsPayload.setVersionNo(budgetZeroVersion.getVersionNo());
                        detailsPayload.setBudgetId(budgetZeroVersion.getId());
                        BigDecimal allocatedResAmt = detailsPayload.getAllocatedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getAllocatedResAmt();
                        BigDecimal changeResAmt = detailsPayload.getChangeResAmt() == null ? BigDecimal.ZERO : detailsPayload.getChangeResAmt();
                        // 已占用
                        BigDecimal occupiedResAmt = detailsPayload.getOccupiedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getOccupiedResAmt();
                        // 已结算
                        BigDecimal settledResAmt = detailsPayload.getSettledResAmt() == null ? BigDecimal.ZERO : detailsPayload.getSettledResAmt();
                        BigDecimal allocatedResAmtNew = allocatedResAmt.add(changeResAmt);
                        detailsPayload.setChangedAllocatedResAmt(allocatedResAmtNew);
                        detailsPayload.setChangeResAmt(BigDecimal.ZERO);
                        detailsPayload.setAllocatedResAmt(allocatedResAmtNew);
                        // 剩余预算 = 分配预算-已占用-已结算
                        BigDecimal remainingResAmt = allocatedResAmtNew.subtract(occupiedResAmt).subtract(settledResAmt);
                        detailsPayload.setRemainingResAmt(remainingResAmt);
                        //更新明细
                        updateDynamic(detailsPayload);
                        // 匹配不上，新增
                    } else {
                        PmsWbsBudgetDetailsPayload detailsPayload = new PmsWbsBudgetDetailsPayload();
                        BeanUtils.copyProperties(detail, detailsPayload);
                        detailsPayload.setId(null);
                        detailsPayload.setVersionId(budgetZeroVersion.getVersionId());
                        detailsPayload.setVersionNo(budgetZeroVersion.getVersionNo());
                        detailsPayload.setBudgetId(budgetZeroVersion.getId());
                        // 当前分配预算
                        BigDecimal allocatedResAmt = detailsPayload.getAllocatedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getAllocatedResAmt();
                        // 已占用
                        BigDecimal occupiedResAmt = detailsPayload.getOccupiedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getOccupiedResAmt();
                        // 已结算
                        BigDecimal settledResAmt = detailsPayload.getSettledResAmt() == null ? BigDecimal.ZERO : detailsPayload.getSettledResAmt();
                        // 变更量
                        BigDecimal changeResAmt = detailsPayload.getChangeResAmt() == null ? BigDecimal.ZERO : detailsPayload.getChangeResAmt();
                        BigDecimal allocatedResAmtNew = allocatedResAmt.add(changeResAmt);
                        detailsPayload.setChangedAllocatedResAmt(allocatedResAmtNew);
                        detailsPayload.setAllocatedResAmt(allocatedResAmtNew);
                        detailsPayload.setChangeResAmt(BigDecimal.ZERO);

                        // 剩余预算 = 分配预算-已占用-已结算
                        BigDecimal remainingResAmt = allocatedResAmtNew.subtract(occupiedResAmt).subtract(settledResAmt);
                        detailsPayload.setRemainingResAmt(remainingResAmt);
                        PmsWbsBudgetDetailsVO insert = insert(detailsPayload);

                        //上个版本 effRelateId 更新为当前版本id
                        // PmsWbsBudgetDetailsPayload payload = new PmsWbsBudgetDetailsPayload();
                        // payload.setId(detail.getId());
                        // payload.setEffRelateId(insert.getId());
                        // updateDynamic(payload);
                    }
                });

                // 更新预算主表信息
                calculateMainTableInformation(effRelateIdV0Id);

                return detailsVOS;
            } else {
                Long budgetId1 = list.get(0).getBudgetId();
                list.forEach(detailsPayload -> {
                    // 当前分配预算
                    BigDecimal allocatedResAmt = detailsPayload.getAllocatedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getAllocatedResAmt();
                    BigDecimal changeResAmt = detailsPayload.getChangeResAmt() == null ? BigDecimal.ZERO : detailsPayload.getChangeResAmt();
                    BigDecimal allocatedResAmtNew = allocatedResAmt.add(changeResAmt);
                    detailsPayload.setChangedAllocatedResAmt(allocatedResAmtNew);
                    detailsPayload.setAllocatedResAmt(allocatedResAmtNew);
                    // 已占用
                    BigDecimal occupiedResAmt = detailsPayload.getOccupiedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getOccupiedResAmt();
                    // 已结算
                    BigDecimal settledResAmt = detailsPayload.getSettledResAmt() == null ? BigDecimal.ZERO : detailsPayload.getSettledResAmt();
                    // 剩余预算 = 分配预算-已占用-已结算
                    BigDecimal remainingResAmt = allocatedResAmtNew.subtract(occupiedResAmt).subtract(settledResAmt);
                    detailsPayload.setRemainingResAmt(remainingResAmt);
                });
                // 持久化数据
                List<PmsWbsBudgetDetailsVO> detailsVOS = insertAll(list);

                // 更新主表预算信息
                calculateMainTableInformation(budgetId1);
                return detailsVOS;
            }

        }
        return null;
    }

    /**
     * 计算主表信息!!!
     *
     * @param budgetId 预算id
     */
    @Transactional
    @Override
    public void calculateMainTableInformation(Long budgetId) {
        PmsWbsBudgetVO pmsWbsBudgetVO = pmsWbsBudgetService.queryByKey(budgetId);
        PmsWbsBudgetDetailsQuery budgetDetailsQuery = new PmsWbsBudgetDetailsQuery();
        budgetDetailsQuery.setBudgetId(budgetId);
        List<PmsWbsBudgetDetailsVO> pmsWbsBudgetDetailsVOS = queryList(budgetDetailsQuery);

        //pmsWbsBudgetDetailsVOS 求和已占用
        BigDecimal occupiedResAmtNew = pmsWbsBudgetDetailsVOS.stream().map(PmsWbsBudgetDetailsVO::getOccupiedResAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        //pmsWbsBudgetDetailsVOS 求和已结算
        BigDecimal settledResAmtNew = pmsWbsBudgetDetailsVOS.stream().map(PmsWbsBudgetDetailsVO::getSettledResAmt).reduce(BigDecimal.ZERO, BigDecimal::add);


        // 资源总预算
        BigDecimal totalResAmt = pmsWbsBudgetVO.getTotalResAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetVO.getTotalResAmt();
        // 剩余资源预算（含待分配）= 资源总预算 - 已占用 - 已结算
        BigDecimal totalRemainingResAmt = totalResAmt.subtract(occupiedResAmtNew).subtract(settledResAmtNew);

        PmsWbsBudgetPayload pmsWbsBudgetPayload = new PmsWbsBudgetPayload();
        pmsWbsBudgetPayload.setId(budgetId);
        // 资源总预算相关
        pmsWbsBudgetPayload.setTotalResAmt(totalResAmt);
        pmsWbsBudgetPayload.setTotalOccupiedResAmt(occupiedResAmtNew);
        pmsWbsBudgetPayload.setTotalSettledResAmt(settledResAmtNew);
        pmsWbsBudgetPayload.setTotalRemainingResAmt(totalRemainingResAmt);

        // 费用总预算
        BigDecimal totalFeeAmt = pmsWbsBudgetVO.getTotalFeeAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetVO.getTotalFeeAmt();
        pmsWbsBudgetPayload.setTotalFeeAmt(totalFeeAmt);
        BigDecimal totalOccupiedFeeAmt = pmsWbsBudgetVO.getTotalOccupiedFeeAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetVO.getTotalOccupiedFeeAmt();
        pmsWbsBudgetPayload.setTotalOccupiedFeeAmt(totalOccupiedFeeAmt);
        // 剩余资源预算（含待分配）= 资源总预算 - 已占用 - 已结算
        BigDecimal totalRemainingFeeAmt = totalFeeAmt.subtract(totalOccupiedFeeAmt).subtract(totalOccupiedFeeAmt);
        pmsWbsBudgetPayload.setTotalRemainingFeeAmt(totalRemainingFeeAmt);

        pmsWbsBudgetService.updateDynamic(pmsWbsBudgetPayload);
    }

    @Override
    @Transactional
    public List<PmsWbsBudgetDetailsVO> releaseOk(List<Long> releaseIdList) {
        List<PmsWbsBudgetDetailsVO> updateList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(releaseIdList)) {
            PmsWbsBudgetReleaseQuery releaseQuery = new PmsWbsBudgetReleaseQuery();
            releaseQuery.setIds(releaseIdList);
            List<PmsWbsBudgetReleaseVO> pmsWbsBudgetReleaseVOS = pmsWbsBudgetReleaseService.queryList(releaseQuery);


            AtomicReference<Long> budgetIdAtomic = new AtomicReference<>();
            // 取预算释放中的 释放值和已结算值 更新到预算明细中
            pmsWbsBudgetReleaseVOS.forEach(release -> {
                PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
                BigDecimal confirmSettledRes = release.getConfirmSettledRes() == null ? BigDecimal.ZERO : release.getConfirmSettledRes();
                BigDecimal changeResAmt = release.getChangeResAmt() == null ? BigDecimal.ZERO : release.getChangeResAmt();
                BigDecimal allocatedResAmtAfter = release.getOccupiedResAmtAfter() == null ? BigDecimal.ZERO : release.getOccupiedResAmtAfter();
                BigDecimal settledResAmtBefore = release.getSettledResAmtBefore() == null ? BigDecimal.ZERO : release.getSettledResAmtBefore();
                // 预算释放表存储的就是最新版本的 wbsId
                detailsQuery.setWbsId(release.getWbsId());
                List<PmsWbsBudgetDetailsVO> detailsVOS = queryList(detailsQuery);
                detailsVOS.forEach(details -> {
                    PmsWbsBudgetDetailsPayload detailsPayload = new PmsWbsBudgetDetailsPayload();
                    detailsPayload.setId(details.getId());

                    // 分配的预算
                    BigDecimal allocatedResAmt = details.getAllocatedResAmt() == null ? BigDecimal.ZERO : details.getAllocatedResAmt();
                    // 释放前 已结算
                    // BigDecimal settledResAmt = details.getSettledResAmt() == null ? BigDecimal.ZERO : details.getSettledResAmt();

                    // 变更值
                    // BigDecimal changeResAmt = details.getChangeResAmt() == null ? BigDecimal.ZERO : details.getChangeResAmt();

                    // changeResAmt值 取反值
                    BigDecimal changeResAmtNegate = changeResAmt.negate();

                    detailsPayload.setChangeResAmt(changeResAmtNegate);
                    detailsPayload.setChangedAllocatedResAmt(allocatedResAmt.add(changeResAmtNegate));

                    // (释放后)已结算 =（释放前)已结算 + 确认结算
                    detailsPayload.setSettledResAmt(settledResAmtBefore.add(confirmSettledRes));

                    // 已占用
                    BigDecimal occupiedResAmt = allocatedResAmtAfter;
                    detailsPayload.setOccupiedResAmt(allocatedResAmtAfter);
                    // 剩余 = allocatedResAmt - occupiedResAmt - settledResAmt
                    detailsPayload.setRemainingResAmt(detailsPayload.getChangedAllocatedResAmt().subtract(occupiedResAmt).subtract(confirmSettledRes));

                    // 更新预算明细
                    PmsWbsBudgetDetailsVO pmsWbsBudgetDetailsVO = updateDynamic(detailsPayload);
                    updateList.add(pmsWbsBudgetDetailsVO);

                    budgetIdAtomic.set(details.getBudgetId());
                });
            });
            Long budgetId = budgetIdAtomic.get();
            if (null != budgetId) {
                // 计算主表信息
                calculateMainTableInformation(budgetId);
            }
        }

        return updateList;
    }

    @Override
    public PmsWbsBudgetDetailsVO getByWbsId(Long wbsId, Long projectId) {
        PmsWbsBudgetVersionVO proIdAndVersionNo = pmsWbsBudgetVersionService.queryByProjectIdAndVersionNo(projectId, 0);
        Long versionId = proIdAndVersionNo.getId();

        PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
        detailsQuery.setWbsId(wbsId);
        detailsQuery.setVersionId(versionId);
        List<PmsWbsBudgetDetailsVO> detailsVOS = queryList(detailsQuery);
        if (!CollectionUtils.isEmpty(detailsVOS)) {
            if (detailsVOS.size() > 1) {
                throw TwException.error("", "预算明细活动数据重复");
            }
            return detailsVOS.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public void updateList(List<PmsWbsBudgetDetailsPayload> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (PmsWbsBudgetDetailsPayload pmsWbsBudgetDetailsPayload : list) {
                update(pmsWbsBudgetDetailsPayload);
            }

            Long budgetId = list.get(0).getBudgetId();
            // 更新主表信息
            calculateMainTableInformation(budgetId);
        }

    }

    /**
     * 创建V0预算
     *
     * @param proId 亲id
     */
    private PmsWbsBudgetVO createOneBudget(Long proId) {
        // 查询预算版本
        PmsWbsBudgetVersionVO version = pmsWbsBudgetVersionService.getVersion(proId, null);
        // 查询最新版 wbs数据
        PmsWbsVersionVO wbsVersion = pmsWbsVersionService.getVersion(proId);
        PmsProjectWbsQuery pmsProjectWbsQuery = new PmsProjectWbsQuery();
        final Long versionId = wbsVersion.getId();
        pmsProjectWbsQuery.setVersionId(versionId);
        pmsProjectWbsQuery.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
        List<PmsProjectWbsListVO> wbsList = pmsProjectActListService.queryList(pmsProjectWbsQuery);


        PmsWbsBudgetPayload budgetPayload = new PmsWbsBudgetPayload();
        budgetPayload.setProId(proId);
        budgetPayload.setVersionNo(version.getVersionNo());
        budgetPayload.setVersionId(version.getId());
        PmsWbsBudgetVO wbsBudgetVO = pmsWbsBudgetService.insert(budgetPayload);
        Long budgetVOId = wbsBudgetVO.getId();
        // 预算明细
        List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloads = new ArrayList<>();
        // 计算资源成本 资源总预算 等
        for (PmsProjectWbsListVO wbs : wbsList) {
            //这里是 V1的主键  在预算激活的时候，需要更换下这个 id 为 V0的主键
            Long wbsId = wbs.getId();
            PmsWbsBudgetDetailsPayload budgetDetail = getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, budgetVOId, version);
            budgetDetailsPayloads.add(budgetDetail);
        }


        List<PmsWbsBudgetDetailsVO> detailsVOS = insertAll(budgetDetailsPayloads);
        wbsBudgetVO.setDetails(detailsVOS);
        return wbsBudgetVO;
    }

    /**
     * 获取PmsWbsBudgetDetailsPayload对象
     *
     * @param proId     项目ID
     * @param wbs       WBS对象
     * @param wbsId     WBS ID
     * @param versionId 版本ID
     * @param budgetId  预算主表ID
     * @param version
     * @return PmsWbsBudgetDetailsPayload对象
     */
    private PmsWbsBudgetDetailsPayload getPmsWbsBudgetDetailsPayload(Long proId, PmsProjectWbsListVO wbs, Long wbsId, Long versionId, Long budgetId, PmsWbsBudgetVersionVO version) {
        if (wbs == null) {
            throw new IllegalArgumentException("wbs cannot be null");
        }
        // 预计工期
        BigDecimal preDurationDay = wbs.getPreDurationDay() == null ? BigDecimal.ZERO : wbs.getPreDurationDay();
        // 查询分配资源
        PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        pmsProjectWbsResourceQuery.setWbsId(wbsId);
        pmsProjectWbsResourceQuery.setVersionId(versionId);
        List<PmsProjectWbsResourceVO> wbsResourceVOS = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
        //资源成本= sum(预计工期*投入精力*角色单价)
        BigDecimal resCostSum = calculateResourceCost(wbsResourceVOS, preDurationDay);

        // 初版预算V0
        PmsWbsBudgetDetailsPayload budgetDetail = new PmsWbsBudgetDetailsPayload();
        budgetDetail.setBudgetId(budgetId);
        //!!!
        budgetDetail.setWbsId(wbsId);
        budgetDetail.setWbsName(wbs.getWbsName());
        budgetDetail.setWbsCode(wbs.getWbsCode());
        budgetDetail.setWbsStatus(wbs.getWbsStatus());
        budgetDetail.setProId(proId);
        budgetDetail.setResCost(resCostSum);
        // budgetDetail.setAllocatedResAmt(BigDecimal.ZERO);
        budgetDetail.setVersionId(version.getId());
        budgetDetail.setVersionNo(version.getVersionNo());
        // budgetDetail.setRemainingResAmt(BigDecimal.ZERO);
        // budgetDetail.setOccupiedResAmt(BigDecimal.ZERO);
        // budgetDetail.setSettledResAmt(BigDecimal.ZERO);
        // budgetDetail.setChangeResAmt(BigDecimal.ZERO);
        // budgetDetail.setChangedAllocatedResAmt(BigDecimal.ZERO);
        return budgetDetail;
    }

    /**
     * 计算资源成本
     *
     * @param wbsResourceVOS wbs资源vos
     * @param preDurationDay 会前一天
     * @return {@link BigDecimal}
     */
    private BigDecimal calculateResourceCost(List<PmsProjectWbsResourceVO> wbsResourceVOS, BigDecimal preDurationDay) {
        BigDecimal resCostSum = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(wbsResourceVOS)) {
            for (PmsProjectWbsResourceVO wbsResourceVO : wbsResourceVOS) {
                Long roleId = wbsResourceVO.getRoleId();
                PmsProjectRoleVO pmsProjectRoleVO = pmsProjectRoleService.queryByKey(roleId);
                // 角色单价
                BigDecimal unitPrice = pmsProjectRoleVO.getUnitPrice() == null ? BigDecimal.ZERO : pmsProjectRoleVO.getUnitPrice();
                // 投入精力
                BigDecimal input = wbsResourceVO.getInput() == null ? BigDecimal.ZERO : wbsResourceVO.getInput();
                // 资源成本
                BigDecimal resCost = preDurationDay.multiply(input).multiply(unitPrice).divide(new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                resCostSum = resCostSum.add(resCost);
            }
        }
        return resCostSum;
    }

    private Long countByProjectIdAndVersion(Long proId, int version) {
        PmsWbsBudgetQuery query = new PmsWbsBudgetQuery();
        query.setProId(proId);
        query.setVersionNo(version);
        return pmsWbsBudgetService.queryCount(query);
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsWbsBudgetDetailsPayload payload) {
    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsWbsBudgetDetailsVO> vos) {
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}
