package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetSubjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetSubjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsBudgetSubjectService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * 预算科目
 *
 * @author xxb
 * @date 2023-04-23
 */
@Api(tags = "预算科目")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsBudgetSubject")
@Slf4j
public class PmsBudgetSubjectController {

    private final PmsBudgetSubjectService pmsBudgetSubjectService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PmsBudgetSubjectPayload payload){
        return TwOutputUtil.ok(pmsBudgetSubjectService.insert(payload));
    }

    /**
     * 树形分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/pagingByTree")
    @ApiOperation("树形分页")
    public TwOutputUtil pagingByTree(PmsBudgetSubjectQuery query) {
        return TwOutputUtil.ok(pmsBudgetSubjectService.pagingByTree(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsBudgetSubjectQuery query) {
        return TwOutputUtil.ok(pmsBudgetSubjectService.queryListDynamic(query));
    }

    /**
     * 更改科目状态 0正常  1弃用
     *
     * @param keys 主键id
     * @return result
     */
    @GetMapping("/updateSubjectStatus")
    @ApiOperation("更改科目状态 0正常  1弃用")
    public TwOutputUtil updateSubjectStatus(Long[] keys,Integer subjectStatus) {
        pmsBudgetSubjectService.updateSubjectStatus(keys,subjectStatus);
        return TwOutputUtil.ok();
    }

//    /**
//     * 删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        pmsBudgetSubjectService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }


//    /**
//     * 分页
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    @ApiOperation("分页")
//    public TwOutputUtil paging(PmsBudgetSubjectQuery query) {
//        return TwOutputUtil.ok(pmsBudgetSubjectService.queryPaging(query));
//    }

//    /**
//     * 主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    @ApiOperation("主键查询")
//    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(pmsBudgetSubjectService.queryByKey(key));
//    }
}
