package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsAcceptPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsAcceptQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsAcceptService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsAcceptVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 *  验收标准
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs验收标准
 */
@RestController
@RequestMapping("/api/pmsProjectWbsAccept")
@RequiredArgsConstructor
@Api(value = "项目wbs验收标准", tags = {"项目wbs验收标准"})
public class PmsProjectWbsAcceptController {

    private final PmsProjectWbsAcceptService pmsProjectWbsAcceptService;


    @PostMapping
    @ApiOperation("新增-项目wbs验收标准")
    public TwOutputUtil<Boolean> save(@RequestBody List<PmsProjectWbsAcceptPayload> pmsProjectWbsAcceptPayloadList) {

        Boolean res = pmsProjectWbsAcceptService.saveAll(pmsProjectWbsAcceptPayloadList);
        return TwOutputUtil.ok(res);

    }


    @PutMapping
    @ApiOperation("修改-项目wbs验收标准")
    public TwOutputUtil<Long> update(@RequestBody PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {

        Long res = pmsProjectWbsAcceptService.update(pmsProjectWbsAcceptPayload);
        return TwOutputUtil.ok(res);

    }


    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除-项目wbs验收标准")
    public TwOutputUtil<Long> del(Long[] keys) {

        Long res = pmsProjectWbsAcceptService.del(Arrays.asList(keys));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页查询-项目wbs验收标准")
    public TwOutputUtil<PagingVO<PmsProjectWbsAcceptVO>> page(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {

        PagingVO<PmsProjectWbsAcceptVO> res = pmsProjectWbsAcceptService.page(pmsProjectWbsAcceptQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/{key}")
    @ApiOperation("详情-项目wbs验收标准")
    public TwOutputUtil<PmsProjectWbsAcceptVO> get(@PathVariable Long id) {

        PmsProjectWbsAcceptVO res = pmsProjectWbsAcceptService.get(id);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/list")
    @ApiOperation("列表查询-项目wbs验收标准")
    public TwOutputUtil<List<PmsProjectWbsAcceptVO>> getList(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {

        List<PmsProjectWbsAcceptVO> res = pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
        return TwOutputUtil.ok(res);

    }


}

