package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsTempBatchPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsTempPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsTempQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsTempVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.service.inf.PmsProjectWbsTempService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 项目wbs模板表
 *
 * @author wangxl
 * @date 2024/4/2
 */
@RestController
@RequestMapping("pms/pmsProjectWbsTemp")
@RequiredArgsConstructor
@Slf4j
@Api(value = "项目wbs模板表", tags = {"项目wbs模板表"})
public class PmsProjectWbsTempController {

    private final PmsProjectWbsTempService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsProjectWbsTempVO>> page(PmsProjectWbsTempQuery query) {
        return service.queryPage(query);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsProjectWbsTempVO>> list(PmsProjectWbsTempQuery query) {
        return service.queryList(query);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsProjectWbsTempVO> queryByKey(Long id) {
        return service.queryByKey(id);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsProjectWbsTempVO> insert(@RequestBody PmsProjectWbsTempPayload payload) {
        // 关键日志打印
        log.debug("【PmsProjectWbsTempController.insert】入参：" + payload.toString());
        return service.insert(payload);
    }

    @ApiOperation("批量新增")
    @PostMapping("/batchInsert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<Boolean> batchInsert(@RequestBody PmsProjectWbsTempBatchPayload payload) {
        // 关键日志打印
        log.debug("【PmsProjectWbsTempController.insert】入参：" + payload.toString());
        return service.batchInsert(payload);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsProjectWbsTempVO> update(@RequestBody PmsProjectWbsTempPayload payload) {
        // 关键日志打印
        log.debug("【PmsProjectWbsTempController.update】入参：" + payload.toString());
        return service.update(payload);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsProjectWbsTempVO> updateDynamic(@RequestBody PmsProjectWbsTempPayload payload) {
        // 关键日志打印
        log.debug("【PmsProjectWbsTempController.updateDynamic】入参：" + payload.toString());
        return service.updateDynamic(payload);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsProjectWbsTempController.deleteSoft】入参：" + ids);
        return service.deleteSoft(ids);
    }
}