package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsActCostPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsActCostQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsActCostService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * wbs活动成预估
 *
 * @author carl
 * @date 2023-04-06
 */
@Api(tags = "wbs活动成预估")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/pmsWbsActCost")
@Slf4j
public class PmsWbsActCostController {

    private final PmsWbsActCostService pmsWbsActCostService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PmsWbsActCostPayload payload) {
        return TwOutputUtil.ok(pmsWbsActCostService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PmsWbsActCostPayload payload) {
        return TwOutputUtil.ok(pmsWbsActCostService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsWbsActCostService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PmsWbsActCostQuery query) {
        return TwOutputUtil.ok(pmsWbsActCostService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsWbsActCostQuery query) {
        return TwOutputUtil.ok(pmsWbsActCostService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsWbsActCostService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
