package com.elitesland.tw.tw5.server.prd.pms.dao;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsResourcePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsResourceQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsResourceDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsResourceDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs资源分配RepoProc
 */
@Component
public class PmsProjectWbsResourceDao extends BaseRepoProc<PmsProjectWbsResourceDO> {

    private static final QPmsProjectWbsResourceDO qPmsProjectWbsResourceDO = QPmsProjectWbsResourceDO.pmsProjectWbsResourceDO;


    protected PmsProjectWbsResourceDao() {

        super(qPmsProjectWbsResourceDO);

    }


    public PagingVO<PmsProjectWbsResourceVO> page(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        JPAQuery<PmsProjectWbsResourceVO> query =
                select(PmsProjectWbsResourceVO.class)
                        .where(bulidPredicate(pmsProjectWbsResourceQuery));
        pmsProjectWbsResourceQuery.setPaging(query);
        pmsProjectWbsResourceQuery.fillOrders(query, qPmsProjectWbsResourceDO);
        return PagingVO.<PmsProjectWbsResourceVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPmsProjectWbsResourceDO)
                .set(qPmsProjectWbsResourceDO.deleteFlag, 1)
                .where(qPmsProjectWbsResourceDO.id.in(ids))
                .execute();

        return res;

    }


    public PmsProjectWbsResourceVO get(Long id) {

        PmsProjectWbsResourceVO pmsProjectWbsResourceVO = select(PmsProjectWbsResourceVO.class)
                .where(qPmsProjectWbsResourceDO.id.eq(id))
                .fetchOne();

        return pmsProjectWbsResourceVO;

    }


    public List<PmsProjectWbsResourceVO> getList(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        List<PmsProjectWbsResourceVO> res =
                select(PmsProjectWbsResourceVO.class)
                        .where(bulidPredicate(pmsProjectWbsResourceQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPmsProjectWbsResourceDO.wbsId,
                        qPmsProjectWbsResourceDO.projectId,
                        qPmsProjectWbsResourceDO.relatePartiesId,
                        qPmsProjectWbsResourceDO.roleId,
                        qPmsProjectWbsResourceDO.managerUserFlag,
                        qPmsProjectWbsResourceDO.input,
                        qPmsProjectWbsResourceDO.id,
                        qPmsProjectWbsResourceDO.createTime,
                        qPmsProjectWbsResourceDO.versionId,
                        qPmsProjectWbsResourceDO.versionNo,
                        qPmsProjectWbsResourceDO.effRelateId,
                        qPmsProjectWbsResourceDO.remark,
                        qPmsProjectWbsResourceDO.wbsCode

                )).from(qPmsProjectWbsResourceDO);

    }


    private Predicate bulidPredicate(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != pmsProjectWbsResourceQuery.getWbsId(), qPmsProjectWbsResourceDO.wbsId, pmsProjectWbsResourceQuery.getWbsId())
                .andEq(null != pmsProjectWbsResourceQuery.getProjectId(), qPmsProjectWbsResourceDO.projectId, pmsProjectWbsResourceQuery.getProjectId())
                .andEq(null != pmsProjectWbsResourceQuery.getRelatePartiesId(), qPmsProjectWbsResourceDO.relatePartiesId, pmsProjectWbsResourceQuery.getRelatePartiesId())
                .andEq(null != pmsProjectWbsResourceQuery.getRoleId(), qPmsProjectWbsResourceDO.roleId, pmsProjectWbsResourceQuery.getRoleId())
                .andEq(null != pmsProjectWbsResourceQuery.getManagerUserFlag(), qPmsProjectWbsResourceDO.managerUserFlag, pmsProjectWbsResourceQuery.getManagerUserFlag())
                .andEq(null != pmsProjectWbsResourceQuery.getInput(), qPmsProjectWbsResourceDO.input, pmsProjectWbsResourceQuery.getInput())
                .andIn(CollUtil.isNotEmpty(pmsProjectWbsResourceQuery.getWbsIdList()), qPmsProjectWbsResourceDO.wbsId, pmsProjectWbsResourceQuery.getWbsIdList())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // wbs主键
        if (null != pmsProjectWbsResourceQuery.getWbsId()) {
            predicates.add(qPmsProjectWbsResourceDO.wbsId.eq(pmsProjectWbsResourceQuery.getWbsId()));
        }
        // 项目id
        if (null != pmsProjectWbsResourceQuery.getProjectId()) {
            predicates.add(qPmsProjectWbsResourceDO.projectId.eq(pmsProjectWbsResourceQuery.getProjectId()));
        }
        // 相关方id
        if (null != pmsProjectWbsResourceQuery.getRelatePartiesId()) {
            predicates.add(qPmsProjectWbsResourceDO.relatePartiesId.eq(pmsProjectWbsResourceQuery.getRelatePartiesId()));
        }
        // 角色id
        if (null != pmsProjectWbsResourceQuery.getRoleId()) {
            predicates.add(qPmsProjectWbsResourceDO.roleId.eq(pmsProjectWbsResourceQuery.getRoleId()));
        }
        // 负责人标识
        if (null != pmsProjectWbsResourceQuery.getManagerUserFlag()) {
            predicates.add(qPmsProjectWbsResourceDO.managerUserFlag.eq(pmsProjectWbsResourceQuery.getManagerUserFlag()));
        }
        // 投入精力
        if (null != pmsProjectWbsResourceQuery.getInput()) {
            predicates.add(qPmsProjectWbsResourceDO.input.eq(pmsProjectWbsResourceQuery.getInput()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        long res = select(PmsProjectWbsResourceVO.class)
                .where(bulidPredicates(pmsProjectWbsResourceQuery))
                .fetchCount();

        return res;


    }

    public Long update(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPmsProjectWbsResourceDO);

        // wbs主键
        if (null != pmsProjectWbsResourcePayload.getWbsId()) {
            update.set(qPmsProjectWbsResourceDO.wbsId, pmsProjectWbsResourcePayload.getWbsId());
        }
        // 项目id
        if (null != pmsProjectWbsResourcePayload.getProjectId()) {
            update.set(qPmsProjectWbsResourceDO.projectId, pmsProjectWbsResourcePayload.getProjectId());
        }
        // 相关方id
        if (null != pmsProjectWbsResourcePayload.getRelatePartiesId()) {
            update.set(qPmsProjectWbsResourceDO.relatePartiesId, pmsProjectWbsResourcePayload.getRelatePartiesId());
        }
        // 角色id
        if (null != pmsProjectWbsResourcePayload.getRoleId()) {
            update.set(qPmsProjectWbsResourceDO.roleId, pmsProjectWbsResourcePayload.getRoleId());
        }
        // 负责人标识
        if (null != pmsProjectWbsResourcePayload.getManagerUserFlag()) {
            update.set(qPmsProjectWbsResourceDO.managerUserFlag, pmsProjectWbsResourcePayload.getManagerUserFlag());
        }
        // 投入精力
        if (null != pmsProjectWbsResourcePayload.getInput()) {
            update.set(qPmsProjectWbsResourceDO.input, pmsProjectWbsResourcePayload.getInput());
        }
        // 有效版本关联id
        if (null != pmsProjectWbsResourcePayload.getEffRelateId()) {
            update.set(qPmsProjectWbsResourceDO.effRelateId, pmsProjectWbsResourcePayload.getEffRelateId());
        }
        long res = update.where(qPmsProjectWbsResourceDO.id.eq(pmsProjectWbsResourcePayload.getId()))
                .execute();
        return res;

    }

    public void delByWbsIds(List<Long> wbsIds) {

        Long res = jpaQueryFactory.update(qPmsProjectWbsResourceDO)
                .set(qPmsProjectWbsResourceDO.deleteFlag, 1)
                .where(qPmsProjectWbsResourceDO.wbsId.in(wbsIds))
                .execute();

    }

    public Long queryBykeyAndVersion(Long wbsId, Long relatePartiesId, int versionNo) {

        Long res = jpaQueryFactory.select(qPmsProjectWbsResourceDO.id)
                .from(qPmsProjectWbsResourceDO)
                .where(qPmsProjectWbsResourceDO.wbsId.eq(wbsId))
                .where(qPmsProjectWbsResourceDO.relatePartiesId.eq(relatePartiesId))
                .where(qPmsProjectWbsResourceDO.versionNo.eq(versionNo))
                .fetchFirst();

        return res;

    }


    public Long updateByKeyNoVersion(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {

        JPAUpdateClause update = jpaQueryFactory.update(qPmsProjectWbsResourceDO);
        // wbs主键
        if (null != pmsProjectWbsResourcePayload.getWbsId()) {
            update.set(qPmsProjectWbsResourceDO.wbsId, pmsProjectWbsResourcePayload.getWbsId());
        }
        // 项目id
        if (null != pmsProjectWbsResourcePayload.getProjectId()) {
            update.set(qPmsProjectWbsResourceDO.projectId, pmsProjectWbsResourcePayload.getProjectId());
        }
        // 相关方id
        if (null != pmsProjectWbsResourcePayload.getRelatePartiesId()) {
            update.set(qPmsProjectWbsResourceDO.relatePartiesId, pmsProjectWbsResourcePayload.getRelatePartiesId());
        }
        // 角色id
        if (null != pmsProjectWbsResourcePayload.getRoleId()) {
            update.set(qPmsProjectWbsResourceDO.roleId, pmsProjectWbsResourcePayload.getRoleId());
        }
        // 负责人标识
        if (null != pmsProjectWbsResourcePayload.getManagerUserFlag()) {
            update.set(qPmsProjectWbsResourceDO.managerUserFlag, pmsProjectWbsResourcePayload.getManagerUserFlag());
        }
        // 投入精力
        if (null != pmsProjectWbsResourcePayload.getInput()) {
            update.set(qPmsProjectWbsResourceDO.input, pmsProjectWbsResourcePayload.getInput());
        }
        // 有效版本关联id
        if (null != pmsProjectWbsResourcePayload.getEffRelateId()) {
            update.set(qPmsProjectWbsResourceDO.effRelateId, pmsProjectWbsResourcePayload.getEffRelateId());
        }
        long res = update.where(qPmsProjectWbsResourceDO.id.eq(pmsProjectWbsResourcePayload.getId()))
                .execute();
        return res;
    }

    public void delByV0(List<Long> delIds,Long wbsId) {

        JPAUpdateClause update = jpaQueryFactory.update(qPmsProjectWbsResourceDO);
        update.set(qPmsProjectWbsResourceDO.deleteFlag, 1)
                .where(qPmsProjectWbsResourceDO.id.notIn(delIds))
                .where(qPmsProjectWbsResourceDO.versionNo.eq(0))
                .where(qPmsProjectWbsResourceDO.wbsId.eq(wbsId))
                .execute();
    }
}

