package com.elitesland.tw.tw5.server.prd.pms.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsTempPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsTempQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsTempVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsTempConvert;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsTempDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsTempDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsTempRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * 项目wbs模板表dao
 * @author wangxl
 * @date 2024/4/2
 */
@RequiredArgsConstructor
@Component
public class PmsProjectWbsTempDao  {

    private static final QPmsProjectWbsTempDO qdo = QPmsProjectWbsTempDO.pmsProjectWbsTempDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectWbsTempRepo repo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectWbsTempVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectWbsTempVO.class,
                qdo.id,
                qdo.tempId,
                qdo.parentId,
                qdo.wbsName,
                qdo.wbsType,
                qdo.wbsCode,
                qdo.parentWbsCode,
                qdo.nodeCode,
                qdo.managerUserId,
                qdo.subjectDist,
                qdo.costType,
                qdo.preStartDate,
                qdo.preEndDate,
                qdo.preDurationDay,
                qdo.wbsProgress,
                qdo.startDate,
                qdo.endDate,
                qdo.durationDay,
                qdo.earlyStartDate,
                qdo.earlyEndDate,
                qdo.lateStartDate,
                qdo.lateEndDate,
                qdo.totalFloat,
                qdo.freeFloat,
                qdo.delayLag,
                qdo.isKeyNode,
                qdo.autoScheduling,
                qdo.wbsStatus,
                qdo.cancelShowFlag,
                qdo.costPlan,
                qdo.invoiceAttr,
                qdo.wbsWeight,
                qdo.manualSettingWeight,
                qdo.state,
                qdo.versionId,
                qdo.versionNo,
                qdo.effRelateId,
                qdo.releaseFlag,
                qdo.tenantId,
                qdo.belongOrgId,
                qdo.tenantOrgId,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.deleteFlag,
                qdo.auditDataVersion,
                qdo.secBuId,
                qdo.secUserId,
                qdo.secOuId,
                qdo.receivePlanId,
                qdo.allocateStatus,
                qdo.eqvaRate,
                qdo.planEqva,
                qdo.originalPlanEqva,
                qdo.distedEqva,
                qdo.allocateEqva,
                qdo.allocateCost,
                qdo.detailControlFlag,
                qdo.occupyEqva,
                qdo.usedEqva,
                qdo.usedEqvaProportion,
                qdo.usedAmtProportion
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsProjectWbsTempQuery query) {
        if (!ObjectUtils.isEmpty(query.getTempId())) {
            jpaQuery.where(qdo.tempId.eq(query.getTempId()));
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            jpaQuery.where(qdo.parentId.eq(query.getParentId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsName())) {
            jpaQuery.where(qdo.wbsName.eq(query.getWbsName()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsType())) {
            jpaQuery.where(qdo.wbsType.eq(query.getWbsType()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsCode())) {
            jpaQuery.where(qdo.wbsCode.eq(query.getWbsCode()));
        }
        if (!ObjectUtils.isEmpty(query.getParentWbsCode())) {
            jpaQuery.where(qdo.parentWbsCode.eq(query.getParentWbsCode()));
        }
        if (!ObjectUtils.isEmpty(query.getNodeCode())) {
            jpaQuery.where(qdo.nodeCode.eq(query.getNodeCode()));
        }
        if (!ObjectUtils.isEmpty(query.getManagerUserId())) {
            jpaQuery.where(qdo.managerUserId.eq(query.getManagerUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getSubjectDist())) {
            jpaQuery.where(qdo.subjectDist.eq(query.getSubjectDist()));
        }
        if (!ObjectUtils.isEmpty(query.getCostType())) {
            jpaQuery.where(qdo.costType.eq(query.getCostType()));
        }
        if (!ObjectUtils.isEmpty(query.getPreStartDate())) {
            jpaQuery.where(qdo.preStartDate.eq(query.getPreStartDate()));
        }
        if (!ObjectUtils.isEmpty(query.getPreEndDate())) {
            jpaQuery.where(qdo.preEndDate.eq(query.getPreEndDate()));
        }
        if (!ObjectUtils.isEmpty(query.getPreDurationDay())) {
            jpaQuery.where(qdo.preDurationDay.eq(query.getPreDurationDay()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsProgress())) {
            jpaQuery.where(qdo.wbsProgress.eq(query.getWbsProgress()));
        }
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            jpaQuery.where(qdo.startDate.eq(query.getStartDate()));
        }
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            jpaQuery.where(qdo.endDate.eq(query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty(query.getDurationDay())) {
            jpaQuery.where(qdo.durationDay.eq(query.getDurationDay()));
        }
        if (!ObjectUtils.isEmpty(query.getEarlyStartDate())) {
            jpaQuery.where(qdo.earlyStartDate.eq(query.getEarlyStartDate()));
        }
        if (!ObjectUtils.isEmpty(query.getEarlyEndDate())) {
            jpaQuery.where(qdo.earlyEndDate.eq(query.getEarlyEndDate()));
        }
        if (!ObjectUtils.isEmpty(query.getLateStartDate())) {
            jpaQuery.where(qdo.lateStartDate.eq(query.getLateStartDate()));
        }
        if (!ObjectUtils.isEmpty(query.getLateEndDate())) {
            jpaQuery.where(qdo.lateEndDate.eq(query.getLateEndDate()));
        }
        if (!ObjectUtils.isEmpty(query.getTotalFloat())) {
            jpaQuery.where(qdo.totalFloat.eq(query.getTotalFloat()));
        }
        if (!ObjectUtils.isEmpty(query.getFreeFloat())) {
            jpaQuery.where(qdo.freeFloat.eq(query.getFreeFloat()));
        }
        if (!ObjectUtils.isEmpty(query.getDelayLag())) {
            jpaQuery.where(qdo.delayLag.eq(query.getDelayLag()));
        }
        if (!ObjectUtils.isEmpty(query.getIsKeyNode())) {
            jpaQuery.where(qdo.isKeyNode.eq(query.getIsKeyNode()));
        }
        if (!ObjectUtils.isEmpty(query.getAutoScheduling())) {
            jpaQuery.where(qdo.autoScheduling.eq(query.getAutoScheduling()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsStatus())) {
            jpaQuery.where(qdo.wbsStatus.eq(query.getWbsStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getCancelShowFlag())) {
            jpaQuery.where(qdo.cancelShowFlag.eq(query.getCancelShowFlag()));
        }
        if (!ObjectUtils.isEmpty(query.getCostPlan())) {
            jpaQuery.where(qdo.costPlan.eq(query.getCostPlan()));
        }
        if (!ObjectUtils.isEmpty(query.getInvoiceAttr())) {
            jpaQuery.where(qdo.invoiceAttr.eq(query.getInvoiceAttr()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsWeight())) {
            jpaQuery.where(qdo.wbsWeight.eq(query.getWbsWeight()));
        }
        if (!ObjectUtils.isEmpty(query.getManualSettingWeight())) {
            jpaQuery.where(qdo.manualSettingWeight.eq(query.getManualSettingWeight()));
        }
//        if (!ObjectUtils.isEmpty(query.getState())) {
//            jpaQuery.where(qdo.state.eq(query.getState()));
//        }
        if (!ObjectUtils.isEmpty(query.getVersionId())) {
            jpaQuery.where(qdo.versionId.eq(query.getVersionId()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            jpaQuery.where(qdo.versionNo.eq(query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty(query.getEffRelateId())) {
            jpaQuery.where(qdo.effRelateId.eq(query.getEffRelateId()));
        }
        if (!ObjectUtils.isEmpty(query.getReleaseFlag())) {
            jpaQuery.where(qdo.releaseFlag.eq(query.getReleaseFlag()));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getAuditDataVersion())) {
            jpaQuery.where(qdo.auditDataVersion.eq(query.getAuditDataVersion()));
        }
        if (!ObjectUtils.isEmpty(query.getSecBuId())) {
            jpaQuery.where(qdo.secBuId.eq(query.getSecBuId()));
        }
        if (!ObjectUtils.isEmpty(query.getSecUserId())) {
            jpaQuery.where(qdo.secUserId.eq(query.getSecUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getSecOuId())) {
            jpaQuery.where(qdo.secOuId.eq(query.getSecOuId()));
        }
        if (!ObjectUtils.isEmpty(query.getReceivePlanId())) {
            jpaQuery.where(qdo.receivePlanId.eq(query.getReceivePlanId()));
        }
        if (!ObjectUtils.isEmpty(query.getAllocateStatus())) {
            jpaQuery.where(qdo.allocateStatus.eq(query.getAllocateStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getEqvaRate())) {
            jpaQuery.where(qdo.eqvaRate.eq(query.getEqvaRate()));
        }
        if (!ObjectUtils.isEmpty(query.getPlanEqva())) {
            jpaQuery.where(qdo.planEqva.eq(query.getPlanEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getOriginalPlanEqva())) {
            jpaQuery.where(qdo.originalPlanEqva.eq(query.getOriginalPlanEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getDistedEqva())) {
            jpaQuery.where(qdo.distedEqva.eq(query.getDistedEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getAllocateEqva())) {
            jpaQuery.where(qdo.allocateEqva.eq(query.getAllocateEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getAllocateCost())) {
            jpaQuery.where(qdo.allocateCost.eq(query.getAllocateCost()));
        }
        if (!ObjectUtils.isEmpty(query.getDetailControlFlag())) {
            jpaQuery.where(qdo.detailControlFlag.eq(query.getDetailControlFlag()));
        }
        if (!ObjectUtils.isEmpty(query.getOccupyEqva())) {
            jpaQuery.where(qdo.occupyEqva.eq(query.getOccupyEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getUsedEqva())) {
            jpaQuery.where(qdo.usedEqva.eq(query.getUsedEqva()));
        }
        if (!ObjectUtils.isEmpty(query.getUsedEqvaProportion())) {
            jpaQuery.where(qdo.usedEqvaProportion.eq(query.getUsedEqvaProportion()));
        }
        if (!ObjectUtils.isEmpty(query.getUsedAmtProportion())) {
            jpaQuery.where(qdo.usedAmtProportion.eq(query.getUsedAmtProportion()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsProjectWbsTempVO> queryPage(PmsProjectWbsTempQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if(count == 0){
            return PagingVO.<PmsProjectWbsTempVO>builder()
                    .total(count)
                    .records(Collections.emptyList())
                    .build();
        }
        JPAQuery<PmsProjectWbsTempVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        // 分页
        SqlUtil.handlePage(jpaQuerySelect, query);
        return PagingVO.<PmsProjectWbsTempVO>builder()
                .total(count)
                .records(jpaQuerySelect.fetch())
                .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectWbsTempVO> queryList(PmsProjectWbsTempQuery query) {
        JPAQuery<PmsProjectWbsTempVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(qdo.createTime.asc());
//        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsProjectWbsTempQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count==null?0:count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectWbsTempVO queryByKey(Long id) {
        JPAQuery<PmsProjectWbsTempVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsProjectWbsTempVO save(PmsProjectWbsTempPayload payload) {
        PmsProjectWbsTempDO ado = PmsProjectWbsTempConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsProjectWbsTempConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsProjectWbsTempDO> saveAll(List<PmsProjectWbsTempDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PmsProjectWbsTempPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getTempId() != null) {
            update.set(qdo.tempId, payload.getTempId());
        }
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        if (payload.getWbsName() != null) {
            update.set(qdo.wbsName, payload.getWbsName());
        }
        if (payload.getWbsType() != null) {
            update.set(qdo.wbsType, payload.getWbsType());
        }
        if (payload.getWbsCode() != null) {
            update.set(qdo.wbsCode, payload.getWbsCode());
        }
        if (payload.getParentWbsCode() != null) {
            update.set(qdo.parentWbsCode, payload.getParentWbsCode());
        }
        if (payload.getNodeCode() != null) {
            update.set(qdo.nodeCode, payload.getNodeCode());
        }
        if (payload.getManagerUserId() != null) {
            update.set(qdo.managerUserId, payload.getManagerUserId());
        }
        if (payload.getSubjectDist() != null) {
            update.set(qdo.subjectDist, payload.getSubjectDist());
        }
        if (payload.getCostType() != null) {
            update.set(qdo.costType, payload.getCostType());
        }
        if (payload.getPreStartDate() != null) {
            update.set(qdo.preStartDate, payload.getPreStartDate());
        }
        if (payload.getPreEndDate() != null) {
            update.set(qdo.preEndDate, payload.getPreEndDate());
        }
        if (payload.getPreDurationDay() != null) {
            update.set(qdo.preDurationDay, payload.getPreDurationDay());
        }
        if (payload.getWbsProgress() != null) {
            update.set(qdo.wbsProgress, payload.getWbsProgress());
        }
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        if (payload.getDurationDay() != null) {
            update.set(qdo.durationDay, payload.getDurationDay());
        }
        if (payload.getEarlyStartDate() != null) {
            update.set(qdo.earlyStartDate, payload.getEarlyStartDate());
        }
        if (payload.getEarlyEndDate() != null) {
            update.set(qdo.earlyEndDate, payload.getEarlyEndDate());
        }
        if (payload.getLateStartDate() != null) {
            update.set(qdo.lateStartDate, payload.getLateStartDate());
        }
        if (payload.getLateEndDate() != null) {
            update.set(qdo.lateEndDate, payload.getLateEndDate());
        }
        if (payload.getTotalFloat() != null) {
            update.set(qdo.totalFloat, payload.getTotalFloat());
        }
        if (payload.getFreeFloat() != null) {
            update.set(qdo.freeFloat, payload.getFreeFloat());
        }
        if (payload.getDelayLag() != null) {
            update.set(qdo.delayLag, payload.getDelayLag());
        }
        if (payload.getIsKeyNode() != null) {
            update.set(qdo.isKeyNode, payload.getIsKeyNode());
        }
        if (payload.getAutoScheduling() != null) {
            update.set(qdo.autoScheduling, payload.getAutoScheduling());
        }
        if (payload.getWbsStatus() != null) {
            update.set(qdo.wbsStatus, payload.getWbsStatus());
        }
        if (payload.getCancelShowFlag() != null) {
            update.set(qdo.cancelShowFlag, payload.getCancelShowFlag());
        }
        if (payload.getCostPlan() != null) {
            update.set(qdo.costPlan, payload.getCostPlan());
        }
        if (payload.getInvoiceAttr() != null) {
            update.set(qdo.invoiceAttr, payload.getInvoiceAttr());
        }
        if (payload.getWbsWeight() != null) {
            update.set(qdo.wbsWeight, payload.getWbsWeight());
        }
        if (payload.getManualSettingWeight() != null) {
            update.set(qdo.manualSettingWeight, payload.getManualSettingWeight());
        }
        if (payload.getState() != null) {
            update.set(qdo.state, payload.getState());
        }
        if (payload.getVersionId() != null) {
            update.set(qdo.versionId, payload.getVersionId());
        }
        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        if (payload.getEffRelateId() != null) {
            update.set(qdo.effRelateId, payload.getEffRelateId());
        }
        if (payload.getReleaseFlag() != null) {
            update.set(qdo.releaseFlag, payload.getReleaseFlag());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getAuditDataVersion() != null) {
            update.set(qdo.auditDataVersion, payload.getAuditDataVersion());
        }
        if (payload.getSecBuId() != null) {
            update.set(qdo.secBuId, payload.getSecBuId());
        }
        if (payload.getSecUserId() != null) {
            update.set(qdo.secUserId, payload.getSecUserId());
        }
        if (payload.getSecOuId() != null) {
            update.set(qdo.secOuId, payload.getSecOuId());
        }
        if (payload.getReceivePlanId() != null) {
            update.set(qdo.receivePlanId, payload.getReceivePlanId());
        }
        if (payload.getAllocateStatus() != null) {
            update.set(qdo.allocateStatus, payload.getAllocateStatus());
        }
        if (payload.getEqvaRate() != null) {
            update.set(qdo.eqvaRate, payload.getEqvaRate());
        }
        if (payload.getPlanEqva() != null) {
            update.set(qdo.planEqva, payload.getPlanEqva());
        }
        if (payload.getOriginalPlanEqva() != null) {
            update.set(qdo.originalPlanEqva, payload.getOriginalPlanEqva());
        }
        if (payload.getDistedEqva() != null) {
            update.set(qdo.distedEqva, payload.getDistedEqva());
        }
        if (payload.getAllocateEqva() != null) {
            update.set(qdo.allocateEqva, payload.getAllocateEqva());
        }
        if (payload.getAllocateCost() != null) {
            update.set(qdo.allocateCost, payload.getAllocateCost());
        }
        if (payload.getDetailControlFlag() != null) {
            update.set(qdo.detailControlFlag, payload.getDetailControlFlag());
        }
        if (payload.getOccupyEqva() != null) {
            update.set(qdo.occupyEqva, payload.getOccupyEqva());
        }
        if (payload.getUsedEqva() != null) {
            update.set(qdo.usedEqva, payload.getUsedEqva());
        }
        if (payload.getUsedEqvaProportion() != null) {
            update.set(qdo.usedEqvaProportion, payload.getUsedEqvaProportion());
        }
        if (payload.getUsedAmtProportion() != null) {
            update.set(qdo.usedAmtProportion, payload.getUsedAmtProportion());
        }
        // 处理要设置成空的字段(nullField处理)
        SqlUtil.handleNullFieldsUpdate(payload,qdo,update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public long delByTempId(Long tempId) {

        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.tempId.eq(tempId));
        return update.execute();
    }

    public Long submitTemplate(Long tempId, String state) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.state, state)
                .where(qdo.tempId.eq(tempId));
        return update.execute();
    }
}