package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsVersionQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsVersionVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsWbsVersionConvert;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsWbsVersionDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsWbsVersionDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsWbsVersionRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * pms版本表dao
 *
 * @author wangxl
 * @date 2024/3/4
 */
@RequiredArgsConstructor
@Component
public class PmsWbsVersionDao {

    private static final QPmsWbsVersionDO qdo = QPmsWbsVersionDO.pmsWbsVersionDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsWbsVersionRepo repo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsWbsVersionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsWbsVersionVO.class,
                qdo.id,
                qdo.tenantId,
                qdo.belongOrgId,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.tenantOrgId,
                qdo.remark,
                qdo.deleteFlag,
                qdo.proId,
                qdo.versionNo,
                qdo.state,
                qdo.stepNum
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsWbsVersionQuery query) {
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getProId())) {
            jpaQuery.where(qdo.proId.eq(query.getProId()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            jpaQuery.where(qdo.versionNo.eq(query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty(query.getState())) {
            jpaQuery.where(qdo.state.eq(query.getState()));
        }
        if (!ObjectUtils.isEmpty(query.getStepNum())) {
            jpaQuery.where(qdo.stepNum.eq(query.getStepNum()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsWbsVersionVO> queryPage(PmsWbsVersionQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if (count == 0) {
            return PagingVO.<PmsWbsVersionVO>builder()
                    .total(count)
                    .records(Collections.emptyList())
                    .build();
        }
        JPAQuery<PmsWbsVersionVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return PagingVO.<PmsWbsVersionVO>builder()
                .total(count)
                .records(jpaQuerySelect.fetch())
                .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsWbsVersionVO> queryList(PmsWbsVersionQuery query) {
        JPAQuery<PmsWbsVersionVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsWbsVersionQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count == null ? 0 : count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsWbsVersionVO queryByKey(Long id) {
        JPAQuery<PmsWbsVersionVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsWbsVersionVO save(PmsWbsVersionPayload payload) {
        PmsWbsVersionDO ado = PmsWbsVersionConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
//        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsWbsVersionConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsWbsVersionDO> saveAll(List<PmsWbsVersionDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
//        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PmsWbsVersionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getProId() != null) {
            update.set(qdo.proId, payload.getProId());
        }
        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        if (payload.getState() != null) {
            update.set(qdo.state, payload.getState());
        }
        if (payload.getStepNum() != null) {
            update.set(qdo.stepNum, payload.getStepNum());
        }
        // 处理要设置成空的字段(nullField处理)
//        SqlUtil.handleNullFieldsUpdate(payload, qdo, update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }


    public PmsWbsVersionVO getVersion(Long proId,Integer state) {

        JPAQuery<PmsWbsVersionVO> jpaQuerySelect = getJpaQuerySelect();
        PmsWbsVersionQuery pmsWbsVersionQuery = new PmsWbsVersionQuery();
        pmsWbsVersionQuery.setProId(proId);
        pmsWbsVersionQuery.setState(state);
        jpaQueryWhere(jpaQuerySelect, pmsWbsVersionQuery);
        // 动态排序 versionNo desc,state asc
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn("versionNo");
        orderItem.setAsc(false);
        OrderItem orderItem1 = new OrderItem();
        orderItem1.setColumn("state");
        pmsWbsVersionQuery.setOrders(List.of(orderItem, orderItem1));
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, pmsWbsVersionQuery.getOrders()));
        PmsWbsVersionVO pmsWbsVersionVO = jpaQuerySelect.fetchFirst();

        return pmsWbsVersionVO;
    }

}