package com.elitesland.tw.tw5.server.prd.pms.deliver.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemStatisticsVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsIframeDocInfoVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemService;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 项目/计划/交付项
 *
 * @author duwh
 * @date 2024/03/13
 */
@RestController
@RequestMapping("/api/pms/pmsDeliverItem")
@RequiredArgsConstructor
@Api(value = "交付项", tags = {"交付项"})
public class PmsDeliverItemController {

    private final PmsDeliverItemService pmsDeliverItemService;


    /**
     * 获取iframe文档信息
     *
     * @param projectId 项目id
     * @param appId     应用程序id
     * @param request   要求
     * @param response  回答
     * @return {@link TwOutputUtil}<{@link PmsIframeDocInfoVO}>
     */// 根据项目 id获取文档库iframe所需信息
    @GetMapping("getIframeDocInfo")
    public TwOutputUtil<PmsIframeDocInfoVO> getIframeDocInfo(Long projectId, String appId, HttpServletRequest request, HttpServletResponse response) {
        PmsIframeDocInfoVO res = pmsDeliverItemService.getIframeDocInfo(projectId, appId, request, response);
        return TwOutputUtil.ok(res);
    }


    @GetMapping("get")
    @ApiOperation("详情-交付项")
    public TwOutputUtil<PmsDeliverItemVO> get(Long id) {
        PmsDeliverItemVO res = pmsDeliverItemService.get(id);
        return TwOutputUtil.ok(res);
    }


    @PostMapping("save")
    @ApiOperation("新增-交付项")
    public TwOutputUtil<Long> save(@RequestBody PmsDeliverItemPayload pmsDeliverItemPayload) {
        PmsDeliverItemVO res = pmsDeliverItemService.save(pmsDeliverItemPayload);
        return TwOutputUtil.ok(res.getId());
    }


    @PostMapping("update")
    @ApiOperation("修改-交付项")
    public TwOutputUtil<Long> update(@RequestBody PmsDeliverItemPayload pmsDeliverItemPayload) {
        Long res = pmsDeliverItemService.update(pmsDeliverItemPayload);
        return TwOutputUtil.ok(res);
    }


    @PostMapping("del")
    @ApiOperation("删除-交付项")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {
        Long res = pmsDeliverItemService.del(ids);
        return TwOutputUtil.ok(res);
    }


    @GetMapping("page")
    @UdcNameClass
    @ApiOperation("分页查询-交付项")
    public TwOutputUtil<PagingVO<PmsDeliverItemVO>> page(PmsDeliverItemQuery query) {
        Assert.notNull(query.getProjectId(), "项目主键不能为空");
        if (ObjectUtils.isEmpty(query.getShowFlag())) {
            query.setShowFlag(true);
        }
        PagingVO<PmsDeliverItemVO> res = pmsDeliverItemService.page(query);
        return TwOutputUtil.ok(res);
    }

    @GetMapping("myPage")
    @UdcNameClass
    @ApiOperation("分页查询-交付项")
    public TwOutputUtil<PagingVO<PmsDeliverItemVO>> myPage(PmsDeliverItemQuery query) {
        Assert.notNull(query.getProjectId(), "项目主键不能为空");
        if (ObjectUtils.isEmpty(query.getShowFlag())) {
            query.setShowFlag(true);
        }
        PagingVO<PmsDeliverItemVO> res = pmsDeliverItemService.myPage(query);
        return TwOutputUtil.ok(res);
    }


    @GetMapping("getList")
    @ApiOperation("列表查询-交付项")
    public TwOutputUtil<List<PmsDeliverItemVO>> getList(PmsDeliverItemQuery query) {
        Assert.notNull(query.getProjectId(), "项目主键不能为空");
        if (ObjectUtils.isEmpty(query.getShowFlag())) {
            query.setShowFlag(true);
        }
        List<PmsDeliverItemVO> res = pmsDeliverItemService.getList(query);
        return TwOutputUtil.ok(res);
    }

    // 交付物统计
    /**
     * 数据源：来源于项目内交付清单和里程碑数据，统计到项目开始到目前日期的数据
     * 统计交付物完成情况，使用饼图根据状态区分为已完成和未完成
     * - 已完成
     * - 未完成中数据细分为
     *   - 逾期（统计当前日期以前未完成的数据）
     *   - 今日需完成（统计当前日期需要完成的数据）
     *   - 剩余（统计后面将要完成的数据）
     */
    @GetMapping("statistics")
    @ApiOperation("统计-交付项")
    public TwOutputUtil<List<PmsDeliverItemStatisticsVO>> statistics(PmsDeliverItemQuery query) {
        List<PmsDeliverItemStatisticsVO> list = pmsDeliverItemService.statistics(query);
        return TwOutputUtil.ok(list);
    }


}

