package com.elitesland.tw.tw5.server.prd.pms.deliver.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


/**
 * @author : duwh
 * @date : 2024-2-27
 * @desc : 交付项
 */
@Entity
@Table(name = "pms_deliver_item")
@org.hibernate.annotations.Table(appliesTo = "pms_deliver_item", comment = "交付项")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PmsDeliverItemDO extends BaseModel {


    /**
     * 规则主键
     */
    @Column(name = "role_id", columnDefinition = "bigint(20) comment '规则主键'")
    private Long roleId;

    /**
     * 项目主键
     */
    @Column(name = "project_id", columnDefinition = "bigint(20) comment '项目主键'")
    private Long projectId;
   /**
    * 交付项
    */
   @Column(name = "name", columnDefinition = "varchar(255) comment '交付项'")
   private String name;

   /**
    * 负责人
    */
   @Column(name = "director_related_parties_id", columnDefinition = "bigint(20) comment '负责人'")
   private Long directorRelatedPartiesId;

   /**
    * 说明
    */
   @Column(name = "content", columnDefinition = "varchar(2000) comment '说明'")
   private String content;

   /**
    * 里程碑主键 pms_project_wbs.id
    */
   @Column(name = "wbs_id", columnDefinition = "bigint(20) comment '里程碑主键 pms_project_wbs.id'")
   private Long wbsId;

   /**
    * 里程碑名称（冗余）
    */
   @Column(name = "wbs_name", columnDefinition = "varchar(255) comment '里程碑名称（冗余）'")
   private String wbsName;

   /**
    * 存储路径
    */
   @Column(name = "save_path", columnDefinition = "varchar(255) comment '存储路径'")
   private String savePath;

   /**
    * 提交内容
    */
   @Column(name = "submit_content", columnDefinition = "varchar(255) comment '提交内容'")
   private String submitContent;

   /**
    * 完成状态 已完成 未完成 UDC[PMS:DELIVER_ITEM:STATUS]
    */
   @Column(name = "status", columnDefinition = "varchar(255) comment '完成状态 已完成 未完成 UDC[PMS:DELIVER_ITEM:STATUS]'")
   private String status;

   /**
    * 是否展示 0不展示 1 展示
    */
   @Column(name = "show_flag", columnDefinition = "tinyint(1) comment '是否展示 0不展示 1 展示'")
   private Boolean showFlag;

   /**
    * 排序字段
    */
   @Column(name = "sort_no", columnDefinition = "int(11) comment '排序字段'")
   private Integer sortNo;

   /**
    * 文件夹主键
    */
   @Column(name = "item_id", columnDefinition = "varchar(255) comment '文件夹主键'")
   private String itemId;

   /**
    * 库主键
    */
   @Column(name = "library_id", columnDefinition = "varchar(255) comment '库主键'")
   private String libraryId;

   /**
    * 创建人（相关方）主键
    */
   @Column(name = "create_related_parties_id", columnDefinition = "bigint(20) comment '创建人（相关方）主键'")
   private Long createRelatedPartiesId;

   /**
    * 创建人（相关方）名称(冗余）
    */
   @Column(name = "create_related_parties_name", columnDefinition = "varchar(255) comment '创建人（相关方）名称(冗余）'")
   private String createRelatedPartiesName;

   /**
    * 扩展字段1
    */
   @Column(name = "ext1", columnDefinition = "varchar(255) comment '扩展字段1'")
   private String ext1;

   /**
    * 扩展字段2
    */
   @Column(name = "ext2", columnDefinition = "varchar(255) comment '扩展字段2'")
   private String ext2;

   /**
    * 扩展字段3
    */
   @Column(name = "ext3", columnDefinition = "varchar(255) comment '扩展字段3'")
   private String ext3;

   /**
    * 扩展字段4
    */
   @Column(name = "ext4", columnDefinition = "varchar(255) comment '扩展字段4'")
   private String ext4;

   /**
    * 扩展字段5
    */
   @Column(name = "ext5", columnDefinition = "varchar(255) comment '扩展字段5'")
   private String ext5;



}

