package com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo;

import com.elitesland.tw.tw5.api.common.TwCommonVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.tw.tw5.api.yeedocpro.vo.ItemInfoDataFileDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * @author : duwh
 * @date : 2024-2-27
 * @desc : 交付项
 */
@Data
@ApiModel(description = "交付项")
public class PmsDeliverItemVO extends TwCommonVO implements Serializable {

    /**
     * 规则主键
     */
    @ApiModelProperty("规则主键")
    private Long roleId;

    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;

    /**
     * 交付项
     */
    @ApiModelProperty("交付项")
    private String name;

    /**
     * 负责人
     */
    @ApiModelProperty("负责人")
    private Long directorRelatedPartiesId;

    @ApiModelProperty("负责人")
    private String directorRelatedPartiesName;

    /**
     * 说明
     */
    @ApiModelProperty("说明")
    private String content;

    /**
     * 里程碑主键 pms_project_wbs.id
     */
    @ApiModelProperty("里程碑主键 pms_project_wbs.id")
    private Long wbsId;

    /**
     * 里程碑名称（冗余）
     */
    @ApiModelProperty("里程碑名称（冗余）")
    private String wbsName;

    /**
     * 存储路径
     */
    @ApiModelProperty("存储路径")
    private String savePath;

    /**
     * 提交内容
     */
    @ApiModelProperty("提交内容")
    private String submitContent;

    /**
     * 完成状态 已完成 未完成 UDC[PMS:DELIVER_ITEM:STATUS]
     */
    @ApiModelProperty("完成状态 已完成 未完成 UDC[PMS:DELIVER_ITEM:STATUS]")
    private String status;
    @UdcName(udcName = "PMS:DELIVER_ITEM:STATUS", codePropName = "status")
    private String statusDesc;

    /**
     * 是否展示 0不展示 1 展示
     */
    @ApiModelProperty("是否展示 0不展示 1 展示")
    private Boolean showFlag;

    /**
     * 排序字段
     */
    @ApiModelProperty("排序字段")
    private Integer sortNo;

    /**
     * 文件夹主键
     */
    @ApiModelProperty("文件夹主键")
    private String itemId;

    /**
     * 库主键
     */
    @ApiModelProperty("库主键")
    private String libraryId;

    /**
     * 创建人（相关方）主键
     */
    @ApiModelProperty("创建人（相关方）主键")
    private Long createRelatedPartiesId;

    /**
     * 创建人（相关方）名称(冗余）
     */
    @ApiModelProperty("创建人（相关方）名称(冗余）")
    private String createRelatedPartiesName;

    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;

    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;

    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;

    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;

    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;

    /**
     * 文件列表(提交内容)
     */
    private List<ItemInfoDataFileDTO> fileList;

    @ApiModelProperty("里程碑预计开始时间")
    private LocalDate preStartDate;


}

