package com.elitesland.tw.tw5.server.prd.pms.deliver.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemStatisticsVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsIframeDocInfoVO;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author : duwh
 * @date : 2024-2-27
 * @desc : 交付项Service
 */
public interface PmsDeliverItemService {

    /**
     * 新增交付项数据
     *
     * @param pmsDeliverItemPayload
     * @return
     */
    PmsDeliverItemVO save(PmsDeliverItemPayload pmsDeliverItemPayload);

    /**
     * 根据主键更新
     *
     * @param pmsDeliverItemPayload
     * @return
     */
    PmsDeliverItemVO updateAll(PmsDeliverItemPayload pmsDeliverItemPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PmsDeliverItemVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param pmsDeliverItemQuery
     * @return
     */
    PagingVO<PmsDeliverItemVO> page(PmsDeliverItemQuery pmsDeliverItemQuery);

    /**
     * 我的交付项分页查询列表
     *
     * @param pmsDeliverItemQuery pms交付项目查询
     * @return {@link PagingVO}<{@link PmsDeliverItemVO}>
     */
    PagingVO<PmsDeliverItemVO> myPage(PmsDeliverItemQuery pmsDeliverItemQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param pmsDeliverItemQuery
     * @return
     */
    List<PmsDeliverItemVO> getList(PmsDeliverItemQuery pmsDeliverItemQuery);

    List<PmsDeliverItemVO> list(PmsDeliverItemQuery pmsDeliverItemQuery);

    /**
     * 根据条件修改
     *
     * @param pmsDeliverItemPayload
     * @return
     */
    Long update(PmsDeliverItemPayload pmsDeliverItemPayload);


    /**
     * 查询数量
     *
     * @param pmsDeliverItemQuery
     * @return
     */
    Long count(PmsDeliverItemQuery pmsDeliverItemQuery);

    /**
     * 按项目id删除
     *
     * @param projectId 项目id
     * @return long
     */
    long delByProjectId(Long projectId);

    /**
     * 按交付清单规则id更新交付项显示标志
     *
     * @param roleId   交付规则主键
     * @param showFlag 显示标志
     * @return {@link Long}
     */
    Long updateShowFlagByRoleId(Long roleId, boolean showFlag);

    PmsIframeDocInfoVO getIframeDocInfo(Long projectId, String appId, HttpServletRequest request, HttpServletResponse response);

    /**
     * 数据源：来源于项目内交付清单和里程碑数据，统计到项目开始到目前日期的数据
     * 统计交付物完成情况，使用饼图根据状态区分为已完成和未完成
     * - 已完成
     * - 未完成中数据细分为
     * - 逾期（统计当前日期以前未完成的数据）
     * - 今日需完成（统计当前日期需要完成的数据）
     * - 剩余（统计后面将要完成的数据）
     *
     * @param query 查询
     * @return {@link List}<{@link PmsDeliverItemStatisticsVO}>
     */
    List<PmsDeliverItemStatisticsVO> statistics(PmsDeliverItemQuery query);
}

