package com.elitesland.tw.tw5.server.prd.pms.deliver.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.excel.EasyExcel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.yeedocpro.vo.ItemInfoDataFileDTO;
import com.elitesland.tw.tw5.server.common.ExcelEntityDataListener;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.constants.DeliverItemStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.deliver.convert.PmsDeliverItemRoleConvert;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.entity.PmsDeliverItemRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemRoleExcelPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemRolePayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemRoleQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemRoleVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.repo.PmsDeliverItemRoleRepo;
import com.elitesland.tw.tw5.server.prd.pms.deliver.repo.dao.PmsDeliverItemRoleDao;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemRoleService;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemService;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedocpro.config.YeedocProProperties;
import com.elitesland.tw.tw5.server.yeedocpro.dto.*;
import com.elitesland.tw.tw5.server.yeedocpro.service.YeedocProService;
import com.elitesland.tw.tw5.server.yeedocref.constants.YeedocRefTypeEnum;
import com.elitesland.tw.tw5.server.yeedocref.model.payload.PrdYeedocRefPayload;
import com.elitesland.tw.tw5.server.yeedocref.model.vo.PrdYeedocRefVO;
import com.elitesland.tw.tw5.server.yeedocref.service.PrdYeedocRefService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author : duwh
 * @date : 2024-2-27
 * @desc : 交付项规则Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsDeliverItemRoleServiceImpl implements PmsDeliverItemRoleService {


    private final PmsDeliverItemRoleDao pmsDeliverItemRoleDao;
    private final PmsDeliverItemRoleRepo pmsDeliverItemRoleRepo;
    private final YeedocProService yeedocProService;
    private final YeedocProProperties yeedocProProperties;
    private final PrdYeedocRefService prdYeedocRefService;
    private final UdcUtil udcUtil;
    @Resource
    @Lazy
    private PmsProjectService pmsProjectService;

    @Resource
    private PmsDeliverItemService pmsDeliverItemService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsDeliverItemRoleVO save(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        checkData(pmsDeliverItemRolePayload);
        PmsDeliverItemRoleDO pmsDeliverItemRoleDO = PmsDeliverItemRoleConvert.INSTANCE.p2d(pmsDeliverItemRolePayload);
        PmsDeliverItemRoleDO res = pmsDeliverItemRoleRepo.save(pmsDeliverItemRoleDO);
        return PmsDeliverItemRoleConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsDeliverItemRoleVO updateAll(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        Assert.notNull(pmsDeliverItemRolePayload.getId(), "id is null");
        PmsDeliverItemRoleVO res = save(pmsDeliverItemRolePayload);
        return res;

    }


    @Override
    public PmsDeliverItemRoleVO get(Long id) {
        if (null == id) {
            return null;
        }
        PmsDeliverItemRoleVO res = pmsDeliverItemRoleDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PmsDeliverItemRoleVO> page(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        PagingVO<PmsDeliverItemRoleVO> res = pmsDeliverItemRoleDao.page(pmsDeliverItemRoleQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = pmsDeliverItemRoleDao.del(ids);
        return res;

    }

    @Override
    public List<PmsDeliverItemRoleVO> getList(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        List<PmsDeliverItemRoleVO> res = pmsDeliverItemRoleDao.getList(pmsDeliverItemRoleQuery);
        return res;
    }

    @Override
    public long count(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        Long count = pmsDeliverItemRoleDao.count(pmsDeliverItemRoleQuery);
        return count;
    }


    /**
     * 数据校验
     *
     * @param pmsDeliverItemRolePayload
     */
    private void checkData(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {

//        Assert.notEmpty(pmsDeliverItemRolePayload.getType(), "类型不能为空");
//        Assert.notNull(pmsDeliverItemRolePayload.getUserId(), "用户id不能为空");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        Assert.notNull(pmsDeliverItemRolePayload.getId(), "id不能为空");
        Long res = pmsDeliverItemRoleDao.update(pmsDeliverItemRolePayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<String, Object> excelImport(MultipartFile file, Long projectId, Boolean force, HttpServletResponse response) {
        Map<String, Object> result = new HashMap<>();
        Assert.notNull(file, "文件不能为空");
        Assert.notNull(projectId, "项目id不能为空");
        if (force == null) {
            force = false;
        }
        // 数据库原有数据
        PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery = new PmsDeliverItemRoleQuery();
        pmsDeliverItemRoleQuery.setProjectId(projectId);
        List<PmsDeliverItemRoleVO> pmsDeliverItemRoleVOList = getList(pmsDeliverItemRoleQuery);
        if (force) {
            // 先全部清空，再插入
            pmsDeliverItemRoleDao.deleteByProjectId(projectId);
        }
        ExcelEntityDataListener<PmsDeliverItemRoleExcelPayload> dataListener = new ExcelEntityDataListener<>();
        try {
            EasyExcel.read(file.getInputStream(), PmsDeliverItemRoleExcelPayload.class, dataListener).sheet(0).headRowNumber(2).doRead();
        } catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据异常，请检查导入 excel的列值是否与模板对应");
        }
        List<PmsDeliverItemRoleExcelPayload> excelDataList = dataListener.getDatas();
        if (CollectionUtils.isEmpty(excelDataList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据不能为空！");
        }
        // udc反向翻译
        // excelDataList = udcUtil.translateListReverse(excelDataList);
        boolean flag = true;
        String error = "该表格有数据未填写完整，请重新上传";
        for (int i = 0; i < excelDataList.size(); i++) {
            PmsDeliverItemRoleExcelPayload pmsDeliverItemRoleExcelPayload = excelDataList.get(i);
            if (!StringUtils.hasText(pmsDeliverItemRoleExcelPayload.getSavePath())
                || !StringUtils.hasText(pmsDeliverItemRoleExcelPayload.getName())
                || !StringUtils.hasText(pmsDeliverItemRoleExcelPayload.getShowConfigFlagStr())
                || !StringUtils.hasText(pmsDeliverItemRoleExcelPayload.getContent())
            ) {
                flag = false;
                break;
            }
        }

        if (!flag) {
            throw TwException.error("", error);
        }

        //excelDataList 中 savePath字段内容重复的报错
        // Set<String> savePathSet = new HashSet<>();
        // for (int i = 0; i < excelDataList.size(); i++) {
        //     PmsDeliverItemRoleExcelPayload pmsDeliverItemRoleExcelPayload = excelDataList.get(i);
        //     if (savePathSet.contains(pmsDeliverItemRoleExcelPayload.getSavePath())) {
        //         throw TwException.error("", "第" + i + 1 + "行，保存路径重复");
        //     } else {
        //         savePathSet.add(pmsDeliverItemRoleExcelPayload.getSavePath());
        //     }
        // }


        List<PmsDeliverItemRoleDO> pmsDeliverItemRoleDOS = PmsDeliverItemRoleConvert.INSTANCE.e2dList(excelDataList);
        pmsDeliverItemRoleDOS.forEach(pmsDeliverItemRoleDO -> {
            pmsDeliverItemRoleDO.setProjectId(projectId);
            pmsDeliverItemRoleVOList.stream()
                .filter(item -> pmsDeliverItemRoleDO.getSavePath().equals(item.getSavePath()) && StringUtils.hasText(item.getItemId())).findFirst().ifPresent(item -> {
                    pmsDeliverItemRoleDO.setItemId(item.getItemId());
                    pmsDeliverItemRoleDO.setLibraryId(item.getLibraryId());
                });
        });

        // List<String> pathArry = pmsDeliverItemRoleDOS.stream()
        //     .filter(pmsDeliverItemRoleDO -> ObjectUtils.isEmpty(pmsDeliverItemRoleDO.getItemId()))
        //     .map(item -> "/" + item.getSavePath())
        //     .collect(Collectors.toList());


        // pathArry 根据 pmsDeliverItemRoleVOList 中的savePath相等，itemId有值的过滤掉，因为数据库中已经存在了
        // 没有在易稻壳创建过的 再创建一次
        // pathArry = pathArry.stream().filter(item -> {
        //     long count = pmsDeliverItemRoleVOList.stream().filter(pmsDeliverItemRoleVO -> pmsDeliverItemRoleVO.getSavePath().equals(item) && StringUtils.hasText(pmsDeliverItemRoleVO.getItemId())).count();
        //     if (count > 0) {
        //         return false;
        //     }
        //     return true;
        // }).collect(Collectors.toList());


        String pmsLibraryId = yeedocProProperties.getPmsLibraryId();
        PrdYeedocRefVO prdYeedocRefVO = prdYeedocRefService.queryByRefTypeAndRefId(YeedocRefTypeEnum.PMS_PROJECT, projectId);
        // 如果不存在的话，同步去易稻壳创建项目文件夹
        if (prdYeedocRefVO == null) {
            // 再次创建项目文件夹
            // 根据项目id查询易稻壳文件夹id
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(projectId);
            String fileName = pmsProjectVO.getProjName() + "-" + pmsProjectVO.getProjNo() + "";
            // String fileName = "测试项目后续删-" + projectId + "";
            CreateFolderTwPayload createFolderTwPayload = new CreateFolderTwPayload();
            createFolderTwPayload.setLibraryId(pmsLibraryId);
            createFolderTwPayload.setPathArry(Arrays.asList("/" + fileName));
            YeedocCreateFolderForTwDTO folderReturn = yeedocProService.createFolderForTw(createFolderTwPayload);

            PrdYeedocRefPayload save = new PrdYeedocRefPayload();
            save.setRefType(YeedocRefTypeEnum.PMS_PROJECT.getCode());
            save.setRefId(projectId);
            save.setLibraryId(pmsLibraryId);
            save.setItemId(folderReturn.getFolderId());
            save.setItemName(folderReturn.getLeafName());
            TwOutputUtil<PrdYeedocRefVO> insert = prdYeedocRefService.insert(save);
            if (insert.isOk()) {
                prdYeedocRefVO = insert.getData();
            }
        }
        String projectFolderId = prdYeedocRefVO.getItemId();

        pmsDeliverItemRoleDOS.stream()
            .filter(pmsDeliverItemRoleDO -> ObjectUtils.isEmpty(pmsDeliverItemRoleDO.getItemId()))
            .forEach(item -> {
                item.setLibraryId(pmsLibraryId);
                CreateFolderPayload createFolderTwPayload = new CreateFolderPayload();
                createFolderTwPayload.setLibraryId(pmsLibraryId);
                createFolderTwPayload.setFolderId(projectFolderId);
                createFolderTwPayload.setPath("/" + item.getSavePath());
                String resultStr = yeedocProService.createFolder(createFolderTwPayload);
                YeedocCreateFolderDataDTO createFolderDataDTO = yeedocProService.createFolderReturn(resultStr);
                String folderId = createFolderDataDTO.getFolderId();
                item.setItemId(folderId);
            });

        // 批量创建文件夹
        // if (!CollectionUtils.isEmpty(pathArry)) {
        //
        //     pathArry.forEach(item -> {
        //         CreateFolderPayload createFolderTwPayload = new CreateFolderPayload();
        //         createFolderTwPayload.setLibraryId(pmsLibraryId);
        //         createFolderTwPayload.setItemId(projectFolderId);
        //         createFolderTwPayload.setPath(item);
        //         String resultStr = yeedocProService.createFolder(createFolderTwPayload);
        //         YeedocCreateFolderTwReturnDTO folderReturn = yeedocProService.createFolderForTwReturnOne(resultStr);
        //
        //     });
        //
        //     CreateFolderTwPayload createFolderTwPayload = new CreateFolderTwPayload();
        //     createFolderTwPayload.setLibraryId(pmsLibraryId);
        //     createFolderTwPayload.setItemId(projectFolderId);
        //     createFolderTwPayload.setPathArry(pathArry);
        //     String createFolderBatchResult = yeedocProService.createFolderForTw(createFolderTwPayload);
        //     List<YeedocCreateFolderTwReturnDTO> folderReturn = yeedocProService.createFolderReturn(createFolderBatchResult);
        //     pmsDeliverItemRoleDOS.forEach(pmsDeliverItemRoleDO -> {
        //         folderReturn.stream().filter(item ->
        //                 pmsDeliverItemRoleDO.getSavePath().equals(item.getLeafName()))
        //             .findFirst().ifPresent(item -> {
        //                 pmsDeliverItemRoleDO.setItemId(item.getFolderId());
        //                 pmsDeliverItemRoleDO.setLibraryId(pmsLibraryId);
        //             });
        //     });
        // }

        pmsDeliverItemRoleRepo.saveAll(pmsDeliverItemRoleDOS);
        result.put("successNum", pmsDeliverItemRoleDOS.size());

        // List<PmsDeliverItemPayload> itemList = new ArrayList<>();
        // pmsDeliverItemRoleDOS.forEach(pmsDeliverItemRoleDO -> {
        //     PmsDeliverItemPayload pmsDeliverItemPayload = new PmsDeliverItemPayload();
        //     BeanUtils.copyProperties(pmsDeliverItemRoleDO, pmsDeliverItemPayload);
        //     pmsDeliverItemPayload.setProjectId(projectId);
        //     pmsDeliverItemPayload.setRoleId(pmsDeliverItemRoleDO.getId());
        //     itemList.add(pmsDeliverItemPayload);
        // });
        // itemList.forEach(pmsDeliverItemPayload -> {
        //     pmsDeliverItemService.save(pmsDeliverItemPayload);
        // });
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateItemByRole(Long projectId) {
        // 先清空交付项  ,仅清空验收标准内未关联的
        pmsDeliverItemService.delByProjectId(projectId);

        PmsDeliverItemQuery pmsDeliverItemQuery = new PmsDeliverItemQuery();
        pmsDeliverItemQuery.setProjectId(projectId);
        List<PmsDeliverItemVO> pmsDeliverItemVOList = pmsDeliverItemService.getList(pmsDeliverItemQuery);
        // 查询交付清单
        PmsDeliverItemRoleQuery query = new PmsDeliverItemRoleQuery();
        query.setProjectId(projectId);
        List<PmsDeliverItemRoleVO> roleList = getList(query);

        List<PmsDeliverItemPayload> itemList = new ArrayList<>();
        roleList.forEach(pmsDeliverItemRoleDO -> {
            long count = pmsDeliverItemVOList.stream()
                .filter(item ->
                    (StringUtils.hasText(item.getName()) && item.getName().equals(pmsDeliverItemRoleDO.getName()))
                        && (StringUtils.hasText(item.getSavePath()) && item.getSavePath().equals(pmsDeliverItemRoleDO.getSavePath()))
                )
                .count();
            if (count > 0) {
                return;
            }
            PmsDeliverItemPayload pmsDeliverItemPayload = new PmsDeliverItemPayload();
            BeanUtils.copyProperties(pmsDeliverItemRoleDO, pmsDeliverItemPayload);
            pmsDeliverItemPayload.setProjectId(pmsDeliverItemRoleDO.getProjectId());
            pmsDeliverItemPayload.setRoleId(pmsDeliverItemRoleDO.getId());
            pmsDeliverItemPayload.setStatus(DeliverItemStatusEnum.NO.getCode());
            // 不允许裁剪，默认必须展示
            if (null != pmsDeliverItemRoleDO.getShowConfigFlag() && !pmsDeliverItemRoleDO.getShowConfigFlag()) {
                pmsDeliverItemPayload.setShowFlag(true);
            } else {
                // 2）若【是否允许裁剪】为【是】，则在【裁剪状态】中显示开关
                // a、当开关关闭时，为实际所需交付项，该交付项数据显示在交付项清单列表中
                // b、当开关开启时，为裁剪项，该交付项数据不显示在交付项清单列表中
                if (pmsDeliverItemRoleDO.getNoShowFlag() != null && pmsDeliverItemRoleDO.getNoShowFlag()) {
                    pmsDeliverItemPayload.setShowFlag(false);
                } else {
                    pmsDeliverItemPayload.setShowFlag(true);
                }
            }
            itemList.add(pmsDeliverItemPayload);
        });
        Set<String> itemIdList = itemList.stream()
            .filter(item -> StringUtils.hasText(item.getItemId()))
            .map(PmsDeliverItemPayload::getItemId)
            .collect(Collectors.toSet());
        // 判断是否存在文件数据
        ItemInfoPayload itemInfoPayload = new ItemInfoPayload();
        itemInfoPayload.setItemIds(itemIdList);
        Map<String, List<ItemInfoDataFileDTO>> stringListMap = yeedocProService.itemInfoReturn(itemInfoPayload);
        if (null != stringListMap) {
            itemList.forEach(i -> {
                String itemId = i.getItemId();
                List<ItemInfoDataFileDTO> itemInfoDataFileDTOS = stringListMap.get(itemId);
                if (!CollectionUtils.isEmpty(itemInfoDataFileDTOS)) {
                    i.setStatus(DeliverItemStatusEnum.OK.getCode());
                }
            });
        }

        int k = 0;
        for (int i = 0; i < itemList.size(); i++) {
            PmsDeliverItemPayload pmsDeliverItemPayload = itemList.get(i);
            pmsDeliverItemService.save(pmsDeliverItemPayload);
            k++;
        }
        return k;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateNoShowFlag(PmsDeliverItemRolePayload payload) {
        Long roleId = payload.getId();
        Assert.notNull(roleId, "id不能为空");
        Boolean noShowFlag = payload.getNoShowFlag();
        Assert.notNull(noShowFlag, "noShowFlag不能为空");

        pmsDeliverItemRoleDao.update(payload);

        boolean showFlag;
        // 2）若【是否允许裁剪】为【是】，则在【裁剪状态】中显示开关
        // a、当开关关闭时，为实际所需交付项，该交付项数据显示在交付项清单列表中
        // b、当开关开启时，为裁剪项，该交付项数据不显示在交付项清单列表中
        if (noShowFlag != null && noShowFlag) {
            showFlag = false;
        } else {
            showFlag = true;
        }
        // 根据主键 动态更新 交付项中的状态
        return pmsDeliverItemService.updateShowFlagByRoleId(roleId, showFlag);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateNoShowFlagList(List<PmsDeliverItemRolePayload> list) {
        Long sum = 0l;
        if (!CollectionUtils.isEmpty(list)) {
            for (PmsDeliverItemRolePayload payload : list) {
                Long l = updateNoShowFlag(payload);
                sum = sum + l;
            }
        }
        return sum;
    }


}

