package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 预算明细
 *
 * @author xxb
 * @date 2023-07-10
 */
@Entity
@Table(name = "pms_budget_detail", indexes = {
        @Index(name = "budget_index", columnList = "budget_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_detail", comment = "预算明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsBudgetDetailDO extends BaseModel implements Serializable  {
    /** 预算id */
    @Comment("预算id")
    @Column(name = "budget_id")
    private Long budgetId;

    /** 资源类型(labour人工、material材料、device设备) */
    @Comment("资源类型(labour人工、material材料、device设备)")
    @Column()
    private String sourceType;
    /** 项目角色主键 */
    @Comment("项目角色主键")
    @Column()
    private Long projectRoleId;
    /** 角色单价 */
    @Comment("角色单价")
    @Column()
    private BigDecimal unitPrice;
    /** 平工期（天 */
    @Comment("平工期（天")
    @Column()
    private BigDecimal days;
    /** 费用总预算 */
    @Comment("费用总预算")
    @Column()
    private BigDecimal totalMoney;
    /** 使用占比=已使用预算金额/预算总金额 */
    @Comment("使用占比=已使用预算金额/预算总金额")
    @Column()
    private BigDecimal proportion;
    /** 已使用预算金额=已经报销完成的金额 */
    @Comment("已使用预算金额=已经报销完成的金额")
    @Column()
    private BigDecimal usedMoney;
    /** 科目主键 */
    @Comment("科目主键")
    @Column()
    private Long subjectId;
    /** 科目父主键 */
    @Comment("科目父主键")
    @Column()
    private Long subjectParentId;

    public void copy(PmsBudgetDetailDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
