package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 预算科目
 *
 * @author xxb
 * @date 2023-04-23
 */
@Entity
@Table(name = "pms_budget_subject", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_subject", comment = "预算科目")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsBudgetSubjectDO extends BaseModel implements Serializable  {
    /** 科目编号 */
    @Comment("科目编号")
    @Column()
    private String subjectCode;

    /** 科目名称 */
    @Comment("科目名称")
    @Column()
    private String subjectName;

    /** 上一级科目即父主键 */
    @Comment("上一级科目即父主键")
    @Column()
    private Long parentId;

    /** 上一级科目即父名称 */
    @Comment("上一级科目即父名称")
    @Column()
    private String parentName;

    /** 层级 默认是1，最多到2 */
    @Comment("层级")
    @Column(columnDefinition = "int default 1")
    private Integer subjectLevel;

    /**
     * 科目状态
     */
    @Comment(value = "科目状态 0正常  1弃用", defaultValue = "0")
    @Column()
    private Integer subjectStatus = 0;

    public void copy(PmsBudgetSubjectDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
