package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 预算科目明细
 *
 * @author Echo
 * @date 2023-04-24
 */
@Entity
@Table(name = "pms_budget_template_subject", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_template_subject", comment = "预算模板科目")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsBudgetTemplateSubjectDO extends BaseModel implements Serializable  {
    /** 模板主键 */
    @Comment("模板主键")
    @Column()
    private Long templateId;
    /** 科目id */
    @Comment("科目id")
    @Column()
    private Long subjectId;

    public void copy(PmsBudgetTemplateSubjectDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
