package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

;

/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
@Entity
@Table(name = "pms_project_activity", indexes = {
        @Index(name = "proj_index", columnList = "proj_id"),
        @Index(name = "parent_index", columnList = "parent_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_activity", comment = "项目活动")
@Getter


@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectActivityDO extends BaseModel implements Serializable {
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;
    /**
     * 活动编号
     */
    @Comment("活动编号")
    @Column()
    private String actNo;
    /**
     * 活动名称
     */
    @Comment("活动名称")
    @Column()
    private String actName;

    /**
     * 父级阶段id
     */
    @Comment("父级阶段id")
    @Column(name = "parent_id")
    private Long parentId;
    /**
     * 父级阶段编号
     */
    @Comment("父级阶段编号")
    @Column()
    private String parentNo;
    /**
     * 是否里程碑标志
     */
    @Comment("是否里程碑标志")
    @Column()
    private Integer milestoneFlag;
    /**
     * 是否阶段标志
     */
    @Comment("是否阶段标志")
    @Column()
    private Integer phaseFlag;
    /**
     * 是否来自模板标志
     */
    @Comment("是否来自模板标志")
    @Column()
    private Integer fromtmplFlag;
    /**
     * 起日期
     */
    @Comment("起日期")
    @Column()
    private LocalDate startDate;
    /**
     * 止日期
     */
    @Comment("止日期")
    @Column()
    private LocalDate endDate;
    /**
     * 排序号
     */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /**
     * 工作台显示标志
     */
    @Comment("工作台显示标志")
    @Column()
    private Integer workbenchFlag;
    /**
     * 收款计划ID
     */
    @Comment("收款计划ID")
    @Column()
    private Long receivePlanId;

    @Comment("当量系数")
    @Column()
    private BigDecimal eqvaRate;

    @Comment("规划当量")
    @Column()
    private BigDecimal planEqva;

    @Comment("原始规划当量")
    @Column()
    private BigDecimal originalPlanEqva;

    @Comment("变更当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal additionEqva;

    /**
     * 拨付状态
     */
    @Comment("拨付状态")
    @Column()
    private String allocateStatus;


    @Comment("已派发当量")
    @Column()
    private BigDecimal distedEqva;


    @Comment("拨付当量")
    @Column()
    private BigDecimal allocateEqva;


    @Comment("拨付费用")
    @Column()
    private BigDecimal allocateCost;

    /**
     * 明细控制
     */
    @Comment("明细控制 ")
    @Column()
    private Boolean detailControlFlag;

    @Comment("占用当量数")
    @Column()
    private BigDecimal occupyEqva;
    @Comment("已使用当量数")
    @Column()
    private BigDecimal usedEqva;

    @Comment("使用当量占比")
    @Column()
    private BigDecimal usedEqvaProportion;

    @Comment("使用费用占比")
    @Column()
    private BigDecimal usedAmtProportion;

    @Comment("拓展字段1")
    @Column()
    private String ext1;

    public void copy(PmsProjectActivityDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
