package com.elitesland.tw.tw5.server.prd.pms.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 项目工作日历
 * @date 2023-06-21
 */
@Entity
@Table(name = "pms_project_calendar", indexes = {
        @Index(name = "source_index", columnList = "source_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_calendar", comment = "项目工作日历表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectCalendarDO extends BaseModel implements Serializable {

    @Comment("关联主键")
    @Column(name = "source_id")
    private Long sourceId;

    @Comment("关联类型：project、WBS")
    @Column()
    private String sourceType;

    @Comment("开始日期")
    @Column()
    private LocalDate startDate;

    @Comment("结束日期")
    @Column()
    private LocalDate endDate;

    @Comment("日历详情")
    @Column(columnDefinition = "json")
    private String calendarInfo;

    @Comment("是否设置固定班制 1设置 0不设置")
    @Column()
    private Integer setFixedShiftSystemFlag;

    @Comment("休假日")
    @Column()
    private String holiday;

}
