package com.elitesland.tw.tw5.server.prd.pms.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs资源分配
 */
@Entity
@Table(name = "pms_project_wbs_resource")
@org.hibernate.annotations.Table(appliesTo = "pms_project_wbs_resource", comment = "项目wbs资源分配")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PmsProjectWbsResourceDO extends BaseModel {


    /**
     * wbs主键
     */
    @Column(name = "wbs_id", columnDefinition = "bigint(20) comment 'wbs主键'")
    private Long wbsId;

    /**
     * 项目id
     */
    @Column(name = "project_id", columnDefinition = "bigint(20) comment '项目id'")
    private Long projectId;

    /**
     * 相关方id
     */
    @Column(name = "relate_parties_id", columnDefinition = "bigint(20) comment '相关方id'")
    private Long relatePartiesId;

    /**
     * 角色id
     */
    @Column(name = "role_id", columnDefinition = "bigint(20) comment '角色id'")
    private Long roleId;

    /**
     * 负责人标识
     */
    @Column(name = "manager_user_flag", columnDefinition = "tinyint(1) comment '负责人标识'")
    private Boolean managerUserFlag;

    /**
     * 投入精力
     */
    @Column(name = "input", columnDefinition = "decimal(20,2) comment '投入精力'")
    private BigDecimal input;


    /**
     * 版本id
     */
    @Column(name = "version_id", columnDefinition = "bigint(20) comment '版本id'")
    private Long versionId;

    /**
     * 版本号
     */
    @Column(name = "version_no", columnDefinition = "int(11) comment '版本号'")
    private Integer versionNo;

    /**
     * 有效版本关联id
     */
    @Column(name = "eff_relate_id", columnDefinition = "bigint(20) comment '有效版本关联id'")
    private Long effRelateId;


    /**
     * wbs编码
     */
    @Column(name = "wbs_code", columnDefinition = "varchar(255) comment 'wbs编码'")
    private String wbsCode;
}

