package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * wbs活动成预估
 *
 * @author carl
 * @date 2023-04-06
 */
@Entity
@Table(name = "pms_wbs_act_cost", indexes = {
        @Index(name = "project_index", columnList = "project_id"),
        @Index(name = "wbs_index", columnList = "wbs_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_wbs_act_cost", comment = "wbs活动成预估")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsWbsActCostDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column(name = "project_id")
    private Long projectId;
    /**
     * wbs主键(仅活动类型)
     */
    @Comment("wbs主键(仅活动类型)")
    @Column(name = "wbs_id")
    private Long wbsId;
    /**
     * wbs描述（名称）
     */
    @Comment("wbs描述（名称）")
    @Column()
    private String wbsName;
    /**
     * 成本要素
     */
    @Comment("成本要素")
    @Column()
    private String costName;
    /**
     * 成本预估
     */
    @Comment("成本预估")
    @Column()
    private BigDecimal costEstimate;

    public void copy(PmsWbsActCostDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
