package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInnerProjectApplyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInnerProjectApplyQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInnerProjectApplyService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInnerProjectApplyVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DataUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsInnerProjectApplyConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsInnerProjectApplyDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsInnerProjectApplyDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsInnerProjectApplyRepo;
import com.elitesland.tw.tw5.server.yeedocref.YeedocUtils;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;

/**
 * 内部项目申请
 *
 * @author carl
 * @date 2023-08-23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsInnerProjectApplyServiceImpl extends BaseServiceImpl implements PmsInnerProjectApplyService {

    private final PmsInnerProjectApplyRepo pmsInnerProjectApplyRepo;
    private final PmsInnerProjectApplyDAO pmsInnerProjectApplyDAO;

    private final WorkflowUtil workflowUtil;

    private final FileUtil fileUtil;

    private final CacheUtil cacheUtil;

    private final PrdSystemRoleService roleService;
    private final SaleConContractService saleConContractService;

    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;

    private final PmsProjectDAO pmsProjectDAO;
    private final PersonPlanService personPlanService;
    @Value("${tw5.sys_default.ou_id:20429}")
    private Long ou_book_id;
    private final YeedocUtils yeedocUtils;

    @Override
    public PagingVO<PmsInnerProjectApplyVO> queryPaging(PmsInnerProjectApplyQuery query) {
        //处理权限
        operPermissionFlag(query);
        return pmsInnerProjectApplyDAO.queryPaging(query);
    }

    /**
     * 权限处理
     *
     * @param query
     */
    void operPermissionFlag(PmsInnerProjectApplyQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        //需要处理权限
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode()));
        query.setPermissionFlag(!rolePermission);
//        if (!rolePermission) {
//            Set<Long> longs = employeeService.querySubordinatesIdsByUserId(loginUserId);
//            query.setLowerUserIds(longs);
//
//        }
    }

    @Override
    public List<PmsInnerProjectApplyVO> queryListDynamic(PmsInnerProjectApplyQuery query) {
        return pmsInnerProjectApplyDAO.queryListDynamic(query);
    }

    @Override
    public PmsInnerProjectApplyVO queryByKey(Long key) {
        PmsInnerProjectApplyDO entity = pmsInnerProjectApplyRepo.findById(key).orElseGet(PmsInnerProjectApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsInnerProjectApplyVO vo = PmsInnerProjectApplyConvert.INSTANCE.toVo(entity);
        transferData(vo);
        //流程实例名称 P08.内部项目立项申请-项目名称
        vo.setProcInstName("P08.内部项目立项申请" + "-" + vo.getProjName());
        return vo;
    }


    @Override
    public void addProject(long id, long projId) {
        // 添加项目id
        pmsInnerProjectApplyDAO.addProjId(id, projId);
        // 将合同id 更新到 项目表
        PmsInnerProjectApplyVO innerProjectApplyVO = pmsInnerProjectApplyDAO.queryByKey(id);
        pmsProjectDAO.addContractId(projId, innerProjectApplyVO.getContractId());
        //将内部项目申请的资源规划拉到内部项目
        PersonPlanVO personPlanVO = personPlanService.getByObjIdAndPlanType(id, Arrays.asList(PersonPlanTypeEnum.INNER_PROJECT.getCode()));
        if (personPlanVO != null) {
            PersonPlanPayload personPlanPayload = new PersonPlanPayload();
            BeanUtils.copyProperties(personPlanVO, personPlanPayload);
            personPlanPayload.setId(null);
            personPlanPayload.setVersion("0");
            personPlanPayload.setPlanType(PersonPlanTypeEnum.PROJECT.getCode());
            personPlanPayload.setObjId(projId);
            List<PersonPlanDtlVO> personPlanDtlVOList = personPlanVO.getPersonPlanDtlVOList();
            if (!CollectionUtils.isEmpty(personPlanDtlVOList)) {
                List<PersonPlanDtlPayload> personPlanDtlPayloadList = new ArrayList<>();
                personPlanDtlVOList.stream().forEach(personPlanDtlVO -> {
                    PersonPlanDtlPayload personPlanDtlPayload = new PersonPlanDtlPayload();
                    BeanUtils.copyProperties(personPlanDtlVO, personPlanDtlPayload);
                    personPlanDtlPayload.setId(null);
                    personPlanDtlPayload.setPlanId(null);
                    personPlanDtlPayloadList.add(personPlanDtlPayload);
                });
                personPlanPayload.setPersonPlanDtlPayloadList(personPlanDtlPayloadList);
            }
            personPlanService.save(personPlanPayload);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsInnerProjectApplyVO save(PmsInnerProjectApplyPayload payload) {
        //数据长度校验
        DataUtil.checkDataLength(payload, null);

        //内部项目工作类型选择有限制
        Boolean errFlag = true;
        PrdSystemSelectionVO selection = cacheUtil.getSystemSelection("salecon:work_type");
        if (!ObjectUtils.isEmpty(selection)) {
            Optional<PrdSystemSelectionVO> optional = selection.getChildren().stream().filter(v -> v.getSelectionValue().equals(payload.getWorkType())).findFirst();
            if (optional.isPresent()) {
                PrdSystemSelectionVO systemSelectionVO = optional.get();
                if ("NO_CONTRACT".equals(systemSelectionVO.getExtString3())) {
                    errFlag = false;
                }
            }
        }
        if (errFlag) {
            throw TwException.error("", "内部项目工作类型选择不符合限制,请核验！");
        }
        /**
         * 迪博内部项目不走流程
         * 1.创建虚拟合同
         * 2.创建项目
         * 3.创建申请单
         */
        String code = generateSeqNum("PMS_APPLY_PROJECT");
        payload.setApplyNo(code);
        payload.setApprStatus(ProjectStatusEnum.ACTIVE.getCode());
        //保存虚拟合同
        SaleConContractVO contract = createContract(payload);
        // 附件处理
        this.innerPrjFileHandle(payload);
        PmsInnerProjectApplyDO entityDo = PmsInnerProjectApplyConvert.INSTANCE.toDo(payload);

        PmsProjectDO pmsProjectDO = new PmsProjectDO();
        BeanUtils.copyProperties(entityDo, pmsProjectDO);
        pmsProjectDO.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        pmsProjectDO.setProjNo(code);
        pmsProjectDO.setContractId(contract.getId());
        pmsProjectDO.setPlanStartDate(entityDo.getStartDate());
        pmsProjectDO.setPlanEndDate(entityDo.getEndDate());
        if (pmsProjectDO.getRelatedProjId() != null) {
            List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryByKeys(Arrays.asList(pmsProjectDO.getRelatedProjId()));
            if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
                pmsProjectDO.setRelatedProjNo(pmsProjectVOS.get(0).getProjNo());
            }
        }
        PmsProjectTemplateVO pmsProjectTemplateVO = pmsProjectTemplateDAO.queryByKey(pmsProjectDO.getProjTempId());
        pmsProjectDO.setSubjectTempId(pmsProjectTemplateVO.getSubjectTemplateId());
        PmsProjectDO save = pmsProjectDAO.save(pmsProjectDO);

        entityDo.setProjId(save.getId());
        entityDo.setContractId(contract.getId());
        entityDo = pmsInnerProjectApplyDAO.save(entityDo);


        PmsInnerProjectApplyVO innerProjectApplyVO = PmsInnerProjectApplyConvert.INSTANCE.toVo(entityDo);
//        if (ObjectUtils.isEmpty(payload.getId())) {
//            payload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
//            // 设置编号
//            payload.setApplyNo(generateSeqNum("PMS_APPLY_PROJECT"));
//            innerProjectApplyVO = insert(payload);
//        } else {
//            innerProjectApplyVO = update(payload);
//        }
//        //新增提交流程模式
//        if (payload.getSubmitFlag() && !ObjectUtils.isEmpty(innerProjectApplyVO) && ProjectStatusEnum.CREATE.getCode().equals(innerProjectApplyVO.getApprStatus())) {
//            submitReportProc(innerProjectApplyVO);
//        }
//        transferData(innerProjectApplyVO);
        return innerProjectApplyVO;
    }

    SaleConContractVO createContract(PmsInnerProjectApplyPayload projApplyNoContract) {
        // 新增主合同数据
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setName(projApplyNoContract.getProjName() + "-虚拟合同");
        payload.setStatus("ACTIVE");
        payload.setMainType(SaleConEnum.MAIN.getCode());
        payload.setPlatType(SaleConEnum.FICTITIOUS.getCode());
        payload.setOuBookId(ou_book_id);
        payload.setAmt(BigDecimal.ZERO);
        payload.setExtraAmt(BigDecimal.ZERO);
        payload.setTaxRate(BigDecimal.ZERO);
        payload.setEffectiveAmt(BigDecimal.ZERO);
        payload.setGrossProfit(BigDecimal.ZERO);
        payload.setRatedEqva(BigDecimal.ZERO);
        payload.setRatedExpense(BigDecimal.ZERO);
        payload.setProductClass("05");
        payload.setProductSubClass("TW");
        //客户承担差旅费，默认不承担
        payload.setCustBarExpense("0");
        // 工作类型，币种，交付BU，交付负责人，销售负责人
        payload.setWorkType(projApplyNoContract.getWorkType());
        payload.setCurrCode(projApplyNoContract.getCurrCode());
        payload.setDeliUserId(projApplyNoContract.getDeliResId());
        payload.setDeliBuId(projApplyNoContract.getDeliBuId());
        payload.setSaleManUserId(projApplyNoContract.getSalesmanResId());
        payload.setSignDate(LocalDate.now());
        payload.setProcInstStatus(ProcInstStatus.APPROVED);
        payload.setApprovedTime(LocalDateTime.now());
        payload.setCreateUserId(projApplyNoContract.getCreateUserId());
        payload.setFileFlag(false);
        SaleConContractVO conContractVO = saleConContractService.insert(payload);

        // 新增子合同数据(T_CONTRACT)
        payload.setParentId(conContractVO.getId());
        payload.setId(null);
        payload.setMainType(SaleConEnum.SUB.getCode());
        payload.setName(projApplyNoContract.getProjName() + "-虚拟子合同");
        conContractVO = saleConContractService.insert(payload);

        return conContractVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsInnerProjectApplyVO insert(PmsInnerProjectApplyPayload payload) {
        PmsInnerProjectApplyDO entityDo = PmsInnerProjectApplyConvert.INSTANCE.toDo(payload);
        return PmsInnerProjectApplyConvert.INSTANCE.toVo(pmsInnerProjectApplyRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsInnerProjectApplyVO update(PmsInnerProjectApplyPayload payload) {
        PmsInnerProjectApplyDO entity = pmsInnerProjectApplyRepo.findById(payload.getId()).orElseGet(PmsInnerProjectApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsInnerProjectApplyDO entityDo = PmsInnerProjectApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsInnerProjectApplyConvert.INSTANCE.toVo(pmsInnerProjectApplyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsInnerProjectApplyPayload payload) {
        PmsInnerProjectApplyDO entity = pmsInnerProjectApplyRepo.findById(payload.getId()).orElseGet(PmsInnerProjectApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 附件处理
        this.innerPrjFileHandle(payload);
        long result = pmsInnerProjectApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsInnerProjectApplyDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createContract(long id) {
        PmsInnerProjectApplyVO projApplyNoContract = pmsInnerProjectApplyDAO.queryByKey(id);
        if (projApplyNoContract != null) {
            // 新增主合同数据
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setName(projApplyNoContract.getProjName() + "-虚拟合同");
            payload.setStatus("ACTIVE");
            payload.setMainType(SaleConEnum.MAIN.getCode());
            payload.setPlatType(SaleConEnum.FICTITIOUS.getCode());
            payload.setOuBookId(ou_book_id);
            payload.setAmt(BigDecimal.ZERO);
            payload.setExtraAmt(BigDecimal.ZERO);
            payload.setTaxRate(BigDecimal.ZERO);
            payload.setEffectiveAmt(BigDecimal.ZERO);
            payload.setGrossProfit(BigDecimal.ZERO);
            payload.setRatedEqva(BigDecimal.ZERO);
            payload.setRatedExpense(BigDecimal.ZERO);
            payload.setProductClass("50");
            payload.setProductSubClass("TW");
            //客户承担差旅费，默认不承担
            payload.setCustBarExpense("0");
            // 工作类型，币种，交付BU，交付负责人，销售负责人
            payload.setWorkType(projApplyNoContract.getWorkType());
            payload.setCurrCode(projApplyNoContract.getCurrCode());
            payload.setDeliUserId(projApplyNoContract.getDeliResId());
            payload.setDeliBuId(projApplyNoContract.getDeliBuId());
            payload.setSaleManUserId(projApplyNoContract.getSalesmanResId());
            payload.setSignDate(LocalDate.now());
            payload.setProcInstStatus(ProcInstStatus.APPROVED);
            payload.setApprovedTime(LocalDateTime.now());
            payload.setCreateUserId(projApplyNoContract.getCreateUserId());
            payload.setFileFlag(false);
            SaleConContractVO conContractVO = saleConContractService.insert(payload);

            // 新增子合同数据(T_CONTRACT)
            payload.setParentId(conContractVO.getId());
            payload.setId(null);
            payload.setMainType(SaleConEnum.SUB.getCode());
            payload.setName(projApplyNoContract.getProjName() + "-虚拟子合同");
            conContractVO = saleConContractService.insert(payload);

            // 更新内部申请项目 的合同id
            pmsInnerProjectApplyDAO.addContractId(id, conContractVO.getId());
        }
    }

    @Override
    public void taskCreated(TaskCreatedPayload payload) {
        // 业务key
        String businessKey = payload.getBusinessKey();

        // 当前流程 审批类型
        CommentInfo commentInfo = payload.getCommentInfo();
        if (!ObjectUtils.isEmpty(commentInfo)) {
            ActionType actionType = commentInfo.getType();
            //下一个节点
            String nextTaskKey = payload.getTaskKey();

            String apprStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();

            ProcInstStatus procInstStatus = ProcInstStatus.APPROVING;

            switch (actionType) {
                case REJECTED:
                    // 如果驳回到提交人 则将单据状态变为新建状态
                    if (!"Activity_1jdr3h2".equals(nextTaskKey) && !"Activity_14wzm2o".equals(nextTaskKey)
                            && !"Activity_0597v9a".equals(nextTaskKey) && !"Activity_1gc7tub".equals(nextTaskKey) && !"Activity_1wuw7tu".equals(nextTaskKey)) {
                        apprStatus = WorkFlowStatusEnum.CREATE_WORK.getCode();
                        procInstStatus = ProcInstStatus.REJECTED;
                    }
                    break;
                case REVOKE:
                    // 如果REVOKE 则将单据状态变为新建状态
                    apprStatus = WorkFlowStatusEnum.CREATE_WORK.getCode();
                    procInstStatus = ProcInstStatus.NOTSUBMIT;
                    break;
                case AGREE:
                    // 通过审批节点后（内部项目为通过财务审批节点，专项&管理项目为通过交付BU负责人审批节点），根据立项申请表数据新增数据虚拟合同数据
                    if ("Activity_07xa87t".equals(nextTaskKey)) {
                        createContract(Long.valueOf(businessKey));
                    }
                    break;
                case AUTO_AGREE:
                    // 通过审批节点后（内部项目为通过财务审批节点，专项&管理项目为通过交付BU负责人审批节点），根据立项申请表数据新增数据虚拟合同数据
                    if ("Activity_07xa87t".equals(nextTaskKey)) {
                        createContract(Long.valueOf(businessKey));
                    }
                    break;
            }

            if (!ObjectUtils.isEmpty(apprStatus)) {
                PmsInnerProjectApplyPayload innerProjectApplyPayload = new PmsInnerProjectApplyPayload();
                innerProjectApplyPayload.setId(Long.parseLong(businessKey));
                innerProjectApplyPayload.setApprStatus(apprStatus);
                innerProjectApplyPayload.setProcInstStatus(procInstStatus);
                pmsInnerProjectApplyDAO.updateWorkFlow(innerProjectApplyPayload);
            }
        }
    }

    @Override
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象

        PmsInnerProjectApplyVO processVO = pmsInnerProjectApplyDAO.queryByKey(Long.valueOf(businessKey));

        if (processVO != null) {
            PmsInnerProjectApplyPayload innerProjectApplyPayload = new PmsInnerProjectApplyPayload();
            innerProjectApplyPayload.setId(Long.parseLong(businessKey));

            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    innerProjectApplyPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    innerProjectApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    innerProjectApplyPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    innerProjectApplyPayload.setDeleteFlag(1);
                    innerProjectApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    innerProjectApplyPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    innerProjectApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    innerProjectApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    innerProjectApplyPayload.setApprovedTime(LocalDateTime.now());
                    innerProjectApplyPayload.setApprStatus(ProjectStatusEnum.ACTIVE.getCode());
                    break;
                case APPROVING:
                    break;
            }
            pmsInnerProjectApplyDAO.updateWorkFlow(innerProjectApplyPayload);
        }
    }


    //无合同项目立项审批流程 发起流程
    private void submitReportProc(PmsInnerProjectApplyVO innerProjectApplyVO) {
        HashMap<String, Object> variables = new HashMap<>();

        variables.put("Activity_0vqr33g", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode()));

        //费用承担BU负责人
        PrdOrgOrganizationVO expenseBu = cacheUtil.getOrg(innerProjectApplyVO.getExpenseBuId());
        variables.put("Activity_1jdr3h2", CollUtil.newArrayList(expenseBu.getManageId()));
        //交付BU负责人
        PrdOrgOrganizationVO deliBu = cacheUtil.getOrg(innerProjectApplyVO.getDeliBuId());
        variables.put("Activity_14wzm2o", CollUtil.newArrayList(deliBu.getManageId()));
        //是否为内部研发类项目
        variables.put("develop", "DEVELOP".equals(innerProjectApplyVO.getWorkType()));
        //平台总体负责人 PLAT_ALL_PIC
        variables.put("Activity_0597v9a", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ALL_PIC.getCode()));
        //研发项目负责人 DEVELIP_PIC
        variables.put("Activity_1gc7tub", CollUtil.newArrayList(roleService.queryUserIdByRoleCode(RoleEnum.DEVELIP_PIC.getCode())));
        //财务审批 PROJECT_CHECK_INFORM_FIN
        variables.put("Activity_1wuw7tu", roleService.queryUserIdByRoleCode(RoleEnum.PROJECT_CHECK_INFORM_FIN.getCode()));
        //申请人
        variables.put("Activity_07xa87t", CollUtil.newArrayList(innerProjectApplyVO.getCreateUserId()));

        //流程实例名称 P08.内部项目立项申请-项目名称
        String procInstName = "P08.内部项目立项申请" + "-" + innerProjectApplyVO.getProjName();

        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                PmsProcDefKey.PMS_INNER_PROJECT.name(),
                procInstName,
                innerProjectApplyVO.getId() + "",
                variables)
        );

        //流程启动成功后，回写业务表数据
        PmsInnerProjectApplyPayload payload = new PmsInnerProjectApplyPayload();
        payload.setId(innerProjectApplyVO.getId());
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApprStatus(ProjectStatusEnum.APPROVING.getCode());
        pmsInnerProjectApplyDAO.updateWorkFlow(payload);
    }


    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(PmsInnerProjectApplyVO vo) {
        vo.setSowFilesData(fileUtil.getFileDatas(vo.getSowFiles()));
        vo.setBudgetFilesData(fileUtil.getFileDatas(vo.getBudgetFiles()));
        vo.setResearchFilesData(fileUtil.getFileDatas(vo.getResearchFiles()));
        vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));
        //  项目模板名称
        if (!ObjectUtils.isEmpty(vo.getProjTempId())) {
            PmsProjectTemplateVO pmsProjectTemplateVO = pmsProjectTemplateDAO.queryByKey(vo.getProjTempId());
            vo.setProjTempName(pmsProjectTemplateVO.getTemplateName());
        }
    }

    // 附件处理
    private void innerPrjFileHandle(PmsInnerProjectApplyPayload payload) {
        Map<String, Object> context = BeanUtil.beanToMap(payload);
        // 附件
        String researchFilesStr = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getResearchFiles());
        payload.setResearchFiles(researchFilesStr);
    }


}
