package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSetQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSetService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetRelationVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectSetConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectSetDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSetDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSetRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目集管理
 *
 * @author carl
 * @date 2023-07-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectSetServiceImpl extends BaseServiceImpl implements PmsProjectSetService {
    private final CacheUtil cacheUtil;
    private final PmsProjectSetRepo pmsProjectSetRepo;
    private final PmsProjectSetDAO pmsProjectSetDAO;
    private final PrdOrgEmployeeService employeeService;
    private final PmsProjectDAO pmsProjectDAO;
    private final TransactionUtilService transactionUtilService;

    @Override
    public List<PmsProjectSetVO> queryListDynamic(PmsProjectSetQuery query) {
        if (checkPermissionFlag()) {
            List<PmsProjectSetVO> list = pmsProjectSetDAO.queryListDynamic(query);
            sortBySetCode(list);
            return list;
        }
        return null;
    }

    @Override
    public List<PmsProjectSetVO> queryListToProject(PmsProjectQuery query) {
        //权限处理
//        query.setBySetManagerUserFlag(false);
//        operPermissionFlag(query);
        List<PmsProjectSetVO> list = pmsProjectSetDAO.queryListToProject(query);

        // 如果当前人是 项目集负责人  项目集权限大于项目权限
//        query.setPermissionFlag(false);
//        query.setBySetManagerUserFlag(true);
        List<PmsProjectSetVO> byManagerUserId = pmsProjectSetDAO.queryListToProject(query);
        Map<Long, Long> map = byManagerUserId.stream().collect(Collectors.toMap(PmsProjectSetVO::getId, PmsProjectSetVO::getProjectCount));
        list.forEach(vo -> {
            if (map.containsKey(vo.getId())) {
                vo.setProjectCount(map.get(vo.getId()));
            }
        });

        sortBySetCode(list);
        return list;
    }

    @Override
    public List<PmsProjectSetVO> querySelectList(PmsProjectSetQuery query) {

        return pmsProjectSetDAO.querySelectList(query);
    }

    @Override
    public PagingVO<PmsProjectSetRelationVO> queryRelationProjectPaging(PmsProjectSetQuery query) {
        PagingVO<PmsProjectSetRelationVO> pmsProjectSetRelationVOPagingVO = pmsProjectSetDAO.queryRelationProjectPaging(query);
        List<PmsProjectSetRelationVO> records = pmsProjectSetRelationVOPagingVO.getRecords();
        if (!ObjectUtils.isEmpty(records)) {
            records.forEach(this::transferData);
        }
        return pmsProjectSetRelationVOPagingVO;
    }

    @Override
    public List<PmsProjectSetRelationVO> queryRelationProjectList(PmsProjectSetQuery query) {
        List<PmsProjectSetRelationVO> records = pmsProjectSetDAO.queryRelationProjectList(query);
        if (!ObjectUtils.isEmpty(records)) {
            records.forEach(this::transferData);
        }
        return records;
    }

    void transferData(PmsProjectSetRelationVO vo) {
        vo.setProjectStatusName(cacheUtil.transferSystemSelection("TSK:PROJ_STATUS", vo.getProjectStatus()));
        vo.setManagerUserName(cacheUtil.getUserName(vo.getManagerUserId()));
        vo.setProjectTypeName(cacheUtil.transferSystemSelection("PMS:PROJECT:OTHER", vo.getProjectType()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectSetVO insertOrUpdate(PmsProjectSetDataPayload payload) {
        //权限判断
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.ADMIN_PMS.getCode()));
        if (true) {
            //获取所有项目集
            List<PmsProjectSetVO> pmsProjectSetVOS = querySelectList(new PmsProjectSetQuery());
            //执行删除操作
            List<Long> delProjectSetIds = payload.getDelProjectSetIds();
            if (!ObjectUtils.isEmpty(delProjectSetIds)) {
                List<PmsProjectSetVO> collect = pmsProjectSetVOS.stream().filter(pmsProjectSetVO -> ObjectUtils.isEmpty(pmsProjectSetVO.getParentId()) && delProjectSetIds.contains(pmsProjectSetVO.getId())).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(collect)) {
                    throw TwException.error("", "根节点不可删除，请核验！");
                }
                deleteSoft(delProjectSetIds);
            }
            //新增或变更
            List<PmsProjectSetPayload> projectSetPayloads = payload.getProjectSetPayloads();
            if (!ObjectUtils.isEmpty(projectSetPayloads)) {
                //校验根节点是否唯一
                List<PmsProjectSetPayload> collect1 = projectSetPayloads.stream().filter(projectSetPayload -> ObjectUtils.isEmpty(projectSetPayload.getParentId())).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(collect1)) {
                    if (collect1.size() > 1) {
                        throw TwException.error("", "项目集只能存储一个根节点，请核验！");
                    }
                    if (!ObjectUtils.isEmpty(pmsProjectSetVOS)) {
                        Optional<PmsProjectSetVO> first = pmsProjectSetVOS.stream().filter(pmsProjectSetVO -> ObjectUtils.isEmpty(pmsProjectSetVO.getParentId())).findFirst();
                        if (first.isPresent()) {
                            Long voId = first.get().getId();
                            Long payloadId = collect1.get(0).getId();
                            if (payloadId == null || !payloadId.equals(voId)) {
                                throw TwException.error("", "项目集只能存储一个根节点，请核验！");
                            }
                        }
                    }
                }
                List<PmsProjectSetPayload> updateSetPayloads = projectSetPayloads.stream().filter(setPayload -> setPayload.getId() != null).collect(Collectors.toList());
                //处理变更
                if (!ObjectUtils.isEmpty(updateSetPayloads)) {
                    //需要移除的项目ids
                    List<Long> delProjectIds = new ArrayList<>();
                    //需要添加关系的项目集payload
                    List<PmsProjectSetPayload> addRelationSetPayloads = new ArrayList<>();
                    updateSetPayloads.forEach(updateSetPayload -> {
                        if (!ObjectUtils.isEmpty(updateSetPayload.getDelProjectIds())) {
                            delProjectIds.addAll(updateSetPayload.getDelProjectIds());
                        }
                        if (!ObjectUtils.isEmpty(updateSetPayload.getAddProjectIds())) {
                            addRelationSetPayloads.add(updateSetPayload);
                        }
                    });
                    //移除项目集关联项的项目
                    if (!ObjectUtils.isEmpty(delProjectIds)) {
                        pmsProjectDAO.clearProjectSetId(delProjectIds, true);
                    }
                    //判断项目集中是否重复添加项目关联
                    //checkRepeatRelation(addRelationSetPayloads);
                }
                //保存项目集
                List<PmsProjectSetDO> entityDos = projectSetPayloads.stream().map(e -> {
                    PmsProjectSetDO entityDo = PmsProjectSetConvert.INSTANCE.toDo(e);
                    e.setProjectSetDO(entityDo);
                    return entityDo;
                }).collect(Collectors.toList());
                List<PmsProjectSetDO> pmsProjectSetDOS = pmsProjectSetDAO.saveAll(entityDos);
                //保存项目集关联关系
                List<PmsProjectSetPayload> saveSetRelationPayloads = projectSetPayloads.stream().filter(setPayload -> !ObjectUtils.isEmpty(setPayload.getAddProjectIds())).collect(Collectors.toList());
                //  List<PmsProjectSetRelationDO> entityRelationDos = new ArrayList<>();

                Map<Long, List<Long>> updateProjectIdsMap = new HashMap<>();
                saveSetRelationPayloads.forEach(saveSetRelationPayload -> {
                    saveSetRelationPayload.setId(saveSetRelationPayload.getProjectSetDO().getId());
                    updateProjectIdsMap.put(saveSetRelationPayload.getProjectSetDO().getId(), saveSetRelationPayload.getAddProjectIds());
                });
                if (updateProjectIdsMap.size() > 0) {
                    //批量更改项目集id
                    updateProjectIdsMap.forEach((projectSetId, keys) -> {
                        transactionUtilService.executeWithRunnable(() -> {
                            pmsProjectDAO.updateProjectSetId(keys, projectSetId);
                        });
                    });
                }

                if (pmsProjectSetDOS.size() > 0) {
                    return PmsProjectSetConvert.INSTANCE.toVo(pmsProjectSetDOS.get(0));
                }
            }
            return null;
        } else {
            throw TwException.error("", "无操作权限，请核验！");
        }
    }

//    /**
//     * 核对项目集中是否重复添加项目关联
//     *
//     * @param addRelationSetPayloads
//     */
//    void checkRepeatRelation(List<PmsProjectSetPayload> addRelationSetPayloads) {
//        List<Long> updateSetIds = addRelationSetPayloads.stream().map(PmsProjectSetPayload::getId).collect(Collectors.toList());
//        List<PmsProjectSetRelationVO> pmsProjectSetRelationVOS = pmsProjectSetRelationDAO.queryList(updateSetIds);
//        if (!ObjectUtils.isEmpty(pmsProjectSetRelationVOS)) {
//            Map<Long, List<Long>> relationIdsMap = new HashMap<>();
//            pmsProjectSetRelationVOS.forEach(setRelationVO -> {
//                List<Long> projectIds = relationIdsMap.get(setRelationVO.getProjectSetId());
//                if (ObjectUtils.isEmpty(projectIds)) {
//                    projectIds = new ArrayList<>();
//                    relationIdsMap.put(setRelationVO.getProjectSetId(), projectIds);
//                }
//                projectIds.add(setRelationVO.getProjectId());
//            });
//            //重新赋值
//            relationIdsMap.forEach((setId, projectIds) -> {
//                PmsProjectSetPayload pmsProjectSetPayload = addRelationSetPayloads.stream().filter(updateSetPayload -> updateSetPayload.getId().equals(setId)).findFirst().get();
//                pmsProjectSetPayload.setAddProjectIds(pmsProjectSetPayload.getAddProjectIds().stream().filter(addProjectId -> !projectIds.contains(addProjectId)).collect(Collectors.toList()));
//            });
//
//        }
//    }

    @Override
    public PmsProjectSetVO queryByKey(Long key) {
        PmsProjectSetDO entity = pmsProjectSetRepo.findById(key).orElseGet(PmsProjectSetDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectSetVO vo = PmsProjectSetConvert.INSTANCE.toVo(entity);
        return vo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectSetVO update(PmsProjectSetPayload payload) {
        PmsProjectSetDO entity = pmsProjectSetRepo.findById(payload.getId()).orElseGet(PmsProjectSetDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectSetDO entityDo = PmsProjectSetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectSetConvert.INSTANCE.toVo(pmsProjectSetRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectSetPayload payload) {
        PmsProjectSetDO entity = pmsProjectSetRepo.findById(payload.getId()).orElseGet(PmsProjectSetDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsProjectSetDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectSetDAO.deleteSoft(keys);
            pmsProjectDAO.clearProjectSetId(keys, false);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void udateSetCode(Long id, String setCode) {
        PmsProjectSetDO entity = pmsProjectSetRepo.findById(id).orElseGet(PmsProjectSetDO::new);
        Assert.notNull(entity.getId(), "不存在");
        entity.setSetCode(setCode);
        pmsProjectSetRepo.save(entity);
    }

    /**
     * 权限处理
     *
     * @param query
     */
    void operPermissionFlag(PmsProjectQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        //需要处理权限
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PROJECT_ADMIN.getCode(), RoleEnum.ADMIN_PMS.getCode()));
        query.setPermissionFlag(!rolePermission);
//        if (!rolePermission) {
//            //查询下级id集合
//            Set<Long> longs = employeeService.querySubordinatesIdsByUserId(loginUserId);
//            query.setLowerUserIds(longs);
//        }
    }

    /**
     * 权限处理
     */
    Boolean checkPermissionFlag() {
//        List<Long> userIds = cacheUtil.queryRoleUserIds(RoleEnum.ADMIN_PMS.getCode());
//        if (!ObjectUtils.isEmpty(userIds)) {
//            Long loginUserId = GlobalUtil.getLoginUserId();
//            if (userIds.contains(loginUserId)) {
//                return true;
//            }
//            Set<Long> longs = employeeService.querySubordinatesIdsByUserId(loginUserId);
//            if (!ObjectUtils.isEmpty(longs)) {
//                return userIds.retainAll(longs);
//            }
//        }
        return true;
    }


    /**
     * 根据科目编号排序
     *
     * @param list
     */
    void sortBySetCode(List<PmsProjectSetVO> list) {
        list.sort(new Comparator<PmsProjectSetVO>() {
            @Override
            public int compare(PmsProjectSetVO obj1, PmsProjectSetVO obj2) {
                String str1 = obj1.getSetCode();
                String str2 = obj2.getSetCode();

                // 将字符串转换为数值进行比较
                double double1 = Double.parseDouble(str1);
                double double2 = Double.parseDouble(str2);

                // 检查是否以0开头
                boolean isStr1StartingWithZero = str1.startsWith("0");
                boolean isStr2StartingWithZero = str2.startsWith("0");

                // 如果一个字符串以0开头而另一个不是，则将以0开头的字符串排在前面
                if (isStr1StartingWithZero && !isStr2StartingWithZero) {
                    return -1;
                } else if (!isStr1StartingWithZero && isStr2StartingWithZero) {
                    return 1;
                } else {
                    // 否则，使用数值进行比较
                    return Double.compare(double1, double2);
                }
            }
        });
    }
}
