package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsRelyService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsRelyConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsRelyDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsRelyDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsRelyRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目wbs前置依赖关系
 *
 * @author carl
 * @date 2023-07-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectWbsRelyServiceImpl extends BaseServiceImpl implements PmsProjectWbsRelyService {

    private final PmsProjectWbsRelyRepo pmsProjectWbsRelyRepo;
    private final PmsProjectWbsRelyDAO pmsProjectWbsRelyDAO;
    private final PmsProjectWbsService pmsProjectWbsService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchInsert(PmsProjectWbsRelyDataPayload payload) {
        if (payload.getWbsId() != null && StringUtils.hasText(payload.getRelyType()) && !ObjectUtils.isEmpty(payload.getAddWbsRelyIds())) {
            if (payload.getAddWbsRelyIds().indexOf(payload.getWbsId()) < 0) {
                List<Long> ids = new ArrayList<>();
                ids.add(payload.getWbsId());
                ids.addAll(payload.getAddWbsRelyIds());
                List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsService.queryListByIds(ids);
                if (pmsProjectWbsVOS.size() == ids.size()) {
                    Map<Long, PmsProjectWbsVO> wbsVOMap = pmsProjectWbsVOS.stream().collect(Collectors.toMap(PmsProjectWbsVO::getId, Function.identity()));
                    PmsProjectWbsVO pmsProjectWbsVO = wbsVOMap.get(payload.getWbsId());
                    Long projectId = pmsProjectWbsVO.getProjectId();

                    String wbsType = pmsProjectWbsVO.getWbsType();
                    String relyType = payload.getRelyType();

                    //核验当前wbs类型
                    checkWbsType(pmsProjectWbsVO);
                    //核验重复添加
                    checkRepeat(relyType, payload.getWbsId(), payload.getAddWbsRelyIds());

                    List<PmsProjectWbsRelyDO> wbsRelyDOS = new ArrayList<>();
                    payload.getAddWbsRelyIds().forEach(key -> {
                        PmsProjectWbsRelyDO wbsRelyDO = new PmsProjectWbsRelyDO();
                        wbsRelyDO.setProjectId(projectId);
                        wbsRelyDO.setVersionId(payload.getVersionId());
                        wbsRelyDO.setVersionNo(payload.getVersionNo());
                        wbsRelyDO.setWbsCode(payload.getWbsCode());
                        wbsRelyDO.setRelyType(relyType);
                        PmsProjectWbsVO relyVO = wbsVOMap.get(key);
                        String wbsType1 = relyVO.getWbsType();
                        //核验当前wbs类型
                        checkWbsType(relyVO);
                        //核验依赖类型
//                        checkWbsTypeRely(wbsType, wbsType1, relyType);
                        if (relyType.equals("SF")) {
                            wbsRelyDO.setRelyType("FS");
                            //表示是开始-结束类型
                            wbsRelyDO.setWbsId(relyVO.getId());
                            wbsRelyDO.setWbsName(relyVO.getWbsName());
                            wbsRelyDO.setWbsRelyId(pmsProjectWbsVO.getId());
                            wbsRelyDO.setWbsRelyName(pmsProjectWbsVO.getWbsName());
                            wbsRelyDO.setRelationType(pmsProjectWbsVO.getWbsType());
                        } else {
                            wbsRelyDO.setWbsId(pmsProjectWbsVO.getId());
                            wbsRelyDO.setWbsName(pmsProjectWbsVO.getWbsName());
                            wbsRelyDO.setWbsRelyId(relyVO.getId());
                            wbsRelyDO.setWbsRelyName(relyVO.getWbsName());
                            wbsRelyDO.setRelationType(relyVO.getWbsType());
                        }
                        wbsRelyDOS.add(wbsRelyDO);
                    });

                    pmsProjectWbsRelyDAO.saveAll(wbsRelyDOS);

                    //变更排期状态
                    pmsProjectWbsService.updateSchedulingStatus(projectId);

                } else {
                    throw TwException.error("", "依赖关系数据异常，请核验！");
                }
            } else {
                throw TwException.error("", "依赖关系不可包含当前节点，请核验！");
            }
        } else {
            throw TwException.error("500", "有效参数不可为空，请核验！");
        }
    }

    /**
     * 校验依赖类型适用范围
     *
     * @param wbsType     当前类型
     * @param relyWbsType 前置类型
     * @param relyType    关系类型
     */
    void checkWbsTypeRely(String wbsType, String relyWbsType, String relyType) {

        if (wbsType.equals(ProjectWbsTypeEnum.ACT.getCode())) {
            //当前为活动
            if (relyWbsType.equals(ProjectWbsTypeEnum.ACT.getCode())) {
                //前置为活动
                if (!relyType.equals("SS") && !relyType.equals("FS") && !relyType.equals("FF")) {
                    throw TwException.error("", "活动-活动不支持该依赖类型，请核验！");
                }
            } else {
                //前置为里程碑
                if (!relyType.equals("FS") && !relyType.equals("FF")) {
                    throw TwException.error("", "活动-里程碑不支持该依赖类型，请核验！");
                }
            }
        } else {
            //当前为里程碑
            if (relyWbsType.equals(ProjectWbsTypeEnum.ACT.getCode())) {
                //前置为活动
                if (!relyType.equals("SF") && !relyType.equals("FF")) {
                    throw TwException.error("", "里程碑-活动不支持该依赖类型，请核验！");
                }
            } else {
                //前置为里程碑
                if (!relyType.equals("FF")) {
                    throw TwException.error("", "里程碑-里程碑不支持该依赖类型，请核验！");
                }
            }
        }

    }

    /**
     * 核验重复添加
     *
     * @param relyType
     * @param wbsId
     * @param relyIds
     */
    void checkRepeat(String relyType, Long wbsId, List<Long> relyIds) {
        if (relyType.equals("SF")) {
            PmsProjectWbsRelyVO pmsProjectWbsRelyVO = pmsProjectWbsRelyDAO.queryWbsIdsAndWbsRelyId(relyIds, wbsId);
            if (pmsProjectWbsRelyVO != null) {
                throw TwException.error("", "不可重复添加依赖关系，请核验！");
            }
        } else {
            PmsProjectWbsRelyVO pmsProjectWbsRelyVO = pmsProjectWbsRelyDAO.queryWbsIdAndWbsRelyIds(wbsId, relyIds);
            if (pmsProjectWbsRelyVO != null) {
                throw TwException.error("", "不可重复添加依赖关系，请核验！");
            }
        }
    }

    /**
     * 核验是否存在非法的前置依赖类型
     *
     * @param pmsProjectWbsVO
     */
    void checkWbsType(PmsProjectWbsVO pmsProjectWbsVO) {
        if (!pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) && !pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
            throw TwException.error("", "仅支持“活动”和“里程碑”建立网络关系，请核验！");
        }
        if (pmsProjectWbsVO.getPreDurationDay() == null || (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) && pmsProjectWbsVO.getPreDurationDay().intValue() == 0)) {
            throw TwException.error("", pmsProjectWbsVO.getWbsName() + "--预计工期不存在，请核验！");
        }
    }

    @Override
    public PagingVO<PmsProjectWbsRelyVO> queryPaging(PmsProjectWbsRelyQuery query) {
        return pmsProjectWbsRelyDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectWbsRelyVO> queryListDynamic(PmsProjectWbsRelyQuery query) {
        return pmsProjectWbsRelyDAO.queryListDynamic(query);
    }

    @Override
    public List<PmsProjectWbsRelyVO> listLeftJoinWbs(PmsProjectWbsRelyQuery query) {
        return pmsProjectWbsRelyDAO.listLeftJoinWbs(query);
    }

    @Override
    public PmsProjectWbsRelyVO queryByKey(Long key) {
        PmsProjectWbsRelyDO entity = pmsProjectWbsRelyRepo.findById(key).orElseGet(PmsProjectWbsRelyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectWbsRelyVO vo = PmsProjectWbsRelyConvert.INSTANCE.toVo(entity);
        return vo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsRelyVO update(PmsProjectWbsRelyPayload payload) {
        PmsProjectWbsRelyDO entity = pmsProjectWbsRelyRepo.findById(payload.getId()).orElseGet(PmsProjectWbsRelyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectWbsRelyDO entityDo = PmsProjectWbsRelyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectWbsRelyConvert.INSTANCE.toVo(pmsProjectWbsRelyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectWbsRelyPayload payload) {
        PmsProjectWbsRelyDO entity = pmsProjectWbsRelyRepo.findById(payload.getId()).orElseGet(PmsProjectWbsRelyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsProjectWbsRelyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectWbsRelyDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean delByWbsId(Long wbsId,Integer versionNo) {

        pmsProjectWbsRelyDAO.delByWbsId(wbsId, versionNo);
        return null;
    }

}
