package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ResourceCostStrategyQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ResourceCostStrategyVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsResourcePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsResourceQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsResourceService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.ResourceCostStrategyService;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsResourceConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsResourceDao;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsResourceDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsResourceRepo;import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs资源分配Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsProjectWbsResourceServiceImpl implements PmsProjectWbsResourceService {


    private final PmsProjectWbsResourceDao pmsProjectWbsResourceDao;

    private final PmsProjectWbsResourceRepo pmsProjectWbsResourceRepo;

    private final ProRelatedPartiesService proRelatedPartiesService;

    private final PmsProjectRoleService pmsProjectRoleService;

    private final ResourceCostStrategyService resourceCostStrategyService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsResourceVO save(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {

        checkData(pmsProjectWbsResourcePayload);
        PmsProjectWbsResourceDO pmsProjectWbsResourceDO = new PmsProjectWbsResourceDO();
        pmsProjectWbsResourceDO = PmsProjectWbsResourceConvert.INSTANCE.p2d(pmsProjectWbsResourcePayload);
        PmsProjectWbsResourceDO res = pmsProjectWbsResourceRepo.save(pmsProjectWbsResourceDO);
        return PmsProjectWbsResourceConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsResourceVO updateAll(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {

        Assert.notNull(pmsProjectWbsResourcePayload.getId(), "id is null");
        PmsProjectWbsResourceVO res = save(pmsProjectWbsResourcePayload);
        return res;

    }


    @Override
    public PmsProjectWbsResourceVO get(Long id) {

        if (null == id) {
            return null;
        }
        PmsProjectWbsResourceVO res = pmsProjectWbsResourceDao.get(id);
        this.trans(List.of(res));
        return res;

    }


    @Override
    public PagingVO<PmsProjectWbsResourceVO> page(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        PagingVO<PmsProjectWbsResourceVO> res = pmsProjectWbsResourceDao.page(pmsProjectWbsResourceQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = pmsProjectWbsResourceDao.del(ids);
        return res;

    }

    @Override
    public List<PmsProjectWbsResourceVO> getList(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        List<PmsProjectWbsResourceVO> res = pmsProjectWbsResourceDao.getList(pmsProjectWbsResourceQuery);
        this.trans(res);

        return res;

    }

    private void trans(List<PmsProjectWbsResourceVO> res) {

        List<Long> collect = res.stream().map(x -> x.getRelatePartiesId()).collect(Collectors.toList());
        List<Long> roleIds = res.stream().map(x -> x.getRoleId()).collect(Collectors.toList());
        ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
        proRelatedPartiesQuery.setIdList(collect);
        List<ProRelatedPartiesVO> list = proRelatedPartiesService.getList(proRelatedPartiesQuery);
        Map<Long, String> relateMap = list.stream().collect(Collectors.toMap(ProRelatedPartiesVO::getId, ProRelatedPartiesVO::getName, (t1, t2) -> t1));
        // 角色翻译
        PmsProjectRoleQuery pmsProjectRoleQuery = new PmsProjectRoleQuery();
        pmsProjectRoleQuery.setIds(roleIds);
        List<PmsProjectRoleVO> pmsProjectRoleVOS = pmsProjectRoleService.queryListDynamic(pmsProjectRoleQuery);
        Map<Long, String> roleMap = pmsProjectRoleVOS.stream().collect(Collectors.toMap(PmsProjectRoleVO::getId, PmsProjectRoleVO::getRoleName, (t1, t2) -> t1));

        TwOutputUtil<List<ResourceCostStrategyVO>> listTwOutputUtil = resourceCostStrategyService.queryList(new ResourceCostStrategyQuery());
        List<ResourceCostStrategyVO> resourceCostStrategyVOList = listTwOutputUtil.getData();
        ResourceCostStrategyVO resourceCostStrategyVO = new ResourceCostStrategyVO();
        resourceCostStrategyVO.setType(1);
        if (CollUtil.isNotEmpty(resourceCostStrategyVOList)) {
            resourceCostStrategyVO = resourceCostStrategyVOList.get(0);
        }
        for (PmsProjectWbsResourceVO x : res) {
            x.setRelatePartiesName(relateMap.get((x.getRelatePartiesId())));
            x.setRoleName(roleMap.get(x.getRoleId()));
            // 各资源的当量配置
            if (resourceCostStrategyVO.getType() == 1) {
                x.setReferenceEqvaRatio(BigDecimal.ONE);
            }
        }

    }


    /**
     * 数据校验
     *
     * @param pmsProjectWbsResourcePayload
     */
    private void checkData(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {

//        Assert.notEmpty(pmsProjectWbsResourcePayload.getType(), "类型不能为空");
        Assert.notNull(pmsProjectWbsResourcePayload.getWbsId(), "wbsId不能为空");
        Assert.notNull(pmsProjectWbsResourcePayload.getRelatePartiesId(), "相关方Id不能为空");
        Assert.notNull(pmsProjectWbsResourcePayload.getVersionId(), "versionId不能为空");
        Assert.notNull(pmsProjectWbsResourcePayload.getVersionNo(), "versionNo不能为空");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {
        Assert.notNull(pmsProjectWbsResourcePayload.getId(), "id不能为空");
        Long res = pmsProjectWbsResourceDao.update(pmsProjectWbsResourcePayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveAll(List<PmsProjectWbsResourcePayload> pmsProjectWbsResourcePayload) {

        List<PmsProjectWbsResourceDO> pmsProjectWbsResourceDOList = new ArrayList<>();
        if (CollUtil.isNotEmpty(pmsProjectWbsResourcePayload)) {

            List<Long> wbsIds = pmsProjectWbsResourcePayload.stream().map(x -> x.getWbsId()).collect(Collectors.toList());
            pmsProjectWbsResourceDao.delByWbsIds(wbsIds);

            for (PmsProjectWbsResourcePayload projectWbsResourcePayload : pmsProjectWbsResourcePayload) {
                checkData(projectWbsResourcePayload);
//                Long sourceV0Id = pmsProjectWbsResourceDao.queryBykeyAndVersion(projectWbsResourcePayload.getWbsId(), projectWbsResourcePayload.getRelatePartiesId(), 0);
//                if (null != sourceV0Id) {
//                    projectWbsResourcePayload.setEffRelateId(sourceV0Id);
//
//                } else {
//                    // 生成V0版本
//                    PmsProjectWbsResourceDO entity = PmsProjectWbsResourceConvert.INSTANCE.p2d(projectWbsResourcePayload);
//                    entity.setId(null);
//                    entity.setWbsId(wbsSaveV0DO.getId());
//                    entity.setVersionNo(0);
//                    entity.setVersionId(0L);
//                    pmsProjectWbsResourceDOList.add(entity);
//                }

                PmsProjectWbsResourceDO pmsProjectWbsResourceDO = new PmsProjectWbsResourceDO();
                pmsProjectWbsResourceDO = PmsProjectWbsResourceConvert.INSTANCE.p2d(projectWbsResourcePayload);
                pmsProjectWbsResourceDOList.add(pmsProjectWbsResourceDO);
            }
            pmsProjectWbsResourceDao.save(pmsProjectWbsResourceDOList);
        }


        return true;
    }


}

