package com.elitesland.tw.tw5.server.prd.pms.stateflow.service.impl;


import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.StateFlowConfigConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.StateFlowConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.PmsStateFlowVersionPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.PmsStateFlowVersionQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.PmsStateFlowVersionVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.StateFlowRepo;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.PmsStateFlowVersionDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.StateFlowConfigDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.StateFlowDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.PmsStateFlowVersionService;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowConfigService;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;



/**
 * 状态流版本表service impl
 *
 * @author wangxl
 * @date 2024/4/19
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsStateFlowVersionServiceImpl implements PmsStateFlowVersionService {

    private final PmsStateFlowVersionDao dao;

    private final StateFlowService stateFlowService;
    private final StateFlowConfigService stateFlowConfigService;

    private final StateFlowRepo stateFlowRepo;
    private final StateFlowConfigDao stateFlowConfigDao;

    @Override
    public TwOutputUtil<PagingVO<PmsStateFlowVersionVO>> queryPage(PmsStateFlowVersionQuery query) {
        PagingVO<PmsStateFlowVersionVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsStateFlowVersionVO>> queryList(PmsStateFlowVersionQuery query) {
        List<PmsStateFlowVersionVO> listVO = dao.queryList(query);
        translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsStateFlowVersionQuery query) {
        return TwOutputUtil.ok(dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsStateFlowVersionVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsStateFlowVersionVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsStateFlowVersionVO> insert(PmsStateFlowVersionPayload payload) {
        // 检查数据局
        checkData(payload);
        if (null == payload.getState()) {
            payload.setState(1);
        }

        PmsStateFlowVersionVO lastVersionNo = dao.getLastVersionNo(payload.getCategoryId(), null);
        payload.setVersionNo(lastVersionNo == null ? 1 : lastVersionNo.getVersionNo() + 1);
        // 保存版本数据
        PmsStateFlowVersionVO save = dao.save(payload);

        // TODO 生成新版本状态流数据
        if (null != lastVersionNo) {

//            StateFlowQuery allstateFlowQuery = new StateFlowQuery();
//            allstateFlowQuery.setObjId(payload.getCategoryId());
//            List<StateFlowVO> alloldStateFlowList = stateFlowService.getList(allstateFlowQuery);
//            Map<Long, StateFlowVO> allOldFlowMap = alloldStateFlowList.stream().collect(Collectors.toMap(StateFlowVO::getId, x -> x));

            // 1）根据categoryId、versionId，查找上一激活版本状态流数据，生成下一新版本状态流数据
            PmsStateFlowVersionVO lastVersionNo2 = dao.getLastVersionNo(payload.getCategoryId(), 3);
            // 如果没有激活版本
            if (null == lastVersionNo2) {
                return TwOutputUtil.ok(save);
            }

            StateFlowQuery stateFlowQuery = new StateFlowQuery();
            stateFlowQuery.setObjId(payload.getCategoryId());
            stateFlowQuery.setVersionNo(lastVersionNo2.getVersionNo());
            stateFlowQuery.setVersionId(lastVersionNo2.getId());
            List<StateFlowVO> oldStateFlowList = stateFlowService.getList(stateFlowQuery);

            if (CollUtil.isNotEmpty(oldStateFlowList)) {
                List<StateFlowConfigDO> allStateFlowConfigList = new ArrayList<>();
                oldStateFlowList.forEach(x -> {
                    // 查询流配置信息
                    StateFlowConfigQuery stateFlowConfigQuery = new StateFlowConfigQuery();
                    stateFlowConfigQuery.setFlowId(x.getId());
                    List<StateFlowConfigVO> stateFlowConfigVOList = stateFlowConfigService.getList(stateFlowConfigQuery);

                    x.setId(null);
                    x.setVersionId(save.getId());
                    x.setVersionNo(save.getVersionNo());
                    StateFlowDO entity = StateFlowConvert.INSTANCE.toEntity(x);
                    StateFlowDO newStateFlowEntity = stateFlowRepo.save(entity);
                    stateFlowConfigVOList.forEach(x1 -> {
                        x1.setId(null);
                        x1.setFlowId(newStateFlowEntity.getId());
                    });
                    List<StateFlowConfigDO> entityList2 = StateFlowConfigConvert.INSTANCE.toEntity(stateFlowConfigVOList);
                    allStateFlowConfigList.addAll(entityList2);

                });
                // 更新 流配置表的 configFlowId
                allStateFlowConfigList.forEach(x -> {
//                    String code = allOldFlowMap.get(x.getConfigFlowId()).getCode();
                    // 根据code + version去查最新的id
                    StateFlowQuery stateFlowQuery1 = new StateFlowQuery();
                    stateFlowQuery1.setVersionId(save.getId());
                    stateFlowQuery1.setObjId(save.getCategoryId());
                    stateFlowQuery1.setCode(x.getConfigFlowCode());
                    List<StateFlowVO> list = stateFlowService.getList(stateFlowQuery1);
                    if (CollUtil.isNotEmpty(list)) {
                        x.setConfigFlowId(list.get(0).getId());
                    }

                });
                // 生成新版本状态流流转
                stateFlowConfigDao.save(allStateFlowConfigList);

            }

        }

        return TwOutputUtil.ok(save);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsStateFlowVersionVO> update(PmsStateFlowVersionPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsStateFlowVersionVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsStateFlowVersionVO> updateDynamic(PmsStateFlowVersionPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return TwOutputUtil.ok(dao.deleteSoft(ids));
    }


    /**
     * 发起工作流
     *
     * @param payload payload
     * @return result
     */
    private TwOutputUtil<Long> startWorkFlow(PmsStateFlowVersionPayload payload) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
//        Assert.notNull(payload.getUserId(), "userId不能为空");
//        // 变更资源审批
//        varMaps.put("Activity_111kevq", payload.getUserId());
        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));
//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        // 回写单据的工作流信息
//        payload.setProcInstId(procInstId);
//        payload.setProcInstStatus("");
        Long update = dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsStateFlowVersionPayload payload) {
    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsStateFlowVersionVO> vos) {
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}